/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.SnmpTrapConfig;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.DialogCreateException;
import com.qlogic.qms.fabric.propertyDialogs.SwitchProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.IpAddress;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NetworkPropertiesDialogSanbox2
extends QDialog {
    public static final int MAX_TRAP_PORT_NUMBER = 65535;
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter chassisEventAdapter = null;
    protected Fabric fabric = null;
    protected JFrame frame = null;
    protected JPanel networkPanel = null;
    protected JPanel buttonPanel = null;
    protected boolean waitingOnIpChange = false;
    protected boolean waitingOnSnmpChange = false;
    protected boolean waitingOnSyslogChange = false;
    protected SwitchProperties properties = new SwitchProperties();
    GridBagLayout baseLayout = new GridBagLayout();
    String[] bootMethodChoices = new String[]{FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.0"), FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.1"), FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.2"), FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodChoice.3")};
    JPanel idPanel = new JPanel();
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel opStateLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateLabel"));
    JLabel opStateContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel firmwareLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.firmwareLabel"));
    JLabel firmwareContent = new JLabel();
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.chassisNameLabel"));
    JLabel chassisNameContent = new JLabel();
    JLabel macAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.macAddrLabel"));
    JLabel macAddrContent = new JLabel();
    JPanel ipPanel = new JPanel();
    GridBagLayout ipLayout = new GridBagLayout();
    JLabel ipLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.ipLabel"));
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.ipAddrLabel"));
    JLabel subnetMaskLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.subnetMaskLabel"));
    JLabel gatewayLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.gatewayLabel"));
    JLabel bootMethodLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.bootMethodLabel"));
    JTextField ipAddrText = new JTextField();
    JTextField subnetMaskText = new JTextField();
    JTextField gatewayText = new JTextField();
    JComboBox bootMethodCombo = new JComboBox<String>(this.bootMethodChoices);
    JPanel syslogPanel = new JPanel();
    GridBagLayout syslogLayout = new GridBagLayout();
    JCheckBox syslogEnable = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.syslogEnable"));
    JLabel syslogAddrLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.syslogAddr"));
    JTextField syslogAddr = new JTextField();
    JPanel snmpPanel = new JPanel();
    GridBagLayout snmpLayout = new GridBagLayout();
    JLabel snmpLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpLabel"));
    JCheckBox snmpProxyEnable = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpProxyEnable"));
    JLabel contactLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.contactLabel"));
    JLabel locationLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.locationLabel"));
    JLabel readCommLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.readCommLabel"));
    JLabel writeCommLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.writeCommLabel"));
    JLabel trapCommLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapCommLabel"));
    JLabel trapAuthLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAuthLabel"));
    String[] trapAuthChoices = new String[]{FabricTreeControl.getResource("NetworkPropertiesDialog.trapAuthEnabled"), FabricTreeControl.getResource("NetworkPropertiesDialog.trapAuthDisabled")};
    JTabbedPane trapTabPane = new JTabbedPane(3);
    GridBagLayout trapLayout = new GridBagLayout();
    JLabel trap1Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trap1"));
    JLabel trap2Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trap2"));
    JLabel trap3Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trap3"));
    JLabel trap4Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trap4"));
    JLabel trap5Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trap5"));
    String[] trapSeverityChoices = new String[]{FabricTreeControl.getResource("NetworkPropertiesDialog.unknown"), FabricTreeControl.getResource("NetworkPropertiesDialog.emergency"), FabricTreeControl.getResource("NetworkPropertiesDialog.alert"), FabricTreeControl.getResource("NetworkPropertiesDialog.critical"), FabricTreeControl.getResource("NetworkPropertiesDialog.error"), FabricTreeControl.getResource("NetworkPropertiesDialog.warning"), FabricTreeControl.getResource("NetworkPropertiesDialog.notify"), FabricTreeControl.getResource("NetworkPropertiesDialog.info"), FabricTreeControl.getResource("NetworkPropertiesDialog.debug"), FabricTreeControl.getResource("NetworkPropertiesDialog.mark")};
    String[] trapVersionChoices = new String[]{FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion.v1"), FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion.v2")};
    JPanel trap1Panel = new JPanel();
    JCheckBox trap1EnabledChBox = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.trap1Enabled"));
    JTextField trap1AddressText = new JTextField();
    JTextField trap1PortText = new JTextField();
    JComboBox trap1SeverityCombo = new JComboBox<String>(this.trapSeverityChoices);
    JLabel trap1EnabledLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapEnabled"));
    JLabel trap1AddressLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAddress"));
    JLabel trap1PortLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapPort"));
    JLabel trap1SeverityLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapSeverity"));
    JLabel snmpTrap1Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpTraps"));
    JLabel trap1VersionLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion"));
    JComboBox trap1VersionCombo = new JComboBox<String>(this.trapVersionChoices);
    JPanel trap2Panel = new JPanel();
    JCheckBox trap2EnabledChBox = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.trap2Enabled"));
    JTextField trap2AddressText = new JTextField();
    JTextField trap2PortText = new JTextField();
    JComboBox trap2SeverityCombo = new JComboBox<String>(this.trapSeverityChoices);
    JLabel trap2EnabledLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapEnabled"));
    JLabel trap2AddressLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAddress"));
    JLabel trap2PortLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapPort"));
    JLabel trap2SeverityLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapSeverity"));
    JLabel snmpTrap2Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpTraps"));
    JLabel trap2VersionLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion"));
    JComboBox trap2VersionCombo = new JComboBox<String>(this.trapVersionChoices);
    JPanel trap3Panel = new JPanel();
    JCheckBox trap3EnabledChBox = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.trap3Enabled"));
    JTextField trap3AddressText = new JTextField();
    JTextField trap3PortText = new JTextField();
    JComboBox trap3SeverityCombo = new JComboBox<String>(this.trapSeverityChoices);
    JLabel trap3EnabledLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapEnabled"));
    JLabel trap3AddressLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAddress"));
    JLabel trap3PortLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapPort"));
    JLabel trap3SeverityLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapSeverity"));
    JLabel snmpTrap3Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpTraps"));
    JLabel trap3VersionLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion"));
    JComboBox trap3VersionCombo = new JComboBox<String>(this.trapVersionChoices);
    JPanel trap4Panel = new JPanel();
    JCheckBox trap4EnabledChBox = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.trap4Enabled"));
    JTextField trap4AddressText = new JTextField();
    JTextField trap4PortText = new JTextField();
    JComboBox trap4SeverityCombo = new JComboBox<String>(this.trapSeverityChoices);
    JLabel trap4EnabledLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapEnabled"));
    JLabel trap4AddressLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAddress"));
    JLabel trap4PortLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapPort"));
    JLabel trap4SeverityLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapSeverity"));
    JLabel snmpTrap4Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpTraps"));
    JLabel trap4VersionLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion"));
    JComboBox trap4VersionCombo = new JComboBox<String>(this.trapVersionChoices);
    JPanel trap5Panel = new JPanel();
    JCheckBox trap5EnabledChBox = new JCheckBox(FabricTreeControl.getResource("NetworkPropertiesDialog.trap5Enabled"));
    JTextField trap5AddressText = new JTextField();
    JTextField trap5PortText = new JTextField();
    JComboBox trap5SeverityCombo = new JComboBox<String>(this.trapSeverityChoices);
    JLabel trap5EnabledLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapEnabled"));
    JLabel trap5AddressLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapAddress"));
    JLabel trap5PortLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapPort"));
    JLabel trap5SeverityLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapSeverity"));
    JLabel snmpTrap5Label = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.snmpTraps"));
    JLabel trap5VersionLabel = new JLabel(FabricTreeControl.getResource("NetworkPropertiesDialog.trapVersion"));
    JComboBox trap5VersionCombo = new JComboBox<String>(this.trapVersionChoices);
    FixedLengthTextField contactText = new FixedLengthTextField(32);
    FixedLengthTextField locationText = new FixedLengthTextField(32);
    FixedLengthTextField readCommText = new FixedLengthTextField(32);
    FixedLengthTextField writeCommText = new FixedLengthTextField(32);
    FixedLengthTextField trapCommText = new FixedLengthTextField(32);
    protected JComboBox trapAuthCombo = new JComboBox<String>(this.trapAuthChoices);
    protected FixedLengthTextField roUserText = new FixedLengthTextField(32);
    protected FixedLengthTextField rwUserText = new FixedLengthTextField(32);
    protected FixedLengthTextField roPassPhraseText = new FixedLengthTextField(32);
    protected FixedLengthTextField rwPassPhraseText = new FixedLengthTextField(32);
    InetAddress newIpAddress = null;
    boolean settingRarp = false;

    public NetworkPropertiesDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        super((Frame)jFrame, bl);
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.frame = jFrame;
        this.setTitle(FabricTreeControl.getResource("NetworkPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.networkPanel = this.buildPanel();
        this.bootMethodCombo.addActionListener(new BootMethodComboListener(this));
        this.resetPanel();
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.networkPropertiesDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.networkPanel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void setSwitch(SanboxChassis sanboxChassis, Fabric fabric) {
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.unregisterForEvents();
        this.resetDialog();
    }

    public void resetDialog() {
        this.resetPanel();
        this.setEnabled(true);
    }

    public void resetDialog(SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        this.unregisterForEvents();
        this.waitingOnIpChange = false;
        this.waitingOnSnmpChange = false;
        this.waitingOnSyslogChange = false;
        this.newIpAddress = null;
        this.settingRarp = false;
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.resetDialog();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.bootMethodCombo.getSelectedIndex() == 0) {
            this.ipAddrText.setEnabled(bl);
            this.ipAddrLabel.setEnabled(bl);
            this.subnetMaskLabel.setEnabled(bl);
            this.subnetMaskText.setEnabled(bl);
            this.gatewayLabel.setEnabled(bl);
            this.gatewayText.setEnabled(bl);
        } else if (this.bootMethodCombo.getSelectedIndex() == 2) {
            this.ipAddrText.setEnabled(false);
            this.ipAddrLabel.setEnabled(false);
            this.subnetMaskLabel.setEnabled(bl);
            this.subnetMaskText.setEnabled(bl);
            this.gatewayLabel.setEnabled(bl);
            this.gatewayText.setEnabled(bl);
        } else {
            this.ipAddrText.setEnabled(false);
            this.ipAddrLabel.setEnabled(false);
            this.subnetMaskLabel.setEnabled(false);
            this.subnetMaskText.setEnabled(false);
            this.gatewayLabel.setEnabled(false);
            this.gatewayText.setEnabled(false);
        }
        if (this.blade.getChassisType() == 33) {
            this.bootMethodCombo.setEnabled(false);
            this.bootMethodLabel.setEnabled(false);
        } else {
            this.bootMethodCombo.setEnabled(bl);
        }
        this.syslogEnable.setEnabled(bl);
        this.syslogAddr.setEnabled(bl ? this.syslogEnable.isSelected() : false);
        this.contactText.setEnabled(bl);
        this.locationText.setEnabled(bl);
        this.readCommText.setEnabled(bl);
        this.writeCommText.setEnabled(bl);
        this.trapCommText.setEnabled(bl);
        this.trapAuthCombo.setEnabled(bl);
        this.roUserText.setEnabled(bl);
        this.rwUserText.setEnabled(bl);
        this.roPassPhraseText.setEnabled(bl);
        this.rwPassPhraseText.setEnabled(bl);
        this.trapTabPane.setEnabled(bl);
        this.trap1EnabledChBox.setEnabled(bl);
        this.trap2EnabledChBox.setEnabled(bl);
        this.trap3EnabledChBox.setEnabled(bl);
        this.trap4EnabledChBox.setEnabled(bl);
        this.trap5EnabledChBox.setEnabled(bl);
    }

    public void resetPanel() {
        boolean bl;
        this.wwNameContent.setText(this.blade.getWWName().delimit());
        int n = this.blade.getAdminMode();
        switch (n) {
            case 1: {
                this.opStateContent.setText(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateContent.0"));
                break;
            }
            case 2: {
                this.opStateContent.setText(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateContent.1"));
                break;
            }
            case 3: {
                this.opStateContent.setText(FabricTreeControl.getResource("NetworkPropertiesDialog.opStateContent.2"));
            }
        }
        this.fcAddrContent.setText(this.blade.delimitFCAddress());
        this.firmwareContent.setText(this.blade.getFlashVersionString());
        this.chassisNameContent.setText(this.blade.getChassisName());
        this.macAddrContent.setText(this.blade.delimitMacAddress());
        int n2 = this.wwNameContent.getFont().getSize();
        Font font = new Font("Dialog", 0, n2);
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        this.opStateContent.setFont(font);
        this.opStateContent.setForeground(Color.black);
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        this.firmwareContent.setFont(font);
        this.firmwareContent.setForeground(Color.black);
        this.chassisNameContent.setFont(font);
        this.chassisNameContent.setForeground(Color.black);
        this.macAddrContent.setFont(font);
        this.macAddrContent.setForeground(Color.black);
        IPInfo iPInfo = this.blade.getIpInfo();
        this.ipAddrText.setText(iPInfo.getIpAddress().getHostAddress());
        this.subnetMaskText.setText(SwitchProperties.intToIpString(iPInfo.getNetMask()));
        this.gatewayText.setText(iPInfo.getGateway().getHostAddress());
        int n3 = iPInfo.getIpBootProcess();
        switch (n3) {
            case 0: {
                this.bootMethodCombo.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.bootMethodCombo.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.bootMethodCombo.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.bootMethodCombo.setSelectedIndex(3);
            }
        }
        if (this.bootMethodCombo.getSelectedIndex() == 0) {
            this.ipAddrText.setEnabled(true);
            this.ipAddrLabel.setEnabled(true);
            this.subnetMaskLabel.setEnabled(true);
            this.subnetMaskText.setEnabled(true);
            this.gatewayLabel.setEnabled(true);
            this.gatewayText.setEnabled(true);
        } else if (this.bootMethodCombo.getSelectedIndex() == 2) {
            this.ipAddrText.setEnabled(false);
            this.ipAddrLabel.setEnabled(false);
            this.subnetMaskLabel.setEnabled(true);
            this.subnetMaskText.setEnabled(true);
            this.gatewayLabel.setEnabled(true);
            this.gatewayText.setEnabled(true);
        } else {
            this.ipAddrText.setEnabled(false);
            this.ipAddrLabel.setEnabled(false);
            this.subnetMaskLabel.setEnabled(false);
            this.subnetMaskText.setEnabled(false);
            this.gatewayLabel.setEnabled(false);
            this.gatewayText.setEnabled(false);
        }
        SnmpInfo snmpInfo = this.blade.getSnmpInfo();
        boolean bl2 = bl = ((Sanbox2)this.blade).getFirmwareVersion() >= 5;
        if (bl) {
            this.snmpProxyEnable.setSelected(snmpInfo.getProxyEnabled());
        }
        this.contactText.setText(snmpInfo.getContact());
        this.contactText.setCaretPosition(0);
        this.locationText.setText(snmpInfo.getLocation());
        this.locationText.setCaretPosition(0);
        this.readCommText.setText("");
        this.writeCommText.setText("");
        this.trapCommText.setText("");
        this.trapAuthCombo.setSelectedIndex(snmpInfo.getDoAuthTrap() == 1L ? 0 : 1);
        SnmpTrapConfig snmpTrapConfig = snmpInfo.getSnmpTrapConfig(0);
        this.trap1AddressText.setText(snmpTrapConfig.getAddress().getHostAddress());
        this.trap1PortText.setText(new Integer(snmpTrapConfig.getPort()).toString());
        String string = snmpTrapConfig.getSeverity();
        this.trap1SeverityCombo.setSelectedIndex(this.translateSeverityStringToIndex(string));
        this.trap1SeverityCombo.setMaximumRowCount(6);
        this.trap1VersionCombo.setSelectedIndex(snmpTrapConfig.getVersion() - 1);
        if (snmpTrapConfig.isEnabled()) {
            this.trap1EnabledChBox.setSelected(true);
            this.trap1AddressLabel.setEnabled(true);
            this.trap1AddressText.setEnabled(true);
            this.trap1PortLabel.setEnabled(true);
            this.trap1PortText.setEnabled(true);
            this.trap1SeverityLabel.setEnabled(true);
            this.trap1SeverityCombo.setEnabled(true);
            this.trap1VersionLabel.setEnabled(true);
            this.trap1VersionCombo.setEnabled(true);
        } else {
            this.trap1EnabledChBox.setSelected(false);
            this.trap1AddressLabel.setEnabled(false);
            this.trap1AddressText.setEnabled(false);
            this.trap1PortLabel.setEnabled(false);
            this.trap1PortText.setEnabled(false);
            this.trap1SeverityLabel.setEnabled(false);
            this.trap1SeverityCombo.setEnabled(false);
            this.trap1VersionLabel.setEnabled(false);
            this.trap1VersionCombo.setEnabled(false);
        }
        snmpTrapConfig = snmpInfo.getSnmpTrapConfig(1);
        this.trap2AddressText.setText(snmpTrapConfig.getAddress().getHostAddress());
        this.trap2PortText.setText(new Integer(snmpTrapConfig.getPort()).toString());
        string = snmpTrapConfig.getSeverity();
        this.trap2SeverityCombo.setSelectedIndex(this.translateSeverityStringToIndex(string));
        this.trap2SeverityCombo.setMaximumRowCount(6);
        this.trap2VersionCombo.setSelectedIndex(snmpTrapConfig.getVersion() - 1);
        if (snmpTrapConfig.isEnabled()) {
            this.trap2EnabledChBox.setSelected(true);
            this.trap2AddressLabel.setEnabled(true);
            this.trap2AddressText.setEnabled(true);
            this.trap2PortLabel.setEnabled(true);
            this.trap2PortText.setEnabled(true);
            this.trap2SeverityLabel.setEnabled(true);
            this.trap2SeverityCombo.setEnabled(true);
            this.trap2VersionLabel.setEnabled(true);
            this.trap2VersionCombo.setEnabled(true);
        } else {
            this.trap2EnabledChBox.setSelected(false);
            this.trap2AddressLabel.setEnabled(false);
            this.trap2AddressText.setEnabled(false);
            this.trap2PortLabel.setEnabled(false);
            this.trap2PortText.setEnabled(false);
            this.trap2SeverityLabel.setEnabled(false);
            this.trap2SeverityCombo.setEnabled(false);
            this.trap2VersionLabel.setEnabled(false);
            this.trap2VersionCombo.setEnabled(false);
        }
        snmpTrapConfig = snmpInfo.getSnmpTrapConfig(2);
        this.trap3AddressText.setText(snmpTrapConfig.getAddress().getHostAddress());
        this.trap3PortText.setText(new Integer(snmpTrapConfig.getPort()).toString());
        string = snmpTrapConfig.getSeverity();
        this.trap3SeverityCombo.setSelectedIndex(this.translateSeverityStringToIndex(string));
        this.trap3SeverityCombo.setMaximumRowCount(6);
        this.trap3VersionCombo.setSelectedIndex(snmpTrapConfig.getVersion() - 1);
        if (snmpTrapConfig.isEnabled()) {
            this.trap3EnabledChBox.setSelected(true);
            this.trap3AddressLabel.setEnabled(true);
            this.trap3AddressText.setEnabled(true);
            this.trap3PortLabel.setEnabled(true);
            this.trap3PortText.setEnabled(true);
            this.trap3SeverityLabel.setEnabled(true);
            this.trap3SeverityCombo.setEnabled(true);
            this.trap3VersionLabel.setEnabled(true);
            this.trap3VersionCombo.setEnabled(true);
        } else {
            this.trap3EnabledChBox.setSelected(false);
            this.trap3AddressLabel.setEnabled(false);
            this.trap3AddressText.setEnabled(false);
            this.trap3PortLabel.setEnabled(false);
            this.trap3PortText.setEnabled(false);
            this.trap3SeverityLabel.setEnabled(false);
            this.trap3SeverityCombo.setEnabled(false);
            this.trap3VersionLabel.setEnabled(false);
            this.trap3VersionCombo.setEnabled(false);
        }
        snmpTrapConfig = snmpInfo.getSnmpTrapConfig(3);
        this.trap4AddressText.setText(snmpTrapConfig.getAddress().getHostAddress());
        this.trap4PortText.setText(new Integer(snmpTrapConfig.getPort()).toString());
        string = snmpTrapConfig.getSeverity();
        this.trap4SeverityCombo.setSelectedIndex(this.translateSeverityStringToIndex(string));
        this.trap4SeverityCombo.setMaximumRowCount(6);
        this.trap4VersionCombo.setSelectedIndex(snmpTrapConfig.getVersion() - 1);
        if (snmpTrapConfig.isEnabled()) {
            this.trap4EnabledChBox.setSelected(true);
            this.trap4AddressLabel.setEnabled(true);
            this.trap4AddressText.setEnabled(true);
            this.trap4PortLabel.setEnabled(true);
            this.trap4PortText.setEnabled(true);
            this.trap4SeverityLabel.setEnabled(true);
            this.trap4SeverityCombo.setEnabled(true);
            this.trap4VersionLabel.setEnabled(true);
            this.trap4VersionCombo.setEnabled(true);
        } else {
            this.trap4EnabledChBox.setSelected(false);
            this.trap4AddressLabel.setEnabled(false);
            this.trap4AddressText.setEnabled(false);
            this.trap4PortLabel.setEnabled(false);
            this.trap4PortText.setEnabled(false);
            this.trap4SeverityLabel.setEnabled(false);
            this.trap4SeverityCombo.setEnabled(false);
            this.trap4VersionLabel.setEnabled(false);
            this.trap4VersionCombo.setEnabled(false);
        }
        snmpTrapConfig = snmpInfo.getSnmpTrapConfig(4);
        this.trap5AddressText.setText(snmpTrapConfig.getAddress().getHostAddress());
        this.trap5PortText.setText(new Integer(snmpTrapConfig.getPort()).toString());
        string = snmpTrapConfig.getSeverity();
        this.trap5SeverityCombo.setSelectedIndex(this.translateSeverityStringToIndex(string));
        this.trap5SeverityCombo.setMaximumRowCount(6);
        this.trap5VersionCombo.setSelectedIndex(snmpTrapConfig.getVersion() - 1);
        if (snmpTrapConfig.isEnabled()) {
            this.trap5EnabledChBox.setSelected(true);
            this.trap5AddressLabel.setEnabled(true);
            this.trap5AddressText.setEnabled(true);
            this.trap5PortLabel.setEnabled(true);
            this.trap5PortText.setEnabled(true);
            this.trap5SeverityLabel.setEnabled(true);
            this.trap5SeverityCombo.setEnabled(true);
            this.trap5VersionLabel.setEnabled(true);
            this.trap5VersionCombo.setEnabled(true);
        } else {
            this.trap5EnabledChBox.setSelected(false);
            this.trap5AddressLabel.setEnabled(false);
            this.trap5AddressText.setEnabled(false);
            this.trap5PortLabel.setEnabled(false);
            this.trap5PortText.setEnabled(false);
            this.trap5SeverityLabel.setEnabled(false);
            this.trap5SeverityCombo.setEnabled(false);
            this.trap5VersionLabel.setEnabled(false);
            this.trap5VersionCombo.setEnabled(false);
        }
        this.syslogEnable.setSelected(((Sanbox2)this.blade).isSyslogEnabled());
        this.syslogAddr.setText(((Sanbox2)this.blade).getSyslogAddr().getHostAddress());
        this.syslogAddr.setEnabled(this.syslogEnable.isSelected());
        this.syslogAddrLabel.setEnabled(this.syslogEnable.isSelected());
        this.validate();
    }

    public int translateSeverityStringToIndex(String string) {
        String string2 = string.toLowerCase();
        int n = this.trapSeverityChoices.length;
        int n2 = 0;
        while (n2 < n) {
            if (string2.equals(this.trapSeverityChoices[n2].toLowerCase())) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    protected JPanel buildPanel() {
        boolean bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.baseLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        jPanel.add((Component)this.ipPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        jPanel.add((Component)this.snmpPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 4;
        jPanel.add((Component)this.trapTabPane, gridBagConstraints);
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.syslogPanel, gridBagConstraints);
        this.idPanel.setLayout(this.idLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        this.idPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.chassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrContent, gridBagConstraints);
        this.idPanel.setBorder(BorderFactory.createEtchedBorder());
        this.idPanel.setBackground(Color.white);
        this.ipPanel.setLayout(this.ipLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.ipPanel.add((Component)this.ipLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.ipAddrText.setColumns(14);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.ipAddrText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.subnetMaskLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.subnetMaskText.setColumns(12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.subnetMaskText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.gatewayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.gatewayText.setColumns(12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.gatewayText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.bootMethodLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipPanel.add((Component)this.bootMethodCombo, gridBagConstraints);
        if (this.blade.getChassisType() == 33) {
            this.bootMethodCombo.setEnabled(false);
            this.bootMethodLabel.setEnabled(false);
        }
        this.ipPanel.setBorder(BorderFactory.createEtchedBorder());
        this.syslogPanel.setLayout(this.syslogLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.syslogPanel.add((Component)this.syslogEnable, gridBagConstraints);
        this.syslogAddrLabel.setEnabled(this.syslogEnable.isSelected());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.syslogPanel.add((Component)this.syslogAddrLabel, gridBagConstraints);
        this.syslogAddr.setEnabled(this.syslogEnable.isSelected());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        this.syslogAddr.setColumns(10);
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.syslogPanel.add((Component)this.syslogAddr, gridBagConstraints);
        this.syslogAddr.setEnabled(this.syslogEnable.isSelected());
        this.syslogPanel.setBorder(BorderFactory.createEtchedBorder());
        this.snmpPanel.setLayout(this.snmpLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.snmpPanel.add((Component)this.snmpLabel, gridBagConstraints);
        boolean bl2 = bl = ((Sanbox2)this.blade).getFirmwareVersion() >= 5;
        if (bl) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            this.snmpPanel.add((Component)this.snmpProxyEnable, gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.snmpPanel.add((Component)this.contactLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.contactText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.contactText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.locationText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.readCommLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.readCommText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapAuthLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapAuthCombo, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapCommLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.trapCommText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.writeCommLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.locationText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.snmpPanel.add((Component)this.writeCommText, gridBagConstraints);
        this.snmpPanel.setBorder(BorderFactory.createEtchedBorder());
        this.createTrapPanel();
        return jPanel;
    }

    protected void createTrapPanel() {
        this.trap1EnabledChBox.addActionListener(new TrapEnabledListener(1));
        this.trap2EnabledChBox.addActionListener(new TrapEnabledListener(2));
        this.trap3EnabledChBox.addActionListener(new TrapEnabledListener(3));
        this.trap4EnabledChBox.addActionListener(new TrapEnabledListener(4));
        this.trap5EnabledChBox.addActionListener(new TrapEnabledListener(5));
        this.syslogEnable.addActionListener(new SyslogEnableListener(this));
        Color color = this.trap1SeverityLabel.getForeground();
        this.trap1EnabledChBox.setForeground(color);
        this.trap2EnabledChBox.setForeground(color);
        this.trap3EnabledChBox.setForeground(color);
        this.trap4EnabledChBox.setForeground(color);
        this.trap5EnabledChBox.setForeground(color);
        this.trap1Panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap1Panel.add((Component)this.snmpTrap1Label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap1Panel.add((Component)this.trap1EnabledChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap1Panel.add((Component)this.trap1VersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap1Panel.add((Component)this.trap1VersionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap1Panel.add((Component)this.trap1SeverityLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap1Panel.add((Component)this.trap1SeverityCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap1Panel.add((Component)this.trap1AddressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.trap1AddressText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap1Panel.add((Component)this.trap1AddressText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap1Panel.add((Component)this.trap1PortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.trap1PortText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap1Panel.add((Component)this.trap1PortText, gridBagConstraints);
        this.trap2Panel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap2Panel.add((Component)this.snmpTrap2Label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap2Panel.add((Component)this.trap2EnabledChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap2Panel.add((Component)this.trap2VersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap2Panel.add((Component)this.trap2VersionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap2Panel.add((Component)this.trap2SeverityLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap2Panel.add((Component)this.trap2SeverityCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap2Panel.add((Component)this.trap2AddressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.trap2AddressText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap2Panel.add((Component)this.trap2AddressText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap2Panel.add((Component)this.trap2PortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap2PortText.setColumns(10);
        this.trap2Panel.add((Component)this.trap2PortText, gridBagConstraints);
        this.trap3Panel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap3Panel.add((Component)this.snmpTrap3Label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap3Panel.add((Component)this.trap3EnabledChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap3Panel.add((Component)this.trap3VersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap3Panel.add((Component)this.trap3VersionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap3Panel.add((Component)this.trap3SeverityLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap3Panel.add((Component)this.trap3SeverityCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap3Panel.add((Component)this.trap3AddressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.trap3AddressText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap3Panel.add((Component)this.trap3AddressText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap3Panel.add((Component)this.trap3PortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap3PortText.setColumns(10);
        this.trap3Panel.add((Component)this.trap3PortText, gridBagConstraints);
        this.trap4Panel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap4Panel.add((Component)this.snmpTrap4Label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap4Panel.add((Component)this.trap4EnabledChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap4Panel.add((Component)this.trap4VersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap4Panel.add((Component)this.trap4VersionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap4Panel.add((Component)this.trap4SeverityLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap4Panel.add((Component)this.trap4SeverityCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap4Panel.add((Component)this.trap4AddressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.trap4AddressText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap4Panel.add((Component)this.trap4AddressText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap4Panel.add((Component)this.trap4PortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap4PortText.setColumns(10);
        this.trap4Panel.add((Component)this.trap4PortText, gridBagConstraints);
        this.trap5Panel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap5Panel.add((Component)this.snmpTrap5Label, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap5Panel.add((Component)this.trap5EnabledChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 20);
        this.trap5Panel.add((Component)this.trap5VersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap5Panel.add((Component)this.trap5VersionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap5Panel.add((Component)this.trap5SeverityLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap5Panel.add((Component)this.trap5SeverityCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap5Panel.add((Component)this.trap5AddressLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.trap5AddressText.setColumns(10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap5Panel.add((Component)this.trap5AddressText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.trap5Panel.add((Component)this.trap5PortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        this.trap5PortText.setColumns(10);
        this.trap5Panel.add((Component)this.trap5PortText, gridBagConstraints);
        this.trapTabPane.add(FabricTreeControl.getResource("NetworkPropertiesDialog.trap1"), this.trap1Panel);
        this.trapTabPane.add(FabricTreeControl.getResource("NetworkPropertiesDialog.trap2"), this.trap2Panel);
        this.trapTabPane.add(FabricTreeControl.getResource("NetworkPropertiesDialog.trap3"), this.trap3Panel);
        this.trapTabPane.add(FabricTreeControl.getResource("NetworkPropertiesDialog.trap4"), this.trap4Panel);
        this.trapTabPane.add(FabricTreeControl.getResource("NetworkPropertiesDialog.trap5"), this.trap5Panel);
    }

    protected void registerForEvents() {
        this.chassisEventAdapter.registerEventHandler(214, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(202, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(315, "receiveChassisEvent");
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.chassisEventAdapter.unregisterEventHandler(214);
        this.chassisEventAdapter.unregisterEventHandler(202);
        this.chassisEventAdapter.unregisterEventHandler(315);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(201));
        vector.add(new Integer(213));
        vector.add(new Integer(314));
        return vector;
    }

    public void disableButtons() {
        this.properties.applyButton.setEnabled(false);
        this.networkPanel.setEnabled(false);
        this.setEnabled(false);
    }

    public void enableButtons() {
        this.properties.applyButton.setEnabled(true);
        this.properties.cancelButton.setEnabled(true);
        this.networkPanel.setEnabled(true);
        this.setEnabled(true);
    }

    public SnmpInfo copySnmpInfo(SnmpInfo snmpInfo) {
        SnmpInfo snmpInfo2 = new SnmpInfo();
        snmpInfo2.setName(snmpInfo.getName());
        snmpInfo2.setLocation(snmpInfo.getLocation());
        snmpInfo2.setContact(snmpInfo.getContact());
        snmpInfo2.setDoAuthTrap(snmpInfo.getDoAuthTrap());
        snmpInfo2.setTrapAddress(snmpInfo.getTrapAddress());
        snmpInfo2.setReadComm(snmpInfo.getReadComm());
        snmpInfo2.setWriteComm(snmpInfo.getWriteComm());
        snmpInfo2.setTrapComm(snmpInfo.getTrapComm());
        snmpInfo2.setDoAuthTrap(snmpInfo.getDoAuthTrap());
        snmpInfo2.setReadOnlyUser(snmpInfo.getReadOnlyUser());
        snmpInfo2.setReadWriteUser(snmpInfo.getReadWriteUser());
        snmpInfo2.setReadOnlyPassPhrase(snmpInfo.getReadOnlyPassPhrase());
        snmpInfo2.setReadWritePassPhrase(snmpInfo.getReadWritePassPhrase());
        int n = 0;
        while (n < 5) {
            SnmpTrapConfig snmpTrapConfig = new SnmpTrapConfig();
            SnmpTrapConfig snmpTrapConfig2 = snmpInfo.getSnmpTrapConfig(n);
            snmpTrapConfig.setAddress(snmpTrapConfig2.getAddress());
            snmpTrapConfig.setPort(snmpTrapConfig2.getPort());
            snmpTrapConfig.setSeverity(snmpTrapConfig2.getSeverity());
            snmpTrapConfig.setEnabled(snmpTrapConfig2.isEnabled());
            snmpInfo2.setSnmpTrapConfig(n, snmpTrapConfig);
            ++n;
        }
        return snmpInfo2;
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyNetworkProperties() {
        SnmpInfo snmpInfo;
        int n;
        IPInfo iPInfo;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        InetAddress inetAddress;
        int n7 = 0;
        int n8 = 0;
        InetAddress inetAddress2 = null;
        InetAddress inetAddress3 = null;
        this.waitingOnIpChange = false;
        this.waitingOnSnmpChange = false;
        this.waitingOnSyslogChange = false;
        this.newIpAddress = null;
        this.settingRarp = false;
        boolean bl = ((Sanbox2)this.blade).getFirmwareVersion() >= 5;
        boolean bl2 = false;
        if (bl) {
            bl2 = this.snmpProxyEnable.isSelected();
        }
        String string = this.contactText.getText().trim();
        String string2 = this.locationText.getText().trim();
        if (string.indexOf(44) != -1 || string.indexOf(59) != -1 || string.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidString"));
            return -1;
        }
        if (string2.indexOf(44) != -1 || string2.indexOf(59) != -1 || string2.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidString"));
            return -1;
        }
        String string3 = this.readCommText.getText().trim();
        String string4 = this.writeCommText.getText().trim();
        String string5 = this.trapCommText.getText().trim();
        if (string3.indexOf(44) != -1 || string3.indexOf(59) != -1 || string3.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidString"));
            return -1;
        }
        if (string4.indexOf(44) != -1 || string4.indexOf(59) != -1 || string4.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidString"));
            return -1;
        }
        if (string5.indexOf(44) != -1 || string5.indexOf(59) != -1 || string5.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidString"));
            return -1;
        }
        if (string3.indexOf(32) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidReadCommString"));
            return -1;
        }
        if (string4.indexOf(32) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidWriteCommString"));
            return -1;
        }
        if (string5.indexOf(32) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidTrapCommString"));
            return -1;
        }
        SnmpTrapConfig snmpTrapConfig = new SnmpTrapConfig();
        SnmpTrapConfig snmpTrapConfig2 = new SnmpTrapConfig();
        SnmpTrapConfig snmpTrapConfig3 = new SnmpTrapConfig();
        SnmpTrapConfig snmpTrapConfig4 = new SnmpTrapConfig();
        SnmpTrapConfig snmpTrapConfig5 = new SnmpTrapConfig();
        String string6 = this.trap1AddressText.getText().trim();
        if (IpAddress.isNumeric(string6) && !IpAddress.isValidTrapAddress(string6)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap1Addr"));
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(string6);
            snmpTrapConfig.setAddress(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap1Addr"));
            return -1;
        }
        string6 = this.trap2AddressText.getText().trim();
        if (IpAddress.isNumeric(string6) && !IpAddress.isValidTrapAddress(string6)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap2Addr"));
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(string6);
            snmpTrapConfig2.setAddress(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap2Addr"));
            return -1;
        }
        string6 = this.trap3AddressText.getText().trim();
        if (IpAddress.isNumeric(string6) && !IpAddress.isValidTrapAddress(string6)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap3Addr"));
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(string6);
            snmpTrapConfig3.setAddress(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap3Addr"));
            return -1;
        }
        string6 = this.trap4AddressText.getText().trim();
        if (IpAddress.isNumeric(string6) && !IpAddress.isValidTrapAddress(string6)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap4Addr"));
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(string6);
            snmpTrapConfig4.setAddress(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap4Addr"));
            return -1;
        }
        string6 = this.trap5AddressText.getText().trim();
        if (IpAddress.isNumeric(string6) && !IpAddress.isValidTrapAddress(string6)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap5Addr"));
            return -1;
        }
        try {
            inetAddress = InetAddress.getByName(string6);
            snmpTrapConfig5.setAddress(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap5Addr"));
            return -1;
        }
        try {
            n6 = Integer.parseInt(this.trap1PortText.getText().trim());
            n5 = Integer.parseInt(this.trap2PortText.getText().trim());
            n4 = Integer.parseInt(this.trap3PortText.getText().trim());
            n3 = Integer.parseInt(this.trap4PortText.getText().trim());
            n2 = Integer.parseInt(this.trap5PortText.getText().trim());
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, "Invalid trap port number.");
            return -1;
        }
        if (n6 <= 0 || n6 > 65535) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap1Port"));
            return -1;
        }
        snmpTrapConfig.setPort(n6);
        if (n5 <= 0 || n5 > 65535) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap2Port"));
            return -1;
        }
        snmpTrapConfig2.setPort(n5);
        if (n4 <= 0 || n4 > 65535) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap3Port"));
            return -1;
        }
        snmpTrapConfig3.setPort(n4);
        if (n3 <= 0 || n3 > 65535) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap4Port"));
            return -1;
        }
        snmpTrapConfig4.setPort(n3);
        if (n2 <= 0 || n2 > 65535) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTrap5Port"));
            return -1;
        }
        snmpTrapConfig5.setPort(n2);
        SnmpTrapConfig[] snmpTrapConfigArray = new SnmpTrapConfig[]{snmpTrapConfig, snmpTrapConfig2, snmpTrapConfig3, snmpTrapConfig4, snmpTrapConfig5};
        if (!this.isTrapAddressAndTrapPortComboUnique(snmpTrapConfigArray)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.trapConfig.notUnique"));
            return -1;
        }
        String string7 = ((String)this.trap1SeverityCombo.getSelectedItem()).toLowerCase();
        snmpTrapConfig.setSeverity(string7);
        string7 = ((String)this.trap2SeverityCombo.getSelectedItem()).toLowerCase();
        snmpTrapConfig2.setSeverity(string7);
        string7 = ((String)this.trap3SeverityCombo.getSelectedItem()).toLowerCase();
        snmpTrapConfig3.setSeverity(string7);
        string7 = ((String)this.trap4SeverityCombo.getSelectedItem()).toLowerCase();
        snmpTrapConfig4.setSeverity(string7);
        string7 = ((String)this.trap5SeverityCombo.getSelectedItem()).toLowerCase();
        snmpTrapConfig5.setSeverity(string7);
        snmpTrapConfig.setEnabled(this.trap1EnabledChBox.isSelected());
        snmpTrapConfig2.setEnabled(this.trap2EnabledChBox.isSelected());
        snmpTrapConfig3.setEnabled(this.trap3EnabledChBox.isSelected());
        snmpTrapConfig4.setEnabled(this.trap4EnabledChBox.isSelected());
        snmpTrapConfig5.setEnabled(this.trap5EnabledChBox.isSelected());
        snmpTrapConfig.setVersion(this.trap1VersionCombo.getSelectedIndex() + 1);
        snmpTrapConfig2.setVersion(this.trap2VersionCombo.getSelectedIndex() + 1);
        snmpTrapConfig3.setVersion(this.trap3VersionCombo.getSelectedIndex() + 1);
        snmpTrapConfig4.setVersion(this.trap4VersionCombo.getSelectedIndex() + 1);
        snmpTrapConfig5.setVersion(this.trap5VersionCombo.getSelectedIndex() + 1);
        int n9 = this.trapAuthCombo.getSelectedIndex();
        if (n9 < 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidTrapAuthentication"));
            return -1;
        }
        int n10 = n9 == 0 ? 1 : 0;
        boolean bl3 = this.syslogEnable.isSelected();
        String string8 = this.syslogAddr.getText().trim();
        if (bl3) {
            if (string8.length() == 0 || IpAddress.isNumeric(string8) && !IpAddress.isValidNumeric(string8)) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.error.invalidSyslogAddr"));
                return -1;
            }
            try {
                inetAddress3 = InetAddress.getByName(string8);
            }
            catch (UnknownHostException unknownHostException) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.error.invalidSyslogAddr"));
                return -1;
            }
        } else {
            inetAddress3 = ((Sanbox2)this.blade).getSyslogAddr();
        }
        String string9 = this.ipAddrText.getText().trim();
        String string10 = this.subnetMaskText.getText().trim();
        String string11 = this.gatewayText.getText().trim();
        if (string9.length() == 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidIpAddr"));
            return -1;
        }
        if (IpAddress.isNumeric(string9) && !IpAddress.isValidNumeric(string9)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidIpAddr"));
            return -1;
        }
        try {
            this.newIpAddress = InetAddress.getByName(string9);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidIpAddr"));
            return -1;
        }
        if (IpAddress.isNumeric(string10) && !IpAddress.isValidMask(string10)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidNetMask"));
            return -1;
        }
        try {
            InetAddress inetAddress4 = InetAddress.getByName(string10);
            if (inetAddress4 == null) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.inetAddrFailed"));
                return -1;
            }
            n8 = SwitchProperties.inetToInt(inetAddress4);
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidNetMask"));
            return -1;
        }
        boolean bl4 = false;
        if (string10.length() == 0) {
            bl4 = true;
            iPInfo = this.blade.getIpInfo();
            n8 = iPInfo.getNetMask();
        }
        if (this.blade.getChassisType() == 33) {
            if (IpAddress.isNumeric(string11) && !IpAddress.isValidSwitchbladeGateway(string11)) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidGateway"));
                return -1;
            }
        } else if (IpAddress.isNumeric(string11) && !IpAddress.isValidNumeric(string11)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidGateway"));
            return -1;
        }
        try {
            inetAddress2 = InetAddress.getByName(string11);
        }
        catch (UnknownHostException unknownHostException) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidGateway"));
            return -1;
        }
        boolean bl5 = false;
        if (string11.length() == 0) {
            bl5 = true;
            iPInfo = this.blade.getIpInfo();
            inetAddress2 = iPInfo.getGateway();
        }
        if ((n = this.bootMethodCombo.getSelectedIndex()) < 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.invalidBootMethod"));
            return -1;
        }
        switch (n) {
            case 0: {
                n7 = 0;
                break;
            }
            case 1: {
                n7 = 1;
                break;
            }
            case 2: {
                n7 = 2;
                this.settingRarp = true;
                break;
            }
            case 3: {
                n7 = 3;
                break;
            }
            default: {
                n7 = -1;
            }
        }
        SnmpInfo snmpInfo2 = this.blade.getSnmpInfo();
        if (!(!bl2 != snmpInfo2.getProxyEnabled() && string.equals(snmpInfo2.getContact()) && string2.equals(snmpInfo2.getLocation()) && string3.length() <= 0 && string4.length() <= 0 && string5.length() <= 0 && n10 == (int)snmpInfo2.getDoAuthTrap() && snmpTrapConfig.equals((Object)snmpInfo2.getSnmpTrapConfig(0)) && snmpTrapConfig2.equals((Object)snmpInfo2.getSnmpTrapConfig(1)) && snmpTrapConfig3.equals((Object)snmpInfo2.getSnmpTrapConfig(2)) && snmpTrapConfig4.equals((Object)snmpInfo2.getSnmpTrapConfig(3)) && snmpTrapConfig5.equals((Object)snmpInfo2.getSnmpTrapConfig(4)))) {
            this.chassisEventAdapter.registerEventHandler(214, "receiveChassisEvent");
            this.waitingOnSnmpChange = true;
            snmpInfo = this.copySnmpInfo(snmpInfo2);
            snmpInfo.setName(snmpInfo2.getName());
            if (bl) {
                snmpInfo.setProxyEnabled(bl2);
            }
            snmpInfo.setContact(string);
            snmpInfo.setLocation(string2);
            snmpInfo.setDoAuthTrap((long)n10);
            snmpInfo.setSnmpTrapConfig(0, snmpTrapConfig);
            snmpInfo.setSnmpTrapConfig(1, snmpTrapConfig2);
            snmpInfo.setSnmpTrapConfig(2, snmpTrapConfig3);
            snmpInfo.setSnmpTrapConfig(3, snmpTrapConfig4);
            snmpInfo.setSnmpTrapConfig(4, snmpTrapConfig5);
            if (string3.length() > 0) {
                snmpInfo.setReadComm(string3);
            }
            if (string4.length() > 0) {
                snmpInfo.setWriteComm(string4);
            }
            if (string5.length() > 0) {
                snmpInfo.setTrapComm(string5);
            }
            this.blade.applySnmpInfo(snmpInfo);
        }
        if (bl3 != ((Sanbox2)this.blade).isSyslogEnabled() || !inetAddress3.equals(((Sanbox2)this.blade).getSyslogAddr())) {
            this.chassisEventAdapter.registerEventHandler(315, "receiveChassisEvent");
            this.waitingOnSyslogChange = true;
            ((Sanbox2)this.blade).applySyslogInfo(bl3, inetAddress3);
        }
        if (!this.newIpAddress.equals((iPInfo = this.blade.getIpInfo()).getIpAddress()) || !inetAddress2.equals(iPInfo.getGateway()) || n8 != iPInfo.getNetMask() || n7 != iPInfo.getIpBootProcess()) {
            this.chassisEventAdapter.registerEventHandler(202, "receiveChassisEvent");
            this.waitingOnIpChange = true;
            snmpInfo = new IPInfo();
            snmpInfo.setIpAddress(this.newIpAddress);
            snmpInfo.setGateway(inetAddress2);
            snmpInfo.setNetMask(n8);
            snmpInfo.setArpTimeout(iPInfo.getArpTimeout());
            snmpInfo.setIpBootProcess(n7);
            this.blade.applyIpInfo((IPInfo)snmpInfo);
        }
        return 1;
    }

    private boolean isTrapAddressAndTrapPortComboUnique(SnmpTrapConfig[] snmpTrapConfigArray) {
        int n = 0;
        while (n < snmpTrapConfigArray.length) {
            SnmpTrapConfig snmpTrapConfig = snmpTrapConfigArray[n];
            if (!this.isIPAddressAllZeroes(snmpTrapConfig.getAddress().getHostAddress())) {
                int n2 = n + 1;
                while (n2 < snmpTrapConfigArray.length) {
                    if (snmpTrapConfig.getAddress().equals(snmpTrapConfigArray[n2].getAddress()) && snmpTrapConfig.getPort() == snmpTrapConfigArray[n2].getPort()) {
                        return false;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean isIPAddressAllZeroes(String string) {
        int n;
        int n2;
        boolean bl = true;
        String[] stringArray = new String[4];
        int[] nArray = new int[4];
        if (string == null) {
            return false;
        }
        int n3 = string.length();
        int n4 = string.indexOf(".", 0);
        if (n4 != -1 && n3 > n4 && (n2 = string.indexOf(".", n4 + 1)) != -1 && n3 > n2 && (n = string.indexOf(".", n2 + 2)) != -1) {
            stringArray[0] = string.substring(0, n4);
            stringArray[1] = string.substring(n4 + 1, n2);
            stringArray[2] = string.substring(n2 + 1, n);
            stringArray[3] = string.substring(n + 1);
            try {
                int n5 = 0;
                while (n5 <= 3) {
                    nArray[n5] = Integer.decode(stringArray[n5]);
                    if (nArray[n5] != 0) {
                        bl = false;
                    }
                    ++n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return bl;
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        if (!chassisEvent.isSuccessful()) {
            this.unregisterForEvents();
        }
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        NetworkPropertiesDialogSanbox2 dialog = null;

        public ApplyResponseHandler(NetworkPropertiesDialogSanbox2 networkPropertiesDialogSanbox22, Object object) {
            this.dialog = networkPropertiesDialogSanbox22;
            this.evt = (ChassisEvent)object;
        }

        public void run() {
            int n = this.evt.getEventType();
            switch (n) {
                case 214: {
                    if (!NetworkPropertiesDialogSanbox2.this.waitingOnSnmpChange) break;
                    NetworkPropertiesDialogSanbox2.this.waitingOnSnmpChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.snmpChangeFailed") + "\n" + NetworkPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        this.closeItDown();
                        break;
                    }
                    if (NetworkPropertiesDialogSanbox2.this.waitingOnIpChange || NetworkPropertiesDialogSanbox2.this.waitingOnSyslogChange) break;
                    this.closeItDown();
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(NetworkPropertiesDialogSanbox2.this.frame, NetworkPropertiesDialogSanbox2.this.blade, NetworkPropertiesDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("NetworkPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 202: {
                    NetworkPropertiesDialogSanbox2.this.waitingOnIpChange = false;
                    if (!this.evt.isSuccessful()) {
                        if (!NetworkPropertiesDialogSanbox2.this.settingRarp) {
                            PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.ipChangeFailed") + "\n" + NetworkPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        } else {
                            PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.ipChangeInQuestion") + "\n" + NetworkPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        }
                        this.closeItDown();
                        break;
                    }
                    if (NetworkPropertiesDialogSanbox2.this.fabric != null && NetworkPropertiesDialogSanbox2.this.fabric.getConnectionSwitch() == NetworkPropertiesDialogSanbox2.this.blade) {
                        NetworkPropertiesDialogSanbox2.this.fabric.getComAgent().setIpAddress(NetworkPropertiesDialogSanbox2.this.newIpAddress);
                    }
                    if (NetworkPropertiesDialogSanbox2.this.waitingOnSnmpChange || NetworkPropertiesDialogSanbox2.this.waitingOnSyslogChange) break;
                    this.closeItDown();
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(NetworkPropertiesDialogSanbox2.this.frame, NetworkPropertiesDialogSanbox2.this.blade, NetworkPropertiesDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("NetworkPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 315: {
                    NetworkPropertiesDialogSanbox2.this.waitingOnSyslogChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("NetworkPropertiesDialog.error.syslogChangeFailed") + "\n" + NetworkPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        this.closeItDown();
                        break;
                    }
                    if (NetworkPropertiesDialogSanbox2.this.waitingOnIpChange || NetworkPropertiesDialogSanbox2.this.waitingOnSnmpChange) break;
                    this.closeItDown();
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(NetworkPropertiesDialogSanbox2.this.frame, NetworkPropertiesDialogSanbox2.this.blade, NetworkPropertiesDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("NetworkPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                }
            }
        }

        private void closeItDown() {
            NetworkPropertiesDialogSanbox2.this.enableButtons();
            NetworkPropertiesDialogSanbox2.this.unregisterForEvents();
            this.dialog.setVisible(false);
        }
    }

    class TrapEnabledListener
    implements ActionListener {
        int trapNum;

        public TrapEnabledListener(int n) {
            this.trapNum = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.trapNum) {
                case 1: {
                    boolean bl = NetworkPropertiesDialogSanbox2.this.trap1EnabledChBox.isSelected();
                    NetworkPropertiesDialogSanbox2.this.trap1AddressLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1AddressText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1PortLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1PortText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1SeverityLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1SeverityCombo.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1VersionLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap1VersionCombo.setEnabled(bl);
                    break;
                }
                case 2: {
                    boolean bl = NetworkPropertiesDialogSanbox2.this.trap2EnabledChBox.isSelected();
                    NetworkPropertiesDialogSanbox2.this.trap2AddressLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2AddressText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2PortLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2PortText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2SeverityLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2SeverityCombo.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2VersionLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap2VersionCombo.setEnabled(bl);
                    break;
                }
                case 3: {
                    boolean bl = NetworkPropertiesDialogSanbox2.this.trap3EnabledChBox.isSelected();
                    NetworkPropertiesDialogSanbox2.this.trap3AddressLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3AddressText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3PortLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3PortText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3SeverityLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3SeverityCombo.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3VersionLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap3VersionCombo.setEnabled(bl);
                    break;
                }
                case 4: {
                    boolean bl = NetworkPropertiesDialogSanbox2.this.trap4EnabledChBox.isSelected();
                    NetworkPropertiesDialogSanbox2.this.trap4AddressLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4AddressText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4PortLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4PortText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4SeverityLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4SeverityCombo.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4VersionLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap4VersionCombo.setEnabled(bl);
                    break;
                }
                case 5: {
                    boolean bl = NetworkPropertiesDialogSanbox2.this.trap5EnabledChBox.isSelected();
                    NetworkPropertiesDialogSanbox2.this.trap5AddressLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5AddressText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5PortLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5PortText.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5SeverityLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5SeverityCombo.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5VersionLabel.setEnabled(bl);
                    NetworkPropertiesDialogSanbox2.this.trap5VersionCombo.setEnabled(bl);
                }
            }
        }
    }

    class BootMethodComboListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox2 theDialog = null;

        public BootMethodComboListener(NetworkPropertiesDialogSanbox2 networkPropertiesDialogSanbox22) {
            this.theDialog = networkPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NetworkPropertiesDialogSanbox2.this.bootMethodCombo.getSelectedIndex() == 0) {
                NetworkPropertiesDialogSanbox2.this.ipAddrText.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.ipAddrLabel.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.subnetMaskLabel.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.subnetMaskText.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.gatewayLabel.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.gatewayText.setEnabled(true);
            } else if (NetworkPropertiesDialogSanbox2.this.bootMethodCombo.getSelectedIndex() == 2) {
                NetworkPropertiesDialogSanbox2.this.ipAddrText.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.ipAddrLabel.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.subnetMaskLabel.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.subnetMaskText.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.gatewayLabel.setEnabled(true);
                NetworkPropertiesDialogSanbox2.this.gatewayText.setEnabled(true);
            } else {
                NetworkPropertiesDialogSanbox2.this.ipAddrText.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.ipAddrLabel.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.subnetMaskLabel.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.subnetMaskText.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.gatewayLabel.setEnabled(false);
                NetworkPropertiesDialogSanbox2.this.gatewayText.setEnabled(false);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox2 theDialog = null;

        public CancelButtonListener(NetworkPropertiesDialogSanbox2 networkPropertiesDialogSanbox22) {
            this.theDialog = networkPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NetworkPropertiesDialogSanbox2.this.enableButtons();
            NetworkPropertiesDialogSanbox2.this.unregisterForEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox2 theDialog = null;

        public ApplyButtonListener(NetworkPropertiesDialogSanbox2 networkPropertiesDialogSanbox22) {
            this.theDialog = networkPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyNetworkProperties() == 1) {
                if (NetworkPropertiesDialogSanbox2.this.waitingOnIpChange || NetworkPropertiesDialogSanbox2.this.waitingOnSnmpChange || NetworkPropertiesDialogSanbox2.this.waitingOnSyslogChange) {
                    NetworkPropertiesDialogSanbox2.this.disableButtons();
                } else {
                    NetworkPropertiesDialogSanbox2.this.enableButtons();
                    NetworkPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.theDialog.setVisible(false);
                    NetworkPropertiesDialogSanbox2.this.blade.updateAll();
                }
            }
        }
    }

    class SyslogEnableListener
    implements ActionListener {
        NetworkPropertiesDialogSanbox2 dialog;

        public SyslogEnableListener(NetworkPropertiesDialogSanbox2 networkPropertiesDialogSanbox22) {
            this.dialog = networkPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = NetworkPropertiesDialogSanbox2.this.syslogEnable.isSelected();
            NetworkPropertiesDialogSanbox2.this.syslogAddrLabel.setEnabled(bl);
            NetworkPropertiesDialogSanbox2.this.syslogAddr.setEnabled(bl);
        }
    }
}

