/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.qms.fabric.FabricTreeControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PortProperties {
    JButton applyButton = new JButton(FabricTreeControl.getResource("PortPropertiesDialog.applyButton"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("PortPropertiesDialog.cancelButton"));
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.chassisNameLabel"));
    JLabel portListLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.singlePortListLabel"));
    JLabel chassisNameContent = new JLabel();
    JLabel portListContent = new JLabel();
    JLabel portStatesLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.portStatesLabel"));
    ButtonGroup stateButtonGroup = new ButtonGroup();
    JRadioButton onlineButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.onlineButton"));
    JRadioButton offlineButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.offlineButton"));
    JRadioButton testButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.testButton"));
    JRadioButton downButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.downButton"));
    JLabel portSpeedLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.portSpeedLabel"));
    ButtonGroup speedButtonGroup = new ButtonGroup();
    JRadioButton autoSenseButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.autoSenseButton"));
    JRadioButton oneGigButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.oneGigButton"));
    JRadioButton twoGigButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.twoGigButton"));
    JLabel portModesLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.portModesLabel"));
    ButtonGroup modeButtonGroup = new ButtonGroup();
    JRadioButton fPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.fPortButton"));
    JRadioButton flPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.flPortButton"));
    JRadioButton slPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.slPortButton"));
    JRadioButton tlPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.tlPortButton"));
    JRadioButton gPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.gPortButton"));
    JRadioButton glPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.glPortButton"));
    JRadioButton donorPortButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.donorPortButton"));
    JRadioButton tlTargetButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.tlTargetButton"));
    JLabel tlModeLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.tlModeLabel"));
    JPanel tlModePanel;
    ButtonGroup tlModeButtonGroup = new ButtonGroup();
    JRadioButton autoLearnButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.autoLearnButton"));
    JRadioButton autoBridgeButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.autoBridgeButton"));
    JLabel rscnLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.rscnLabel"));
    JLabel rscnExplainLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.rscnExplain"));
    JPanel rscnPanel;
    ButtonGroup rscnButtonGroup = new ButtonGroup();
    JRadioButton rscnEnableButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.rscnEnableButton"));
    JRadioButton rscnDisableButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.rscnDisableButton"));
    JLabel bbCreditsLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.bbCreditsLabel"));
    JPanel bbCreditsPanel;
    JTextField bbCreditsText = new JTextField(3);
    JLabel bbCreditsHelpLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.bbCreditsHelpLabel"));
    JLabel bbCreditsExplainLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.bbCreditsExplainLabel"));
    JLabel islSecurityLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.islSecurityLabel"));
    JPanel islSecurityPanel;
    ButtonGroup islSecurityButtonGroup = new ButtonGroup();
    JRadioButton allButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.allButton"));
    JRadioButton noneButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.noneButton"));

    public JPanel createButtonPanel(ActionListener actionListener, ActionListener actionListener2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.applyButton.addActionListener(actionListener);
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(actionListener2);
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.applyButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public void resetIdPanel(SanboxChassis sanboxChassis, Vector vector) {
        this.chassisNameContent.setText(sanboxChassis.getChassisName());
        if (vector.size() <= 1) {
            this.portListLabel.setText(FabricTreeControl.getResource("PortPropertiesDialog.singlePortListLabel"));
        } else {
            this.portListLabel.setText(FabricTreeControl.getResource("PortPropertiesDialog.multiplePortListLabel"));
        }
        this.portListContent.setText(this.createPortListString(vector));
    }

    public void resetIdPanel(SanboxChassis sanboxChassis, FCPort fCPort) {
        this.chassisNameContent.setText(sanboxChassis.getChassisName());
        this.portListLabel.setText(FabricTreeControl.getResource("PortPropertiesDialog.singlePortListLabel"));
        if (sanboxChassis.getChassisType() == 33 || sanboxChassis.getChassisType() == 38) {
            if (fCPort.getPortNumber() == 0) {
                this.portListContent.setText(FabricTreeControl.getResource("Switchblade.port.0"));
            } else if (fCPort.getPortNumber() == 15) {
                this.portListContent.setText(FabricTreeControl.getResource("Switchblade.port.15"));
            } else {
                this.portListContent.setText("Bay " + Integer.toString(fCPort.getPortNumber()));
            }
        } else {
            this.portListContent.setText(Integer.toString(fCPort.getPortNumber()));
        }
    }

    public JPanel createIdPanel(SanboxChassis sanboxChassis, Vector vector) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        this.chassisNameContent.setText(sanboxChassis.getChassisName());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.chassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (vector.size() <= 1) {
            this.portListLabel.setText(FabricTreeControl.getResource("PortPropertiesDialog.singlePortListLabel"));
        } else {
            this.portListLabel.setText(FabricTreeControl.getResource("PortPropertiesDialog.multiplePortListLabel"));
        }
        jPanel.add((Component)this.portListLabel, gridBagConstraints);
        this.portListContent.setText(this.createPortListString(vector));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.portListContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    public JPanel createIdPanel(SanboxChassis sanboxChassis, FCPort fCPort) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        this.chassisNameContent.setText(sanboxChassis.getChassisName());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.chassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.portListLabel.setText(FabricTreeControl.getResource("PortPropertiesDialog.singlePortListLabel"));
        jPanel.add((Component)this.portListLabel, gridBagConstraints);
        if (sanboxChassis.getChassisType() == 33 || sanboxChassis.getChassisType() == 38) {
            if (fCPort.getPortNumber() == 0) {
                this.portListContent.setText(FabricTreeControl.getResource("Switchblade.port.0"));
            } else if (fCPort.getPortNumber() == 15) {
                this.portListContent.setText(FabricTreeControl.getResource("Switchblade.port.15"));
            } else {
                this.portListContent.setText("Bay " + Integer.toString(fCPort.getPortNumber()));
            }
        } else {
            this.portListContent.setText(Integer.toString(fCPort.getPortNumber()));
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.portListContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    public JPanel createPortStatesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.stateButtonGroup.add(this.onlineButton);
        this.stateButtonGroup.add(this.offlineButton);
        this.stateButtonGroup.add(this.testButton);
        this.stateButtonGroup.add(this.downButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        jPanel.add((Component)this.portStatesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 7);
        jPanel.add((Component)this.onlineButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.offlineButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.testButton, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.downButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createPortSpeedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.speedButtonGroup.add(this.autoSenseButton);
        this.speedButtonGroup.add(this.oneGigButton);
        this.speedButtonGroup.add(this.twoGigButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        jPanel.add((Component)this.portSpeedLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.autoSenseButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.oneGigButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.twoGigButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createPortModesPanel(int n) {
        if (n == 16 || n == 25 || n == 8 || n == 26 || n == 33 || n == 38 || n == 30) {
            this.modeButtonGroup.add(this.fPortButton);
            this.modeButtonGroup.add(this.flPortButton);
            this.modeButtonGroup.add(this.tlPortButton);
            this.modeButtonGroup.add(this.gPortButton);
            this.modeButtonGroup.add(this.glPortButton);
            this.modeButtonGroup.add(this.donorPortButton);
        } else {
            this.modeButtonGroup.add(this.gPortButton);
            this.modeButtonGroup.add(this.glPortButton);
            this.modeButtonGroup.add(this.tlPortButton);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.portModesLabel, gridBagConstraints);
        if (n == 16 || n == 25 || n == 8 || n == 26 || n == 33 || n == 38 || n == 30) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            jPanel.add((Component)this.fPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.flPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.tlPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.gPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.glPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.donorPortButton, gridBagConstraints);
        } else {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            jPanel.add((Component)this.gPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.glPortButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.tlPortButton, gridBagConstraints);
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createTLModePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.tlModeButtonGroup.add(this.autoLearnButton);
        this.tlModeButtonGroup.add(this.autoBridgeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        jPanel.add((Component)this.tlModeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel.add((Component)this.autoLearnButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        jPanel.add((Component)this.autoBridgeButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createRscnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.rscnButtonGroup.add(this.rscnEnableButton);
        this.rscnButtonGroup.add(this.rscnDisableButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 4);
        jPanel.add((Component)this.rscnLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 4, 0, 2);
        jPanel.add((Component)this.rscnEnableButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(2, 4, 0, 2);
        jPanel.add((Component)this.rscnDisableButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        jPanel.add((Component)this.rscnExplainLabel, gridBagConstraints);
        return jPanel;
    }

    public JPanel createBBCreditsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        jPanel.add((Component)this.bbCreditsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.bbCreditsText, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.bbCreditsHelpLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        jPanel.add((Component)this.bbCreditsExplainLabel, gridBagConstraints);
        return jPanel;
    }

    public void updatePortStateButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        PortStates portStates = null;
        FCPort fCPort = (FCPort)objectArray[0];
        portStates = fCPort.getPortStates();
        if (portStates == null) {
            return;
        }
        int n = 1;
        while (n < objectArray.length) {
            FCPort fCPort2 = (FCPort)objectArray[n];
            PortStates portStates2 = fCPort2.getPortStates();
            if (portStates2 == null || portStates.getActiveAdminState() != portStates2.getActiveAdminState()) {
                bl = false;
            }
            ++n;
        }
        if (bl && portStates != null) {
            switch (portStates.getActiveAdminState()) {
                case 1: {
                    this.onlineButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.offlineButton.setSelected(true);
                    break;
                }
                case 3: {
                    this.testButton.setSelected(true);
                    break;
                }
                case 4: {
                    this.downButton.setSelected(true);
                }
            }
        } else {
            this.stateButtonGroup.remove(this.onlineButton);
            this.stateButtonGroup.remove(this.offlineButton);
            this.stateButtonGroup.remove(this.testButton);
            this.stateButtonGroup.remove(this.downButton);
            this.onlineButton.setSelected(false);
            this.offlineButton.setSelected(false);
            this.testButton.setSelected(false);
            this.downButton.setSelected(false);
            this.stateButtonGroup.add(this.onlineButton);
            this.stateButtonGroup.add(this.offlineButton);
            this.stateButtonGroup.add(this.testButton);
            this.stateButtonGroup.add(this.downButton);
        }
    }

    public void updatePortModeButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        PortStates portStates = null;
        FCPort fCPort = (FCPort)objectArray[0];
        portStates = fCPort.getPortStates();
        int n = 1;
        while (n < objectArray.length) {
            FCPort fCPort2 = (FCPort)objectArray[n];
            if (fCPort.getPortStates() == null || fCPort2.getPortStates() == null) {
                bl = false;
            } else if (fCPort.getPortStates().getConfigPortType() != fCPort2.getPortStates().getConfigPortType()) {
                bl = false;
            }
            ++n;
        }
        if (bl && fCPort.getPortStates() != null) {
            switch (fCPort.getPortStates().getConfigPortType()) {
                case 1: {
                    this.fPortButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.flPortButton.setSelected(true);
                    break;
                }
                case 4: {
                    this.slPortButton.setSelected(true);
                    break;
                }
                case 8: {
                    this.gPortButton.setSelected(true);
                    break;
                }
                case 5: {
                    this.tlPortButton.setSelected(true);
                    break;
                }
                case 9: {
                    this.glPortButton.setSelected(true);
                    break;
                }
                case 6: {
                    this.donorPortButton.setSelected(true);
                    break;
                }
            }
        } else {
            this.modeButtonGroup.remove(this.fPortButton);
            this.modeButtonGroup.remove(this.flPortButton);
            this.modeButtonGroup.remove(this.slPortButton);
            this.modeButtonGroup.remove(this.gPortButton);
            this.modeButtonGroup.remove(this.tlPortButton);
            this.modeButtonGroup.remove(this.glPortButton);
            this.modeButtonGroup.remove(this.donorPortButton);
            this.fPortButton.setSelected(false);
            this.flPortButton.setSelected(false);
            this.slPortButton.setSelected(false);
            this.gPortButton.setSelected(false);
            this.tlPortButton.setSelected(false);
            this.glPortButton.setSelected(false);
            this.donorPortButton.setSelected(false);
            this.modeButtonGroup.add(this.fPortButton);
            this.modeButtonGroup.add(this.flPortButton);
            this.modeButtonGroup.add(this.slPortButton);
            this.modeButtonGroup.add(this.gPortButton);
            this.modeButtonGroup.add(this.tlPortButton);
            this.modeButtonGroup.add(this.glPortButton);
            this.modeButtonGroup.add(this.donorPortButton);
        }
    }

    public void updatePortSpeedButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        PortStates portStates = null;
        FCPort fCPort = (FCPort)objectArray[0];
        portStates = fCPort.getPortStates();
        boolean bl2 = false;
        if (fCPort instanceof S16Port) {
            bl2 = true;
        }
        int n = 1;
        while (n < objectArray.length) {
            FCPort fCPort2 = (FCPort)objectArray[n];
            PortStates portStates2 = fCPort2.getPortStates();
            if (bl2 && ((S16Port)fCPort).getAdminPortSpeed() != ((S16Port)fCPort2).getAdminPortSpeed()) {
                bl = false;
            }
            ++n;
        }
        if (bl2 && bl) {
            switch (((S16Port)fCPort).getAdminPortSpeed()) {
                case 3: {
                    this.autoSenseButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.oneGigButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.twoGigButton.setSelected(true);
                }
            }
        } else {
            this.speedButtonGroup.remove(this.autoSenseButton);
            this.speedButtonGroup.remove(this.oneGigButton);
            this.speedButtonGroup.remove(this.twoGigButton);
            this.autoSenseButton.setSelected(false);
            this.oneGigButton.setSelected(false);
            this.twoGigButton.setSelected(false);
            this.speedButtonGroup.add(this.autoSenseButton);
            this.speedButtonGroup.add(this.oneGigButton);
            this.speedButtonGroup.add(this.twoGigButton);
        }
    }

    public void updateBBCreditButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        S16Port s16Port = (S16Port)objectArray[0];
        boolean bl = true;
        int n = s16Port.getBBCredits();
        int n2 = 1;
        while (n2 < objectArray.length) {
            S16Port s16Port2 = (S16Port)objectArray[n2];
            if (n != s16Port2.getBBCredits()) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            this.bbCreditsText.setText(Integer.toString(n));
        } else {
            this.bbCreditsText.setText("");
        }
    }

    public void updateTLModeButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        S16Port s16Port = (S16Port)objectArray[0];
        int n = s16Port.getTLMode();
        int n2 = 1;
        while (n2 < objectArray.length) {
            S16Port s16Port2 = (S16Port)objectArray[n2];
            if (n != s16Port2.getTLMode()) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            if (n == 1) {
                this.autoLearnButton.setSelected(true);
            } else {
                this.autoBridgeButton.setSelected(true);
            }
        } else {
            this.tlModeButtonGroup.remove(this.autoLearnButton);
            this.tlModeButtonGroup.remove(this.autoBridgeButton);
            this.autoLearnButton.setSelected(false);
            this.autoBridgeButton.setSelected(false);
            this.tlModeButtonGroup.add(this.autoLearnButton);
            this.tlModeButtonGroup.add(this.autoBridgeButton);
        }
        if (this.tlPortButton.isSelected()) {
            this.autoLearnButton.setEnabled(true);
            this.autoBridgeButton.setEnabled(true);
            this.tlModeLabel.setEnabled(true);
        } else {
            this.autoLearnButton.setEnabled(false);
            this.autoBridgeButton.setEnabled(false);
            this.tlModeLabel.setEnabled(false);
        }
    }

    public void updateS43TLModeButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        S43Port s43Port = (S43Port)objectArray[0];
        boolean bl2 = s43Port.isAutoLearnEnabled();
        int n = 1;
        while (n < objectArray.length) {
            S43Port s43Port2 = (S43Port)objectArray[n];
            if (bl2 != s43Port2.isAutoLearnEnabled()) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            if (bl2) {
                this.autoLearnButton.setSelected(true);
            } else {
                this.autoBridgeButton.setSelected(true);
            }
        } else {
            this.tlModeButtonGroup.remove(this.autoLearnButton);
            this.tlModeButtonGroup.remove(this.autoBridgeButton);
            this.autoLearnButton.setSelected(false);
            this.autoBridgeButton.setSelected(false);
            this.tlModeButtonGroup.add(this.autoLearnButton);
            this.tlModeButtonGroup.add(this.autoBridgeButton);
        }
        if (this.tlPortButton.isSelected()) {
            this.autoLearnButton.setEnabled(true);
            this.autoBridgeButton.setEnabled(true);
            this.tlModeLabel.setEnabled(true);
        } else {
            this.autoLearnButton.setEnabled(false);
            this.autoBridgeButton.setEnabled(false);
            this.tlModeLabel.setEnabled(false);
        }
    }

    public void updateRscnButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        S16Port s16Port = (S16Port)objectArray[0];
        boolean bl2 = s16Port.getRscnEnable();
        int n = 1;
        while (n < objectArray.length) {
            S16Port s16Port2 = (S16Port)objectArray[n];
            if (bl2 != s16Port2.getRscnEnable()) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            if (bl2) {
                this.rscnEnableButton.setSelected(false);
                this.rscnDisableButton.setSelected(true);
            } else {
                this.rscnEnableButton.setSelected(true);
                this.rscnDisableButton.setSelected(false);
            }
        } else {
            this.rscnButtonGroup.remove(this.rscnEnableButton);
            this.rscnButtonGroup.remove(this.rscnDisableButton);
            this.rscnEnableButton.setSelected(false);
            this.rscnDisableButton.setSelected(false);
            this.rscnButtonGroup.add(this.rscnEnableButton);
            this.rscnButtonGroup.add(this.rscnDisableButton);
        }
    }

    public void setPortModeButtonsEnabled(boolean bl) {
        this.fPortButton.setEnabled(bl);
        this.flPortButton.setEnabled(bl);
        this.slPortButton.setEnabled(bl);
        this.gPortButton.setEnabled(bl);
        this.glPortButton.setEnabled(bl);
        this.tlPortButton.setEnabled(bl);
        this.donorPortButton.setEnabled(bl);
        this.tlTargetButton.setEnabled(bl);
    }

    public void setRscnButtonsEnabled(boolean bl) {
        this.rscnEnableButton.setEnabled(bl);
        this.rscnDisableButton.setEnabled(bl);
    }

    public void setPortStateButtonsEnabled(boolean bl) {
        this.onlineButton.setEnabled(bl);
        this.offlineButton.setEnabled(bl);
        this.testButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
    }

    public void setPortSpeedButtonsEnabled(boolean bl) {
        this.autoSenseButton.setEnabled(bl);
        this.oneGigButton.setEnabled(bl);
        this.twoGigButton.setEnabled(bl);
    }

    public void setBBCreditsEnabled(boolean bl) {
        this.bbCreditsText.setEnabled(bl);
    }

    public void setTLModeButtonsEnabled(boolean bl) {
        if (bl && this.tlPortButton.isSelected()) {
            this.autoLearnButton.setEnabled(bl);
            this.autoBridgeButton.setEnabled(bl);
        } else if (!bl) {
            this.autoLearnButton.setEnabled(bl);
            this.autoBridgeButton.setEnabled(bl);
        }
    }

    protected void setPortTypes(Vector vector, int[] nArray, int n) {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = ((FCPort)vector.elementAt(n3)).getPortNumber();
            nArray[n4] = n;
            ++n3;
        }
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public String createPortListString(Vector vector) {
        int n;
        StringBuffer stringBuffer;
        int n2 = vector.size();
        SortedSet<Integer> sortedSet = Collections.synchronizedSortedSet(new TreeSet());
        SanboxChassis sanboxChassis = null;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer = (FCPort)vector.elementAt(n3);
            if (sanboxChassis == null) {
                sanboxChassis = stringBuffer.getChassis();
            }
            int n4 = stringBuffer.getPortNumber();
            sortedSet.add(new Integer(n4));
            ++n3;
        }
        stringBuffer = new StringBuffer();
        Iterator iterator = sortedSet.iterator();
        int n5 = n = ((Integer)iterator.next()).intValue();
        int n6 = n;
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n - n6 == 1) {
                n6 = n;
                continue;
            }
            if (n5 == n6) {
                stringBuffer.append(this.getPortDesc(n5, sanboxChassis) + ", ");
            } else {
                stringBuffer.append(this.getPortDesc(n5, sanboxChassis) + "-" + this.getPortDesc(n6, sanboxChassis) + ", ");
            }
            n5 = n6 = n;
        }
        if (n5 == n6) {
            stringBuffer.append(this.getPortDesc(n5, sanboxChassis));
        } else {
            stringBuffer.append(this.getPortDesc(n5, sanboxChassis) + "-" + this.getPortDesc(n6, sanboxChassis));
        }
        return stringBuffer.toString();
    }

    private String getPortDesc(int n, SanboxChassis sanboxChassis) {
        FCPort fCPort = sanboxChassis.getPort(n);
        return fCPort.toString();
    }
}

