/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.PortProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortPropertiesDialogSanbox2
extends QDialog {
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected Vector portList = null;
    protected JFrame frame = null;
    protected JPanel propertyPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel idPanel = null;
    protected JPanel portStatePanel = null;
    protected JPanel portSpeedPanel = null;
    protected JPanel portModePanel = null;
    protected JPanel tlModePanel = null;
    protected JPanel bbCreditsPanel = null;
    protected JPanel rscnPanel = null;
    protected JPanel deviceScanPanel = null;
    protected boolean waitingOnPortStateChange = false;
    protected boolean waitingOnPortSpeedChange = false;
    protected boolean waitingOnPortModeChange = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean waitingOnTLMode = false;
    protected boolean waitingOnRscn = false;
    protected boolean waitingOnBBCredits = false;
    protected int initialBBCredits = -1;
    protected boolean waitingOnDeviceScan = false;
    protected PortProperties properties = new PortProperties();
    protected JLabel enableDeviceScanLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.deviceScan"));
    JRadioButton deviceScanEnableButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.deviceScanEnableButton"));
    JRadioButton deviceScanDisableButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.deviceScanDisableButton"));
    ButtonGroup deviceScanButtonGroup = new ButtonGroup();

    public PortPropertiesDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Vector vector) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("PortPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.propertyPanel = this.createPropertyPanel();
        this.properties.tlPortButton.addChangeListener(new TLModeButtonListener(this));
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.portPropertiesDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.updateRadioButtons();
    }

    public void resetDialog(SanboxChassis sanboxChassis, Vector vector) {
        this.unregisterForEvents();
        this.setEnabled(true);
        this.blade = sanboxChassis;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.properties.resetIdPanel(this.blade, this.portList);
        this.updateRadioButtons();
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.idPanel = this.properties.createIdPanel(this.blade, this.portList);
        this.portStatePanel = this.properties.createPortStatesPanel();
        this.portSpeedPanel = this.properties.createPortSpeedPanel();
        this.portModePanel = this.properties.createPortModesPanel(this.blade.getChassisType());
        this.tlModePanel = this.properties.createTLModePanel();
        this.bbCreditsPanel = this.properties.createBBCreditsPanel();
        this.rscnPanel = this.properties.createRscnPanel();
        this.deviceScanPanel = this.createDeviceScanPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.portStatePanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.portSpeedPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.portModePanel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.bbCreditsPanel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.rscnPanel, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)this.deviceScanPanel, gridBagConstraints);
        return jPanel;
    }

    public JPanel createDeviceScanPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.deviceScanButtonGroup.add(this.deviceScanEnableButton);
        this.deviceScanButtonGroup.add(this.deviceScanDisableButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 40);
        jPanel.add((Component)this.enableDeviceScanLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 20, 2, 10);
        jPanel.add((Component)this.deviceScanEnableButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        jPanel.add((Component)this.deviceScanDisableButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    protected void updateRadioButtons() {
        if (this.portList == null || this.portList.size() < 1) {
            return;
        }
        this.properties.updatePortStateButtons(this.portList);
        this.properties.updatePortModeButtons(this.portList);
        this.properties.updatePortSpeedButtons(this.portList);
        this.properties.updateBBCreditButtons(this.portList);
        this.properties.updateTLModeButtons(this.portList);
        this.properties.updateRscnButtons(this.portList);
        this.updateDeviceScanButtons(this.portList);
    }

    public void updateDeviceScanButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        S16Port s16Port = (S16Port)objectArray[0];
        boolean bl2 = s16Port.getDeviceScanEnable();
        int n = 1;
        while (n < objectArray.length) {
            S16Port s16Port2 = (S16Port)objectArray[n];
            if (bl2 != s16Port2.getDeviceScanEnable()) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            if (bl2) {
                this.deviceScanEnableButton.setSelected(true);
                this.deviceScanDisableButton.setSelected(false);
            } else {
                this.deviceScanEnableButton.setSelected(false);
                this.deviceScanDisableButton.setSelected(true);
            }
        } else {
            this.deviceScanButtonGroup.remove(this.deviceScanEnableButton);
            this.deviceScanButtonGroup.remove(this.deviceScanDisableButton);
            this.deviceScanEnableButton.setSelected(false);
            this.deviceScanDisableButton.setSelected(false);
            this.deviceScanButtonGroup.add(this.deviceScanEnableButton);
            this.deviceScanButtonGroup.add(this.deviceScanDisableButton);
        }
    }

    protected void updateBBCredits() {
        if (this.portList == null || this.portList.size() < 1) {
            return;
        }
        Object[] objectArray = this.portList.toArray();
        S16Port s16Port = (S16Port)objectArray[0];
        boolean bl = true;
        int n = s16Port.getBBCredits();
        int n2 = 1;
        while (n2 < objectArray.length) {
            S16Port s16Port2 = (S16Port)objectArray[n2];
            if (n != s16Port2.getBBCredits()) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            this.initialBBCredits = n;
            this.properties.bbCreditsText.setText(Integer.toString(n));
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.properties.setPortModeButtonsEnabled(bl);
        this.properties.setPortStateButtonsEnabled(bl);
        this.properties.setPortSpeedButtonsEnabled(bl);
        this.properties.setBBCreditsEnabled(bl);
        this.properties.setTLModeButtonsEnabled(bl);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(354));
        vector.add(new Integer(297));
        vector.add(new Integer(257));
        vector.add(new Integer(225));
        vector.add(new Integer(269));
        return vector;
    }

    protected void registerForEvents() {
        this.eventAdapter.registerEventHandler(355, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(298, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(258, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(256, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(227, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(376, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(238, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(239, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(237, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(235, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(236, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(264, "receiveChassisEvent");
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        if (!chassisEvent.isSuccessful()) {
            this.unregisterForEvents();
        }
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(355);
        this.eventAdapter.unregisterEventHandler(258);
        this.eventAdapter.unregisterEventHandler(298);
        this.eventAdapter.unregisterEventHandler(256);
        this.eventAdapter.unregisterEventHandler(227);
        this.eventAdapter.unregisterEventHandler(376);
        this.eventAdapter.unregisterEventHandler(238);
        this.eventAdapter.unregisterEventHandler(239);
        this.eventAdapter.unregisterEventHandler(237);
        this.eventAdapter.unregisterEventHandler(235);
        this.eventAdapter.unregisterEventHandler(236);
        this.eventAdapter.unregisterEventHandler(264);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyPortProperties() {
        Sanbox2 sanbox2;
        FCPort fCPort;
        int n;
        int n2;
        Object object;
        this.waitingOnPortStateChange = false;
        this.waitingOnPortSpeedChange = false;
        this.waitingOnRequestAdmin = false;
        this.waitingOnReleaseAdmin = false;
        this.waitingOnTLMode = false;
        this.waitingOnBBCredits = false;
        this.waitingOnRscn = false;
        this.waitingOnDeviceScan = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        boolean bl3 = true;
        String string = this.properties.bbCreditsText.getText().trim();
        if (string.length() > 0) {
            try {
                n6 = Integer.decode(string);
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("PortPropertiesDialog.invalidBBCreditsValue"));
                return -1;
            }
            if (n6 < 0 || n6 > 255) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("PortPropertiesDialog.invalidBBCreditsValue"));
                return -1;
            }
            if (n6 != this.initialBBCredits) {
                this.waitingOnBBCredits = true;
            }
        }
        this.waitingOnPortStateChange = true;
        if (this.properties.onlineButton.isSelected()) {
            n4 = 1;
        } else if (this.properties.offlineButton.isSelected()) {
            n4 = 2;
        } else if (this.properties.testButton.isSelected()) {
            n4 = 3;
        } else if (this.properties.downButton.isSelected()) {
            n4 = 4;
        }
        if (this.properties.fPortButton.isSelected()) {
            n3 = 1;
        } else if (this.properties.flPortButton.isSelected()) {
            n3 = 2;
        } else if (this.properties.gPortButton.isSelected()) {
            n3 = 8;
        } else if (this.properties.glPortButton.isSelected()) {
            n3 = 9;
        } else if (this.properties.donorPortButton.isSelected()) {
            n3 = 6;
        } else if (this.properties.tlPortButton.isSelected()) {
            n3 = 5;
        }
        this.waitingOnPortSpeedChange = true;
        if (this.properties.autoSenseButton.isSelected()) {
            n5 = 3;
        } else if (this.properties.oneGigButton.isSelected()) {
            n5 = 1;
        } else if (this.properties.twoGigButton.isSelected()) {
            n5 = 2;
        } else {
            this.waitingOnPortSpeedChange = false;
        }
        this.waitingOnRscn = true;
        if (this.properties.rscnEnableButton.isSelected()) {
            bl2 = true;
        } else if (this.properties.rscnDisableButton.isSelected()) {
            bl2 = false;
        } else {
            this.waitingOnRscn = false;
        }
        this.waitingOnDeviceScan = true;
        if (this.deviceScanEnableButton.isSelected()) {
            bl3 = true;
        } else if (this.deviceScanDisableButton.isSelected()) {
            bl3 = false;
        } else {
            this.waitingOnDeviceScan = false;
        }
        if (this.waitingOnPortStateChange || this.waitingOnPortSpeedChange || this.waitingOnTLMode || this.waitingOnBBCredits || this.waitingOnRscn || this.waitingOnDeviceScan) {
            this.registerForEvents();
            this.waitingOnRequestAdmin = true;
            ((Sanbox2Sml)this.blade).requestAdmin();
            ((Sanbox2Sml)this.blade).editConfig();
        }
        if (this.waitingOnPortStateChange) {
            Fabric fabric = FabricList.getFabric((Chassis)this.blade);
            boolean bl4 = false;
            int n7 = this.portList.size();
            int n8 = 0;
            while (n8 < n7) {
                FCPort fCPort2 = (FCPort)this.portList.elementAt(n8);
                object = fabric.getLinkByEnd((Chassis)this.blade, fCPort2);
                if (object != null && fCPort2.getAdminState() == 1 && n4 != 1) {
                    bl4 = true;
                }
                ++n8;
            }
            if (bl4 && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("PortPropertiesDialog.applyOfflineWarning"))) {
                return -1;
            }
            n2 = this.blade.getPortCount();
            object = new int[n2];
            int[] nArray = new int[n2];
            n = 0;
            while (n < n2) {
                fCPort = this.blade.getPort(n).getPortStates();
                if (fCPort != null) {
                    object[n] = fCPort.getActiveAdminState();
                    nArray[n] = fCPort.getConfigPortType();
                }
                ++n;
            }
            if (n3 != 0) {
                this.properties.setPortTypes(this.portList, nArray, n3);
            }
            if (n4 != 0) {
                int n9 = this.portList.size();
                int n10 = 0;
                while (n10 < n9) {
                    sanbox2 = (FCPort)this.portList.elementAt(n10);
                    object[sanbox2.getPortNumber()] = n4;
                    ++n10;
                }
            }
            this.eventAdapter.registerEventHandler(376, "receiveChassisEvent");
            ((Sanbox2)this.blade).applyPortConfig((int[])object, nArray);
        }
        if (this.waitingOnPortSpeedChange) {
            int n11 = this.portList.size();
            Sanbox2 sanbox22 = (Sanbox2)this.blade;
            Fabric fabric = FabricList.getFabric((Chassis)sanbox22);
            Chassis chassis = null;
            n2 = 0;
            object = "";
            boolean bl5 = false;
            n = 0;
            while (n < n11) {
                fCPort = (FCPort)this.portList.elementAt(n);
                FabricLink fabricLink = fabric.getLinkByEnd((Chassis)this.blade, fCPort);
                if (fabricLink != null) {
                    if (fabricLink.getSwitch1().equals(this.blade) && fabricLink.getPortNumber1() == fCPort.getPortNumber()) {
                        chassis = fabricLink.getSwitch2();
                        n2 = fabricLink.getPortNumber2();
                    } else if (fabricLink.getSwitch2().equals(this.blade) && fabricLink.getPortNumber2() == fCPort.getPortNumber()) {
                        chassis = fabricLink.getSwitch1();
                        n2 = fabricLink.getPortNumber1();
                    }
                }
                if (chassis instanceof Sanbox2) {
                    sanbox2 = (Sanbox2)chassis;
                    S16Port s16Port = (S16Port)sanbox2.getPort(n2);
                    if (s16Port.getAdminPortSpeed() != n5) {
                        if (s16Port.getAdminPortSpeed() == 2 && n5 == 1) {
                            bl5 = true;
                            object = (String)object + fabricLink.toString() + "\n ";
                        } else if (s16Port.getAdminPortSpeed() == 1 && n5 == 2) {
                            bl5 = true;
                            object = (String)object + fabricLink.toString() + "\n ";
                        }
                    }
                } else if (chassis instanceof Sanbox && n5 == 2) {
                    bl5 = true;
                }
                chassis = null;
                n2 = 0;
                ++n;
            }
            if (bl5 && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("PortPropertiesDialog.applyIncompatPortSpeedWarning") + FabricTreeControl.getResource("PortPropertiesDialog.unreachableIncompatPortSpeedWarning"))) {
                return -1;
            }
            int n12 = 0;
            while (n12 < n11) {
                FCPort fCPort3 = (FCPort)this.portList.elementAt(n12);
                sanbox22.applyPortSpeed(fCPort3.getPortNumber(), n5);
                ++n12;
            }
        }
        if (this.waitingOnRscn) {
            int n13 = this.portList.size();
            int n14 = 0;
            while (n14 < n13) {
                S16Port s16Port = (S16Port)this.portList.elementAt(n14);
                ((Sanbox2)this.blade).applyRscn(s16Port.getPortNumber(), !bl2);
                ++n14;
            }
        }
        if (this.waitingOnDeviceScan) {
            int n15 = this.portList.size();
            int n16 = 0;
            while (n16 < n15) {
                S16Port s16Port = (S16Port)this.portList.elementAt(n16);
                if (s16Port.getDeviceScanEnable() != bl3) {
                    ((Sanbox2)this.blade).applyDeviceScan(s16Port.getPortNumber(), bl3);
                }
                ++n16;
            }
        }
        if (this.waitingOnBBCredits) {
            int n17 = this.portList.size();
            int n18 = 0;
            while (n18 < n17) {
                S16Port s16Port = (S16Port)this.portList.elementAt(n18);
                ((Sanbox2)this.blade).applyBBCredits(s16Port.getPortNumber(), n6);
                ++n18;
            }
        }
        if (this.waitingOnPortStateChange || this.waitingOnPortSpeedChange || this.waitingOnTLMode || this.waitingOnBBCredits || this.waitingOnRscn || this.waitingOnDeviceScan) {
            this.waitingOnReleaseAdmin = true;
            ((Sanbox2)this.blade).saveConfig();
            ((Sanbox2Sml)this.blade).activateConfigAndReleaseAdmin();
        }
        return 1;
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        PortPropertiesDialogSanbox2 dialog = null;

        public ApplyResponseHandler(PortPropertiesDialogSanbox2 portPropertiesDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = portPropertiesDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 238: {
                    PortPropertiesDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.adminFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 239: {
                    PortPropertiesDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        PortPropertiesDialogSanbox2.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.relAdminFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        PortPropertiesDialogSanbox2.this.properties.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    break;
                }
                case 237: {
                    if (this.evt.isSuccessful()) break;
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.editSwitchConfigFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 235: {
                    if (this.evt.isSuccessful()) break;
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.saveSwitchConfigFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 236: {
                    if (this.evt.isSuccessful()) break;
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.activateSwitchConfigFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 264: {
                    PortPropertiesDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        PortPropertiesDialogSanbox2.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.saveAndActivateSwitchConfigFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        PortPropertiesDialogSanbox2.this.properties.enableButtons();
                        this.dialog.setVisible(false);
                        return;
                    }
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(PortPropertiesDialogSanbox2.this.frame, PortPropertiesDialogSanbox2.this.blade, PortPropertiesDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 227: {
                    PortPropertiesDialogSanbox2.this.waitingOnPortSpeedChange = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.portSpeedError") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 376: {
                    PortPropertiesDialogSanbox2.this.waitingOnPortStateChange = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.portStateError") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 256: {
                    PortPropertiesDialogSanbox2.this.waitingOnTLMode = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.tlModeFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 298: {
                    PortPropertiesDialogSanbox2.this.waitingOnRscn = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.rscnFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 258: {
                    PortPropertiesDialogSanbox2.this.waitingOnBBCredits = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.bbCreditsFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 355: {
                    PortPropertiesDialogSanbox2.this.waitingOnDeviceScan = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.deviceScanFailed") + "\n" + PortPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                }
            }
        }
    }

    class TLModeButtonListener
    implements ChangeListener {
        PortPropertiesDialogSanbox2 theDialog = null;

        public TLModeButtonListener(PortPropertiesDialogSanbox2 portPropertiesDialogSanbox22) {
            this.theDialog = portPropertiesDialogSanbox22;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == PortPropertiesDialogSanbox2.this.properties.tlPortButton) {
                if (PortPropertiesDialogSanbox2.this.properties.tlPortButton.isSelected()) {
                    PortPropertiesDialogSanbox2.this.properties.autoLearnButton.setEnabled(true);
                    PortPropertiesDialogSanbox2.this.properties.autoBridgeButton.setEnabled(true);
                    PortPropertiesDialogSanbox2.this.properties.tlModeLabel.setEnabled(true);
                } else {
                    PortPropertiesDialogSanbox2.this.properties.autoLearnButton.setEnabled(false);
                    PortPropertiesDialogSanbox2.this.properties.autoBridgeButton.setEnabled(false);
                    PortPropertiesDialogSanbox2.this.properties.tlModeLabel.setEnabled(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        PortPropertiesDialogSanbox2 theDialog = null;

        public CancelButtonListener(PortPropertiesDialogSanbox2 portPropertiesDialogSanbox22) {
            this.theDialog = portPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortPropertiesDialogSanbox2.this.unregisterForEvents();
            PortPropertiesDialogSanbox2.this.properties.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        PortPropertiesDialogSanbox2 theDialog = null;

        public ApplyButtonListener(PortPropertiesDialogSanbox2 portPropertiesDialogSanbox22) {
            this.theDialog = portPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyPortProperties() == 1) {
                if (PortPropertiesDialogSanbox2.this.waitingOnPortStateChange || PortPropertiesDialogSanbox2.this.waitingOnPortSpeedChange || PortPropertiesDialogSanbox2.this.waitingOnTLMode || PortPropertiesDialogSanbox2.this.waitingOnBBCredits || PortPropertiesDialogSanbox2.this.waitingOnRscn || PortPropertiesDialogSanbox2.this.waitingOnDeviceScan) {
                    PortPropertiesDialogSanbox2.this.properties.disableButtons();
                } else {
                    PortPropertiesDialogSanbox2.this.unregisterForEvents();
                    PortPropertiesDialogSanbox2.this.properties.enableButtons();
                    this.theDialog.setVisible(false);
                }
            }
        }
    }
}

