/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.LoopbackPortTestResult;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PortTestDialogSanbox
extends QDialog
implements ChassisEventListener {
    JButton applyButton = new JButton(FabricTreeControl.getResource("LoopbackDialog.startTest"));
    JButton stopTestButton = new JButton(FabricTreeControl.getResource("LoopbackDialog.stopTest"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("LoopbackDialog.cancelTest"));
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.chassisNameLabel"));
    JLabel chassisNameContent = new JLabel();
    JLabel selectPortLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.selectPort"));
    JComboBox portCombo;
    String[] eightPortChoices = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
    String[] sixteenPortChoices = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
    JLabel selectTestLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.selectTest"));
    JRadioButton internalButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.internal"));
    JRadioButton externalButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.external"));
    JRadioButton onlineButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.online"));
    ButtonGroup testButtonGroup = new ButtonGroup();
    JLabel testStatusLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.testStatus"));
    JTextField testStatusText = new JTextField();
    JLabel testFailuresLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.failureCount"));
    JTextField testFailuresText = new JTextField();
    JLabel framesSentLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.framesSent"));
    JTextField framesSentText = new JTextField();
    JLabel frameCountLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.frameCount"));
    JTextField frameCountText = new JTextField();
    JLabel frameSizeLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.frameSize"));
    JTextField frameSizeText = new JTextField();
    JLabel patternLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.pattern"));
    JTextField patternText = new JTextField();
    JCheckBox stopOnErrorChBox = new JCheckBox(FabricTreeControl.getResource("LoopbackDialog.stopOnError"));
    JTextArea testDetailsText = new JTextArea(FabricTreeControl.getResource("LoopbackDialog.sanbox1.details"));
    JScrollPane scrollPane = new JScrollPane();
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel loopbackPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel idPanel = null;
    protected JPanel testParametersPanel = null;
    protected JPanel resultsPanel = null;
    protected JPanel testSelectionPanel = null;
    protected JPanel testDetailsPanel = null;
    protected final int INACTIVE_STATE = 1;
    protected final int ACTIVE_STATE = 2;
    protected final int TERMINATED_STATE = 3;
    protected final int COMPLETED_STATE = 4;
    protected final int PRE_CONFIG_PORT_STATE = 5;
    protected final int POST_CONFIG_PORT_STATE = 6;
    protected boolean waitingOnTestResults = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnPortConfigRequestAdmin1 = false;
    protected boolean waitingOnPortConfigRequestAdmin2 = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean waitingOnPortConfigReleaseAdmin1 = false;
    protected boolean waitingOnPortConfigReleaseAdmin2 = false;
    protected boolean waitingOnPortStateChange = false;
    protected int settingPortStateCount = 0;
    protected int dialogState = 1;
    Timer timer;
    protected final int TEST_TIME_LIMIT = 1000;
    long frameCount;
    int frameSize;
    long pattern;
    boolean stopOnError;
    int portCount;
    FCPort selectedPort;
    int prevPortState;
    boolean unreachableWarningDisplayed = false;
    protected final int PORT_NOT_IN_DIAG_STATE = 95;
    protected final int DONOR_PORT_STATE = 99;
    protected final int PORT_TEST_ALREADY_IN_PROGRESS = 98;

    public PortTestDialogSanbox(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, FCPort fCPort) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("LoopbackDialog.title.portDiagnostics") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.selectedPort = fCPort;
        this.portCount = this.blade.getPortCount();
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.dialogState = 1;
        this.loopbackPanel = this.createLoopbackPanel();
        this.buttonPanel = this.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this), new StopTestButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.portTestDialogSanboxHelp"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.loopbackPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public JPanel createButtonPanel(ActionListener actionListener, ActionListener actionListener2, ActionListener actionListener3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.applyButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener2);
        this.stopTestButton.addActionListener(actionListener3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.applyButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(this.stopTestButton);
        gridBagConstraints.gridx = 2;
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createIdPanel(SanboxChassis sanboxChassis) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        this.chassisNameContent.setText(sanboxChassis.getChassisName());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = this.chassisNameContent.getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        this.chassisNameContent.setFont(font);
        this.chassisNameContent.setForeground(Color.black);
        jPanel.add((Component)this.chassisNameContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    protected JPanel createLoopbackPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.idPanel = this.createIdPanel(this.blade);
        this.testParametersPanel = this.createTestParametersPanel();
        this.resultsPanel = this.createResultsPanel();
        this.testDetailsPanel = this.createTestDetailsPanel();
        this.testSelectionPanel = this.createTestSelectionPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.testDetailsPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.resultsPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.testSelectionPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.testParametersPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createTestSelectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.portCombo = this.portCount == 8 ? new JComboBox<String>(this.eightPortChoices) : new JComboBox<String>(this.sixteenPortChoices);
        this.portCombo.setSelectedIndex(this.selectedPort.getPortNumber());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.selectPortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        jPanel.add((Component)this.portCombo, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testSelection")));
        return jPanel;
    }

    protected JPanel createTestDetailsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.scrollPane.getViewport().add((Component)this.testDetailsText, gridBagConstraints);
        this.testDetailsText.setRows(5);
        this.testDetailsText.setColumns(16);
        this.testDetailsText.setEditable(false);
        this.testDetailsText.setBackground(Color.gray);
        this.testDetailsText.setForeground(Color.white);
        Font font = this.testDetailsText.getFont();
        Font font2 = new Font("Dialog", 0, font.getSize() - 1);
        this.testDetailsText.setFont(font2);
        this.testDetailsText.setCaretPosition(0);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testDetails")));
        return jPanel;
    }

    protected JPanel createTestParametersPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.frameCountLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.frameCountText.setColumns(8);
        this.frameCountText.setText("100");
        jPanel.add((Component)this.frameCountText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.frameSizeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.frameSizeText.setColumns(8);
        this.frameSizeText.setText("2048");
        jPanel.add((Component)this.frameSizeText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.patternLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.patternText.setColumns(8);
        this.patternText.setText("f5f5f5f5");
        jPanel.add((Component)this.patternText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.stopOnErrorChBox.setSelected(false);
        Color color = this.patternLabel.getForeground();
        this.stopOnErrorChBox.setForeground(color);
        jPanel.add((Component)this.stopOnErrorChBox, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testParameters")));
        return jPanel;
    }

    protected JPanel createResultsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 20, 4, 2);
        jPanel.add((Component)this.testStatusLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.testInactive"));
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.testStatusText.setColumns(8);
        this.testStatusText.setEditable(false);
        jPanel.add((Component)this.testStatusText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.framesSentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.framesSentText.setColumns(8);
        this.framesSentText.setEditable(false);
        jPanel.add((Component)this.framesSentText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.testFailuresLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.testFailuresText.setColumns(8);
        jPanel.add((Component)this.testFailuresText, gridBagConstraints);
        this.testStatusText.setEditable(false);
        this.framesSentText.setEditable(false);
        this.testFailuresText.setEditable(false);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testResults")));
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.blade.removeChassisEventListener((ChassisEventListener)this);
            this.setVisible(false);
        }
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
        this.stopTestButton.setEnabled(true);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.stopTestButton.setEnabled(false);
    }

    protected void enableTestParametersPanel(boolean bl) {
        this.frameCountLabel.setEnabled(bl);
        this.frameCountText.setEnabled(bl);
        this.frameSizeLabel.setEnabled(bl);
        this.frameSizeText.setEnabled(bl);
        this.patternLabel.setEnabled(bl);
        this.patternText.setEnabled(bl);
        this.stopOnErrorChBox.setEnabled(bl);
    }

    protected void postTestStatus(LoopbackPortTestResult loopbackPortTestResult) {
        this.framesSentText.setText(Long.toString(loopbackPortTestResult.getFrameCount()));
        this.testFailuresText.setText(Long.toString(loopbackPortTestResult.getFailureCount()));
        String string = loopbackPortTestResult.getTestStatus();
        if (loopbackPortTestResult.getFrameCount() < this.frameCount && (string.equals("Passed") || string.equals("Failed"))) {
            this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.running"));
        } else {
            this.testStatusText.setText(loopbackPortTestResult.getTestStatus());
        }
    }

    protected void requestLoopbackTest() {
        this.blade.applyLoopbackTest(this.selectedPort.getPortNumber(), 5);
        ((SanboxUtil)this.blade).applyOnlineLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.pattern, this.stopOnError);
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TestWatchDog(), 1000L);
    }

    protected void stopTest() {
        this.blade.applyLoopbackTest(this.selectedPort.getPortNumber(), 4);
    }

    protected void updateTestStatus() {
        ((SanboxUtil)this.blade).updateLoopbackTestStatus();
    }

    protected void registerForEvents() {
        this.blade.addChassisEventListener((ChassisEventListener)this);
    }

    protected void unregisterForEvents() {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyLoopbackTest() {
        int n = this.portCombo.getSelectedIndex();
        this.selectedPort = this.blade.getPort(n);
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.testInactive"));
        this.framesSentText.setText("");
        this.testFailuresText.setText("");
        if (this.selectedPort.getGbicType() == 99 || this.selectedPort.getGbicType() == 7) {
            boolean bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("LoopbackDialog.ask.deviceRequired"));
            if (!bl) {
                return -1;
            }
            if (this.selectedPort.getGbicType() == 99 || this.selectedPort.getGbicType() == 7) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.emptyPort"));
                return -1;
            }
        }
        try {
            this.frameCount = Long.parseLong(this.frameCountText.getText());
            if (this.frameCount < 1L || this.frameCount > Integer.MAX_VALUE) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameCount"));
                return -1;
            }
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameCount"));
            return -1;
        }
        try {
            this.frameSize = Integer.parseInt(this.frameSizeText.getText());
            if (this.frameSize < 36 || this.frameSize > 2148) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameSize"));
                return -1;
            }
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameSize"));
            return -1;
        }
        try {
            String string = this.patternText.getText().trim().toLowerCase();
            if (string.startsWith("0x") && string.length() > 2) {
                string = string.substring(2);
            }
            this.pattern = Long.parseLong(string, 16);
            if (this.pattern < 0L || this.pattern > 0xFFFFFFFFL) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidPattern"));
                return -1;
            }
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidPattern"));
            return -1;
        }
        this.stopOnError = this.stopOnErrorChBox.isSelected();
        this.waitingOnTestResults = true;
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.running"));
        this.dialogState = 2;
        this.registerForEvents();
        this.requestLoopbackTest();
        return 1;
    }

    class TestWatchDog
    extends TimerTask {
        public void run() {
            PortTestDialogSanbox.this.updateTestStatus();
            if (PortTestDialogSanbox.this.dialogState == 2) {
                PortTestDialogSanbox.this.timer = new Timer(true);
                PortTestDialogSanbox.this.timer.schedule((TimerTask)new TestWatchDog(), 1000L);
            }
        }
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        PortTestDialogSanbox dialog = null;

        public ApplyResponseHandler(PortTestDialogSanbox portTestDialogSanbox2, ChassisEvent chassisEvent) {
            this.dialog = portTestDialogSanbox2;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 282: {
                    if (this.evt.isSuccessful()) break;
                    if (PortTestDialogSanbox.this.timer != null) {
                        PortTestDialogSanbox.this.timer.cancel();
                    }
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.startTest") + "\n" + PortTestDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    PortTestDialogSanbox.this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.neverRun"));
                    PortTestDialogSanbox.this.enableButtons();
                    return;
                }
                case 283: {
                    if (PortTestDialogSanbox.this.timer != null) {
                        PortTestDialogSanbox.this.timer.cancel();
                    }
                    PortTestDialogSanbox.this.enableButtons();
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.stopTest") + "\n" + PortTestDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                        return;
                    }
                    PortTestDialogSanbox.this.dialogState = 4;
                    break;
                }
                case 284: {
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.resetTest") + "\n" + PortTestDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    return;
                }
                case 285: {
                    if (!this.evt.isSuccessful()) {
                        if (PortTestDialogSanbox.this.blade.getOverallStatus() == 3) {
                            if (PortTestDialogSanbox.this.dialogState == 2) {
                                PortTestDialogSanbox.this.testStatusText.setText("Unknown");
                            }
                            if (PortTestDialogSanbox.this.timer != null) {
                                PortTestDialogSanbox.this.timer.cancel();
                            }
                            PortTestDialogSanbox.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                            if (!PortTestDialogSanbox.this.unreachableWarningDisplayed) {
                                PortTestDialogSanbox.this.unreachableWarningDisplayed = true;
                                PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.switchUnreachable"));
                            }
                            PortTestDialogSanbox.this.waitingOnTestResults = false;
                            PortTestDialogSanbox.this.dialogState = 4;
                            PortTestDialogSanbox.this.enableButtons();
                            return;
                        }
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testResults") + "\n" + PortTestDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                        return;
                    }
                    LoopbackPortTestResult[] loopbackPortTestResultArray = ((SanboxUtil)PortTestDialogSanbox.this.blade).getLoopbackTestResults();
                    LoopbackPortTestResult loopbackPortTestResult = loopbackPortTestResultArray[PortTestDialogSanbox.this.selectedPort.getPortNumber()];
                    loopbackPortTestResultArray = null;
                    PortTestDialogSanbox.this.postTestStatus(loopbackPortTestResult);
                    if (loopbackPortTestResult.getFrameCount() != PortTestDialogSanbox.this.frameCount) break;
                    if (PortTestDialogSanbox.this.timer != null) {
                        PortTestDialogSanbox.this.timer.cancel();
                    }
                    PortTestDialogSanbox.this.dialogState = 4;
                    PortTestDialogSanbox.this.enableButtons();
                }
            }
        }
    }

    class StopTestButtonListener
    implements ActionListener {
        PortTestDialogSanbox theDialog = null;

        public StopTestButtonListener(PortTestDialogSanbox portTestDialogSanbox2) {
            this.theDialog = portTestDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortTestDialogSanbox.this.stopTest();
            PortTestDialogSanbox.this.updateTestStatus();
            PortTestDialogSanbox.this.enableButtons();
        }
    }

    class CancelButtonListener
    implements ActionListener {
        PortTestDialogSanbox theDialog = null;

        public CancelButtonListener(PortTestDialogSanbox portTestDialogSanbox2) {
            this.theDialog = portTestDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortTestDialogSanbox.this.unregisterForEvents();
            PortTestDialogSanbox.this.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        PortTestDialogSanbox theDialog = null;

        public ApplyButtonListener(PortTestDialogSanbox portTestDialogSanbox2) {
            this.theDialog = portTestDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyLoopbackTest() == 1) {
                if (PortTestDialogSanbox.this.waitingOnTestResults) {
                    PortTestDialogSanbox.this.disableButtons();
                }
            } else {
                PortTestDialogSanbox.this.dialogState = 1;
                PortTestDialogSanbox.this.unregisterForEvents();
                PortTestDialogSanbox.this.enableButtons();
            }
        }
    }
}

