/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.LoopbackPortTestResult;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PortTestDialogSanbox2
extends QDialog
implements ChassisEventListener {
    JButton applyButton = new JButton(FabricTreeControl.getResource("LoopbackDialog.startTest"));
    JButton stopTestButton = new JButton(FabricTreeControl.getResource("LoopbackDialog.stopTest"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("LoopbackDialog.cancelTest"));
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.chassisNameLabel"));
    JLabel chassisNameContent = new JLabel();
    JLabel selectPortLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.selectPort"));
    JComboBox portCombo;
    JLabel selectTestLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.selectTest"));
    JRadioButton internalButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.internal"));
    JRadioButton externalButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.external"));
    JRadioButton onlineButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.online"));
    ButtonGroup testButtonGroup = new ButtonGroup();
    JLabel testStatusLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.testStatus"));
    JTextField testStatusText = new JTextField();
    JLabel testFailuresLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.failureCount"));
    JTextField testFailuresText = new JTextField();
    JLabel framesSentLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.framesSent"));
    JTextField framesSentText = new JTextField();
    JLabel frameCountLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.frameCount"));
    JTextField frameCountText = new JTextField();
    JLabel frameSizeLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.frameSize"));
    JLabel frameSizeLabel256 = new JLabel(FabricTreeControl.getResource("LoopbackDialog.frameSize.256"));
    JTextField frameSizeText = new JTextField();
    JTextField patternText = new JTextField();
    JCheckBox stopOnErrorChBox = new JCheckBox(FabricTreeControl.getResource("LoopbackDialog.stopOnError"));
    JLabel selectPatternLabel = new JLabel(FabricTreeControl.getResource("LoopbackDialog.selectPattern"));
    JRadioButton defaultPatternButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.defaultPattern"));
    JRadioButton userDefinedPatternButton = new JRadioButton(FabricTreeControl.getResource("LoopbackDialog.userDefinedPattern"));
    ButtonGroup patternButtonGroup = new ButtonGroup();
    JTextArea testDetailsText = new JTextArea(FabricTreeControl.getResource("LoopbackDialog.internal.details"));
    JScrollPane scrollPane = new JScrollPane();
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel loopbackPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel idPanel = null;
    protected JPanel testParametersPanel = null;
    protected JPanel resultsPanel = null;
    protected JPanel testSelectionPanel = null;
    protected JPanel testDetailsPanel = null;
    protected final int INACTIVE_STATE = 1;
    protected final int ACTIVE_STATE = 2;
    protected final int TERMINATED_STATE = 3;
    protected final int COMPLETED_STATE = 4;
    protected final int PRE_CONFIG_PORT_STATE = 5;
    protected final int POST_CONFIG_PORT_STATE = 6;
    protected boolean waitingOnTestResults = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnPortConfigRequestAdmin1 = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean waitingOnPortConfigReleaseAdmin1 = false;
    protected boolean waitingOnPortStateChange = false;
    protected boolean waitingOnPortStateNotification = false;
    protected int testStatusTimeoutCount = 0;
    protected boolean waitingOnPortRestoration = false;
    protected boolean delayDialogExit = false;
    protected CancelButtonListener cancelButtonListener;
    protected int dialogState = 1;
    int testType;
    Timer timer;
    protected final int UPDATE_TIME_INTERVAL = 1000;
    protected final int TEST_TIME_LIMIT = 30000;
    long frameCount;
    int frameSize;
    long pattern;
    boolean useDefaultPattern;
    boolean stopOnError;
    int portCount;
    FCPort selectedPort;
    int[] originalPortState;
    boolean[] portStateChanged;
    boolean portStatesSaved = false;
    boolean fport = false;
    boolean unreachableWarningDisplayed = false;
    protected final int PORT_NOT_IN_DIAG_STATE = 95;
    protected final int DONOR_PORT_STATE = 99;
    protected final int PORT_TEST_ALREADY_IN_PROGRESS = 98;

    public PortTestDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, FCPort fCPort) {
        this(jFrame, bl, sanboxChassis, fCPort, false);
    }

    public PortTestDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, FCPort fCPort, boolean bl2) {
        super((Frame)jFrame, bl);
        this.delayDialogExit = bl2;
        this.setTitle(FabricTreeControl.getResource("LoopbackDialog.title.portDiagnostics") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.selectedPort = fCPort;
        this.portCount = this.blade.getPortCount();
        this.originalPortState = new int[this.portCount];
        this.portStateChanged = new boolean[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            this.portStateChanged[n] = false;
            ++n;
        }
        this.portStatesSaved = false;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.fport = false;
        PortStates portStates = this.selectedPort.getPortStates();
        if (portStates != null && (portStates.getPortType() == 1 || portStates.getPortType() == 0 && portStates.getConfigPortType() == 1)) {
            this.fport = true;
        }
        this.dialogState = 1;
        this.loopbackPanel = this.createLoopbackPanel();
        this.cancelButtonListener = new CancelButtonListener(this);
        this.buttonPanel = this.createButtonPanel(new ApplyButtonListener(this), this.cancelButtonListener, new StopTestButtonListener(this));
        this.buttonPanel.add(this.helpContextButton);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.portTestDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.loopbackPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public JPanel createButtonPanel(ActionListener actionListener, ActionListener actionListener2, ActionListener actionListener3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.applyButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener2);
        this.stopTestButton.addActionListener(actionListener3);
        jPanel.add(this.applyButton);
        this.stopTestButton.setEnabled(false);
        jPanel.add(this.stopTestButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createIdPanel(SanboxChassis sanboxChassis) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        this.chassisNameContent.setText(sanboxChassis.getChassisName());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = this.chassisNameContent.getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        this.chassisNameContent.setFont(font);
        this.chassisNameContent.setForeground(Color.black);
        jPanel.add((Component)this.chassisNameContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    protected JPanel createLoopbackPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.idPanel = this.createIdPanel(this.blade);
        this.testParametersPanel = this.createTestParametersPanel();
        this.resultsPanel = this.createResultsPanel();
        this.testDetailsPanel = this.createTestDetailsPanel();
        this.testSelectionPanel = this.createTestSelectionPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.testDetailsPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.resultsPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.testSelectionPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.testParametersPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createTestSelectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.portCombo = new JComboBox();
        int n = 0;
        while (n < this.portCount) {
            this.portCombo.addItem(Integer.toString(n));
            ++n;
        }
        this.portCombo.setSelectedIndex(this.selectedPort.getPortNumber());
        this.portCombo.addActionListener(new PortComboListener(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.selectPortLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        jPanel.add((Component)this.portCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        jPanel.add((Component)this.selectTestLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel.add((Component)this.internalButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.externalButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.onlineButton, gridBagConstraints);
        this.internalButton.addActionListener(new TestButtonListener(this));
        this.externalButton.addActionListener(new TestButtonListener(this));
        this.onlineButton.addActionListener(new TestButtonListener(this));
        this.testButtonGroup.add(this.internalButton);
        this.testButtonGroup.add(this.externalButton);
        this.testButtonGroup.add(this.onlineButton);
        this.internalButton.setSelected(true);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testSelection")));
        return jPanel;
    }

    protected JPanel createTestDetailsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.scrollPane.getViewport().add((Component)this.testDetailsText, gridBagConstraints);
        this.testDetailsText.setRows(5);
        this.testDetailsText.setColumns(16);
        this.testDetailsText.setEditable(false);
        this.testDetailsText.setBackground(Color.gray);
        this.testDetailsText.setForeground(Color.white);
        Font font = this.testDetailsText.getFont();
        Font font2 = new Font("Dialog", 0, font.getSize() - 1);
        this.testDetailsText.setFont(font2);
        this.testDetailsText.setCaretPosition(0);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testDetails")));
        return jPanel;
    }

    protected JPanel createTestParametersPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.frameCountLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.frameCountText.setColumns(8);
        this.frameCountText.setText("100");
        jPanel.add((Component)this.frameCountText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.gridwidth = 1;
        this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize.40_292"));
        jPanel.add((Component)this.frameSizeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.frameSizeText.setColumns(8);
        this.frameSizeText.setText("256");
        jPanel.add((Component)this.frameSizeText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(4, 20, 0, 2);
        jPanel.add((Component)this.selectPatternLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 28, 0, 2);
        jPanel.add((Component)this.defaultPatternButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 28, 4, 0);
        jPanel.add((Component)this.userDefinedPatternButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.patternText.setColumns(8);
        this.patternText.setText("f5f5f5f5");
        jPanel.add((Component)this.patternText, gridBagConstraints);
        this.patternText.setEnabled(false);
        this.defaultPatternButton.addActionListener(new PatternButtonListener(this));
        this.userDefinedPatternButton.addActionListener(new PatternButtonListener(this));
        this.patternButtonGroup.add(this.defaultPatternButton);
        this.patternButtonGroup.add(this.userDefinedPatternButton);
        this.defaultPatternButton.setSelected(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.stopOnErrorChBox.setSelected(false);
        Color color = this.selectPatternLabel.getForeground();
        this.stopOnErrorChBox.setForeground(color);
        jPanel.add((Component)this.stopOnErrorChBox, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testParameters")));
        return jPanel;
    }

    protected JPanel createResultsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 20, 4, 2);
        jPanel.add((Component)this.testStatusLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.testInactive"));
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.testStatusText.setColumns(8);
        this.testStatusText.setEditable(false);
        jPanel.add((Component)this.testStatusText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.framesSentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.framesSentText.setColumns(8);
        this.framesSentText.setEditable(false);
        jPanel.add((Component)this.framesSentText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.testFailuresLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        this.testFailuresText.setColumns(8);
        this.testFailuresText.setEditable(false);
        jPanel.add((Component)this.testFailuresText, gridBagConstraints);
        this.testStatusText.setEditable(false);
        this.framesSentText.setEditable(false);
        this.testFailuresText.setEditable(false);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("LoopbackDialog.testResults")));
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancelButtonListener.actionPerformed(null);
        }
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
        this.stopTestButton.setEnabled(true);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        this.stopTestButton.setEnabled(false);
    }

    protected void enableTestParametersPanel(boolean bl) {
        this.frameCountLabel.setEnabled(bl);
        this.frameCountText.setEnabled(bl);
        this.frameSizeLabel.setEnabled(bl);
        this.frameSizeText.setEnabled(bl);
        this.defaultPatternButton.setEnabled(bl);
        this.selectPatternLabel.setEnabled(bl);
        this.userDefinedPatternButton.setEnabled(bl);
        if (bl & this.userDefinedPatternButton.isSelected()) {
            this.patternText.setEnabled(bl);
        } else if (!bl) {
            this.patternText.setEnabled(bl);
        }
        this.stopOnErrorChBox.setEnabled(bl);
    }

    protected void postTestStatus(LoopbackPortTestResult loopbackPortTestResult) {
        if (loopbackPortTestResult.isTestDone()) {
            this.testStatusText.setText(loopbackPortTestResult.isTestSuccessful() ? "Passed" : "Failed");
        } else {
            this.framesSentText.setText(Long.toString(loopbackPortTestResult.getFrameCount()));
            this.testFailuresText.setText(Long.toString(loopbackPortTestResult.getFailureCount()));
        }
    }

    protected void requestOnlineLoopbackTest() {
        if (this.useDefaultPattern) {
            ((Sanbox2)this.blade).applyOnlineLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.stopOnError);
        } else {
            this.blade.applyOnlineLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.pattern, this.stopOnError);
        }
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TestStatusUpdateTimer(), 1000L);
    }

    protected void requestInternalLoopbackTest() {
        if (this.useDefaultPattern) {
            ((Sanbox2)this.blade).applyLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.stopOnError, 1);
        } else {
            ((Sanbox2)this.blade).applyLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.pattern, this.stopOnError, 1);
        }
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TestStatusUpdateTimer(), 1000L);
    }

    protected void requestExternalLoopbackTest() {
        if (this.useDefaultPattern) {
            ((Sanbox2)this.blade).applyLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.stopOnError, 2);
        } else {
            ((Sanbox2)this.blade).applyLoopbackTest(this.selectedPort.getPortNumber(), this.frameCount, this.frameSize, this.pattern, this.stopOnError, 2);
        }
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TestStatusUpdateTimer(), 1000L);
    }

    protected void stopTest() {
        this.dialogState = 3;
        ((Sanbox2)this.blade).applyStopLoopbackTest(this.selectedPort.getPortNumber());
    }

    protected void updateTestStatus() {
        boolean bl = ((Sanbox2)this.blade).updateLoopbackTestStatus();
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyLoopbackTest() {
        int n = this.portCombo.getSelectedIndex();
        this.selectedPort = this.blade.getPort(n);
        this.framesSentText.setText("");
        this.testFailuresText.setText("");
        this.testStatusTimeoutCount = 0;
        if (this.onlineButton.isSelected()) {
            this.testType = 3;
            return this.applyOnlineLoopbackTest();
        }
        if (this.internalButton.isSelected()) {
            this.testType = 1;
            if (!this.portStatesSaved) {
                this.savePortStates();
                this.portStatesSaved = true;
            }
            return this.applyInternalLoopbackTest();
        }
        if (this.externalButton.isSelected()) {
            this.testType = 2;
            if (!this.portStatesSaved) {
                this.savePortStates();
                this.portStatesSaved = true;
            }
            return this.applyExternalLoopbackTest();
        }
        return -1;
    }

    protected void savePortStates() {
        int n = 0;
        while (n < this.portCount) {
            FCPort fCPort = this.blade.getPort(n);
            PortStates portStates = fCPort.getPortStates();
            this.originalPortState[n] = portStates != null ? (int)portStates.getActiveAdminState() : -1;
            ++n;
        }
    }

    protected int applyOnlineLoopbackTest() {
        this.useDefaultPattern = false;
        this.testFailuresText.setText("");
        this.testStatusText.setText("");
        this.framesSentText.setText("");
        this.unreachableWarningDisplayed = false;
        PortStates portStates = this.selectedPort.getPortStates();
        if (portStates != null && portStates.getLoggedIn() != 1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.portNotOnline"));
            return -1;
        }
        if (this.getUserParameters() == -1) {
            return -1;
        }
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.running"));
        this.waitingOnRequestAdmin = true;
        this.waitingOnReleaseAdmin = true;
        this.waitingOnTestResults = true;
        this.waitingOnPortStateChange = false;
        this.dialogState = 2;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        ((Sanbox2Sml)this.blade).requestAdmin();
        return 1;
    }

    protected int getUserParameters() {
        try {
            this.frameCount = Long.parseLong(this.frameCountText.getText());
            if (this.frameCount < 1L || this.frameCount > Integer.MAX_VALUE) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameCount"));
                return -1;
            }
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameCount"));
            return -1;
        }
        try {
            this.frameSize = Integer.parseInt(this.frameSizeText.getText());
            if (this.internalButton.isSelected() || this.externalButton.isSelected()) {
                if (this.frameSize < 40 || this.frameSize > 292) {
                    PopupDialog.showDialog(this.frame, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameSize.40_292"));
                    return -1;
                }
            } else if (this.fport) {
                if (this.frameSize < 36 || this.frameSize > 256) {
                    PopupDialog.showDialog(this.frame, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameSize.256"));
                    return -1;
                }
            } else if (this.frameSize < 36 || this.frameSize > 2148) {
                PopupDialog.showDialog(this.frame, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameSize"));
                return -1;
            }
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this.frame, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidFrameSize.general"));
            return -1;
        }
        try {
            if (this.defaultPatternButton.isSelected()) {
                this.useDefaultPattern = true;
            } else {
                this.useDefaultPattern = false;
                String string = this.patternText.getText().trim().toLowerCase();
                if (string.startsWith("0x") && string.length() > 2) {
                    string = string.substring(2);
                }
                this.pattern = Long.parseLong(string, 16);
                if (this.pattern < 0L || this.pattern > 0xFFFFFFFFL) {
                    PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidPattern"));
                    return -1;
                }
            }
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.invalidPattern"));
            return -1;
        }
        this.stopOnError = this.stopOnErrorChBox.isSelected();
        return 0;
    }

    protected int applyInternalLoopbackTest() {
        byte by;
        this.useDefaultPattern = false;
        this.testFailuresText.setText("");
        this.testStatusText.setText("");
        this.framesSentText.setText("");
        this.unreachableWarningDisplayed = false;
        this.dialogState = 2;
        this.waitingOnPortStateNotification = false;
        PortStates portStates = this.selectedPort.getPortStates();
        if (portStates != null && (by = portStates.getOperationalAdminState()) != 3) {
            boolean bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("LoopbackDialog.ask.portToTest"));
            if (bl) {
                this.portStateChanged[this.selectedPort.getPortNumber()] = true;
                this.waitingOnPortConfigRequestAdmin1 = true;
                this.waitingOnPortConfigReleaseAdmin1 = true;
                this.waitingOnPortStateChange = true;
                this.dialogState = 5;
                this.waitingOnPortStateNotification = true;
                this.applyPortState(this.selectedPort.getPortNumber(), 3);
            } else {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotGoingToRun"));
                return -1;
            }
        }
        if (this.getUserParameters() == -1) {
            return -1;
        }
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.running"));
        this.waitingOnRequestAdmin = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        ((Sanbox2Sml)this.blade).requestAdmin();
        return 1;
    }

    protected int applyExternalLoopbackTest() {
        byte by;
        this.useDefaultPattern = false;
        this.testFailuresText.setText("");
        this.testStatusText.setText("");
        this.framesSentText.setText("");
        this.unreachableWarningDisplayed = false;
        this.dialogState = 2;
        this.waitingOnPortStateNotification = false;
        boolean bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("LoopbackDialog.ask.loopbackPluggedIn"));
        if (!bl) {
            return -1;
        }
        if (this.selectedPort.getGbicType() == 99) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.emptyPort"));
            return -1;
        }
        PortStates portStates = this.selectedPort.getPortStates();
        if (portStates != null && (by = portStates.getOperationalAdminState()) != 3) {
            boolean bl2 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("LoopbackDialog.ask.portToTest"));
            if (bl2) {
                this.portStateChanged[this.selectedPort.getPortNumber()] = true;
                this.waitingOnPortConfigRequestAdmin1 = true;
                this.waitingOnPortConfigReleaseAdmin1 = true;
                this.waitingOnPortStateChange = true;
                this.waitingOnPortStateNotification = true;
                this.dialogState = 5;
                this.applyPortState(this.selectedPort.getPortNumber(), 3);
            } else {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotGoingToRun"));
                return -1;
            }
        }
        if (this.getUserParameters() == -1) {
            return -1;
        }
        this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.running"));
        this.waitingOnRequestAdmin = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        ((Sanbox2Sml)this.blade).requestAdmin();
        return 1;
    }

    protected void applyPortState(int n, int n2) {
        this.blade.addChassisEventListener((ChassisEventListener)this);
        ((Sanbox2Sml)this.blade).requestAdmin();
        ((Sanbox2Sml)this.blade).applyTempPortState(n, n2);
        ((Sanbox2Sml)this.blade).releaseAdmin();
    }

    protected void restoreAllPortStates() {
        this.blade.addChassisEventListener((ChassisEventListener)this);
        ((Sanbox2Sml)this.blade).requestAdmin();
        int n = 0;
        while (n < this.portCount) {
            if (this.portStateChanged[n]) {
                ((Sanbox2Sml)this.blade).applyTempPortState(n, this.originalPortState[n]);
                this.portStateChanged[n] = false;
            }
            ++n;
        }
        ((Sanbox2Sml)this.blade).releaseAdmin();
    }

    class TestStatusUpdateTimer
    extends TimerTask {
        public void run() {
            PortTestDialogSanbox2.this.updateTestStatus();
            if (PortTestDialogSanbox2.this.dialogState == 2 || PortTestDialogSanbox2.this.dialogState == 5) {
                PortTestDialogSanbox2.this.timer = new Timer(true);
                PortTestDialogSanbox2.this.timer.schedule((TimerTask)new TestStatusUpdateTimer(), 1000L);
            }
        }
    }

    class TestWatchDog
    extends TimerTask {
        PortTestDialogSanbox2 dialog;

        public TestWatchDog(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.dialog = portTestDialogSanbox22;
        }

        public void run() {
            SwingUtilities.invokeLater(new TestTerminatedNotifier(this.dialog));
            PortTestDialogSanbox2.this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.runOnTest"));
            PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
            PortTestDialogSanbox2.this.waitingOnTestResults = false;
            PortTestDialogSanbox2.this.dialogState = 3;
            ((Sanbox2Sml)PortTestDialogSanbox2.this.blade).releaseAdmin();
            PortTestDialogSanbox2.this.enableButtons();
        }
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        PortTestDialogSanbox2 dialog = null;

        public ApplyResponseHandler(PortTestDialogSanbox2 portTestDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = portTestDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            if (PortTestDialogSanbox2.this.dialogState == 6) {
                this.processRestorePortStateEvent(this.evt);
            } else if (PortTestDialogSanbox2.this.testType == 1 || PortTestDialogSanbox2.this.testType == 2) {
                this.processLoopbackTestEvent(this.evt);
            } else if (PortTestDialogSanbox2.this.testType == 3) {
                this.processOnlineTestEvent(this.evt);
            }
        }

        public void processOnlineTestEvent(ChassisEvent chassisEvent) {
            switch (chassisEvent.getEventType()) {
                case 238: {
                    PortTestDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (!chassisEvent.isSuccessful()) {
                        PortTestDialogSanbox2.this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.testInactive"));
                        PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.adminReqFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        PortTestDialogSanbox2.this.enableButtons();
                        return;
                    }
                    PortTestDialogSanbox2.this.requestOnlineLoopbackTest();
                    break;
                }
                case 239: {
                    if (!chassisEvent.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.adminRelFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    }
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PortTestDialogSanbox2.this.waitingOnTestResults = false;
                    PortTestDialogSanbox2.this.dialogState = 4;
                    PortTestDialogSanbox2.this.enableButtons();
                    break;
                }
                case 279: {
                    if (PortTestDialogSanbox2.this.timer != null) {
                        PortTestDialogSanbox2.this.timer.cancel();
                    }
                    PortTestDialogSanbox2.this.dialogState = 4;
                    PortTestDialogSanbox2.this.updateTestStatus();
                    LoopbackPortTestResult loopbackPortTestResult = (LoopbackPortTestResult)chassisEvent.getValue();
                    PortTestDialogSanbox2.this.postTestStatus(loopbackPortTestResult);
                    ((Sanbox2Sml)PortTestDialogSanbox2.this.blade).releaseAdmin();
                    break;
                }
                case 280: {
                    if (chassisEvent.isSuccessful()) break;
                    LoopbackPortTestResult loopbackPortTestResult = (LoopbackPortTestResult)chassisEvent.getValue();
                    if (loopbackPortTestResult != null && loopbackPortTestResult.getErrorCode() == 95) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + FabricTreeControl.getResource("LoopbackDialog.error.notInDiagState") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    } else if (loopbackPortTestResult != null && loopbackPortTestResult.getErrorCode() == 99) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + FabricTreeControl.getResource("LoopbackDialog.error.portIsDonor") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    } else if (loopbackPortTestResult != null && loopbackPortTestResult.getErrorCode() == 98) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + FabricTreeControl.getResource("LoopbackDialog.error.testInProgress") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    } else {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    }
                    ((Sanbox2Sml)PortTestDialogSanbox2.this.blade).releaseAdmin();
                    PortTestDialogSanbox2.this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.neverRun"));
                    PortTestDialogSanbox2.this.dialogState = 1;
                    break;
                }
                case 283: {
                    if (PortTestDialogSanbox2.this.timer != null) {
                        PortTestDialogSanbox2.this.timer.cancel();
                    }
                    if (!chassisEvent.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testStopFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        break;
                    }
                    PortTestDialogSanbox2.this.testStatusText.setText("Stopped");
                    PortTestDialogSanbox2.this.dialogState = 4;
                    PortTestDialogSanbox2.this.updateTestStatus();
                    PortTestDialogSanbox2.this.enableButtons();
                    break;
                }
                case 285: {
                    if (chassisEvent.isSuccessful()) {
                        LoopbackPortTestResult loopbackPortTestResult = (LoopbackPortTestResult)chassisEvent.getValue();
                        PortTestDialogSanbox2.this.postTestStatus(loopbackPortTestResult);
                        break;
                    }
                    if (PortTestDialogSanbox2.this.blade.getOverallStatus() == 3) {
                        if (PortTestDialogSanbox2.this.dialogState == 2) {
                            PortTestDialogSanbox2.this.testStatusText.setText("Unknown");
                        }
                        if (PortTestDialogSanbox2.this.timer != null) {
                            PortTestDialogSanbox2.this.timer.cancel();
                        }
                        PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        if (!PortTestDialogSanbox2.this.unreachableWarningDisplayed) {
                            PortTestDialogSanbox2.this.unreachableWarningDisplayed = true;
                            PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.switchUnreachable") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        }
                        PortTestDialogSanbox2.this.waitingOnTestResults = false;
                        PortTestDialogSanbox2.this.dialogState = 4;
                        PortTestDialogSanbox2.this.enableButtons();
                        break;
                    }
                    ++PortTestDialogSanbox2.this.testStatusTimeoutCount;
                    if (PortTestDialogSanbox2.this.dialogState == 4) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testStatusFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        break;
                    }
                    if (PortTestDialogSanbox2.this.testStatusTimeoutCount < 30) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testStatusFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    PortTestDialogSanbox2.this.testStatusTimeoutCount = 0;
                }
            }
        }

        public void processLoopbackTestEvent(ChassisEvent chassisEvent) {
            switch (chassisEvent.getEventType()) {
                case 238: {
                    if (PortTestDialogSanbox2.this.waitingOnPortConfigRequestAdmin1) {
                        PortTestDialogSanbox2.this.waitingOnPortConfigRequestAdmin1 = false;
                    } else if (PortTestDialogSanbox2.this.waitingOnRequestAdmin) {
                        PortTestDialogSanbox2.this.waitingOnRequestAdmin = false;
                        if (!PortTestDialogSanbox2.this.waitingOnPortStateNotification && chassisEvent.isSuccessful()) {
                            if (PortTestDialogSanbox2.this.testType == 1) {
                                PortTestDialogSanbox2.this.requestInternalLoopbackTest();
                            } else if (PortTestDialogSanbox2.this.testType == 2) {
                                PortTestDialogSanbox2.this.requestExternalLoopbackTest();
                            }
                        }
                    }
                    if (chassisEvent.isSuccessful()) break;
                    PortTestDialogSanbox2.this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.testInactive"));
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.adminReqFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    PortTestDialogSanbox2.this.enableButtons();
                    return;
                }
                case 239: {
                    if (PortTestDialogSanbox2.this.waitingOnPortConfigReleaseAdmin1) {
                        PortTestDialogSanbox2.this.waitingOnPortConfigReleaseAdmin1 = false;
                    } else {
                        PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PortTestDialogSanbox2.this.waitingOnTestResults = false;
                        PortTestDialogSanbox2.this.dialogState = 4;
                        PortTestDialogSanbox2.this.enableButtons();
                    }
                    if (chassisEvent.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.adminRelFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    break;
                }
                case 334: {
                    if (chassisEvent.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.portToTestFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PortTestDialogSanbox2.this.waitingOnTestResults = false;
                    PortTestDialogSanbox2.this.waitingOnPortStateChange = false;
                    PortTestDialogSanbox2.this.dialogState = 4;
                    PortTestDialogSanbox2.this.enableButtons();
                    break;
                }
                case 279: {
                    if (PortTestDialogSanbox2.this.timer != null) {
                        PortTestDialogSanbox2.this.timer.cancel();
                    }
                    PortTestDialogSanbox2.this.dialogState = 4;
                    PortTestDialogSanbox2.this.updateTestStatus();
                    LoopbackPortTestResult loopbackPortTestResult = (LoopbackPortTestResult)chassisEvent.getValue();
                    PortTestDialogSanbox2.this.postTestStatus(loopbackPortTestResult);
                    ((Sanbox2Sml)PortTestDialogSanbox2.this.blade).releaseAdmin();
                    break;
                }
                case 336: {
                    int n;
                    if (PortTestDialogSanbox2.this.waitingOnPortStateNotification && (n = ((Integer)chassisEvent.getValue()).intValue()) == PortTestDialogSanbox2.this.selectedPort.getPortNumber()) {
                        PortTestDialogSanbox2.this.waitingOnPortStateNotification = false;
                    }
                    if (PortTestDialogSanbox2.this.waitingOnPortStateNotification || PortTestDialogSanbox2.this.waitingOnRequestAdmin) break;
                    if (PortTestDialogSanbox2.this.testType == 1) {
                        PortTestDialogSanbox2.this.requestInternalLoopbackTest();
                        break;
                    }
                    if (PortTestDialogSanbox2.this.testType != 2) break;
                    PortTestDialogSanbox2.this.requestExternalLoopbackTest();
                    break;
                }
                case 280: {
                    if (chassisEvent.isSuccessful()) break;
                    LoopbackPortTestResult loopbackPortTestResult = (LoopbackPortTestResult)chassisEvent.getValue();
                    if (loopbackPortTestResult != null && loopbackPortTestResult.getErrorCode() == 95) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + FabricTreeControl.getResource("LoopbackDialog.error.notInDiagState") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    } else if (loopbackPortTestResult != null && loopbackPortTestResult.getErrorCode() == 99) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + FabricTreeControl.getResource("LoopbackDialog.error.portIsDonor") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    } else {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testNotPerformed") + " " + Integer.toString(loopbackPortTestResult.getPortNumber()) + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    }
                    ((Sanbox2Sml)PortTestDialogSanbox2.this.blade).releaseAdmin();
                    PortTestDialogSanbox2.this.testStatusText.setText(FabricTreeControl.getResource("LoopbackDialog.neverRun"));
                    break;
                }
                case 283: {
                    if (PortTestDialogSanbox2.this.timer != null) {
                        PortTestDialogSanbox2.this.timer.cancel();
                    }
                    if (!chassisEvent.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testStopFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        break;
                    }
                    PortTestDialogSanbox2.this.testStatusText.setText("Stopped");
                    PortTestDialogSanbox2.this.dialogState = 4;
                    PortTestDialogSanbox2.this.updateTestStatus();
                    PortTestDialogSanbox2.this.enableButtons();
                    break;
                }
                case 285: {
                    if (chassisEvent.isSuccessful()) {
                        LoopbackPortTestResult loopbackPortTestResult = (LoopbackPortTestResult)chassisEvent.getValue();
                        PortTestDialogSanbox2.this.postTestStatus(loopbackPortTestResult);
                        break;
                    }
                    if (PortTestDialogSanbox2.this.blade.getOverallStatus() == 3) {
                        if (PortTestDialogSanbox2.this.dialogState == 2) {
                            PortTestDialogSanbox2.this.testStatusText.setText("Unknown");
                        }
                        if (PortTestDialogSanbox2.this.timer != null) {
                            PortTestDialogSanbox2.this.timer.cancel();
                        }
                        PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        if (!PortTestDialogSanbox2.this.unreachableWarningDisplayed) {
                            PortTestDialogSanbox2.this.unreachableWarningDisplayed = true;
                            PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.switchUnreachable") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        }
                        PortTestDialogSanbox2.this.waitingOnTestResults = false;
                        PortTestDialogSanbox2.this.dialogState = 4;
                        PortTestDialogSanbox2.this.enableButtons();
                        break;
                    }
                    ++PortTestDialogSanbox2.this.testStatusTimeoutCount;
                    if (PortTestDialogSanbox2.this.dialogState == 4) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testStatusFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                        break;
                    }
                    if (PortTestDialogSanbox2.this.testStatusTimeoutCount < 30) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.testStatusFailed") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    PortTestDialogSanbox2.this.testStatusTimeoutCount = 0;
                }
            }
        }

        public void processRestorePortStateEvent(ChassisEvent chassisEvent) {
            switch (chassisEvent.getEventType()) {
                case 238: {
                    if (chassisEvent.isSuccessful()) break;
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.adminReqFailed") + "\n" + FabricTreeControl.getResource("LoopbackDialog.error.restoringPortStates") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PortTestDialogSanbox2.this.enableButtons();
                    PortTestDialogSanbox2.this.waitingOnPortRestoration = false;
                    if (PortTestDialogSanbox2.this.delayDialogExit) {
                        PortTestDialogSanbox2.this.setVisible(false);
                    }
                    return;
                }
                case 334: {
                    if (chassisEvent.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.restoringPortStates") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PortTestDialogSanbox2.this.enableButtons();
                    PortTestDialogSanbox2.this.waitingOnPortRestoration = false;
                    if (!PortTestDialogSanbox2.this.delayDialogExit) break;
                    PortTestDialogSanbox2.this.setVisible(false);
                    break;
                }
                case 239: {
                    if (!chassisEvent.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.restoringPortStates") + "\n" + PortTestDialogSanbox2.this.getFailedString(chassisEvent.getErrorType()));
                    }
                    PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    PortTestDialogSanbox2.this.enableButtons();
                    PortTestDialogSanbox2.this.waitingOnPortRestoration = false;
                    if (!PortTestDialogSanbox2.this.delayDialogExit) break;
                    PortTestDialogSanbox2.this.setVisible(false);
                }
            }
        }
    }

    class StopTestButtonListener
    implements ActionListener {
        PortTestDialogSanbox2 theDialog = null;

        public StopTestButtonListener(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.theDialog = portTestDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortTestDialogSanbox2.this.stopTest();
            PortTestDialogSanbox2.this.updateTestStatus();
            PortTestDialogSanbox2.this.enableButtons();
        }
    }

    class TestTerminatedNotifier
    implements Runnable {
        PortTestDialogSanbox2 dialog;

        public TestTerminatedNotifier(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.dialog = portTestDialogSanbox22;
        }

        public void run() {
            PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("LoopbackDialog.error.runOnTest"));
        }
    }

    class PatternButtonListener
    implements ActionListener {
        PortTestDialogSanbox2 theDialog = null;

        public PatternButtonListener(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.theDialog = portTestDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PortTestDialogSanbox2.this.defaultPatternButton.isSelected()) {
                PortTestDialogSanbox2.this.patternText.setEnabled(false);
            } else {
                PortTestDialogSanbox2.this.patternText.setEnabled(true);
            }
        }
    }

    class PortComboListener
    implements ActionListener {
        PortTestDialogSanbox2 theDialog = null;

        public PortComboListener(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.theDialog = portTestDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PortTestDialogSanbox2.this.portCombo.getSelectedIndex();
            PortTestDialogSanbox2.this.selectedPort = PortTestDialogSanbox2.this.blade.getPort(n);
            PortTestDialogSanbox2.this.fport = false;
            PortStates portStates = PortTestDialogSanbox2.this.selectedPort.getPortStates();
            if (portStates != null && (portStates.getPortType() == 1 || portStates.getPortType() == 0 && portStates.getConfigPortType() == 1)) {
                PortTestDialogSanbox2.this.fport = true;
            }
            if (PortTestDialogSanbox2.this.internalButton.isSelected() || PortTestDialogSanbox2.this.externalButton.isSelected()) {
                PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize.40_292"));
            } else if (PortTestDialogSanbox2.this.fport) {
                PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize.256"));
            } else {
                PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize"));
            }
            PortTestDialogSanbox2.this.frameSizeText.setText("256");
        }
    }

    class CancelButtonListener
    implements ActionListener {
        PortTestDialogSanbox2 theDialog = null;

        public CancelButtonListener(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.theDialog = portTestDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PortTestDialogSanbox2.this.delayDialogExit) {
                this.theDialog.setVisible(false);
            }
            boolean bl = false;
            int n = 0;
            while (n < PortTestDialogSanbox2.this.portCount) {
                if (PortTestDialogSanbox2.this.portStateChanged[n]) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                if (PortTestDialogSanbox2.this.timer != null) {
                    PortTestDialogSanbox2.this.timer.cancel();
                }
                PortTestDialogSanbox2.this.dialogState = 6;
                PortTestDialogSanbox2.this.restoreAllPortStates();
                PortTestDialogSanbox2.this.waitingOnPortRestoration = true;
                if (!PortTestDialogSanbox2.this.delayDialogExit) {
                    PopupDialog.showDialog(this.theDialog, 2, FabricTreeControl.getResource("LoopbackDialog.restoringPortStates"));
                }
            } else {
                PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.theDialog);
                PortTestDialogSanbox2.this.enableButtons();
                if (PortTestDialogSanbox2.this.timer != null) {
                    PortTestDialogSanbox2.this.timer.cancel();
                }
                PortTestDialogSanbox2.this.eventAdapter = null;
                if (PortTestDialogSanbox2.this.delayDialogExit) {
                    this.theDialog.setVisible(false);
                }
            }
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        PortTestDialogSanbox2 theDialog = null;

        public ApplyButtonListener(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.theDialog = portTestDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyLoopbackTest() == 1) {
                if (PortTestDialogSanbox2.this.waitingOnTestResults || PortTestDialogSanbox2.this.waitingOnRequestAdmin || PortTestDialogSanbox2.this.waitingOnPortStateChange) {
                    PortTestDialogSanbox2.this.disableButtons();
                }
            } else {
                PortTestDialogSanbox2.this.dialogState = 1;
                PortTestDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.theDialog);
                PortTestDialogSanbox2.this.enableButtons();
            }
        }
    }

    class TestButtonListener
    implements ActionListener {
        PortTestDialogSanbox2 theDialog = null;

        public TestButtonListener(PortTestDialogSanbox2 portTestDialogSanbox22) {
            this.theDialog = portTestDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PortTestDialogSanbox2.this.internalButton) {
                PortTestDialogSanbox2.this.testDetailsText.setText(FabricTreeControl.getResource("LoopbackDialog.internal.details"));
                PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize.40_292"));
            } else if (object == PortTestDialogSanbox2.this.externalButton) {
                PortTestDialogSanbox2.this.testDetailsText.setText(FabricTreeControl.getResource("LoopbackDialog.external.details"));
                PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize.40_292"));
            } else if (object == PortTestDialogSanbox2.this.onlineButton) {
                PortTestDialogSanbox2.this.testDetailsText.setText(FabricTreeControl.getResource("LoopbackDialog.online.details"));
                if (PortTestDialogSanbox2.this.fport) {
                    PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize.256"));
                } else {
                    PortTestDialogSanbox2.this.frameSizeLabel.setText(FabricTreeControl.getResource("LoopbackDialog.frameSize"));
                }
            }
            PortTestDialogSanbox2.this.frameSizeText.setText("256");
            PortTestDialogSanbox2.this.testDetailsText.setCaretPosition(0);
        }
    }
}

