/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.DialogCreateException;
import com.qlogic.qms.fabric.propertyDialogs.SwitchProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwitchPropertiesDialogSanbox
extends QDialog {
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter chassisEventAdapter = null;
    protected Fabric fabric = null;
    protected JFrame frame = null;
    protected JPanel chassisPanel = null;
    protected JPanel buttonPanel = null;
    protected boolean waitingOnNameChange = false;
    protected boolean waitingOnSwitchConfigChange = false;
    protected boolean waitingOnChassisTypeChange = false;
    protected boolean waitingOnSavePending = false;
    protected boolean waitingOnReconfig = false;
    protected boolean switchConfigCompletedOk = false;
    protected int newFcAddress;
    protected SwitchProperties properties = new SwitchProperties();
    GridBagLayout baseLayout = new GridBagLayout();
    String[] adminStateChoicesNoTest = new String[]{FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.0"), FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.1")};
    String[] adminStateChoicesWithTest = new String[]{FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.0"), FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.1"), FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.2")};
    JPanel idPanel = new JPanel();
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.ipAddrLabel"));
    JLabel ipAddrContent = new JLabel();
    JLabel opStateLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateLabel"));
    JLabel opStateContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel firmwareLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.firmwareLabel"));
    JLabel firmwareContent = new JLabel();
    JLabel curChassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel curChassisNameContent = new JLabel();
    JLabel macAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.macAddrLabel"));
    JLabel macAddrContent = new JLabel();
    GridBagLayout chassisLayout = new GridBagLayout();
    JPanel switchPanel = new JPanel();
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel adminStateLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateLabel"));
    JLabel domainIdLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.domainIdLabel"));
    public FixedLengthTextField chassisNameText = new FixedLengthTextField(63);
    public JComboBox adminStateCombo;
    public JTextField domainIdText = new JTextField();
    JLabel domainIdLockLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.domainIdLockLabel"));
    JRadioButton enableDomainIdLockButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.enableButton"));
    JRadioButton disableDomainIdLockButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.disableButton"));
    ButtonGroup domainIdLockButtonGroup = new ButtonGroup();
    JPanel timeoutPanel = new JPanel();
    GridBagLayout timeoutLayout = new GridBagLayout();
    JLabel timeoutLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.timeoutLabel"));
    JLabel raTovLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.raTovLabel"));
    JLabel edTovLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.edTovLabel"));
    public JTextField raTovText = new JTextField();
    public JTextField edTovText = new JTextField();

    public SwitchPropertiesDialogSanbox(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        super((Frame)jFrame, bl);
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.frame = jFrame;
        this.setTitle(FabricTreeControl.getResource("SwitchPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.chassisPanel = this.buildPanel();
        this.setEnabled(true);
        this.resetPanel();
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.switchPropertiesDialogSanboxHelp"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.chassisPanel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void setSwitch(SanboxChassis sanboxChassis, Fabric fabric) {
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.unregisterForEvents();
        this.resetDialog();
    }

    public void resetDialog() {
        this.resetPanel();
        this.setEnabled(true);
    }

    public void resetDialog(SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        this.unregisterForEvents();
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.resetPanel();
        this.setEnabled(true);
    }

    public void disableButtons() {
        this.properties.applyButton.setEnabled(false);
        this.setEnabled(false);
    }

    public void enableButtons() {
        this.properties.applyButton.setEnabled(true);
        this.properties.cancelButton.setEnabled(true);
        this.setEnabled(true);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.chassisNameText.setEnabled(bl);
        this.adminStateCombo.setEnabled(bl);
        this.domainIdText.setEnabled(bl);
        this.raTovText.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.edTovText.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.timeoutLabel.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.raTovLabel.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.edTovLabel.setEnabled(bl && this.blade.getAdminMode() == 2);
    }

    public void resetPanel() {
        this.wwNameContent.setText(this.blade.getWWName().delimit());
        int n = this.blade.getAdminMode();
        switch (n) {
            case 1: {
                this.opStateContent.setText(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateContent.0"));
                break;
            }
            case 2: {
                this.opStateContent.setText(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateContent.1"));
                break;
            }
            case 3: {
                this.opStateContent.setText(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateContent.2"));
            }
        }
        this.fcAddrContent.setText(this.blade.delimitFCAddress());
        this.firmwareContent.setText(this.blade.getFlashVersionString());
        this.curChassisNameContent.setText(this.blade.getChassisName());
        this.macAddrContent.setText(this.blade.delimitMacAddress());
        IPInfo iPInfo = this.blade.getIpInfo();
        if (iPInfo != null) {
            this.ipAddrContent.setText(iPInfo.getIpAddress().getHostAddress());
        } else {
            this.ipAddrContent.setText("unknown");
        }
        this.chassisNameText.setText(this.blade.getChassisName());
        this.adminStateCombo.setSelectedIndex(n - 1);
        this.domainIdText.setText(Integer.toString(this.blade.getDomainId()));
        if (this.blade.getDomainIdLock() == 1) {
            this.enableDomainIdLockButton.setSelected(true);
            this.disableDomainIdLockButton.setSelected(false);
        } else if (this.blade.getDomainIdLock() == 0) {
            this.enableDomainIdLockButton.setSelected(false);
            this.disableDomainIdLockButton.setSelected(true);
        } else {
            this.enableDomainIdLockButton.setSelected(false);
            this.disableDomainIdLockButton.setSelected(false);
        }
        this.raTovText.setText(Integer.toString(this.blade.getRaTimeout()));
        this.edTovText.setText(Integer.toString(this.blade.getEdTimeout()));
        this.validate();
    }

    protected JPanel buildPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.baseLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        jPanel.add((Component)this.switchPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        jPanel.add((Component)this.timeoutPanel, gridBagConstraints);
        this.idPanel.setLayout(this.idLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.idPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.curChassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.curChassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.ipAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrContent, gridBagConstraints);
        this.idPanel.setBorder(BorderFactory.createEtchedBorder());
        this.idPanel.setBackground(Color.white);
        int n = this.wwNameContent.getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        this.opStateContent.setFont(font);
        this.opStateContent.setForeground(Color.black);
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        this.firmwareContent.setFont(font);
        this.firmwareContent.setForeground(Color.black);
        this.curChassisNameContent.setFont(font);
        this.curChassisNameContent.setForeground(Color.black);
        this.macAddrContent.setFont(font);
        this.macAddrContent.setForeground(Color.black);
        this.ipAddrContent.setFont(font);
        this.ipAddrContent.setForeground(Color.black);
        int n2 = this.blade.getAdminMode();
        this.adminStateCombo = n2 == 3 ? new JComboBox<String>(this.adminStateChoicesWithTest) : new JComboBox<String>(this.adminStateChoicesNoTest);
        this.switchPanel.setLayout(this.chassisLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        this.switchPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.chassisNameText.setColumns(10);
        gridBagConstraints.gridwidth = 2;
        this.switchPanel.add((Component)this.chassisNameText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.gridwidth = 1;
        this.switchPanel.add((Component)this.adminStateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        this.switchPanel.add((Component)this.adminStateCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.switchPanel.add((Component)this.domainIdLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        this.switchPanel.add((Component)this.domainIdText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.switchPanel.add((Component)this.domainIdLockLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.enableDomainIdLockButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.switchPanel.add((Component)this.disableDomainIdLockButton, gridBagConstraints);
        this.domainIdLockButtonGroup.add(this.enableDomainIdLockButton);
        this.domainIdLockButtonGroup.add(this.disableDomainIdLockButton);
        this.switchPanel.setBorder(BorderFactory.createEtchedBorder());
        this.timeoutPanel.setLayout(this.timeoutLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        this.timeoutPanel.add(this.timeoutLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.raTovLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        this.raTovText.setColumns(7);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.raTovText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.edTovLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.edTovText, gridBagConstraints);
        this.timeoutPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(213));
        vector.add(new Integer(230));
        return vector;
    }

    protected Vector getNameChangeEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(213));
        return vector;
    }

    protected int applyChassisProperties() {
        boolean bl;
        int n;
        Chassis chassis;
        int n2;
        int n3;
        int n4;
        int n5;
        SnmpInfo snmpInfo;
        block43: {
            block42: {
                int n6;
                this.waitingOnNameChange = false;
                this.waitingOnSwitchConfigChange = false;
                this.waitingOnChassisTypeChange = false;
                this.waitingOnSavePending = false;
                this.waitingOnReconfig = false;
                this.switchConfigCompletedOk = false;
                SnmpInfo snmpInfo2 = this.blade.getSnmpInfo();
                snmpInfo = this.properties.copySnmpInfo(snmpInfo2);
                String string = this.chassisNameText.getText();
                if (!string.equals(this.blade.getChassisName())) {
                    snmpInfo.setName(string);
                    this.chassisEventAdapter.registerEventHandler(214, "receiveChassisEvent");
                    this.waitingOnNameChange = true;
                }
                if ((n6 = this.adminStateCombo.getSelectedIndex()) < 0) {
                    PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidAdminState"));
                    return -1;
                }
                n5 = n6 + 1;
                n4 = this.blade.getDomainIdLock();
                if (this.enableDomainIdLockButton.isSelected()) {
                    n4 = 1;
                } else if (this.disableDomainIdLockButton.isSelected()) {
                    n4 = 0;
                }
                try {
                    n3 = Integer.parseInt(this.domainIdText.getText());
                }
                catch (Exception exception) {
                    n3 = 0;
                }
                if (!this.fabric.isUniqueDomainID(this.blade.getDomainId(), n3)) {
                    String string2 = FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidDomainId.duplicate") + "\n\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.error.rules") + 1 + " to " + 239 + " ( 0x" + Integer.toHexString(1) + " to " + " 0x" + Integer.toHexString(239) + " ).\n\n";
                    PopupDialog.showDialog(this, 3, string2);
                    return -1;
                }
                if (n3 < 1) break block42;
                if (n3 <= 239) break block43;
            }
            String string = FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidDomainId.outOfRange") + "\n\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.error.rules") + 1 + " to " + 239 + " ( 0x" + Integer.toHexString(1) + " to " + " 0x" + Integer.toHexString(239) + " ).\n\n";
            PopupDialog.showDialog(this, 3, string);
            return -1;
        }
        if (this.fabric.hasSanbox() && (n3 < this.fabric.minValidDomainID() || n3 > this.fabric.maxValidDomainID())) {
            String string = FabricTreeControl.getResource("SwitchPropertiesDialog.mixedFabricDomainRange.1") + " " + this.fabric.minValidDomainID() + " to " + this.fabric.maxValidDomainID() + " ( 0x" + Integer.toHexString(this.fabric.minValidDomainID()) + " to " + " 0x" + Integer.toHexString(this.fabric.maxValidDomainID()) + " ).\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.mixedFabricDomainRange.2") + n3 + " ( 0x" + Integer.toHexString(n3) + " ) " + FabricTreeControl.getResource("SwitchPropertiesDialog.mixedFabricDomainRange.3");
            n2 = PopupDialog.showDialog(this, 1, string = string + "\n\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.error.changeAnyway")) ? 1 : 0;
            if (n2 == 0) {
                return -1;
            }
        }
        n2 = 0;
        int n7 = 0;
        int n8 = this.blade.getRtTimeout();
        try {
            n2 = Integer.parseInt(this.raTovText.getText());
            n7 = Integer.parseInt(this.edTovText.getText());
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTimeout"));
            return -1;
        }
        if (n2 < 100 || n2 > 100000) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalid_R_A_TOV"));
            return -1;
        }
        if (n7 < 10 || n7 > 20000) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalid_E_D_TOV"));
            return -1;
        }
        if (n2 != this.blade.getRaTimeout()) {
            if (this.fabric.getConnectionSwitch().equals((Object)this.blade)) {
                chassis = this.fabric.getFirstSwitch();
                n = 0;
                while (n < this.fabric.switchCount()) {
                    if (n2 != ((SanboxChassis)chassis).getRaTimeout() && !this.fabric.getConnectionSwitch().equals((Object)chassis)) {
                        if (!PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableFabConflictingTOVWarning"))) {
                            return -1;
                        }
                        break;
                    }
                    chassis = this.fabric.getNextSwitch(chassis);
                    ++n;
                }
            } else if (n2 != this.fabric.getConnectionSwitch().getRaTimeout() && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableConflictingTOVWarning"))) {
                return -1;
            }
        }
        if (n7 != this.blade.getEdTimeout()) {
            if (this.fabric.getConnectionSwitch().equals((Object)this.blade)) {
                chassis = this.fabric.getFirstSwitch();
                n = 0;
                while (n < this.fabric.switchCount()) {
                    if (n7 != ((SanboxChassis)chassis).getEdTimeout() && !this.fabric.getConnectionSwitch().equals((Object)chassis)) {
                        if (!PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableFabConflictingTOVWarning"))) {
                            return -1;
                        }
                        break;
                    }
                    chassis = this.fabric.getNextSwitch(chassis);
                    ++n;
                }
            } else if (n7 != this.fabric.getConnectionSwitch().getEdTimeout() && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableConflictingTOVWarning"))) {
                return -1;
            }
        }
        if (n5 == 2 && this.blade.getAdminMode() != 2 && this.fabric != null && this.fabric.getConnectionSwitch() != this.blade && !(bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.switchOfflineWarning")))) {
            return -1;
        }
        int n9 = this.blade.getPortCount();
        FCPort fCPort = null;
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        int[] nArray3 = new int[n9];
        int[] nArray4 = new int[n9];
        if (n5 != this.blade.getAdminMode() || n3 != this.blade.getDomainId() || n2 != this.blade.getRaTimeout() || n7 != this.blade.getEdTimeout() || n4 != this.blade.getDomainIdLock()) {
            this.chassisEventAdapter.registerEventHandler(231, "receiveChassisEvent");
            this.chassisEventAdapter.registerEventHandler(266, "receiveChassisEvent");
            this.chassisEventAdapter.registerEventHandler(268, "receiveChassisEvent");
            this.waitingOnSwitchConfigChange = true;
            this.waitingOnSavePending = true;
            this.waitingOnReconfig = true;
            int n10 = 0;
            while (n10 < n9) {
                try {
                    fCPort = this.blade.getPort(n10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                nArray[n10] = fCPort.getAdminState();
                nArray2[n10] = fCPort.getMfsMode();
                nArray3[n10] = fCPort.getAlDisabled();
                nArray4[n10] = fCPort.getPortStates().getPortType();
                ++n10;
            }
        }
        if (this.waitingOnNameChange) {
            this.blade.applySnmpInfo(snmpInfo);
        }
        if (this.waitingOnSwitchConfigChange) {
            ((Sanbox)this.blade).applySwitchConfig(n3, n4, this.blade.getStageType(), n5, this.blade.getMfsTimeout(), nArray, nArray2, nArray3, nArray4, n8, n2, n7);
            this.newFcAddress = n3 << 16;
            ((SanboxUtil)this.blade).applySavePendingSwitchConfig();
            ((SanboxUtil)this.blade).applySwitchReconfig();
        }
        return 1;
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 268 && chassisEvent.isSuccessful() && this.newFcAddress != 0 && this.switchConfigCompletedOk) {
            chassisEvent.getChassis().setFcAddress(this.newFcAddress);
        }
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.chassisEventAdapter.unregisterEventHandler(214);
        this.chassisEventAdapter.unregisterEventHandler(231);
        this.chassisEventAdapter.unregisterEventHandler(217);
        this.chassisEventAdapter.unregisterEventHandler(266);
        this.chassisEventAdapter.unregisterEventHandler(268);
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        SwitchPropertiesDialogSanbox dialog = null;

        public ApplyResponseHandler(SwitchPropertiesDialogSanbox switchPropertiesDialogSanbox2, Object object) {
            this.dialog = switchPropertiesDialogSanbox2;
            this.evt = (ChassisEvent)object;
        }

        public void run() {
            int n = this.evt.getEventType();
            switch (n) {
                case 214: {
                    if (!SwitchPropertiesDialogSanbox.this.waitingOnNameChange) break;
                    SwitchPropertiesDialogSanbox.this.waitingOnNameChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.nameChangeFailed") + "\n" + SwitchPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox.this.waitingOnSavePending || SwitchPropertiesDialogSanbox.this.waitingOnReconfig) break;
                    SwitchPropertiesDialogSanbox.this.enableButtons();
                    SwitchPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(SwitchPropertiesDialogSanbox.this.frame, SwitchPropertiesDialogSanbox.this.blade, SwitchPropertiesDialogSanbox.this.getNameChangeEventList(), FabricTreeControl.getResource("SwitchPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 266: {
                    SwitchPropertiesDialogSanbox.this.waitingOnSavePending = false;
                    if (SwitchPropertiesDialogSanbox.this.waitingOnReconfig) break;
                    SwitchPropertiesDialogSanbox.this.enableButtons();
                    SwitchPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 268: {
                    SwitchPropertiesDialogSanbox.this.waitingOnReconfig = false;
                    SwitchPropertiesDialogSanbox.this.enableButtons();
                    SwitchPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(SwitchPropertiesDialogSanbox.this.frame, SwitchPropertiesDialogSanbox.this.blade, SwitchPropertiesDialogSanbox.this.getEventList(), FabricTreeControl.getResource("SwitchPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 231: {
                    SwitchPropertiesDialogSanbox.this.waitingOnSwitchConfigChange = false;
                    if (!this.evt.isSuccessful()) {
                        SwitchPropertiesDialogSanbox.this.switchConfigCompletedOk = false;
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.chassisConfigChangeFailed") + "\n" + SwitchPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    } else {
                        SwitchPropertiesDialogSanbox.this.switchConfigCompletedOk = true;
                    }
                    if (SwitchPropertiesDialogSanbox.this.waitingOnNameChange || SwitchPropertiesDialogSanbox.this.waitingOnSavePending || SwitchPropertiesDialogSanbox.this.waitingOnReconfig) break;
                    SwitchPropertiesDialogSanbox.this.enableButtons();
                    SwitchPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        SwitchPropertiesDialogSanbox theDialog = null;

        public CancelButtonListener(SwitchPropertiesDialogSanbox switchPropertiesDialogSanbox2) {
            this.theDialog = switchPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwitchPropertiesDialogSanbox.this.enableButtons();
            SwitchPropertiesDialogSanbox.this.unregisterForEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        SwitchPropertiesDialogSanbox theDialog = null;

        public ApplyButtonListener(SwitchPropertiesDialogSanbox switchPropertiesDialogSanbox2) {
            this.theDialog = switchPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyChassisProperties() == 1) {
                if (SwitchPropertiesDialogSanbox.this.waitingOnNameChange || SwitchPropertiesDialogSanbox.this.waitingOnSwitchConfigChange) {
                    SwitchPropertiesDialogSanbox.this.disableButtons();
                } else {
                    SwitchPropertiesDialogSanbox.this.unregisterForEvents();
                    this.theDialog.setVisible(false);
                    SwitchPropertiesDialogSanbox.this.blade.updateAll();
                }
            }
        }
    }
}

