/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class UserPreferencesDialog
extends QDialog {
    protected JLabel workingDirLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.workingDir"));
    protected JButton fileChooserButton = new JButton(FabricTreeControl.getResource("UserPreferences.options.browse"));
    protected JTextField workingDirText = new JTextField(18);
    protected JLabel browserPathLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.browserPath"));
    protected JButton pathChooserButton = new JButton(FabricTreeControl.getResource("UserPreferences.options.browse"));
    protected JTextField browserPathText = new JTextField(18);
    protected JLabel pollingLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.polling"));
    protected String[] pollingChoices = new String[]{FabricTreeControl.getResource("UserPreferences.options.polling.level1"), FabricTreeControl.getResource("UserPreferences.options.polling.level2"), FabricTreeControl.getResource("UserPreferences.options.polling.level3")};
    protected JComboBox pollingCombo = new JComboBox<String>(this.pollingChoices);
    protected JLabel portViewLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.portView"));
    protected String[] portViewChoices = new String[]{FabricTreeControl.getResource("UserPreferences.options.portView.modes"), FabricTreeControl.getResource("UserPreferences.options.portView.states"), FabricTreeControl.getResource("UserPreferences.options.portView.speeds"), FabricTreeControl.getResource("UserPreferences.options.portView.media")};
    protected JComboBox portViewCombo = new JComboBox<String>(this.portViewChoices);
    protected JLabel autoSaveLoadLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.autoSaveLoad"));
    protected ButtonGroup autoSaveLoadButtonGroup = new ButtonGroup();
    protected JRadioButton enableButton = new JRadioButton(FabricTreeControl.getResource("UserPreferences.options.autoSaveLoad.enabled"));
    protected JRadioButton disableButton = new JRadioButton(FabricTreeControl.getResource("UserPreferences.options.autoSaveLoad.disabled"));
    protected JLabel eventBrowserLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.eventBrowser"));
    protected ButtonGroup eventBrowserButtonGroup = new ButtonGroup();
    protected JRadioButton eventBrowserEnableButton = new JRadioButton(FabricTreeControl.getResource("UserPreferences.options.eventBrowser.enabled"));
    protected JRadioButton eventBrowserDisableButton = new JRadioButton(FabricTreeControl.getResource("UserPreferences.options.eventBrowser.disabled"));
    protected JLabel startUpDialogLabel = new JLabel(FabricTreeControl.getResource("UserPreferences.options.startUpDialog"));
    protected ButtonGroup startUpDialogButtonGroup = new ButtonGroup();
    protected JRadioButton startUpEnableButton = new JRadioButton(FabricTreeControl.getResource("UserPreferences.options.startUpDialog.enabled"));
    protected JRadioButton startUpDisableButton = new JRadioButton(FabricTreeControl.getResource("UserPreferences.options.startUpDialog.disabled"));
    protected JButton optionApplyButton = new JButton(FabricTreeControl.getResource("UserPreferences.apply"));
    protected JButton optionCancelButton = new JButton(FabricTreeControl.getResource("UserPreferences.cancel"));
    protected JCheckBox disableAllChBox = new JCheckBox(FabricTreeControl.getResource("UserPreferences.layout.disableAll"));
    protected JCheckBox windowSizeChBox = new JCheckBox(FabricTreeControl.getResource("UserPreferences.layout.windowSize"));
    protected JCheckBox splitterBarChBox = new JCheckBox(FabricTreeControl.getResource("UserPreferences.layout.splitterBarPosition"));
    protected JButton layoutApplyButton = new JButton(FabricTreeControl.getResource("UserPreferences.apply"));
    protected JButton layoutCancelButton = new JButton(FabricTreeControl.getResource("UserPreferences.cancel"));
    protected JTabbedPane tabbedPane;
    protected JPanel optionPanel;
    protected JPanel layoutPanel;
    protected JFrame frame = null;
    protected UserPreferences preferences;

    public UserPreferencesDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("UserPreferences.title") + " - " + VendorProperties.getFrameTitle());
        this.preferences = UserPreferences.getInstance();
        this.frame = jFrame;
        this.optionPanel = this.createOptionPanel();
        this.initOptionPanel();
        this.getContentPane().add(this.optionPanel);
        this.getRootPane().setDefaultButton(this.optionApplyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2 - 12, (dimension.height - this.getHeight()) / 2 - 12);
    }

    public JPanel createOptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.optionApplyButton.addActionListener(new ApplyButtonListener("option", this));
        this.optionApplyButton.setMnemonic('O');
        this.optionCancelButton.addActionListener(new CancelButtonListener(this));
        this.optionCancelButton.setMnemonic('C');
        jPanel2.add(this.optionApplyButton);
        jPanel2.add(this.optionCancelButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.workingDirLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        jPanel3.add((Component)this.workingDirText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.fileChooserButton, gridBagConstraints);
        this.fileChooserButton.addActionListener(new FileChooserButtonListener(this));
        this.fileChooserButton.setMnemonic('B');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.browserPathLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        jPanel3.add((Component)this.browserPathText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.pathChooserButton, gridBagConstraints);
        this.pathChooserButton.addActionListener(new PathChooserButtonListener(this));
        this.pathChooserButton.setMnemonic('w');
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        jPanel4.add((Component)this.pollingLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 12);
        jPanel4.add((Component)this.pollingCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        jPanel4.add((Component)this.autoSaveLoadLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        jPanel4.add((Component)this.enableButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 2, 2, 12);
        jPanel4.add((Component)this.disableButton, gridBagConstraints);
        this.autoSaveLoadButtonGroup.add(this.enableButton);
        this.autoSaveLoadButtonGroup.add(this.disableButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        jPanel4.add((Component)this.startUpDialogLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        jPanel4.add((Component)this.startUpEnableButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 2, 2, 12);
        jPanel4.add((Component)this.startUpDisableButton, gridBagConstraints);
        this.startUpDialogButtonGroup.add(this.startUpEnableButton);
        this.startUpDialogButtonGroup.add(this.startUpDisableButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        jPanel4.add((Component)this.eventBrowserLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        jPanel4.add((Component)this.eventBrowserEnableButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 2, 2, 12);
        jPanel4.add((Component)this.eventBrowserDisableButton, gridBagConstraints);
        this.eventBrowserButtonGroup.add(this.eventBrowserEnableButton);
        this.eventBrowserButtonGroup.add(this.eventBrowserDisableButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        jPanel4.add((Component)this.portViewLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 12);
        jPanel4.add((Component)this.portViewCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        jPanel4.setBorder(BorderFactory.createTitledBorder("Application-wide Options"));
        gridBagConstraints.insets = new Insets(2, 8, 4, 8);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 8, 8, 8);
        jPanel2.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.userPreferencesDialogHelp"));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected void initOptionPanel() {
        Properties properties = this.preferences.getUserProperties();
        this.workingDirText.setText(properties.getProperty("workingDir"));
        this.browserPathText.setText(properties.getProperty("browserPath"));
        String string = properties.getProperty("pollingLevel");
        int n = Integer.parseInt(string);
        switch (n) {
            case 1: {
                this.pollingCombo.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.pollingCombo.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.pollingCombo.setSelectedIndex(2);
            }
        }
        String string2 = properties.getProperty("autoSaveLoad");
        if (string2.equals("true")) {
            this.enableButton.setSelected(true);
            this.disableButton.setSelected(false);
        } else {
            this.enableButton.setSelected(false);
            this.disableButton.setSelected(true);
        }
        String string3 = properties.getProperty("startUpDialog");
        if (string3.equals("true")) {
            this.startUpEnableButton.setSelected(true);
            this.startUpDisableButton.setSelected(false);
        } else {
            this.startUpEnableButton.setSelected(false);
            this.startUpDisableButton.setSelected(true);
        }
        String string4 = properties.getProperty("eventBrowser");
        if (string4.equals("true")) {
            this.eventBrowserEnableButton.setSelected(true);
            this.eventBrowserDisableButton.setSelected(false);
        } else {
            this.eventBrowserEnableButton.setSelected(false);
            this.eventBrowserDisableButton.setSelected(true);
        }
        String string5 = this.preferences.getPortView();
        if (string5.equals("modes")) {
            this.portViewCombo.setSelectedIndex(0);
        } else if (string5.equals("states")) {
            this.portViewCombo.setSelectedIndex(1);
        } else if (string5.equals("speeds")) {
            this.portViewCombo.setSelectedIndex(2);
        } else if (string5.equals("media")) {
            this.portViewCombo.setSelectedIndex(3);
        }
    }

    protected JPanel createLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.layoutApplyButton.addActionListener(new ApplyButtonListener("layout", this));
        this.layoutCancelButton.addActionListener(new CancelButtonListener(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.layoutApplyButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add(this.layoutCancelButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Disable Auto Save Upon Exit"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel3.add((Component)this.disableAllChBox, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Enable Auto Save Upon Exit"));
        gridBagConstraints.gridy = 0;
        jPanel4.add((Component)this.windowSizeChBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel4.add((Component)this.splitterBarChBox, gridBagConstraints);
        this.disableAllChBox.addActionListener(new LayoutCheckBoxListener(this));
        this.windowSizeChBox.addActionListener(new LayoutCheckBoxListener(this));
        this.splitterBarChBox.addActionListener(new LayoutCheckBoxListener(this));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected void initLayoutPanel() {
        Properties properties = this.preferences.getUserProperties();
        String string = properties.getProperty("layout.disableAll");
        if (string.equals("true")) {
            this.disableAllChBox.setSelected(true);
            this.windowSizeChBox.setEnabled(false);
            this.splitterBarChBox.setEnabled(false);
        } else {
            this.disableAllChBox.setSelected(false);
        }
        String string2 = properties.getProperty("layout.windowSize");
        boolean bl = string2.equals("true");
        this.windowSizeChBox.setSelected(bl);
        string2 = properties.getProperty("layout.splitterBar");
        bl = string2.equals("true");
        this.splitterBarChBox.setSelected(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected void registerForEvents() {
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
    }

    public String selectWorkingDirectory(String string) {
        File file;
        QFileChooser qFileChooser = UserPreferencesDialog.getDirectoryChooser(string);
        if (string != null) {
            file = new File(string);
            qFileChooser.setSelectedFile(file);
            qFileChooser.setCurrentDirectory(file);
        }
        int n = qFileChooser.showDialog(this, "Select");
        file = qFileChooser.getSelectedFile();
        if (n != 0 || file == null) {
            return null;
        }
        return file.toString();
    }

    private static QFileChooser getDirectoryChooser(String string) {
        QFileChooser qFileChooser = new QFileChooser(string);
        qFileChooser.setSelectedFile(new File(string));
        qFileChooser.setFileSelectionMode(1);
        return qFileChooser;
    }

    public String selectBrowserPath(String string) {
        File file;
        QFileChooser qFileChooser = UserPreferencesDialog.getFileChooser(string);
        if (string != null) {
            file = new File(string);
            qFileChooser.setSelectedFile(file);
            qFileChooser.setCurrentDirectory(file);
        }
        int n = qFileChooser.showDialog(this, "Select");
        file = qFileChooser.getSelectedFile();
        if (n != 0 || file == null) {
            return null;
        }
        return file.toString();
    }

    private static QFileChooser getFileChooser(String string) {
        QFileChooser qFileChooser = new QFileChooser(string);
        qFileChooser.setSelectedFile(new File(string));
        qFileChooser.setFileSelectionMode(0);
        return qFileChooser;
    }

    protected int applyOptions() {
        String string;
        boolean bl;
        int n = 1;
        String string2 = this.workingDirText.getText().trim();
        if (string2.length() == 0) {
            PopupDialog.showDialog(this, 3, "Working directory is required.");
            return -1;
        }
        File file = new File(string2);
        if (!file.exists() && (bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("UserPreferences.createDir")))) {
            try {
                boolean bl2 = file.mkdir();
                if (!bl2) {
                    PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserPreferences.createDirFailed"));
                }
                n = -1;
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserPreferences.createDirFailed"));
                n = -1;
            }
        }
        if ((string = this.browserPathText.getText().trim()).length() == 0) {
            PopupDialog.showDialog(this, 3, "Broswer path is required.");
            return -1;
        }
        File file2 = new File(string);
        if (!file2.exists() || !file2.isFile()) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserPreferences.invalidBrowserPath"));
            n = -1;
        }
        int n2 = this.pollingCombo.getSelectedIndex();
        int n3 = 1;
        switch (n2) {
            case 0: {
                n3 = 1;
                FabricList.getInstance();
                FabricList.setPollingLevelMultiplier((float)1.0f);
                break;
            }
            case 1: {
                n3 = 2;
                FabricList.getInstance();
                FabricList.setPollingLevelMultiplier((float)1.5f);
                break;
            }
            case 2: {
                n3 = 3;
                FabricList.getInstance();
                FabricList.setPollingLevelMultiplier((float)2.0f);
            }
        }
        String string3 = "true";
        if (this.disableButton.isSelected()) {
            string3 = "false";
        }
        String string4 = "true";
        if (this.startUpDisableButton.isSelected()) {
            string4 = "false";
        }
        String string5 = "true";
        if (this.eventBrowserDisableButton.isSelected()) {
            string5 = "false";
            FabricTreeControl.instance().setEventBrowserEnabled(false);
        } else {
            string5 = "true";
            FabricTreeControl.instance().setEventBrowserEnabled(true);
        }
        String string6 = "modes";
        int n4 = this.portViewCombo.getSelectedIndex();
        switch (n4) {
            case 0: {
                string6 = "modes";
                break;
            }
            case 1: {
                string6 = "states";
                break;
            }
            case 2: {
                string6 = "speeds";
                break;
            }
            case 3: {
                string6 = "media";
            }
        }
        if (n == 1) {
            Properties properties = this.preferences.getUserProperties();
            properties.setProperty("workingDir", string2);
            properties.setProperty("browserPath", string);
            properties.setProperty("pollingLevel", Integer.toString(n3));
            properties.setProperty("autoSaveLoad", string3);
            properties.setProperty("startUpDialog", string4);
            properties.setProperty("portView", string6);
            properties.setProperty("eventBrowser", string5);
        }
        return n;
    }

    protected int applyLayout() {
        Properties properties = this.preferences.getUserProperties();
        String string = properties.getProperty("layout.disableAll");
        if (this.disableAllChBox.isSelected()) {
            properties.setProperty("layout.disableAll", "true");
        } else {
            properties.setProperty("layout.disableAll", "false");
        }
        String string2 = this.windowSizeChBox.isSelected() ? "true" : "false";
        properties.setProperty("layout.windowSize", string2);
        string2 = this.splitterBarChBox.isSelected() ? "true" : "false";
        properties.setProperty("layout.splitterBar", string2);
        return 1;
    }

    class LayoutCheckBoxListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public LayoutCheckBoxListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox == UserPreferencesDialog.this.disableAllChBox) {
                if (UserPreferencesDialog.this.disableAllChBox.isSelected()) {
                    UserPreferencesDialog.this.windowSizeChBox.setEnabled(false);
                    UserPreferencesDialog.this.splitterBarChBox.setEnabled(false);
                } else {
                    UserPreferencesDialog.this.windowSizeChBox.setEnabled(true);
                    UserPreferencesDialog.this.splitterBarChBox.setEnabled(true);
                }
            }
        }
    }

    class PathChooserButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public PathChooserButtonListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = UserPreferencesDialog.this.preferences.getUserProperties();
            String string = UserPreferencesDialog.this.selectBrowserPath(properties.getProperty("browserPath"));
            if (string != null && string.trim().length() > 0) {
                UserPreferencesDialog.this.browserPathText.setText(string);
            }
        }
    }

    class FileChooserButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public FileChooserButtonListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = UserPreferencesDialog.this.preferences.getUserProperties();
            String string = UserPreferencesDialog.this.selectWorkingDirectory(properties.getProperty("workingDir"));
            if (string != null && string.trim().length() > 0) {
                UserPreferencesDialog.this.workingDirText.setText(string);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public CancelButtonListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;
        String theKey;

        public ApplyButtonListener(String string, UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
            this.theKey = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                if (UserPreferencesDialog.this.preferences == null) break block3;
                int n = 1;
                n = UserPreferencesDialog.this.applyOptions();
                if (n == 1) {
                    try {
                        UserPreferencesDialog.this.preferences.write();
                        PopupDialog.showDialog(this.theDialog, 2, "Preferences have been updated.");
                        this.theDialog.setVisible(false);
                    }
                    catch (Exception exception) {
                        PopupDialog.showDialog(this.theDialog, 3, "Attempt to write preferences out to file failed.\nFilename: " + UserPreferencesDialog.this.preferences.getPropertyFilename() + "\n" + "[ " + exception.toString() + " ]");
                    }
                }
            }
        }
    }
}

