/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WaitForUpdateDialog
extends QDialog
implements ChassisEventListener {
    protected SanboxChassis blade = null;
    protected JFrame frame = null;
    protected JPanel msgPanel = null;
    protected JPanel buttonPanel = null;
    protected JButton cancelButton = null;
    protected Vector eventList = null;
    protected boolean[] eventReceivedList = null;
    protected int errCount = 0;
    protected JLabel msgLabel1 = new JLabel(FabricTreeControl.getResource("UpdateDialog.changesAccepted"));
    protected JLabel msgLabel2 = new JLabel();
    private static WaitForUpdateDialog instance = null;

    private WaitForUpdateDialog(JFrame jFrame, SanboxChassis sanboxChassis, Vector vector, String string) {
        super((Frame)jFrame, true);
        this.setTitle(string + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.eventList = vector;
        int n = this.eventList.size();
        this.eventReceivedList = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.eventReceivedList[n2] = false;
            ++n2;
        }
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.blade.updateAll();
        this.msgPanel = this.createMsgPanel();
        this.buttonPanel = this.createButtonPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 24, 2, 24);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.msgPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public static WaitForUpdateDialog getInstance(JFrame jFrame, SanboxChassis sanboxChassis, Vector vector, String string) {
        if (instance == null) {
            instance = new WaitForUpdateDialog(jFrame, sanboxChassis, vector, string);
        } else {
            instance.resetDialog(jFrame, sanboxChassis, vector, string);
        }
        return instance;
    }

    protected void resetDialog(JFrame jFrame, SanboxChassis sanboxChassis, Vector vector, String string) {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        this.errCount = 0;
        this.setTitle(string + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.eventList = vector;
        int n = this.eventList.size();
        this.eventReceivedList = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.eventReceivedList[n2] = false;
            ++n2;
        }
        this.msgLabel2.setText(FabricTreeControl.getResource("UpdateDialog.status") + "                " + FabricTreeControl.getResource("UpdateDialog.updating"));
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.blade.updateAll();
    }

    protected JPanel createMsgPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 85, 5, 85);
        jPanel.add((Component)this.msgLabel1, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.msgLabel2.setText(FabricTreeControl.getResource("UpdateDialog.status") + "                " + FabricTreeControl.getResource("UpdateDialog.updating"));
        jPanel.add((Component)this.msgLabel2, gridBagConstraints);
        return jPanel;
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        this.cancelButton = new JButton(FabricTreeControl.getResource("UpdateDialog.ok"));
        this.cancelButton.addActionListener(new CancelButtonListener(this));
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public void dismissDialog() {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        this.setVisible(false);
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dismissDialog();
        }
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        WaitForUpdateDialog dialog = null;

        public ApplyResponseHandler(WaitForUpdateDialog waitForUpdateDialog2, ChassisEvent chassisEvent) {
            this.dialog = waitForUpdateDialog2;
            this.evt = chassisEvent;
        }

        public void run() {
            int n = this.evt.getEventType();
            int n2 = WaitForUpdateDialog.this.eventList.indexOf(new Integer(n));
            if (n2 >= 0) {
                if (!this.evt.isSuccessful()) {
                    ++WaitForUpdateDialog.this.errCount;
                }
                WaitForUpdateDialog.this.eventReceivedList[n2] = true;
                if (this.allEventsComplete()) {
                    WaitForUpdateDialog.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    if (WaitForUpdateDialog.this.errCount == 0) {
                        WaitForUpdateDialog.this.msgLabel2.setText(FabricTreeControl.getResource("UpdateDialog.status") + "       " + FabricTreeControl.getResource("UpdateDialog.updateComplete"));
                    } else if (WaitForUpdateDialog.this.errCount > 0 && !WaitForUpdateDialog.this.blade.isReachable()) {
                        WaitForUpdateDialog.this.msgLabel2.setText(FabricTreeControl.getResource("UpdateDialog.status") + "   " + FabricTreeControl.getResource("UpdateDialog.unreachable"));
                    } else if (WaitForUpdateDialog.this.errCount > 0 && WaitForUpdateDialog.this.blade.isReachable()) {
                        WaitForUpdateDialog.this.msgLabel2.setText(FabricTreeControl.getResource("UpdateDialog.status") + " " + FabricTreeControl.getResource("UpdateDialog.timedOut"));
                    }
                    this.dialog.repaint();
                }
            }
        }

        public boolean allEventsComplete() {
            int n = 0;
            while (n < WaitForUpdateDialog.this.eventReceivedList.length) {
                if (!WaitForUpdateDialog.this.eventReceivedList[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    class CancelButtonListener
    implements ActionListener {
        WaitForUpdateDialog theDialog = null;

        public CancelButtonListener(WaitForUpdateDialog waitForUpdateDialog2) {
            this.theDialog = waitForUpdateDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WaitForUpdateDialog.this.dismissDialog();
        }
    }
}

