/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards;

import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.BottomPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.LeftPanel;
import com.qlogic.qms.fabric.wizards.Page;
import com.qlogic.qms.fabric.wizards.QWizard;
import com.qlogic.qms.fabric.wizards.RightPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;

public class Navigator
implements ActionListener {
    protected Vector pageList;
    protected Page current;
    protected Stack pageHistory;
    protected RightPanel rightPanel;
    protected BottomPanel bottomPanel;
    protected LeftPanel leftPanel;
    protected QWizard wizard;
    protected boolean listenersSet = false;

    public Navigator(QWizard qWizard, RightPanel rightPanel, BottomPanel bottomPanel, LeftPanel leftPanel) {
        this.wizard = qWizard;
        this.rightPanel = rightPanel;
        this.bottomPanel = bottomPanel;
        this.leftPanel = leftPanel;
        this.pageList = new Vector();
        this.current = null;
        this.pageHistory = new Stack();
        if (!this.listenersSet) {
            this.addActionListener(this.pageList);
        }
    }

    public Navigator(QWizard qWizard, Vector vector, RightPanel rightPanel, BottomPanel bottomPanel, LeftPanel leftPanel) {
        this.wizard = qWizard;
        this.rightPanel = rightPanel;
        this.bottomPanel = bottomPanel;
        this.leftPanel = leftPanel;
        this.pageList = vector;
        this.current = (Page)this.pageList.firstElement();
        this.pageHistory = new Stack();
        if (!this.listenersSet) {
            this.addActionListener(this.pageList);
        }
    }

    public void initNavigator() {
        this.addActionListener(this.pageList);
    }

    protected void addActionListener(Vector vector) {
        if (this.listenersSet) {
            return;
        }
        int n = this.pageList.size();
        int n2 = 0;
        while (n2 < n) {
            Page page = (Page)this.pageList.elementAt(n2);
            ButtonPanel buttonPanel = page.getButtonPanel();
            if (buttonPanel.backButton != null) {
                buttonPanel.backButton.addActionListener(this);
            }
            if (buttonPanel.nextButton != null) {
                buttonPanel.nextButton.addActionListener(this);
            }
            if (buttonPanel.helpButton != null) {
                buttonPanel.helpButton.addActionListener(this);
            }
            if (buttonPanel.cancelButton != null) {
                buttonPanel.cancelButton.addActionListener(this);
            }
            if (buttonPanel.finishButton != null) {
                buttonPanel.finishButton.addActionListener(this);
            }
            if (buttonPanel.closeButton != null) {
                buttonPanel.closeButton.addActionListener(this);
            }
            ++n2;
        }
        this.listenersSet = true;
    }

    public void setPageList(Vector vector) {
        this.pageList = vector;
        this.current = (Page)this.pageList.firstElement();
        this.addActionListener(this.pageList);
    }

    public void setRightPanel(RightPanel rightPanel) {
        this.rightPanel = rightPanel;
    }

    public void first() {
        this.current = (Page)this.pageList.firstElement();
        this.pageHistory.push(this.current);
        this.rightPanel.showFirst();
        this.bottomPanel.showFirst();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void last() {
        this.current = (Page)this.pageList.lastElement();
        this.pageHistory.push(this.current);
        this.rightPanel.showLast();
        this.bottomPanel.showLast();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void next() {
        int n = this.current.getIndex();
        if (n < this.pageList.size() - 1) {
            ++n;
        }
        this.current = (Page)this.pageList.elementAt(n);
        this.pageHistory.push(this.current);
        this.rightPanel.showNext();
        this.bottomPanel.showNext();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void prev() {
        this.current = (Page)this.pageHistory.pop();
        this.rightPanel.showPrev();
        this.bottomPanel.showPrev();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = ((JButton)object).getText();
            if (string.equals(FabricTreeControl.getResource("Wizard.back"))) {
                this.prev();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.next"))) {
                this.next();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.cancel"))) {
                this.wizard.close();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.help"))) {
                this.wizard.help();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.close"))) {
                this.wizard.close();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.finish"))) {
                this.next();
            }
        }
    }
}

