/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards;

import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.qms.fabric.wizards.BottomPanel;
import com.qlogic.qms.fabric.wizards.LeftPanel;
import com.qlogic.qms.fabric.wizards.Navigator;
import com.qlogic.qms.fabric.wizards.Page;
import com.qlogic.qms.fabric.wizards.RightPanel;
import com.qlogic.ui.QDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class QWizard
extends QDialog {
    protected String wizardTitle;
    protected RightPanel rightPanel;
    protected LeftPanel leftPanel;
    protected BottomPanel bottomPanel;
    protected Navigator navigator;
    protected Vector pageList;
    protected String[] stepsList;
    protected Properties properties;
    protected SanboxChassis blade;
    protected JFrame frame;

    public QWizard(JFrame jFrame, String string, SanboxChassis sanboxChassis) {
        super((Frame)jFrame, true);
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.setTitle(string);
        this.leftPanel = new LeftPanel();
        this.bottomPanel = new BottomPanel();
        this.rightPanel = new RightPanel();
        this.navigator = new Navigator(this, this.rightPanel, this.bottomPanel, this.leftPanel);
        this.layoutWizard();
    }

    public void initWizard() {
        this.properties = this.createWizardProperties();
        this.stepsList = this.createWizardStepsList();
        this.pageList = this.createWizardPageList();
        this.leftPanel.setWizardStepsList(this.stepsList);
        this.rightPanel.setPageList(this.pageList);
        this.bottomPanel.setPageList(this.pageList);
        this.navigator.setPageList(this.pageList);
    }

    public void setTitle(String string) {
        this.wizardTitle = string;
        super.setTitle(string);
    }

    protected void layoutWizard() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.leftPanel, gridBagConstraints);
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.leftPanel.setPreferredSize(new Dimension(220, 400));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.rightPanel, gridBagConstraints);
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rightPanel.setPreferredSize(new Dimension(440, 400));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.bottomPanel, gridBagConstraints);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void start() {
        this.navigator.first();
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
    }

    public void help() {
        super.help();
    }

    public int getPageIndex(String string) {
        int n = this.pageList.size();
        int n2 = 0;
        while (n2 < n) {
            Page page = (Page)this.pageList.elementAt(n2);
            if (page.getTitle().equals(string)) {
                return page.getIndex();
            }
            ++n2;
        }
        return 0;
    }

    public abstract Properties createWizardProperties();

    public abstract Vector createWizardPageList();

    public abstract String[] createWizardStepsList();

    public abstract void resetWizard();
}

