/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.BottomPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.LeftPanel;
import com.qlogic.qms.fabric.wizards.Navigator;
import com.qlogic.qms.fabric.wizards.Page;
import com.qlogic.qms.fabric.wizards.QWizard;
import com.qlogic.qms.fabric.wizards.RightPanel;
import com.qlogic.qms.fabric.wizards.zoning.ZoningPanel;
import com.qlogic.qms.fabric.wizards.zoning.ZoningWizard;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;

public class ZoningNavigator
extends Navigator {
    ZoningWizard wiz;

    public ZoningNavigator(QWizard qWizard, RightPanel rightPanel, BottomPanel bottomPanel, LeftPanel leftPanel) {
        super(qWizard, rightPanel, bottomPanel, leftPanel);
        this.wiz = (ZoningWizard)qWizard;
    }

    protected void addActionListener(Vector vector) {
        int n = this.pageList.size();
        int n2 = 0;
        while (n2 < n) {
            Page page = (Page)this.pageList.elementAt(n2);
            ButtonPanel buttonPanel = page.getButtonPanel();
            if (buttonPanel.backButton != null) {
                buttonPanel.backButton.addActionListener(this);
            }
            if (buttonPanel.nextButton != null) {
                buttonPanel.nextButton.addActionListener(this);
            }
            if (buttonPanel.helpButton != null) {
                buttonPanel.helpButton.addActionListener(this);
            }
            if (buttonPanel.cancelButton != null) {
                buttonPanel.cancelButton.addActionListener(this);
            }
            if (buttonPanel.finishButton != null) {
                buttonPanel.finishButton.addActionListener(this);
            }
            if (buttonPanel.closeButton != null) {
                buttonPanel.closeButton.addActionListener(this);
            }
            ++n2;
        }
    }

    public void setRightPanel(RightPanel rightPanel) {
        this.rightPanel = rightPanel;
    }

    public void first() {
        this.current = (Page)this.pageList.firstElement();
        this.rightPanel.showFirst();
        this.bottomPanel.showFirst();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void last() {
        this.current = (Page)this.pageList.lastElement();
        this.rightPanel.showLast();
        this.bottomPanel.showLast();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void next() {
        int n = this.current.getIndex();
        ZoningPanel zoningPanel = (ZoningPanel)((Object)this.current.getPanel());
        if (!zoningPanel.saveData()) {
            return;
        }
        switch (this.current.getIndex()) {
            case 0: {
                this.wiz.createTargetAndInitiatorLists();
                if (this.wiz.getNumberOfTargets() == 0 || this.wiz.getNumberOfInitiators() == 0) {
                    n = 1;
                    break;
                }
                n = 2;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                if (this.wiz.getDedicateToNtServers()) {
                    n = 3;
                    break;
                }
                this.wiz.clearNtServerGroups();
                if (this.wiz.getNumberOfUnassignedInitiators() > 0) {
                    n = 8;
                    break;
                }
                n = 18;
                break;
            }
            case 3: {
                n = 4;
                this.wiz.setNtServerIndex(0);
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                if (this.wiz.getNumberOfUnassignedInitiators() > 0) {
                    n = 7;
                    break;
                }
                n = 18;
                break;
            }
            case 7: {
                if (this.wiz.moreNtServers()) {
                    n = 4;
                    this.wiz.setNtServerIndex(this.wiz.getNtServerIndex() + 1);
                    break;
                }
                if (this.wiz.getNumberOfUnassignedInitiators() > 0) {
                    n = 8;
                    break;
                }
                n = 18;
                break;
            }
            case 8: {
                if (this.wiz.getGroupTargetsAndInitatiators()) {
                    n = 9;
                    this.wiz.setTargetInitiatorGroupIndex(0);
                    break;
                }
                this.wiz.clearTargetInitiatorGroups();
                if (this.wiz.getNumberOfUnassignedTlInitiators() > 0) {
                    n = 13;
                    break;
                }
                n = 18;
                break;
            }
            case 9: {
                n = 10;
                break;
            }
            case 10: {
                n = 11;
                break;
            }
            case 11: {
                if (this.wiz.getNumberOfUnassignedInitiators() > 0) {
                    n = 12;
                    break;
                }
                n = 18;
                break;
            }
            case 12: {
                if (this.wiz.moreTargetInitiatorGroups()) {
                    n = 9;
                    this.wiz.setTargetInitiatorGroupIndex(this.wiz.getTargetInitiatorGroupIndex() + 1);
                    break;
                }
                if (this.wiz.getNumberOfUnassignedTlInitiators() > 0) {
                    n = 13;
                    break;
                }
                n = 18;
                break;
            }
            case 13: {
                if (this.wiz.getZoneTLPorts()) {
                    this.wiz.setTlPortGroupIndex(0);
                    n = 14;
                    break;
                }
                this.wiz.clearTlPortGroups();
                n = 18;
                break;
            }
            case 14: {
                n = 15;
                break;
            }
            case 15: {
                n = 16;
                break;
            }
            case 16: {
                if (this.wiz.getNumberOfUnassignedTlInitiators() > 0) {
                    n = 17;
                    break;
                }
                n = 18;
                break;
            }
            case 17: {
                if (this.wiz.moreTlPorts()) {
                    n = 15;
                    this.wiz.setTlPortGroupIndex(this.wiz.getTlPortGroupIndex() + 1);
                    break;
                }
                n = 18;
                break;
            }
            case 18: {
                if (!this.wiz.generateZoning()) break;
                this.wiz.shutDown();
            }
        }
        this.current = (Page)this.pageList.elementAt(n);
        ((ZoningPanel)((Object)this.current.getPanel())).fillDataControls();
        Page page = (Page)this.pageList.elementAt(n);
        ButtonPanel buttonPanel = page.getButtonPanel();
        this.rightPanel.showPage(this.current.getTitle());
        this.bottomPanel.showPage(this.current.getTitle());
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void prev() {
        ZoningPanel zoningPanel = (ZoningPanel)((Object)this.current.getPanel());
        int n = this.current.getIndex();
        switch (n) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                if (this.wiz.getNtServerIndex() == 0) {
                    n = 3;
                    break;
                }
                n = 4;
                this.wiz.setNtServerIndex(this.wiz.getNtServerIndex() - 1);
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 8: {
                n = 2;
                break;
            }
            case 9: {
                if (this.wiz.getTargetInitiatorGroupIndex() == 0) {
                    n = 8;
                    break;
                }
                n = 9;
                this.wiz.setTargetInitiatorGroupIndex(this.wiz.getTargetInitiatorGroupIndex() - 1);
                break;
            }
            case 10: {
                n = 9;
                break;
            }
            case 11: {
                n = 10;
                break;
            }
            case 12: {
                n = 11;
                break;
            }
            case 13: {
                n = 8;
                break;
            }
            case 14: {
                if (this.wiz.getTlPortGroupIndex() == 0) {
                    n = 8;
                } else {
                    this.wiz.setTlPortGroupIndex(this.wiz.getTlPortGroupIndex() - 1);
                }
            }
            case 15: {
                if (this.wiz.getNumberOfUnassignedInitiators() > 0) {
                    n = 8;
                    break;
                }
                n = 0;
                break;
            }
            case 16: {
                n = 15;
                break;
            }
            case 18: {
                n = 13;
            }
        }
        this.current = (Page)this.pageList.elementAt(n);
        this.rightPanel.showPage(this.current.getTitle());
        this.bottomPanel.showPage(this.current.getTitle());
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = ((JButton)object).getText();
            if (string.equals(FabricTreeControl.getResource("Wizard.back"))) {
                this.prev();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.next"))) {
                this.next();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.cancel"))) {
                this.wizard.close();
            } else if (!string.equals(FabricTreeControl.getResource("Wizard.help"))) {
                if (string.equals(FabricTreeControl.getResource("Wizard.close"))) {
                    this.wizard.close();
                } else if (string.equals(FabricTreeControl.getResource("Wizard.finish"))) {
                    this.next();
                }
            }
        }
    }
}

