/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.ui.Spinner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DateTimeDialog
extends JDialog {
    protected JPanel propertyPanel = null;
    protected JPanel datePanel = null;
    protected JPanel timePanel = null;
    JLabel monthLabel = new JLabel(DeviceUtilities.getResource((String)"DateTimeDialog.month"));
    JLabel dayLabel = new JLabel(DeviceUtilities.getResource((String)"DateTimeDialog.day"));
    JLabel yearLabel = new JLabel(DeviceUtilities.getResource((String)"DateTimeDialog.year"));
    JLabel hourLabel = new JLabel(DeviceUtilities.getResource((String)"DateTimeDialog.hour"));
    JLabel minLabel = new JLabel(DeviceUtilities.getResource((String)"DateTimeDialog.minutes"));
    JRadioButton amButton = new JRadioButton(DeviceUtilities.getResource((String)"DateTimeDialog.am"));
    JRadioButton pmButton = new JRadioButton(DeviceUtilities.getResource((String)"DateTimeDialog.pm"));
    ButtonGroup buttonGroup = new ButtonGroup();
    String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final int MAX_YEAR = 2037;
    private static final int MIN_YEAR = 2000;
    protected JComboBox monthCombo = new JComboBox<String>(this.months);
    Spinner daySpinner = new Spinner();
    Spinner yearSpinner = new Spinner();
    Spinner hourSpinner = new Spinner();
    Spinner minutesSpinner = new Spinner();
    JButton applyButton = new JButton(DeviceUtilities.getResource((String)"DateTimeDialog.applyButton"));
    JButton cancelButton = new JButton(DeviceUtilities.getResource((String)"DateTimeDialog.cancelButton"));
    protected int month;
    protected int day;
    protected int year;
    protected int hour;
    protected int min;
    protected boolean AM;
    protected String newDateTime;

    public DateTimeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle(DeviceUtilities.getResource((String)"DateTimeDialog.title"));
        this.propertyPanel = this.createPropertyPanel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = this.createButtonPanel();
        jPanel.add(jPanel2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void setDateTime(long l) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.year = calendar.get(1);
        this.hour = calendar.get(10);
        if (this.hour == 0) {
            this.hour = 12;
        }
        this.min = calendar.get(12);
        this.AM = calendar.get(9) == 0;
        this.fillControls();
    }

    public Date getDateTime() {
        Calendar calendar = Calendar.getInstance();
        if (this.hour == 12 && this.AM) {
            this.hour = 0;
        }
        calendar.set(this.year, this.month - 1, this.day, this.hour, this.min, 0);
        return calendar.getTime();
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.applyButton.addActionListener(new ApplyButtonListener(this));
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(new CancelButtonListener(this));
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.applyButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createDatePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 20, 5, 2);
        jPanel.add((Component)this.monthLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 20);
        jPanel.add((Component)this.monthCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 2);
        jPanel.add((Component)this.dayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 20);
        jPanel.add((Component)this.daySpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 20, 5, 2);
        jPanel.add((Component)this.yearLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 20);
        jPanel.add((Component)this.yearSpinner, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(DeviceUtilities.getResource((String)"DateTimeDialog.date")));
        this.daySpinner.setEditable(true);
        this.yearSpinner.setEditable(true);
        return jPanel;
    }

    public void fillControls() {
        this.monthCombo.setSelectedIndex(this.month - 1);
        this.setSpinner(this.daySpinner, this.day, 1, this.getMaxDaysInMonth(this.year, this.month));
        this.daySpinner.setUpArrowAction(this, "dayUpArrowAction");
        this.daySpinner.setDownArrowAction(this, "dayDownArrowAction");
        this.setSpinner(this.yearSpinner, this.year, 2000, 2037);
        this.yearSpinner.setUpArrowAction(this, "yearUpArrowAction");
        this.yearSpinner.setDownArrowAction(this, "yearDownArrowAction");
        this.amButton.setSelected(this.AM);
        this.pmButton.setSelected(!this.AM);
        this.setSpinner(this.hourSpinner, this.hour, 1, 12);
        this.hourSpinner.setUpArrowAction(this, "hourUpArrowAction");
        this.hourSpinner.setDownArrowAction(this, "hourDownArrowAction");
        this.setSpinner(this.minutesSpinner, this.min, 0, 59);
        this.minutesSpinner.setUpArrowAction(this, "minUpArrowAction");
        this.minutesSpinner.setDownArrowAction(this, "minDownArrowAction");
    }

    public JPanel createTimePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 20, 5, 2);
        jPanel.add((Component)this.hourLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 20);
        jPanel.add((Component)this.hourSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 2);
        jPanel.add((Component)this.minLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 20);
        jPanel.add((Component)this.minutesSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 20, 5, 2);
        jPanel.add((Component)this.amButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 20);
        jPanel.add((Component)this.pmButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(DeviceUtilities.getResource((String)"DateTimeDialog.time")));
        this.buttonGroup.add(this.amButton);
        this.buttonGroup.add(this.pmButton);
        this.hourSpinner.setEditable(true);
        this.minutesSpinner.setEditable(true);
        return jPanel;
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.datePanel = this.createDatePanel();
        this.timePanel = this.createTimePanel();
        this.fillControls();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 40, 2, 40);
        jPanel.add((Component)this.datePanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.timePanel, gridBagConstraints);
        return jPanel;
    }

    protected boolean getDateTimeFromControls() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.monthCombo.getSelectedIndex() + 1;
        try {
            n4 = Integer.decode(this.yearSpinner.getText());
            if (n4 < 2000 || n4 > 2037) {
                JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidYear"), "", 0);
                return false;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidYear"), "", 0);
            return false;
        }
        try {
            n3 = Integer.decode(this.daySpinner.getText());
            if (!this.isValidDay(n4, n5, n3)) {
                JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidDay"), "", 0);
                return false;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidDay"), "", 0);
            return false;
        }
        try {
            n2 = Integer.decode(this.hourSpinner.getText());
            if (n2 < 1 || n2 > 12) {
                JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidHour"), "", 0);
                return false;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidHour"), "", 0);
            return false;
        }
        try {
            n = Integer.decode(this.minutesSpinner.getText());
            if (n < 0 || n > 59) {
                JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidHour"), "", 0);
                return false;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, DeviceUtilities.getResource((String)"DateTimeDialog.invalidMinutes"), "", 0);
            return false;
        }
        boolean bl = this.amButton.isSelected();
        if (n2 < 12 && !bl) {
            n2 += 12;
        }
        this.hour = n2;
        this.min = n;
        this.day = n3;
        this.month = n5;
        this.year = n4;
        this.AM = bl;
        return true;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.closeDownDialog();
        }
    }

    protected void closeDownDialog() {
        this.setVisible(false);
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    protected boolean isValidDay(int n, int n2, int n3) {
        if (n3 < 1) {
            return false;
        }
        return !(n2 == 1 || n2 == 3 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 10 || n2 == 12 ? n3 > 31 : (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11 ? n3 > 30 : n2 == 2 && (n % 4 == 0 && n % 100 != 0 || n % 400 == 0 ? n3 > 29 : n3 > 28)));
    }

    protected int getMaxDaysInMonth(int n, int n2) {
        if (n2 == 2) {
            if (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) {
                return 29;
            }
            return 28;
        }
        if (n2 == 1 || n2 == 3 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 10 || n2 == 12) {
            return 31;
        }
        return 30;
    }

    public void dayUpArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            int n = this.monthCombo.getSelectedIndex() + 1;
            try {
                int n2 = Integer.decode(string) + 1;
                int n3 = Integer.decode(this.yearSpinner.getText());
                this.setSpinner(spinner, n2, 1, this.getMaxDaysInMonth(n3, n));
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.day));
            }
        }
    }

    public void dayDownArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            int n = this.monthCombo.getSelectedIndex() + 1;
            try {
                int n2 = Integer.decode(string) - 1;
                int n3 = Integer.decode(this.yearSpinner.getText());
                this.setSpinner(spinner, n2, 1, this.getMaxDaysInMonth(n3, n));
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.day));
            }
        }
    }

    public void yearUpArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n = Integer.decode(string) + 1;
                this.setSpinner(spinner, n, 2000, 2037);
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.year));
            }
        }
    }

    public void yearDownArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n = Integer.decode(string) - 1;
                this.setSpinner(spinner, n, 2000, 2037);
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.year));
            }
        }
    }

    public void hourUpArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n = Integer.decode(string) + 1;
                this.setSpinner(spinner, n, 1, 12);
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.hour));
            }
        }
    }

    private void setSpinner(Spinner spinner, int n, int n2, int n3) {
        spinner.downButtonSetEnabled(n > n2);
        spinner.upButtonSetEnabled(n < n3);
        spinner.setText(Integer.toString(n));
    }

    public void hourDownArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n = Integer.decode(string) - 1;
                this.setSpinner(spinner, n, 1, 12);
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.hour));
            }
        }
    }

    public void minUpArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n = Integer.decode(string) + 1;
                this.setSpinner(spinner, n, 0, 59);
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.min));
            }
        }
    }

    public void minDownArrowAction(Spinner spinner) {
        block2: {
            String string = spinner.getText();
            if (string == null) break block2;
            try {
                int n = Integer.decode(string) - 1;
                this.setSpinner(spinner, n, 0, 59);
            }
            catch (Exception exception) {
                spinner.setText(Integer.toString(this.min));
            }
        }
    }

    protected boolean applyDateTime() {
        if (!this.getDateTimeFromControls()) {
            return false;
        }
        this.closeDownDialog();
        return true;
    }

    class CancelButtonListener
    implements ActionListener {
        DateTimeDialog theDialog = null;

        public CancelButtonListener(DateTimeDialog dateTimeDialog2) {
            this.theDialog = dateTimeDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateTimeDialog.this.closeDownDialog();
            DateTimeDialog.this.enableButtons();
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        DateTimeDialog theDialog = null;

        public ApplyButtonListener(DateTimeDialog dateTimeDialog2) {
            this.theDialog = dateTimeDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyDateTime()) {
                DateTimeDialog.this.disableButtons();
            }
        }
    }
}

