/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.ui.GenericFileFilter;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.eventBrowser.EventEntry;
import com.qlogic.ui.eventBrowser.EventFilterDialog;
import com.qlogic.ui.eventBrowser.EventList;
import com.qlogic.ui.eventBrowser.EventModel;
import com.qlogic.ui.eventBrowser.EventTable;
import com.qlogic.util.JDocument;
import com.qlogic.util.JElement;
import com.qlogic.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class EventBrowser
extends JFrame {
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenuItem fileSaveAs = new JMenuItem("Save As ...");
    JMenuItem fileClose = new JMenuItem("Exit");
    JMenu sortMenu = new JMenu("Sort");
    JMenuItem sortSeverity = new JMenuItem("By Severity");
    JMenuItem sortTimestamp = new JMenuItem("By Timestamp");
    JMenuItem sortSource = new JMenuItem("By Source");
    JMenuItem sortType = new JMenuItem("By Type");
    JMenuItem sortDescription = new JMenuItem("By Description");
    JMenu filterMenu = new JMenu();
    JMenuItem filterEntries = new JMenuItem();
    JToolBar toolBar = new JToolBar();
    EventTable eventTable;
    JScrollPane scrollPane;
    Border scrollPaneBorder;
    JLabel statusField = new JLabel("Ready");
    EventFilterDialog filterDialog = new EventFilterDialog(this);
    GenericFileFilter xmlFilter = new GenericFileFilter("xml", "XML Format");
    GenericFileFilter csvFilter = new GenericFileFilter("csv", "Comma Separated Values");

    public EventBrowser(EventTable eventTable) {
        super("Event Browser");
        this.eventTable = eventTable;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public EventBrowser(EventModel eventModel) {
        this(new EventTable(eventModel));
    }

    public EventBrowser(EventList eventList) {
        this(new EventTable(eventList));
    }

    public EventBrowser() {
        this(new EventTable());
    }

    private void jbInit() throws Exception {
        this.setSize(640, 480);
        FileListener fileListener = new FileListener();
        this.fileSaveAs.addActionListener(fileListener);
        this.filterMenu.setText("Filter");
        this.filterEntries.setText("Filter Entries ...");
        this.fileMenu.add(this.fileSaveAs);
        this.fileMenu.addSeparator();
        this.fileClose.addActionListener(fileListener);
        this.fileMenu.add(this.fileClose);
        this.menuBar.add(this.fileMenu);
        SortListener sortListener = new SortListener();
        this.sortSeverity.addActionListener(sortListener);
        this.sortMenu.add(this.sortSeverity);
        this.sortTimestamp.addActionListener(sortListener);
        this.sortMenu.add(this.sortTimestamp);
        this.sortSource.addActionListener(sortListener);
        this.sortMenu.add(this.sortSource);
        this.sortType.addActionListener(sortListener);
        this.sortMenu.add(this.sortType);
        this.sortDescription.addActionListener(sortListener);
        this.sortMenu.add(this.sortDescription);
        this.menuBar.add(this.sortMenu);
        FilterListener filterListener = new FilterListener();
        this.filterEntries.addActionListener(filterListener);
        this.filterMenu.add(this.filterEntries);
        this.menuBar.add(this.filterMenu);
        this.setJMenuBar(this.menuBar);
        TableModel tableModel = this.eventTable.getModel();
        TableColumn tableColumn = this.eventTable.getColumn(tableModel.getColumnName(0));
        tableColumn.setMinWidth(this.eventTable.getPreferredColumnWidth(tableColumn));
        tableColumn.setMaxWidth(this.eventTable.getPreferredColumnWidth(tableColumn));
        int n = 1;
        while (n < this.eventTable.getColumnCount()) {
            tableColumn = this.eventTable.getColumn(tableModel.getColumnName(n));
            tableColumn.setMinWidth(this.eventTable.getPreferredColumnWidth(tableColumn));
            ++n;
        }
        this.scrollPane = new JScrollPane(this.eventTable);
        this.scrollPaneBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(142, 142, 142), new Color(99, 99, 99)), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createLineBorder(new Color(142, 142, 142))));
        this.scrollPane.setBorder(this.scrollPaneBorder);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.statusField, "South");
    }

    void saveEventsToFile() {
        String string = UserPreferences.getInstance().getWorkingDirectory();
        QFileChooser qFileChooser = new QFileChooser(string);
        qFileChooser.addChoosableFileFilter(this.xmlFilter);
        qFileChooser.addChoosableFileFilter(this.csvFilter);
        qFileChooser.setFileFilter(this.xmlFilter);
        if (qFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File file = qFileChooser.getSelectedFile();
        FileFilter fileFilter = qFileChooser.getFileFilter();
        if (file.getName().indexOf(46) < 0) {
            if (fileFilter == this.xmlFilter) {
                file = new File(file.getPath() + ".xml");
            } else if (fileFilter == this.csvFilter) {
                file = new File(file.getPath() + ".csv");
            }
        }
        if (file.exists()) {
            Object[] objectArray = new Object[]{file.getName()};
            String string2 = StringUtilities.formatString(FabricTreeControl.getResource("AbstractFaceplate.fileExists"), objectArray);
            int n = JOptionPane.showConfirmDialog(this, string2, this.getTitle(), 0);
            if (n != 0) {
                return;
            }
        }
        if (fileFilter == this.xmlFilter) {
            this.saveEventsToXmlFile(file);
        } else if (fileFilter == this.csvFilter) {
            this.saveEventsToCsvFile(file);
        } else if (file.getAbsolutePath().endsWith(".xml")) {
            this.saveEventsToXmlFile(file);
        } else if (file.getAbsolutePath().endsWith(".csv")) {
            this.saveEventsToCsvFile(file);
        } else {
            this.saveEventsToXmlFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveEventsToCsvFile(File file) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{file.getName(), fileNotFoundException.getMessage()};
            String string = StringUtilities.formatString(FabricTreeControl.getResource("AbstractFaceplate.errorWriting"), objectArray);
            JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
            return;
        }
        Cursor cursor = this.getCursor();
        try {
            try {
                this.setCursor(new Cursor(3));
                printWriter = new PrintWriter(new FileOutputStream(file));
                printWriter = new PrintWriter(new FileOutputStream(file));
                printWriter.println("Severity,Timestamp,Source,Type,Description");
                EventModel eventModel = (EventModel)this.eventTable.getModel();
                Object[] objectArray = eventModel.getEvents();
                int n = 0;
                while (n < objectArray.length) {
                    EventEntry eventEntry = (EventEntry)objectArray[n];
                    printWriter.print(eventEntry.severity.toString());
                    printWriter.print(',');
                    printWriter.print(eventEntry.date.toString());
                    printWriter.print(',');
                    printWriter.print(eventEntry.source.toString());
                    printWriter.print(',');
                    printWriter.print(eventEntry.type);
                    printWriter.print(',');
                    printWriter.println(eventEntry.description);
                    ++n;
                }
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{file.getName(), iOException.getMessage()};
                String string = StringUtilities.formatString(FabricTreeControl.getResource("AbstractFaceplate.errorWriting"), objectArray);
                JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
                Object var9_15 = null;
                printWriter.close();
                this.setCursor(cursor);
                return;
            }
            Object var9_14 = null;
            printWriter.close();
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            printWriter.close();
            this.setCursor(cursor);
            throw throwable;
        }
        this.setCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveEventsToXmlFile(File file) {
        Object object;
        EventEntry eventEntry;
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        JDocument jDocument = new JDocument();
        JElement jElement = new JElement("EventList");
        EventModel eventModel = (EventModel)this.eventTable.getModel();
        Object[] objectArray = eventModel.getEvents();
        int n = 0;
        while (n < objectArray.length) {
            eventEntry = (EventEntry)objectArray[n];
            object = new JElement("EventEntry");
            object.addContent(new JElement("Severity").addContent(eventEntry.severity.toString()));
            object.addContent(new JElement("Timestamp").addContent(eventEntry.date.toString()));
            object.addContent(new JElement("Source").addContent(eventEntry.source.toString()));
            object.addContent(new JElement("Type").addContent(eventEntry.type));
            object.addContent(new JElement("Description").addContent(eventEntry.description));
            jElement.addContent((Element)object);
            ++n;
        }
        jDocument.setRootElement(jElement);
        eventEntry = new XMLOutputter();
        eventEntry.setNewlines(true);
        eventEntry.setIndent("    ");
        try {
            object = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray2 = new Object[]{file.getName(), fileNotFoundException.getMessage()};
            String string = StringUtilities.formatString(FabricTreeControl.getResource("AbstractFaceplate.errorWriting"), objectArray2);
            JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
            return;
        }
        try {
            try {
                eventEntry.output(jDocument, (OutputStream)object);
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                Object[] objectArray3 = new Object[]{file.getName(), iOException.getMessage()};
                String string = StringUtilities.formatString(FabricTreeControl.getResource("AbstractFaceplate.errorWriting"), objectArray3);
                JOptionPane.showMessageDialog(this, string, this.getTitle(), 0);
                Object var14_17 = null;
                this.setCursor(cursor);
                return;
            }
            Object var14_16 = null;
            this.setCursor(cursor);
            return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            this.setCursor(cursor);
            throw throwable;
        }
    }

    void doFilterEntries() {
        int n = this.filterDialog.showDialog();
        if (n == 0) {
            EventModel eventModel = (EventModel)this.eventTable.getModel();
            eventModel.setFilter(this.filterDialog.getEventFilter());
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            super("Help ...", new ImageIcon("Help16.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class FilterAction
    extends AbstractAction {
        public FilterAction() {
            super("Filter ...", new ImageIcon("Filter16.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class FilterListener
    implements ActionListener {
        FilterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventModel eventModel = (EventModel)EventBrowser.this.eventTable.getModel();
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem == EventBrowser.this.filterEntries) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ FilterListener this$1;
                    {
                        this.this$1 = filterListener;
                    }

                    public void run() {
                        FilterListener.access$000(this.this$1).doFilterEntries();
                    }
                });
            } else {
                System.err.println("Unknown event: " + actionEvent.toString());
            }
        }

        static /* synthetic */ EventBrowser access$000(FilterListener filterListener) {
            return filterListener.EventBrowser.this;
        }
    }

    class SortListener
    implements ActionListener {
        SortListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem == EventBrowser.this.sortSeverity) {
                EventBrowser.this.eventTable.resortColumn(0);
            } else if (jMenuItem == EventBrowser.this.sortTimestamp) {
                EventBrowser.this.eventTable.resortColumn(1);
            } else if (jMenuItem == EventBrowser.this.sortSource) {
                EventBrowser.this.eventTable.resortColumn(2);
            } else if (jMenuItem == EventBrowser.this.sortType) {
                EventBrowser.this.eventTable.resortColumn(3);
            } else if (jMenuItem == EventBrowser.this.sortDescription) {
                EventBrowser.this.eventTable.resortColumn(4);
            } else {
                System.err.println("Unknown event: " + actionEvent.toString());
            }
        }
    }

    class SortAction
    extends AbstractAction {
        public SortAction() {
            super("Sort ...", new ImageIcon("Sort16.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super("Save As ...", new ImageIcon("SaveAs16.gif"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventBrowser.this.saveEventsToFile();
        }
    }

    class FileListener
    implements ActionListener {
        FileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventModel eventModel = (EventModel)EventBrowser.this.eventTable.getModel();
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem == EventBrowser.this.fileSaveAs) {
                EventBrowser.this.saveEventsToFile();
            } else if (jMenuItem == EventBrowser.this.fileClose) {
                EventBrowser.this.setVisible(false);
            } else {
                System.err.println("Unknown event: " + actionEvent.toString());
            }
        }
    }
}

