/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import com.qlogic.ui.eventBrowser.EventEntry;
import com.qlogic.ui.eventBrowser.EventListListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class EventList
extends Vector {
    public static final int DEBUG = 0;
    public static final int INFO = 100;
    public static final int NORMAL = 200;
    public static final int WARNING = 300;
    public static final int CRITICAL = 400;
    public static final int UNFILTERABLE = 500;
    private static EventList instance;
    private ArrayList listenerList = new ArrayList(2);

    public EventList() {
    }

    public EventList(EventListListener eventListListener) {
        this();
        this.addListener(eventListListener);
    }

    public static synchronized EventList instance() {
        if (instance == null) {
            instance = new EventList();
        }
        return instance;
    }

    public void addListener(EventListListener eventListListener) {
        this.listenerList.add(eventListListener);
    }

    public void removeListener(EventListListener eventListListener) {
        this.listenerList.remove(eventListListener);
    }

    public synchronized void fireEntryAdded(EventEntry eventEntry) {
        Iterator iterator = this.listenerList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EventListListener)) continue;
            ((EventListListener)e).eventAdded(eventEntry);
        }
    }

    public boolean add(Object object) {
        if (!(object instanceof EventEntry)) {
            throw new IllegalArgumentException("Not an EventEntry: " + object);
        }
        if (super.add(object)) {
            this.fireEntryAdded((EventEntry)object);
            return true;
        }
        return false;
    }

    public void enter(long l, int n, Object object, String string, String string2) {
        this.add(new EventEntry(l, n, object, string, string2));
    }

    public void enter(int n, Object object, String string, String string2) {
        this.add(new EventEntry(n, object, string, string2));
    }

    public void enter(String string) {
        this.add(new EventEntry(string));
    }

    public Iterator iterator() {
        return new EventListIterator();
    }

    class EventListIterator
    implements Iterator {
        int position = 0;

        EventListIterator() {
        }

        public boolean hasNext() {
            return this.position < EventList.this.size();
        }

        public Object next() {
            try {
                return EventList.this.get(this.position++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

