/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import com.qlogic.ui.eventBrowser.AvlTree;
import com.qlogic.ui.eventBrowser.EventEntry;
import com.qlogic.ui.eventBrowser.EventFilter;
import com.qlogic.ui.eventBrowser.EventList;
import com.qlogic.ui.eventBrowser.EventListListener;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

class EventModel
extends AbstractTableModel
implements EventListListener {
    private String[] columnHeader = new String[]{"", "Timestamp", "Source", "Type", "Description"};
    private AvlTree eventTree = new AvlTree();
    private EventList eventList;
    private EventFilter filter = null;
    Sorter sorter = new Sorter();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public EventModel(EventList eventList) {
        this.eventList = eventList;
        this.sortBy(1, 1);
        eventList.addListener(this);
    }

    public EventModel() {
        this(EventList.instance());
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        super.addTableModelListener(tableModelListener);
    }

    public void setFilter(EventFilter eventFilter) {
        this.filter = eventFilter;
        this.resort();
    }

    public void eventAdded(EventEntry eventEntry) {
        if ((this.filter == null || this.filter.accept(eventEntry)) && this.eventTree.add(eventEntry)) {
            int n = this.eventTree.indexOf(eventEntry);
            this.fireTableRowsInserted(n, n);
        }
    }

    public void add(EventEntry eventEntry) {
        this.eventList.add(eventEntry);
    }

    public Object[] getEvents() {
        return this.eventTree.toArray();
    }

    public void sortBy(int n, int n2) {
        switch (n) {
            case 0: {
                this.sorter = new SeveritySorter();
                break;
            }
            case 1: {
                this.sorter = new TimestampSorter();
                break;
            }
            case 2: {
                this.sorter = new SourceSorter();
                break;
            }
            case 3: {
                this.sorter = new TypeSorter();
                break;
            }
            case 4: {
                this.sorter = new DescriptionSorter();
            }
        }
        this.sorter.setDirection(n2);
        this.resort();
    }

    public void resort() {
        AvlTree avlTree = new AvlTree(this.sorter);
        if (this.filter == null) {
            avlTree.addAll(this.eventList);
        } else {
            Iterator iterator = this.eventList.iterator();
            while (iterator.hasNext()) {
                EventEntry eventEntry = (EventEntry)iterator.next();
                if (!this.filter.accept(eventEntry)) continue;
                avlTree.add(eventEntry);
            }
        }
        this.eventTree = avlTree;
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        return this.eventTree.size();
    }

    public String getColumnName(int n) {
        return this.columnHeader[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = EventModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 1: {
                return class$java$util$Date == null ? (class$java$util$Date = EventModel.class$("java.util.Date")) : class$java$util$Date;
            }
            case 2: {
                return class$java$lang$Object == null ? (class$java$lang$Object = EventModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            case 3: {
                return class$java$lang$String == null ? (class$java$lang$String = EventModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 4: {
                return class$java$lang$String == null ? (class$java$lang$String = EventModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        throw new IllegalArgumentException("columnIndex=" + n);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        if (this.eventTree == null || n >= this.eventTree.size()) {
            return null;
        }
        EventEntry eventEntry = (EventEntry)this.eventTree.get(n);
        switch (n2) {
            case 0: {
                return eventEntry.severity;
            }
            case 1: {
                return eventEntry.date;
            }
            case 2: {
                return eventEntry.source;
            }
            case 3: {
                return eventEntry.type;
            }
            case 4: {
                return eventEntry.description;
            }
        }
        throw new IllegalArgumentException("col=" + n2);
    }

    public static void main(String[] stringArray) {
        Sorter sorter = new Sorter();
        AvlTree avlTree = new AvlTree();
        int n = 0;
        while (n < 100) {
            avlTree.add(new Double(Math.random()));
            ++n;
        }
        System.out.println(avlTree.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DescriptionSorter
    extends TimestampSorter {
        DescriptionSorter() {
        }

        public int compare(Object object, Object object2) {
            int n = ((EventEntry)object).description.compareTo(((EventEntry)object2).description);
            if (n == 0) {
                return super.compare(object, object2);
            }
            return this.sortDirection < 0 ? -n : n;
        }
    }

    static class TypeSorter
    extends TimestampSorter {
        TypeSorter() {
        }

        public int compare(Object object, Object object2) {
            int n = ((EventEntry)object).type.compareTo(((EventEntry)object2).type);
            if (n == 0) {
                return super.compare(object, object2);
            }
            return this.sortDirection < 0 ? -n : n;
        }
    }

    static class SourceSorter
    extends TimestampSorter {
        SourceSorter() {
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2 = ((EventEntry)object).source.toString();
            int n = string2.compareTo(string = ((EventEntry)object2).source.toString());
            if (n == 0) {
                return super.compare(object, object2);
            }
            return this.sortDirection < 0 ? -n : n;
        }
    }

    static class SeveritySorter
    extends TimestampSorter {
        SeveritySorter() {
        }

        public int compare(Object object, Object object2) {
            int n = ((EventEntry)object2).severity - ((EventEntry)object).severity;
            if (n == 0) {
                return super.compare(object, object2);
            }
            return this.sortDirection < 0 ? -n : n;
        }
    }

    static class TimestampSorter
    extends Sorter {
        TimestampSorter() {
        }

        public int compare(Object object, Object object2) {
            Long l;
            Long l2 = new Long(((EventEntry)object).date.getTime());
            int n = l2.compareTo(l = new Long(((EventEntry)object2).date.getTime()));
            if (n == 0) {
                return super.compare(object, object2);
            }
            return this.sortDirection < 0 ? -n : n;
        }
    }

    static class Sorter
    implements Comparator {
        int sortDirection = 0;

        Sorter() {
        }

        public void setDirection(int n) {
            this.sortDirection = n;
        }

        public int compare(Object object, Object object2) {
            int n = ((Comparable)object).compareTo(object2);
            return this.sortDirection < 0 ? -n : n;
        }
    }
}

