/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.topology;

import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.TopologyLayout;
import com.qlogic.ui.topology.TopologyNode;
import java.util.Vector;

public abstract class AbstractTopologyLayout
implements TopologyLayout {
    protected Topology topology;

    public AbstractTopologyLayout(Topology topology) {
        this.setTopology(topology);
        this.initializeLayout();
    }

    protected void initializeLayout() {
    }

    protected Topology getTopology() {
        return this.topology;
    }

    protected void setTopology(Topology topology) {
        this.topology = topology;
    }

    public abstract void layoutNode(TopologyNode var1);

    public void layoutNodeAt(TopologyNode topologyNode, int n, int n2) {
        topologyNode.setLocation(n, n2);
        if (this.getTopology().isAutoLayoutEnabled()) {
            this.layoutAllNodes();
        } else if (this.getTopology().isSnapToPositionEnabled()) {
            this.snapToPosition(topologyNode);
        }
    }

    public void layoutAllNodes() {
        Vector vector = this.getTopology().getTopologyNodeList();
        this.sortNodes(vector);
        this.initializeLayout();
        int n = 0;
        while (n < vector.size()) {
            this.layoutNode((TopologyNode)vector.elementAt(n));
            ++n;
        }
    }

    protected void snapToPosition(TopologyNode topologyNode) {
    }

    protected int compareNodes(TopologyNode topologyNode, TopologyNode topologyNode2) {
        return 0;
    }

    protected void sortNodes(Vector vector) {
        int n = 0;
        while (n < vector.size() - 1) {
            int n2 = n + 1;
            while (n2 < vector.size()) {
                TopologyNode topologyNode;
                TopologyNode topologyNode2 = (TopologyNode)vector.elementAt(n);
                if (this.compareNodes(topologyNode2, topologyNode = (TopologyNode)vector.elementAt(n2)) > 0) {
                    vector.setElementAt(topologyNode2, n2);
                    vector.setElementAt(topologyNode, n);
                }
                ++n2;
            }
            ++n;
        }
    }
}

