/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.topology;

import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.TopologyLink;
import com.qlogic.ui.topology.TopologyLinkRenderer;
import com.qlogic.ui.topology.TopologyNode;
import com.qlogic.ui.topology.TopologyNodeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;

public class DefaultTopologyLinkRenderer
implements TopologyLinkRenderer {
    Topology topology;
    Color selectedLinkColor = Color.blue;
    Color unselectedLinkColor = Color.black;

    public DefaultTopologyLinkRenderer(Topology topology) {
        this.topology = topology;
    }

    protected Rectangle getDefaultRectangle() {
        return new Rectangle(0, 0);
    }

    public Polygon getBounds(TopologyLink topologyLink, int n) {
        Point point = this.getLinkEndpoint(topologyLink, this.topology.getLinkEndPoint1(topologyLink));
        Point point2 = this.getLinkEndpoint(topologyLink, this.topology.getLinkEndPoint2(topologyLink));
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        int n2 = (int)(0.5 + d * (double)n / d3);
        int n3 = (int)(0.5 + d2 * (double)n / d3);
        Polygon polygon = new Polygon();
        polygon.addPoint(point.x - n3, point.y + n2);
        polygon.addPoint(point2.x - n3, point2.y + n2);
        polygon.addPoint(point2.x + n3, point2.y - n2);
        polygon.addPoint(point.x + n3, point.y - n2);
        return polygon;
    }

    protected Rectangle getIconBounds(TopologyNode topologyNode) {
        Rectangle rectangle;
        Component component = null;
        if (topologyNode != null) {
            component = this.topology.getNodeRenderer(topologyNode);
        }
        if ((component = this.topology.getNodeRenderer(topologyNode)) == null) {
            rectangle = this.getDefaultRectangle();
        } else if (component instanceof TopologyNodeRenderer) {
            rectangle = ((TopologyNodeRenderer)((Object)component)).getIconBounds(topologyNode, component);
        } else if (component instanceof JLabel) {
            Icon icon = ((JLabel)component).getIcon();
            if (icon == null) {
                rectangle = component.getBounds();
            } else {
                int n = icon.getIconWidth();
                int n2 = icon.getIconHeight();
                int n3 = topologyNode.getX() - n / 2;
                int n4 = topologyNode.getY() - n2 / 2;
                rectangle = new Rectangle(n3, n4, n, n2);
            }
        } else {
            rectangle = component.getBounds();
        }
        return rectangle;
    }

    protected Point getLinkEndpoint(TopologyLink topologyLink, TopologyNode topologyNode) {
        Rectangle rectangle = this.getIconBounds(topologyNode);
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public void paintLink(Graphics graphics, TopologyLink topologyLink) {
        if (this.topology.isSelected(topologyLink)) {
            graphics.setColor(this.selectedLinkColor);
        } else {
            graphics.setColor(this.unselectedLinkColor);
        }
        Point point = this.getLinkEndpoint(topologyLink, this.topology.getLinkEndPoint1(topologyLink));
        Point point2 = this.getLinkEndpoint(topologyLink, this.topology.getLinkEndPoint2(topologyLink));
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }
}

