/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.topology;

import com.qlogic.ui.topology.TopologyEvent;
import com.qlogic.ui.topology.TopologyLink;
import com.qlogic.ui.topology.TopologyListener;
import com.qlogic.ui.topology.TopologyModel;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class DefaultTopologyModel
implements TopologyModel,
Serializable {
    EventListenerList listenerList = new EventListenerList();
    Vector nodeList = new Vector();
    Vector linkList = new Vector();
    boolean nodeListIsEditable = true;
    boolean linkListIsEditable = true;
    static /* synthetic */ Class class$com$qlogic$ui$topology$TopologyListener;

    public void addTopologyListener(TopologyListener topologyListener) {
        this.listenerList.add(class$com$qlogic$ui$topology$TopologyListener == null ? (class$com$qlogic$ui$topology$TopologyListener = DefaultTopologyModel.class$("com.qlogic.ui.topology.TopologyListener")) : class$com$qlogic$ui$topology$TopologyListener, topologyListener);
    }

    public void removeTopologyListener(TopologyListener topologyListener) {
        this.listenerList.remove(class$com$qlogic$ui$topology$TopologyListener == null ? (class$com$qlogic$ui$topology$TopologyListener = DefaultTopologyModel.class$("com.qlogic.ui.topology.TopologyListener")) : class$com$qlogic$ui$topology$TopologyListener, topologyListener);
    }

    public int getListenerCount() {
        return this.listenerList.getListenerCount();
    }

    protected void fireTopologyChanged(TopologyEvent topologyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$qlogic$ui$topology$TopologyListener == null ? DefaultTopologyModel.class$("com.qlogic.ui.topology.TopologyListener") : class$com$qlogic$ui$topology$TopologyListener)) {
                ((TopologyListener)objectArray[n + 1]).topologyChanged(topologyEvent);
            }
            n -= 2;
        }
    }

    protected void fireTopologyChanged(int n, Object object) {
        this.fireTopologyChanged(new TopologyEvent(this, n, object));
    }

    protected void fireTopologyExpired() {
        this.fireTopologyChanged(new TopologyEvent(this));
    }

    protected void fireNodeInserted(Object object) {
        this.fireTopologyChanged(new TopologyEvent(this, 2, object));
    }

    protected void fireNodeDeleted(Object object) {
        this.fireTopologyChanged(new TopologyEvent(this, 3, object));
    }

    protected void fireNodeMoved(Object object) {
        this.fireTopologyChanged(new TopologyEvent(this, 4, object));
    }

    protected void fireNodeChanged(Object object) {
        this.fireTopologyChanged(new TopologyEvent(this, 5, object));
    }

    protected void fireLinkAdded(TopologyLink topologyLink) {
        this.fireTopologyChanged(new TopologyEvent(this, 2, topologyLink));
    }

    protected void fireLinkRemoved(TopologyLink topologyLink) {
        this.fireTopologyChanged(new TopologyEvent(this, 3, topologyLink));
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public boolean isNodeListEditable() {
        return this.nodeListIsEditable;
    }

    public void setNodeListEditable(boolean bl) {
        this.nodeListIsEditable = bl;
    }

    public boolean containsNode(Object object) {
        return this.nodeList.contains(object);
    }

    public int indexOfNode(Object object) {
        return this.nodeList.indexOf(object);
    }

    public Object nodeAtIndex(int n) {
        return this.nodeList.elementAt(n);
    }

    public TopologyLink[] getNodeLinks(Object object) {
        Vector<TopologyLink> vector = new Vector<TopologyLink>();
        int n = 0;
        while (n < this.linkList.size()) {
            TopologyLink topologyLink = (TopologyLink)this.linkList.elementAt(n);
            if (object.equals(topologyLink.getEndPoint1()) || object.equals(topologyLink.getEndPoint2())) {
                vector.addElement(topologyLink);
            }
            ++n;
        }
        return (TopologyLink[])vector.toArray();
    }

    public void addNode(int n, Object object) {
        if (!this.nodeListIsEditable) {
            throw new IllegalStateException("node list is not editable");
        }
        if (!this.nodeList.contains(object)) {
            this.nodeList.insertElementAt(object, n);
            this.fireNodeInserted(object);
        } else if (this.nodeList.indexOf(object) != n) {
            throw new IllegalArgumentException("Model already contains node " + object.toString());
        }
    }

    public void addNode(Object object) {
        if (!this.nodeListIsEditable) {
            throw new IllegalStateException("node list is not editable");
        }
        if (!this.nodeList.contains(object)) {
            this.nodeList.addElement(object);
            this.fireNodeInserted(object);
        }
    }

    public void insertNodeAt(Object object, int n) {
        this.addNode(n, object);
    }

    public void reindexNode(Object object, int n) {
        if (!this.nodeListIsEditable) {
            throw new IllegalStateException("node list is not editable");
        }
        this.nodeList.removeElement(object);
        this.nodeList.add(n, object);
    }

    public void removeNode(Object object) {
        int n = this.nodeList.indexOf(object);
        if (n < 0) {
            throw new NoSuchElementException("model does not contain " + object.toString());
        }
        this.removeNodeAtIndex(n);
    }

    public void removeNodeAtIndex(int n) {
        if (!this.nodeListIsEditable) {
            throw new IllegalStateException("node list is not editable");
        }
        Object e = this.nodeList.elementAt(n);
        Vector<TopologyLink> vector = new Vector<TopologyLink>();
        int n2 = 0;
        while (n2 < this.getLinkCount()) {
            if (this.linkAtIndex(n2).hasEndPoint(e)) {
                vector.addElement(this.linkAtIndex(n2));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            this.removeLink((TopologyLink)vector.elementAt(n3));
            ++n3;
        }
        this.nodeList.removeElementAt(n);
        this.fireNodeDeleted(e);
    }

    public void removeAllNodes() {
        this.linkList = new Vector();
        this.nodeList = new Vector();
        this.fireTopologyExpired();
    }

    public int getLinkCount() {
        return this.linkList.size();
    }

    public boolean isLinkListEditable() {
        return this.linkListIsEditable;
    }

    public void setLinkListEditable(boolean bl) {
        this.linkListIsEditable = bl;
    }

    public int indexOfLink(TopologyLink topologyLink) {
        return this.linkList.indexOf(topologyLink);
    }

    public TopologyLink linkAtIndex(int n) {
        return (TopologyLink)this.linkList.elementAt(n);
    }

    public void addLink(int n, TopologyLink topologyLink) {
        if (!this.linkListIsEditable) {
            throw new IllegalStateException("link list is not editable");
        }
        if (!this.linkList.contains(topologyLink)) {
            this.linkList.addElement(topologyLink);
            this.fireLinkAdded(topologyLink);
        } else if (this.linkList.indexOf(topologyLink) != n) {
            throw new IllegalArgumentException("Model already contains link");
        }
    }

    public void addLink(TopologyLink topologyLink) {
        if (!this.linkListIsEditable) {
            throw new IllegalStateException("link list is not editable");
        }
        if (!this.linkList.contains(topologyLink)) {
            this.linkList.addElement(topologyLink);
            this.fireLinkAdded(topologyLink);
        }
    }

    public void insertLinkAt(TopologyLink topologyLink, int n) {
        this.addLink(n, topologyLink);
    }

    public void removeLink(TopologyLink topologyLink) {
        int n = this.linkList.indexOf(topologyLink);
        if (n < 0) {
            throw new NoSuchElementException("model does not contain link");
        }
        this.removeLinkAtIndex(n);
    }

    public void removeLinkAtIndex(int n) {
        if (!this.linkListIsEditable) {
            throw new IllegalStateException("link list is not editable");
        }
        TopologyLink topologyLink = (TopologyLink)this.linkList.elementAt(n);
        this.linkList.removeElementAt(n);
        this.fireLinkRemoved(topologyLink);
    }

    public void removeAllLinks() {
        this.linkList = new Vector();
        this.fireTopologyExpired();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

