/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.topology;

import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.AbstractTopologyLayout;
import com.qlogic.ui.topology.TopologyNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;

public class TopologyRingLayout
extends AbstractTopologyLayout {
    protected static final int DEFAULT_BORDER_PAD = 32;
    protected static final float DEFAULT_INCREMENT = 0.59541404f;
    float position = 0.0f;
    protected float increment;
    protected Point origin;
    protected boolean layingOutNodes = false;

    public TopologyRingLayout(Topology topology) {
        super(topology);
    }

    protected void initializeLayout() {
        this.position = 0.0f;
        this.increment = this.layingOutNodes ? (this.topology.getNodeCount() == 0 ? (float)Math.PI * 4 : (float)(Math.PI * 2 / (double)this.topology.getNodeCount())) : (float)Math.PI * 2;
    }

    protected Point getOrigin() {
        Dimension dimension = this.getTopology().getVisibleSize();
        Dimension dimension2 = this.getTopology().getMinimumSize();
        int n = Math.max(dimension.width, dimension2.width);
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Point((n + 1) / 2, (n2 + 1) / 2);
    }

    public void layoutNode(TopologyNode topologyNode) {
        if (this.origin == null) {
            this.layoutNode(topologyNode, this.getOrigin());
        } else {
            this.layoutNode(topologyNode, this.origin);
        }
        if (!this.layingOutNodes && this.topology.isAutoLayoutEnabled()) {
            this.layoutAllNodes();
        }
    }

    protected void layoutNode(TopologyNode topologyNode, Point point) {
        if ((double)this.position >= Math.PI * 2 - (double)this.increment / 2.0) {
            this.increment = (float)((double)this.increment / 2.0);
            this.position = this.topology.isAutoLayoutEnabled() ? (float)(Math.PI * 2 - (double)this.increment) : (float)((double)this.increment / 2.0);
        }
        Component component = this.topology.getNodeRenderer(topologyNode);
        int n = point.x - 32 - component.getWidth() / 2;
        int n2 = point.y - 32 - component.getHeight() / 2;
        int n3 = (int)((double)point.x + (double)n * Math.sin(this.position) - (double)(component.getWidth() / 2));
        int n4 = (int)((double)point.y - (double)n2 * Math.cos(this.position) - (double)(component.getHeight() / 2));
        this.position += this.increment;
        topologyNode.setLocation(n3, n4);
    }

    public void layoutAllNodes() {
        this.layingOutNodes = true;
        this.origin = this.getOrigin();
        super.layoutAllNodes();
        this.origin = null;
        this.layingOutNodes = false;
    }

    protected void snapToPosition(TopologyNode topologyNode) {
        if (this.origin == null) {
            this.snapToPosition(topologyNode, this.getOrigin());
        } else {
            this.snapToPosition(topologyNode, this.origin);
        }
    }

    protected void snapToPosition(TopologyNode topologyNode, Point point) {
        double d = (double)(topologyNode.getX() - point.x) / (double)(point.x - 32);
        double d2 = (double)(topologyNode.getY() - point.y) / (double)(point.y - 32);
        double d3 = Math.sqrt(d * d + d2 * d2);
        int n = point.x + (int)((double)(topologyNode.getX() - point.x) / d3);
        int n2 = point.y + (int)((double)(topologyNode.getY() - point.y) / d3);
        topologyNode.setLocation(n, n2);
    }

    protected int compareNodes(TopologyNode topologyNode, TopologyNode topologyNode2) {
        if (this.origin == null) {
            return this.compareNodes(topologyNode, topologyNode2, this.getOrigin());
        }
        return this.compareNodes(topologyNode, topologyNode2, this.origin);
    }

    private static double normedAngle(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        double d = n == 0 && n2 == 0 ? 0.0 : (n >= 0 ? (n2 <= 0 ? (double)n / (double)(n - n2) : 2.0 - (double)n / (double)(n + n2)) : (n2 > 0 ? 2.0 + (double)n / (double)(n - n2) : 4.0 - (double)n / (double)(n + n2)));
        return d;
    }

    protected int compareNodes(TopologyNode topologyNode, TopologyNode topologyNode2, Point point) {
        Component component = this.topology.getNodeRenderer(topologyNode);
        Point point2 = topologyNode.getLocation();
        point2.translate(component.getWidth() / 2, component.getHeight() / 2);
        component = this.topology.getNodeRenderer(topologyNode2);
        Point point3 = topologyNode2.getLocation();
        point3.translate(component.getWidth() / 2, component.getHeight() / 2);
        double d = TopologyRingLayout.normedAngle(point2, point);
        double d2 = TopologyRingLayout.normedAngle(point3, point);
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        int n = Math.abs(point2.x - point.x) + Math.abs(point2.x - point.y);
        int n2 = Math.abs(point3.x - point.x) + Math.abs(point3.y - point.y);
        return n - n2;
    }
}

