/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

public class Invoker {
    protected DispatchQueue dispatchQueue = new DispatchQueue();
    protected DispatchThread dispatchThread = new DispatchThread();
    protected static int threadCount = 0;

    public Invoker() {
        this.dispatchThread.start();
    }

    public final void dispose() {
        this.dispatchThread.stopDispatching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeAndWait(Runnable runnable) {
        Invocation invocation;
        if (Thread.currentThread() == this.dispatchThread) {
            throw new Error("Cannot call invokeAndWait from the dispatcher thread");
        }
        Invocation invocation2 = invocation = new Invocation(runnable);
        synchronized (invocation2) {
            this.dispatchQueue.add(invocation);
            try {
                invocation.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final void invokeLater(Runnable runnable) {
        this.dispatchQueue.add(new Invocation(runnable));
    }

    public static void main(String[] stringArray) {
        Invoker invoker = new Invoker();
        int n = 0;
        while (n < 5) {
            System.out.println("main() calling invokeLater()");
            invoker.invokeLater(new Runnable(){

                public void run() {
                    System.out.println("TestRunnable.run()");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            System.out.println("main() calling invokeAndWait()");
            invoker.invokeAndWait(new Runnable(){

                public void run() {
                    System.out.println("TestRunnable.run()");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            ++n2;
        }
        invoker.dispose();
    }

    class TestRunnable
    implements Runnable {
        TestRunnable() {
        }

        public void run() {
            System.out.println("TestRunnable.run()");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class DispatchThread
    extends Thread {
        private volatile boolean doDispatch = true;

        public DispatchThread() {
            super("Invoker-dispatchThread-" + threadCount++);
        }

        public void stopDispatching() {
            block2: {
                this.doDispatch = false;
                Invoker.this.invokeLater(new Runnable(this){
                    private final /* synthetic */ DispatchThread this$1;
                    {
                        this.this$1 = dispatchThread;
                    }

                    public void run() {
                    }
                });
                if (Thread.currentThread() == this) break block2;
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.doDispatch) {
                try {
                    if (this.isInterrupted()) {
                        this.doDispatch = false;
                        continue;
                    }
                    Invocation invocation = Invoker.this.dispatchQueue.get();
                    Runnable runnable = invocation.runnable;
                    runnable.run();
                    Invocation invocation2 = invocation;
                    synchronized (invocation2) {
                        invocation.notifyAll();
                    }
                }
                catch (ThreadDeath threadDeath) {
                    this.doDispatch = false;
                }
                catch (Throwable throwable) {
                    System.err.println("Exception occurred during event dispatching:");
                    throwable.printStackTrace();
                }
            }
        }
    }

    class DispatchQueue {
        QueueItem head;
        QueueItem tail;

        DispatchQueue() {
        }

        public synchronized void add(Invocation invocation) {
            QueueItem queueItem = new QueueItem(invocation);
            if (this.head == null) {
                this.head = queueItem;
                this.tail = queueItem;
                this.notifyAll();
            } else {
                this.tail.next = queueItem;
                this.tail = queueItem;
            }
        }

        public synchronized Invocation get() {
            QueueItem queueItem;
            while ((queueItem = this.head) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.head = queueItem.next;
            return queueItem.invocation;
        }

        class QueueItem {
            Invocation invocation;
            QueueItem next = null;

            QueueItem(Invocation invocation) {
                this.invocation = invocation;
            }
        }
    }

    class Invocation {
        Runnable runnable;

        public Invocation(Runnable runnable) {
            this.runnable = runnable;
        }
    }
}

