/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.NameServerEntry;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Director
implements Chassis,
UtilDestination,
UtilEventListener {
    private Vector nodeList = new Vector();
    private ChassisEventHandler eventHandler;
    protected UtilAgent utilAgent = null;
    protected WorldWideName WWName = null;
    protected int fcAddress = 0;
    protected String vendorName = "QLogic Director";
    private boolean discoveredByIpAddress = false;
    private int status = 1;
    private int chassisType;
    private int portCount;

    public Director(int n, WorldWideName worldWideName, UtilAgent utilAgent) {
        this.utilAgent = utilAgent;
        this.fcAddress = n;
        this.setWWName(worldWideName);
        this.eventHandler = new ChassisEventHandler(this);
    }

    public Director(UtilMsgVersionReq utilMsgVersionReq, UtilAgent utilAgent) {
        this.utilAgent = utilAgent;
        this.eventHandler = new ChassisEventHandler(this);
        this.saveVersionRequest(utilMsgVersionReq);
    }

    public boolean useVersion_0() {
        return false;
    }

    public ComAgent getComAgent() {
        return this.utilAgent;
    }

    public boolean getDiscoveredByIpAddress() {
        return this.getComAgent().getConnectionWwn().equals(this.getWWName());
    }

    protected void saveVersionRequest(UtilMsgVersionReq utilMsgVersionReq) {
        int n = utilMsgVersionReq.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(212, null, false);
            return;
        }
        this.fcAddress = utilMsgVersionReq.getResponseFcAddress() & 0xFFFFFF;
        int n2 = utilMsgVersionReq.getChassisType();
        this.saveChassisType(n2);
        long l = utilMsgVersionReq.getWWName();
        WorldWideName worldWideName = new WorldWideName(l);
        this.setWWName(worldWideName);
        this.eventHandler.fireChassisEvent(212, null, true);
    }

    protected void saveChassisType(int n) {
        switch (n) {
            case 4: {
                this.chassisType = 4;
                this.portCount = 64;
                break;
            }
            case 6: {
                this.chassisType = 6;
                this.portCount = 64;
                break;
            }
            case 5: {
                this.chassisType = 5;
                this.portCount = 64;
                break;
            }
            case 3: {
                this.chassisType = 3;
                this.portCount = 64;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Chassis)) {
            return false;
        }
        Chassis chassis = (Chassis)object;
        return this.getWWName().equals(chassis.getWWName());
    }

    public int getPortCount() {
        return 0;
    }

    public FCPort getFirstPort() {
        return null;
    }

    public FCPort getNextPort(FCPort fCPort) {
        return null;
    }

    public WorldWideName getWWName() {
        return this.WWName;
    }

    public FCNode getFirstNode() {
        if (this.nodeList.size() > 0) {
            return (FCNode)this.nodeList.firstElement();
        }
        return null;
    }

    public FCNode getNextNode(FCNode fCNode) {
        int n;
        if (this.nodeList.size() > 0 && (n = this.nodeList.indexOf(fCNode)) >= 0 && n + 1 < this.nodeList.size()) {
            return (FCNode)this.nodeList.elementAt(n + 1);
        }
        return null;
    }

    public int getDomainId() {
        return this.getFcAddress() >> 16;
    }

    public void setWWName(WorldWideName worldWideName) {
        long l = worldWideName.getWWName();
        l &= 0xFFFFFFFFFFFFL;
        this.WWName = new WorldWideName(l |= 0x1000000000000000L);
    }

    public int getChassisType() {
        return this.chassisType;
    }

    public int getChassisId() {
        return 0;
    }

    public ChassisEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void addChassisEventListener(ChassisEventListener chassisEventListener) {
        this.getEventHandler().addChassisEventListener(chassisEventListener);
    }

    public void removeChassisEventListener(ChassisEventListener chassisEventListener) {
        this.getEventHandler().removeChassisEventListener(chassisEventListener);
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public String delimitFCAddress() {
        int n = 0;
        String string = Integer.toHexString(this.fcAddress);
        n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n < 6) {
            int n2 = 6;
            while (n2 > n) {
                stringBuffer.insert(0, "0");
                --n2;
            }
        }
        return stringBuffer.toString();
    }

    public void setFcAddress(int n) {
        this.fcAddress = n;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public int getTemperature() {
        return 0;
    }

    public int getTemperatureStatus() {
        return 3;
    }

    public int getFanCount() {
        return 1;
    }

    public int getPowerSupplyCount() {
        return 1;
    }

    public int getFanStatus(int n) {
        return 3;
    }

    public int getPowerSupplyStatus(int n) {
        return 3;
    }

    public boolean isInOrderDeliverySet() {
        return true;
    }

    public boolean updateAll() {
        return false;
    }

    public boolean updateChassisStatistics() {
        return false;
    }

    public boolean updatePortStatistics() {
        return false;
    }

    public String toString() {
        if (this.WWName != null) {
            return "<html><font size=-2>Vendor=" + this.WWName.getCompanyName() + " WWN=" + this.WWName.delimit();
        }
        return "Non-QLogic switch";
    }

    public boolean updateChassisInfo() {
        return false;
    }

    public boolean calculateOverallStatus() {
        return false;
    }

    public List getReasonForStatus() {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.status) {
            case 1: {
                arrayList.add("Status.none");
                break;
            }
            case 3: {
                arrayList.add("Status.noResponse");
                break;
            }
            case 2: {
                arrayList.add("Status.unreachable");
                break;
            }
            default: {
                arrayList.add("Status.unmanageable");
            }
        }
        return arrayList;
    }

    public int getOverallStatus() {
        return 3;
    }

    public boolean pingChassis() {
        return this.updateVersion();
    }

    public boolean isTimedOut(UtilMessage utilMessage) {
        return System.currentTimeMillis() - utilMessage.getTimeSent() > (long)utilMessage.getTimeoutValue();
    }

    public boolean updateVersion() {
        return this.utilAgent.getVersion(this, this);
    }

    public void setNotInFabric() {
        this.fcAddress = 0;
    }

    public boolean isReachable() {
        return this.fcAddress != 0;
    }

    public void receiveMessage(UtilMessage utilMessage) {
        int n = utilMessage.getStatus();
        int n2 = utilMessage.getErrorCode();
        if (n == 103 && this.getChassisStatus() != 1) {
            this.setChassisStatus(1);
        } else if (n == 107 && this.getChassisStatus() != 3 && this.getChassisStatus() != 4) {
            this.setChassisStatus(3);
        } else if (n2 == 12 && this.getChassisStatus() != 2 && this.getChassisStatus() != 4) {
            this.setChassisStatus(2);
        } else if ((n2 == 5 || n2 == 14) && this.getChassisStatus() != 4) {
            this.setChassisStatus(4);
        }
        if (utilMessage instanceof UtilMsgVersionReq) {
            this.saveVersionRequest((UtilMsgVersionReq)utilMessage);
        }
    }

    public void setChassisStatus(int n) {
        this.status = n;
    }

    public int getChassisStatus() {
        return this.status;
    }

    public void saveFabricNameServerList(Vector vector) {
        int n = vector.size();
        boolean bl = false;
        Vector<FCNode> vector2 = new Vector<FCNode>();
        int n2 = 0;
        while (n2 < n) {
            NameServerEntry nameServerEntry = (NameServerEntry)vector.get(n2);
            int n3 = nameServerEntry.getFcAddress() & 0xFF0000;
            if (n3 == this.getFcAddress()) {
                FCNode fCNode = new FCNode(nameServerEntry, this);
                if (!this.nodeList.contains(fCNode)) {
                    bl = true;
                }
                vector2.add(fCNode);
            }
            ++n2;
        }
        if (bl || vector2.size() != this.nodeList.size()) {
            this.nodeList = vector2;
            this.eventHandler.fireChassisEvent(219, (Object)this, true);
        }
    }
}

