/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Pollable;
import com.qlogic.device.fcfabric.Updater;

public class PollingItem
implements Comparable {
    Pollable target;
    Updater action;
    boolean disabled;
    boolean repeating;
    boolean requeue;
    long wakeTime;
    long interval;
    long actTime;
    Object[] args;

    public PollingItem(Pollable pollable, Updater updater, long l) {
        this.target = pollable;
        this.action = updater;
        this.wakeTime = l;
    }

    public PollingItem(Pollable pollable, Updater updater, Object[] objectArray, long l) {
        this.target = pollable;
        this.action = updater;
        this.wakeTime = l;
        this.args = objectArray;
    }

    public PollingItem(Pollable pollable, Updater updater, long l, long l2) {
        this.target = pollable;
        this.action = updater;
        this.wakeTime = l;
        this.interval = l2;
        this.repeating = true;
    }

    public Pollable getTarget() {
        return this.target;
    }

    public Updater getAction() {
        return this.action;
    }

    public long getWakeTime() {
        return this.wakeTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getActTime() {
        return this.actTime;
    }

    public boolean activate() {
        this.actTime = System.currentTimeMillis();
        if (this.args != null) {
            return this.action.update(this.args);
        }
        return this.action.update();
    }

    public void deactivate() {
        this.actTime = 0L;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean shouldRequeue() {
        return this.requeue;
    }

    public void setRequeue(boolean bl) {
        this.requeue = bl;
    }

    public void enable() {
        this.disabled = false;
    }

    public void disable() {
        this.disabled = true;
    }

    public synchronized void setWakeTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(l + "< 0");
        }
        this.wakeTime = l;
    }

    public synchronized void setInterval(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(l + "< 0");
        }
        this.interval = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("target: ");
        stringBuffer.append(this.target);
        stringBuffer.append(" event: ");
        stringBuffer.append(this.action.getEvent());
        stringBuffer.append(" wakeTime: ");
        stringBuffer.append(this.wakeTime);
        stringBuffer.append(" disabled: ");
        stringBuffer.append(this.disabled);
        stringBuffer.append(" requeue: ");
        stringBuffer.append(this.requeue);
        stringBuffer.append(" repeating: ");
        stringBuffer.append(this.repeating);
        stringBuffer.append(" interval: ");
        stringBuffer.append(this.interval);
        stringBuffer.append(" actTime: ");
        stringBuffer.append(this.actTime);
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        PollingItem pollingItem = (PollingItem)object;
        long l = pollingItem.getWakeTime();
        if (l == this.wakeTime) {
            return 0;
        }
        if (this.wakeTime > l) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        PollingItem pollingItem;
        if (object == null) {
            return false;
        }
        return object instanceof PollingItem && (pollingItem = (PollingItem)object).getTarget() == this.target && pollingItem.getAction().equals(this.action);
    }

    public int hashCode() {
        int n = 42;
        n += 13 * this.target.hashCode();
        return n += 13 * this.action.getEvent();
    }
}

