/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SbTraceDecoder;
import com.qlogic.device.fcfabric.TrapLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class Sanbox
extends SanboxChassis {
    public static final int SANBOX_16AB = 1;
    public static final int SANBOX_16HA = 2;
    public static final int SANBOX_16I = 3;
    public static final int TEMP_OK = 0;
    public static final int OVERWARM = 1;
    public static final int OVERHEAT = 2;
    public static final int FW_BUF_SIZE = 492;
    public static final int MAX_POWER_SUPPLY_COUNT = 2;
    public static final int MAX_FAN_COUNT = 3;
    public static final int MAX_TEMPERATURE_SENSORS = 3;
    public static final int EPORT_ISOLATED_NA = 0;
    public static final int EPORT_ISOLATED_REJECT = 1;
    public static final int EPORT_ISOLATED_BAD_DOMAIN = 2;
    public static final int EPORT_ISOLATED_INCOMPATIBLE = 3;
    public static final int EPORT_ISOLATED_DOMAIN_OVERLAP = 4;
    public static final int EPORT_ISOLATED_EFP_BAD_DOMAIN = 5;
    public static final int EPORT_ISOLATED_TOV_MISMATCH = 6;
    public static final int EPORT_ISOLATED_ZONE_MERGE_FAILURE = 7;
    public static final int EPORT_ISOLATED_REMOVE_EPORT_ISOLATED = 8;
    protected S43Port[] s43PortList = null;
    protected ComAgent comAgent = null;
    protected boolean editingTrapConfig = false;
    protected int numberOfTraps;
    protected boolean trapsEnabled;
    protected int sampleInterval;
    public static final int NUMBER_OF_TRAPS = 32;
    protected int[] risingThresholds;
    protected int[] fallingThresholds;
    protected boolean[] enableArray;
    protected int[] temperatureSensorStatus;
    protected int[] temperatureSensorDegrees;
    protected int temperatureSensorCount;
    private boolean discoveredByIpAddress = false;
    private SbTraceDecoder traceDecoder = new SbTraceDecoder();
    protected Vector updaters;

    public Sanbox() {
        this.temperatureSensorStatus = new int[3];
        this.temperatureSensorDegrees = new int[3];
        int n = 0;
        while (n < 3) {
            this.temperatureSensorStatus[n] = 3;
            ++n;
        }
        this.temperatureSensorCount = 0;
    }

    public Sanbox(ComAgent comAgent) {
        super(comAgent);
        this.comAgent = comAgent;
        this.temperatureSensorStatus = new int[3];
        this.temperatureSensorDegrees = new int[3];
        int n = 0;
        while (n < 3) {
            this.temperatureSensorStatus[n] = 3;
            ++n;
        }
        this.temperatureSensorCount = 0;
    }

    public String getTrapDef(int n) {
        return this.traceDecoder.getTrapDef(n);
    }

    public boolean supportsBrocadeMergeMode() {
        return false;
    }

    public boolean isAutoSaveSettable() {
        return false;
    }

    public int getTemperatureSensorCount() {
        return this.temperatureSensorCount;
    }

    public void setTemperatureSensorCount(int n) {
        this.temperatureSensorCount = n;
    }

    public int getTemperatureSensorDegrees(int n) {
        if (n < this.temperatureSensorDegrees.length) {
            return this.temperatureSensorDegrees[n];
        }
        return 3;
    }

    public int getTemperatureSensorStatus(int n) {
        if (n < this.temperatureSensorStatus.length) {
            return this.temperatureSensorStatus[n];
        }
        return 3;
    }

    protected S43Port createPort(int n, SanboxChassis sanboxChassis, FCStatistics fCStatistics) {
        return new S43Port(n, sanboxChassis, fCStatistics, false);
    }

    public FCPort getPort(int n) {
        return this.s43PortList[n];
    }

    public int getPortCount() {
        return this.s43PortList.length;
    }

    public abstract boolean applyExtCredits(int[] var1, int[] var2);

    public abstract boolean isExtCreditModeValid(int var1, int var2);

    public abstract int getModelType();

    public abstract int getExtCreditMode(int var1);

    public abstract boolean applyActiveAdminPortTypes(int var1, byte[] var2);

    public abstract boolean applySavePendingSwitchConfig();

    public abstract boolean applySwitchReconfig();

    public abstract boolean updateActiveAdminPortTypes();

    public abstract boolean applyActiveAdminPortTypesSave();

    public abstract boolean updateEPortIsolationReasons();

    public abstract boolean applyRscn(boolean[] var1);

    public abstract boolean updateRscn();

    public abstract boolean updateLoopbackTestStatus();

    public abstract TrapLog getTrapLog();

    public abstract boolean updateTrapInfo();

    public abstract boolean clearTrapLog();

    public abstract boolean applyTrapConfig();

    public abstract boolean applyAllPortsAdminStates(boolean var1);

    public abstract boolean applyActiveSwitchConfig(int var1, int var2, int var3, int var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9, int var10, int var11, int var12);

    public abstract boolean applySwitchConfig(int var1, int var2, int var3, int var4, int var5, int[] var6, int[] var7, int[] var8, int[] var9, int var10, int var11, int var12);

    public abstract boolean applySaveActiveSwitchConfig();

    public void setEditingTrapConfig(boolean bl) {
        this.editingTrapConfig = bl;
    }

    public void setNumberOfTraps(int n) {
        this.numberOfTraps = n;
        this.risingThresholds = new int[this.numberOfTraps];
        this.fallingThresholds = new int[this.numberOfTraps];
        this.enableArray = new boolean[this.numberOfTraps];
    }

    public void setTrapsEnabled(boolean bl) {
        this.trapsEnabled = bl;
    }

    public void setSampleInterval(int n) {
        this.sampleInterval = n;
    }

    public void setTrapConfig(int n, int n2, int n3, boolean bl) {
        if (n < this.numberOfTraps) {
            this.risingThresholds[n] = n2;
            this.fallingThresholds[n] = n3;
            this.enableArray[n] = bl;
        }
    }

    public int getNumberOfTraps() {
        return this.numberOfTraps;
    }

    public boolean getTrapsEnabled() {
        return this.trapsEnabled;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public int getTrapRisingThreadhold(int n) {
        return this.risingThresholds[n];
    }

    public int getTrapFallingThreadhold(int n) {
        return this.fallingThresholds[n];
    }

    public boolean getTrapEnable(int n) {
        return this.enableArray[n];
    }

    public boolean verifyFwChecksum(File file) {
        int n;
        int n2;
        FileInputStream fileInputStream;
        int n3 = 0;
        byte[] byArray = new byte[2];
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        try {
            while (fileInputStream.read(byArray) > 0) {
                int n4 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00;
                n3 = n3 + n4 & 0xFFFF;
                n3 = (n3 & 1) << 15 | n3 >> 1;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.portCount == 16) {
            n2 = 2582;
            n = 3094;
        } else if (this.portCount == 8) {
            n2 = 170;
            n = 204;
        } else {
            return false;
        }
        return n3 == n2 || n3 == n;
    }

    public boolean calculateOverallStatus() {
        int n = this.overallStatus;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.comAgent.getComAgentStatus() != 1) {
            this.setChassisStatus(3);
            n = 3;
            arrayList.add("Status.noResponse");
        } else {
            switch (this.getChassisStatus()) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 3;
                    arrayList.add("Status.unreachable");
                    break;
                }
                case 4: {
                    n = 3;
                    arrayList.add("Status.notLoggedIn");
                    break;
                }
                case 7: {
                    n = 3;
                    arrayList.add("Status.loginFailure");
                    break;
                }
                case 6: {
                    n = 3;
                    arrayList.add("Status.noEntrySession");
                    break;
                }
                case 3: {
                    n = 3;
                    arrayList.add("Status.noResponse");
                }
            }
        }
        if (this.isInPromMode()) {
            n = Math.max(n, 2);
            arrayList.add("Status.isInPromMode");
        }
        if (this.hasUnsupportedFw()) {
            arrayList.add("Status.unsupportedFw");
            n = Math.max(n, 1);
        }
        switch (this.getAdminMode()) {
            case 2: {
                n = Math.max(n, 1);
                arrayList.add("Status.offline");
                break;
            }
            case 3: {
                n = Math.max(n, 1);
                arrayList.add("Status.test");
            }
        }
        switch (this.getTemperatureStatus()) {
            case 1: {
                arrayList.add("Status.overwarm");
                n = Math.max(n, 1);
                break;
            }
            case 2: {
                arrayList.add("Status.overheat");
                n = Math.max(n, 2);
            }
        }
        int n2 = 0;
        int n3 = this.getPowerSupplyCount();
        while (n2 < n3) {
            if (this.getPowerSupplyStatus(n2) == 2) {
                arrayList.add("Status.psFailed");
                n = Math.max(n, 1);
                break;
            }
            ++n2;
        }
        int n4 = 0;
        int n5 = this.getFanCount();
        while (n4 < n5) {
            if (this.getFanStatus(n4) == 2) {
                n = Math.max(n, 2);
                arrayList.add("Status.fanFailed");
                break;
            }
            ++n4;
        }
        int n6 = 0;
        int n7 = this.getPortCount();
        while (n6 < n7) {
            FCPort fCPort = this.getPort(n6);
            if (fCPort.getPortState() == 4) {
                arrayList.add("Status.portsFailed");
                n = Math.max(n, 1);
                break;
            }
            if (fCPort.getEPortConnState() == 3) {
                n = Math.max(n, 1);
                arrayList.add("Status.ePortsIsolated");
                break;
            }
            ++n6;
        }
        if (n == 0) {
            arrayList.add("Status.normal");
        }
        if (arrayList.size() <= 0) {
            arrayList.addAll(this.reasonForStatus);
        }
        if (n != this.overallStatus || !arrayList.equals(this.reasonForStatus)) {
            this.overallStatus = n;
            this.reasonForStatus = arrayList;
            this.eventHandler.fireChassisEvent(208, (Object)new Integer(this.overallStatus), true);
            return true;
        }
        return false;
    }

    public String decodeLog() {
        return this.traceDecoder.decodeLog(this.getTrapLog());
    }

    public boolean hasUnsupportedFw() {
        String string = this.getFlashVersionString();
        if (string.equals("unknown")) {
            return false;
        }
        int n = string.startsWith("e") ? 1 : 0;
        int n2 = n + 1;
        try {
            int n3 = Integer.parseInt(string.substring(n, n + 1), 16);
            int n4 = Integer.parseInt(string.substring(n2, n2 + 2), 16);
            if (n3 < 4) {
                return true;
            }
            if (n3 == 4 && n4 < 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return false;
    }

    public List getUpdaters() {
        return this.updaters;
    }
}

