/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.FwVersion;
import com.qlogic.device.fcfabric.RequestNotImplementedException;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.device.fcfabric.UserAccount;
import com.qlogic.device.fcfabric.util.Sanbox8000Sml;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public abstract class Sanbox2
extends SanboxChassis
implements UtilDestination {
    public static final int FW_UNKNOWN = 0;
    public static final int FW_UNSUPPORTED = 1;
    public static final int FW_1_03 = 2;
    public static final int FW_1_04 = 3;
    public static final int FW_1_05 = 4;
    public static final int FW_1_5_1 = 5;
    public static final int FW_2_00 = 6;
    public static final int FW_DEV = 255;
    public static final int DEV_FW_MAJOR_VER = 255;
    public static final int MIN_FW_VER_SUPPORTED = 4;
    public static final int MAX_FW_VER_SUPPORTED = 6;
    protected static final int PING_STATUS_NONE = 1;
    protected static final int PING_STATUS_BUSY = 2;
    protected static final int PING_STATUS_WAITING = 3;
    protected int busyStatus = 1;
    protected String sessionTs;
    protected int upTime = -1;
    protected S16Port[] s16PortList = null;
    protected int operationalState = 1;
    protected int operAdminState = 1;
    protected int unusedCreditPool;
    protected boolean broadcastSupportEnabled = false;
    protected int inbandEnable = 0;
    protected int tempMonEnable = 0;
    protected int warningTemp = 0;
    protected int failureTemp = 0;
    protected String dateTime = "Unknown";
    protected String mfgVendorName = null;
    protected InetAddress changedIpAddress = null;
    protected String inactiveFlashVersionString = "N/A";
    protected Date inactiveFlashTimestamp;
    protected FwVersion firmwareVersion = FwVersion.UNKNOWN_VERSION;
    protected FwVersion pendingVersion;
    protected InetAddress syslogAddr;
    protected boolean syslogEnabled;
    protected boolean ignoreNotifications = false;
    private static final String[] operationalStateStr = new String[]{DeviceUtilities.getResource("SanboxChassis.unknown"), DeviceUtilities.getResource("SanboxChassis.online"), DeviceUtilities.getResource("SanboxChassis.offline"), DeviceUtilities.getResource("SanboxChassis.test"), DeviceUtilities.getResource("SanboxChassis.downed")};
    protected boolean trapsEnabled;
    public static final int NUMBER_OF_TRAPS = 6;
    public static final int TRAP_CRC_ERRORS = 0;
    public static final int TRAP_DECODE_ERRORS = 1;
    public static final int TRAP_ISL_MONITORING = 2;
    public static final int TRAP_LOGIN_MONITORING = 3;
    public static final int TRAP_LOGOUT_MONITORING = 4;
    public static final int TRAP_LOS_MONITORING = 5;
    protected int[] sampleIntervals = new int[6];
    protected int[] risingThresholds = new int[6];
    protected int[] fallingThresholds = new int[6];
    protected boolean[] enableArray = new boolean[6];
    protected int perfMonInterval = 1;
    protected int blinkCode = -1;
    protected Vector userAccountList = new Vector();
    protected Vector attributes;
    private static final int IT_SECID_FIRMWARE = 1;
    private static final int IT_PKG_SECTION_SIZE = 20;
    private static final int IT_PKG_SECTION_REV = 4;
    private static final int IT_PKG_NUM_SECTIONS = 36;
    private static final int IT_PKG_SECTION_LIST = 40;

    public Sanbox2() {
    }

    public Sanbox2(ComAgent comAgent) {
        super(comAgent);
        this.comAgent = comAgent;
    }

    public abstract void dispose();

    public void setIgnoreNotifications(boolean bl) {
        this.ignoreNotifications = bl;
    }

    public abstract boolean unpackFwImage(String var1);

    public abstract boolean cleanupFwImage();

    public boolean verifyFwChecksum(File file) {
        int n;
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        int n2 = 79764919;
        int n3 = -1;
        int n4 = 228;
        int[] nArray = new int[256];
        int n5 = (int)file.length();
        int n6 = 255;
        while (n6 >= 0) {
            n = n6 << 24;
            int n7 = 0;
            while (n7 < 8) {
                n = (n & Integer.MIN_VALUE) != 0 ? n << 1 ^ n2 : (n <<= 1);
                ++n7;
            }
            nArray[n6] = n;
            --n6;
        }
        long l = n5 - n4 - 4;
        if (l < 232L) {
            return false;
        }
        n = n3;
        try {
            int n8;
            bufferedInputStream.skip(n4);
            long l2 = 0L;
            while (l2 < l && (n8 = bufferedInputStream.read()) >= 0) {
                n = n << 8 ^ nArray[(n >>> 24 ^ n8) & 0xFF];
                ++l2;
            }
            int n9 = bufferedInputStream.read();
            n9 += bufferedInputStream.read() << 8;
            n9 += bufferedInputStream.read() << 16;
        }
        catch (IOException iOException) {
            return false;
        }
        return (n9 += bufferedInputStream.read() << 24) == n;
    }

    public abstract boolean supportsNonSw2Legacy();

    public abstract boolean applyZoningConfigWithoutGettingAdmin(ZoningConfig var1);

    public boolean calculateOverallStatus() {
        int n;
        int n2 = this.overallStatus;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.comAgent.getComAgentStatus() != 1) {
            this.setChassisStatus(3);
            n2 = 3;
            arrayList.add("Status.noResponse");
        } else {
            switch (this.getChassisStatus()) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 3: {
                    n2 = 3;
                    arrayList.add("Status.noResponse");
                    break;
                }
                case 2: {
                    n2 = 3;
                    arrayList.add("Status.unreachable");
                    break;
                }
                case 7: {
                    n2 = 3;
                    arrayList.add("Status.loginFailure");
                    break;
                }
                case 4: {
                    n2 = 3;
                    arrayList.add("Status.notLoggedIn");
                    break;
                }
                case 5: {
                    n2 = 3;
                    arrayList.add("Status.maxSessions");
                    break;
                }
                case 6: {
                    n2 = 3;
                    arrayList.add("Status.noEntrySession");
                }
            }
        }
        if (this instanceof Sanbox8000Sml) {
            Sanbox8000Sml sanbox8000Sml = (Sanbox8000Sml)this;
            n = 0;
            while (n < sanbox8000Sml.getNumberOfBlades()) {
                Sanbox8000Blade sanbox8000Blade = sanbox8000Sml.getBlade(n);
                switch (sanbox8000Blade.getBladeState()) {
                    case 2: {
                        n2 = Math.max(n2, 2);
                        break;
                    }
                    case 0: {
                        n2 = Math.max(n2, 1);
                    }
                }
                switch (sanbox8000Blade.getBladeOperState()) {
                    case 1: {
                        n2 = Math.max(n2, 1);
                        arrayList.add("Status.bladeOffline");
                        break;
                    }
                    case 2: {
                        n2 = Math.max(n2, 1);
                        arrayList.add("Status.test");
                        break;
                    }
                    case 3: {
                        n2 = Math.max(n2, 2);
                        arrayList.add("Status.bladeDowned");
                    }
                }
                switch (sanbox8000Blade.getDiagStatus()) {
                    case 3: {
                        n2 = Math.max(n2, 1);
                        arrayList.add("Status.bladeDiagStatus");
                        break;
                    }
                    case 2: {
                        n2 = Math.max(n2, 2);
                        arrayList.add("Status.bladeDiagStatus");
                    }
                }
                ++n;
            }
        }
        if (this.blinkCode != -1 && this.blinkCode != 1) {
            arrayList.add(Status.getBlinkCodeReason(this.blinkCode));
            n2 = Math.max(n2, 2);
        }
        if (this.isInPromMode()) {
            n2 = Math.max(n2, 2);
            arrayList.add("Status.isInPromMode");
        } else if (this.hasUnsupportedFw()) {
            arrayList.add("Status.unsupportedFw");
            n2 = Math.max(n2, 1);
        }
        switch (this.getOperAdminState()) {
            case 2: {
                n2 = Math.max(n2, 1);
                arrayList.add("Status.offline");
                break;
            }
            case 3: {
                n2 = Math.max(n2, 1);
                arrayList.add("Status.test");
                break;
            }
            case 4: {
                n2 = Math.max(n2, 2);
                arrayList.add("Status.downed");
            }
        }
        switch (this.getTemperatureStatus()) {
            case 1: {
                arrayList.add("Status.overwarm");
                n2 = Math.max(n2, 1);
                break;
            }
            case 2: {
                arrayList.add("Status.overheat");
                n2 = Math.max(n2, 2);
            }
        }
        int n3 = 0;
        n = this.getPowerSupplyCount();
        while (n3 < n) {
            if (this.getPowerSupplyStatus(n3) == 2) {
                arrayList.add("Status.psFailed");
                n2 = Math.max(n2, 1);
                break;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = this.getFanCount();
        while (n4 < n5) {
            if (this.getFanStatus(n4) == 2) {
                n2 = Math.max(n2, 2);
                arrayList.add("Status.fanFailed");
                break;
            }
            ++n4;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = this.getPortCount();
        while (n6 < n7) {
            FCPort fCPort = this.getPort(n6);
            if (!bl2 && fCPort.getPortState() == 4) {
                n2 = Math.max(n2, 1);
                arrayList.add("Status.portsFailed");
                bl2 = true;
                break;
            }
            if (!bl && fCPort.getEPortConnState() == 3) {
                n2 = Math.max(n2, 1);
                arrayList.add("Status.ePortsIsolated");
                bl = true;
                break;
            }
            ++n6;
        }
        if (n2 == 0) {
            arrayList.add("Status.normal");
        }
        if (arrayList.size() == 0) {
            arrayList.addAll(this.reasonForStatus);
        }
        if (n2 != this.overallStatus || !arrayList.equals(this.reasonForStatus)) {
            this.overallStatus = n2;
            this.reasonForStatus = arrayList;
            this.eventHandler.fireChassisEvent(208, (Object)new Integer(this.overallStatus), true);
            return true;
        }
        return false;
    }

    public int getOverallStatus() {
        return this.overallStatus;
    }

    public abstract Vector getAlarmLog();

    public String getMfgVendorName() {
        return this.mfgVendorName;
    }

    public void setMfgVendorName(String string) {
        this.mfgVendorName = string;
    }

    public void setFanStatus(int n, int n2) {
        if (n >= 0 && n < this.getFanCount()) {
            this.fanStatus[n] = n2;
        }
    }

    public void setPowerSupplyStatus(int n, int n2) {
        if (n >= 0 && n < this.getPowerSupplyCount()) {
            this.powerSupplyStatus[n] = n2;
        }
    }

    public boolean isAutoSaveSettable() {
        return this.getZoningConfig().getMergeMode() == 0;
    }

    protected S16Port createS16Port(int n, SanboxChassis sanboxChassis, FCStatistics fCStatistics) {
        return new S16Port(n, sanboxChassis, fCStatistics, false);
    }

    public FCPort getPort(int n) {
        return this.s16PortList[n];
    }

    public int getPortCount() {
        return this.s16PortList.length;
    }

    public int getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(int n) {
        this.operationalState = n;
    }

    public String getOperationalStateString() {
        return operationalStateStr[this.operationalState];
    }

    public int getOperAdminState() {
        return this.operAdminState;
    }

    public void setOperAdminState(int n) {
        this.operAdminState = n;
    }

    public String getOperAdminStateString() {
        return operationalStateStr[this.operAdminState];
    }

    public int getInbandEnable() {
        return this.inbandEnable;
    }

    public void setInbandEnable(int n) {
        this.inbandEnable = n;
    }

    public boolean getUserAccountAdminAuthority(String string) {
        int n = this.userAccountList.size();
        int n2 = 0;
        while (n2 < n) {
            UserAccount userAccount = (UserAccount)this.userAccountList.elementAt(n2);
            if (userAccount.getLogin().equals(string)) {
                return userAccount.getAdminAuthority();
            }
            ++n2;
        }
        return false;
    }

    public void setUserAccountAdminAuthority(String string, boolean bl) {
        int n = this.userAccountList.size();
        int n2 = 0;
        while (n2 < n) {
            UserAccount userAccount = (UserAccount)this.userAccountList.elementAt(n2);
            if (userAccount.getLogin().equals(string)) {
                userAccount.setAdminAuthority(bl);
            }
            ++n2;
        }
    }

    public void setUserAccountExpiration(String string, int n) {
        int n2 = this.userAccountList.size();
        int n3 = 0;
        while (n3 < n2) {
            UserAccount userAccount = (UserAccount)this.userAccountList.elementAt(n3);
            if (userAccount.getLogin().equals(string)) {
                userAccount.setExpiration(n);
            }
            ++n3;
        }
    }

    public Vector getUserAccountList() {
        return this.userAccountList;
    }

    public void setUserAccountList(Vector vector) {
        this.userAccountList = vector;
    }

    public int getTempMonEnable() {
        return this.tempMonEnable;
    }

    public void setTempMonEnable(int n) {
        this.tempMonEnable = n;
    }

    public int getWarningTemp() {
        return this.warningTemp;
    }

    public void setWarningTemp(int n) {
        this.warningTemp = n;
    }

    public int getFailureTemp() {
        return this.failureTemp;
    }

    public void setFailureTemp(int n) {
        this.failureTemp = n;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String string) {
        this.dateTime = string;
    }

    public boolean isBroadcastSupportEnabled() {
        return this.broadcastSupportEnabled;
    }

    public void setBroadcastSupportEnabled(boolean bl) {
        this.broadcastSupportEnabled = bl;
    }

    public InetAddress getChangedIpAddress() {
        return this.changedIpAddress;
    }

    public void setChangedIpAddress(InetAddress inetAddress) {
        this.changedIpAddress = inetAddress;
    }

    public int getAdminPortSpeed(int n) throws RequestNotImplementedException {
        return this.s16PortList[n].getAdminPortSpeed();
    }

    public int getOperationalPortSpeed(int n) throws RequestNotImplementedException {
        return this.s16PortList[n].getOperationalPortSpeed();
    }

    public abstract boolean resetPort(int var1);

    public abstract boolean editConfig();

    public abstract boolean saveConfig();

    public abstract boolean activateConfig();

    public abstract boolean activateConfigAndReleaseAdmin();

    public abstract boolean activateConfigAndReleaseAdmin(int var1, int var2);

    public abstract boolean requestAdmin();

    public abstract boolean releaseAdmin();

    public abstract boolean applyLoopbackTest(int var1, long var2, int var4, long var5, boolean var7, int var8);

    public abstract boolean applyLoopbackTest(int var1, long var2, int var4, boolean var5, int var6);

    public abstract boolean applyOnlineLoopbackTest(int var1, long var2, int var4, long var5, boolean var7);

    public abstract boolean applyOnlineLoopbackTest(int var1, long var2, int var4, boolean var5);

    public abstract boolean applyStopLoopbackTest(int var1);

    public abstract boolean applySwitchConfig(int var1, int var2, int var3, int var4);

    public abstract boolean applyPortConfig(int[] var1, int[] var2);

    public abstract boolean applyDomainIdLock(int var1);

    public abstract boolean updateDomainIdLock();

    public abstract boolean updateLoopbackTestStatus();

    public abstract boolean applyPortSpeed(int var1, int var2);

    public abstract boolean applyPortMode(int var1, int var2);

    public abstract boolean applyPortState(int var1, int var2);

    public abstract boolean applyName(String var1);

    public abstract boolean applyFirmwareFallback();

    public abstract boolean updateName();

    public abstract boolean applyBroadcastSupport(boolean var1);

    public abstract boolean updateBroadcastSupport();

    public abstract boolean applyRscn(int var1, boolean var2);

    public abstract boolean applyDeviceScan(int var1, boolean var2);

    public abstract boolean updateRscn();

    public abstract boolean updateDeviceScan();

    public abstract boolean updateInbandEnable();

    public abstract boolean updateUserAccountList();

    public abstract boolean applyAddUserAccount(String var1, boolean var2, String var3);

    public abstract boolean applyRemoveUserAccount(String var1);

    public abstract boolean applyChangePassword(String var1, String var2, String var3);

    public abstract boolean applyUserAccountExpiration(int var1);

    public abstract boolean applyInbandEnable(int var1);

    public abstract boolean updateTempMonitoring();

    public abstract boolean applyTempMonitoring(int var1, int var2, int var3);

    public abstract boolean updateDateTime();

    public abstract boolean applyBBCredits(int var1, int var2);

    public abstract boolean updateBBCredits();

    public abstract boolean applyPortName(int var1, String var2);

    public abstract boolean updatePortNames();

    public abstract boolean applySessionTimer(boolean var1);

    public abstract boolean applyPerfMonInterval(int var1);

    public abstract boolean updatePerfMonInterval();

    public int getPerfMonInterval() {
        return this.perfMonInterval;
    }

    public void setPerfMonInterval(int n) {
        this.perfMonInterval = n;
    }

    public abstract boolean updatePortSpeeds();

    public abstract boolean applyDateTime(String var1);

    public abstract boolean applyExtCredit(int var1, int var2);

    public abstract boolean updateCreditPool();

    public abstract boolean updateExtCreditInfo();

    public int getUnusedCreditPool() {
        return this.unusedCreditPool;
    }

    public void setUnusedCreditPool(int n) {
        this.unusedCreditPool = n;
    }

    public void setSyslogEnable(boolean bl) {
        this.syslogEnabled = bl;
    }

    public boolean isSyslogEnabled() {
        return this.syslogEnabled;
    }

    public abstract boolean applySyslogInfo(boolean var1, InetAddress var2);

    public InetAddress getSyslogAddr() {
        return this.syslogAddr;
    }

    public void setSyslogAddr(InetAddress inetAddress) {
        this.syslogAddr = inetAddress;
    }

    public void setFlashVersion(FwVersion fwVersion) {
        boolean bl = false;
        if (this.firmwareVersion == null) {
            bl = true;
        } else if (!this.firmwareVersion.equals(fwVersion)) {
            bl = true;
        }
        if (bl) {
            this.firmwareVersion = fwVersion;
            this.updateAll();
        }
    }

    public void setPendingVersion(FwVersion fwVersion) {
        this.pendingVersion = fwVersion;
    }

    public FwVersion getPendingVersion() {
        return this.pendingVersion;
    }

    public String getPendingVersionString() {
        return this.pendingVersionString;
    }

    public void setPendingVersionString(String string) {
        this.pendingVersionString = string;
    }

    public Date getPendingTimestamp() {
        return this.pendingTimestamp;
    }

    public void setPendingTimestamp(Date date) {
        this.pendingTimestamp = date;
    }

    public String getInactiveFlashVersionString() {
        return this.inactiveFlashVersionString;
    }

    public void setInactiveFlashVersionString(String string) {
        this.inactiveFlashVersionString = string;
    }

    public Date getInactiveFlashTimestamp() {
        return this.inactiveFlashTimestamp;
    }

    public void setInactiveFlashTimeStamp(Date date) {
        this.inactiveFlashTimestamp = date;
    }

    public int getInactiveFirmwareVersion() {
        if (this.inactiveFlashVersionString == null) {
            return 1;
        }
        FwVersion fwVersion = new FwVersion(this.inactiveFlashVersionString);
        int n = fwVersion.getMajor();
        int n2 = fwVersion.getMinor();
        if (n == 1 && n2 == 3) {
            return 2;
        }
        if (n == 1 && n2 == 4) {
            return 3;
        }
        return 1;
    }

    public int getFwImageVersion(byte[] byArray) {
        int n = byArray[36];
        int n2 = 40;
        while (n-- > 0) {
            int n3 = 0;
            int n4 = n2 + 3;
            while (n4 >= n2) {
                n3 = (n3 << 8) + byArray[n4];
                --n4;
            }
            if (n3 == 1) {
                int n5 = 0;
                int n6 = n2 + 4 + 3;
                while (n6 >= n2 + 4) {
                    n5 = (n5 << 8) + byArray[n6];
                    --n6;
                }
                return this.getFirmwareVersion(new FwVersion(n5));
            }
            n2 += 20;
        }
        return 0;
    }

    public int getFirmwareVersion() {
        return this.getFirmwareVersion(this.firmwareVersion);
    }

    private int getFirmwareVersion(FwVersion fwVersion) {
        if (fwVersion == FwVersion.UNKNOWN_VERSION) {
            return 0;
        }
        int n = fwVersion.getMajor();
        int n2 = fwVersion.getMinor();
        if (n == 1 && n2 == 3) {
            return 2;
        }
        if (n == 1 && n2 == 4) {
            return 3;
        }
        if (n == 1 && n2 == 5) {
            switch (fwVersion.getBranch()) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
            }
            return 4;
        }
        if (n == 2 && n2 == 0) {
            return 6;
        }
        if (n == 255) {
            return 255;
        }
        return 1;
    }

    public boolean hasUnsupportedFw() {
        int n = this.getFirmwareVersion();
        return n != 0 && (n < 4 || n > 6);
    }

    public abstract boolean applyTrapConfig();

    public abstract boolean updateTrapInfo();

    public int getBlinkCode() {
        return this.blinkCode;
    }

    public abstract void setEditingTrapConfig(boolean var1);

    public void setTrapsEnabled(boolean bl) {
        this.trapsEnabled = bl;
    }

    public void setTrapConfig(int n, int n2, int n3, int n4, boolean bl) {
        if (n < 6) {
            this.sampleIntervals[n] = n4;
            this.risingThresholds[n] = n2;
            this.fallingThresholds[n] = n3;
            this.enableArray[n] = bl;
        }
    }

    public int getNumberOfTraps() {
        return 6;
    }

    public boolean getTrapsEnabled() {
        return this.trapsEnabled;
    }

    public int getTrapSampleInterval(int n) {
        return this.sampleIntervals[n];
    }

    public int getTrapRisingThreadhold(int n) {
        return this.risingThresholds[n];
    }

    public int getTrapFallingThreadhold(int n) {
        return this.fallingThresholds[n];
    }

    public boolean getTrapEnable(int n) {
        return this.enableArray[n];
    }

    public void setSessionTs(String string) {
        this.sessionTs = string;
    }

    public String getSessionTs() {
        return this.sessionTs;
    }

    public void setUpTime(int n) {
        this.upTime = n;
    }

    public int getUpTime() {
        return this.upTime;
    }

    public abstract boolean closeMgmtSession();

    public List getUpdaters() {
        return this.attributes;
    }

    public boolean canNdcla() {
        return this.getFirmwareVersion() >= 6 && this.getFirmwareVersion(this.getPendingVersion()) >= 6;
    }
}

