/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.TrapLog;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import java.util.Date;

public class SbTraceDecoder {
    private final TrapDef[] trapDefs = new TrapDef[]{new TrapDef(0, "Switch Reset/Power Up"), new TrapDef(1, "Power Supply Failure"), new TrapDef(2, "Overheat Temperature Warning"), new TrapDef(3, "Overwarm Temperature Warning"), new TrapDef(4, "Fan Failure"), new TrapDef(5, "Internal Processes Completely Congested"), new TrapDef(6, "Internal Processes Overly Congested"), new TrapDef(7, "Inactive Zoneset Deleted to Free Resources"), new TrapDef(8, "Reserved"), new TrapDef(9, "Port Login"), new TrapDef(10, "Port Logout"), new TrapDef(11, "Fibre Port CRC Error Threshold"), new TrapDef(12, "Fibre Port Loss of Sync Error Threshold"), new TrapDef(13, "Fibre Port Decode Error Threshold"), new TrapDef(14, "Fibre Port Framing Error Threshold"), new TrapDef(15, "Fibre Port Smoothing Overflow Error Threshold"), new TrapDef(16, "FL_Port Loop Initialization Attempt (LIP) Threshold"), new TrapDef(17, "FL_Port Loop Initialization Failure Threshold"), new TrapDef(18, "FL_Port Not Initialized as Master"), new TrapDef(19, "N/NL_Port Response Timeout Threshold"), new TrapDef(20, "Internal Hardware Flow Control Error Threshold"), new TrapDef(21, "Fibre Port Data Out Parity Error Threshold"), new TrapDef(22, "Internal Class 1 Hardware Error Threshold"), new TrapDef(23, "Port Address ID Errors"), new TrapDef(24, "Discarded Frames Total Count"), new TrapDef(25, "Reserved"), new TrapDef(26, "Frame Bus Timeout Error Threshold"), new TrapDef(27, "Frame Bus Hardware Error"), new TrapDef(28, "Reserved"), new TrapDef(29, "Internal Frame (Control Port) CRC Error Threshold"), new TrapDef(30, "Internal Frame (Control Port) Parity Error Threshold"), new TrapDef(31, "Reserved"), new TrapDef(32, "E_Port Add Link"), new TrapDef(33, "E_Port Lost LInk"), new TrapDef(34, "E_Port Domain Range/Duplicate"), new TrapDef(35, "E_Port Remote Switch Isolated"), new TrapDef(36, "E_Port Domain Out of Range"), new TrapDef(37, "E_Port TOV Mismatch"), new TrapDef(38, "E_Port ELP Incompatability"), new TrapDef(39, "E_Port Domain ID Rejected"), new TrapDef(40, "E_Port Incompatable Switch Capability"), new TrapDef(41, "E_Port Duplicate Domain ID"), new TrapDef(42, "E_Port Zone Merge Failure"), new TrapDef(48, "Reserved"), new TrapDef(49, "E_Port R_A_TOV mismatch"), new TrapDef(50, "E_Port E_D_TOV mismatch"), new TrapDef(51, "E_Port R_T_TOV mismatch"), new TrapDef(52, "E_Port Zone Type (WWN or Port) Mismatch"), new TrapDef(53, "E_Port WWN Zone Backup Mismatch"), new TrapDef(54, "E_Port Duplicate Chassis Number"), new TrapDef(55, "E_Port Unassigned Chassis (Usually Temporary)"), new TrapDef(56, "E_Port Hard Zone Mismatch"), new TrapDef(57, "E_Port New Chassis Discovered"), new TrapDef(58, "E_Port Chassis Lost"), new TrapDef(59, "E_Port Chassis Number Assigned"), new TrapDef(60, "E_Port Multistage Config Error Cleared")};
    private final TraceDef[] traceDefs = new TraceDef[]{new TraceDef(40961, 0, "System startup"), new TraceDef(40962, 1, "Time tick"), new TraceDef(40963, 14, "S4 receive"), new TraceDef(40964, 1, "Sync detected"), new TraceDef(40965, 2, "Login frame from N_Port"), new TraceDef(40966, 2, "High Resolutiom Time Stamp (Units of 100 ns)"), new TraceDef(40967, 2, "Low Resolution Time Stamp"), new TraceDef(40974, 14, "Reject Frame"), new TraceDef(40975, 14, "Busy Frame"), new TraceDef(40976, 14, "Frame discarded"), new TraceDef(40979, 2, "CNQ Frame Deleted"), new TraceDef(41002, 14, "S4 Send"), new TraceDef(41003, 14, "S4 CNQ Loaded"), new TraceDef(41004, 3, "Send Internal Msg to Another F_Port"), new TraceDef(41016, 1, "Port Went Offline"), new TraceDef(41033, 2, "broadcast Frame"), new TraceDef(41041, 3, "Sent Port RSCN to Chassis"), new TraceDef(41042, 3, "Sent Area RSCN to Chassis"), new TraceDef(41043, 3, "Sent Domain RSCN to Chassis"), new TraceDef(41044, 3, "Sent Port RSCN to N_Port"), new TraceDef(41045, 3, "Sent Area RSCN to N_Port"), new TraceDef(41046, 3, "Sent Domain RSCN to N_Port"), new TraceDef(41047, 2, "Receive Port RSCN from Chassis"), new TraceDef(41048, 2, "Receive Area RSCN from Chassis"), new TraceDef(41049, 2, "Receive Domain RSCN from Chassis"), new TraceDef(41056, 1, "Register for State Change Notifications"), new TraceDef(41062, 1, "Corrupted Frame (EOFni) Received"), new TraceDef(41069, 1, "Link Reset Occurred"), new TraceDef(41070, 4, "Link State"), new TraceDef(41072, 4, "Name Server Cmd"), new TraceDef(41073, 1, "LOF Timeout Detected"), new TraceDef(41074, 2, "AL Init Called"), new TraceDef(41075, 5, "ELS Originated by Fabric"), new TraceDef(41076, 6, "ELS Received by Fabric"), new TraceDef(41077, 3, "F_CHKPORT Processed"), new TraceDef(41078, 8, "Symbol Table"), new TraceDef(41079, 6, "Multi Stage Config Rec"), new TraceDef(41080, 2, "WWN Hash Index"), new TraceDef(41081, 0, "Propagate Config Table Entry"), new TraceDef(41082, 0, "Change Master Chassis"), new TraceDef(41083, 0, "Local Chassis Becomes Unassigned Because of Duplicate Chassis Number"), new TraceDef(41084, 1, "Send F_ASGNUM"), new TraceDef(41085, 10, "Start Chassis Assign"), new TraceDef(41086, 4, "Rcv F_ASGNUM"), new TraceDef(41087, 1, "Rcv F_CONFIG"), new TraceDef(41088, 5, "Rcv AAI"), new TraceDef(41089, 1, "Send ELP"), new TraceDef(41090, 1, "Rcv ELP"), new TraceDef(41091, 0, "Send Initial F_CONFIG After ELP"), new TraceDef(41092, 1, "Config Changed, Port Offline"), new TraceDef(41093, 1, "Send AAI"), new TraceDef(41094, 2, "Store VID"), new TraceDef(41095, 1, "Disable VID"), new TraceDef(41096, 1, "Set Max Rotary Count"), new TraceDef(41097, 5, "Set VIDs for 3 Stage IO Chassis"), new TraceDef(41098, 6, "Set VIDs for a Destination Chassis"), new TraceDef(41099, 4, "New Chassis Discovered"), new TraceDef(41100, 5, "S4 Steering Registers"), new TraceDef(41101, 0, "Error in Frame Detected From EOF Word -- Frame Discarded"), new TraceDef(41102, 3, "Frame Waiting for CIF Ready to Complete Tx "), new TraceDef(41103, 1, "Bad Rcv Frame Length"), new TraceDef(41104, 1, "Process Start Link internal Msg"), new TraceDef(41105, 3, "Process Stop Link Internal Msg"), new TraceDef(41106, 4, "Start Chassis Assign"), new TraceDef(41108, 5, "SL Controller"), new TraceDef(41109, 5, "SL Port"), new TraceDef(41110, 4, "SL Port SM"), new TraceDef(41111, 3, "NV Memory Data Saved"), new TraceDef(41112, 3, "Get NV Memory Data"), new TraceDef(41113, 4, "NV Memory Linked List Data Saved"), new TraceDef(41114, 5, "Get NV Memory Linked List Data"), new TraceDef(41115, 1, "Delete NV Memory Data"), new TraceDef(41116, 3, "Init NV Memory"), new TraceDef(41117, 1, "NV Memory Checksum Error"), new TraceDef(41118, 1, "NV Memory Invalid Directory"), new TraceDef(41119, 2, "SL Controller"), new TraceDef(41120, 2, "SL Port"), new TraceDef(41121, 4, "Multistage Config Send Hard Zone Data"), new TraceDef(41122, 6, "Multistage Config Rcv Hard Zone Data"), new TraceDef(41123, 4, "Steering Select Link"), new TraceDef(41124, 2, "Steering Delete Link"), new TraceDef(41125, 2, "Resteer Lost Path"), new TraceDef(41126, 1, "Set steering for port"), new TraceDef(41213, 3, "Generic Trace Event 1"), new TraceDef(41214, 4, "Generic Trace Event 2"), new TraceDef(41215, 5, "Generic Trace Event 3"), new TraceDef(41217, 1, "AL Init Complete"), new TraceDef(41218, 4, "Multistage Link Logged In"), new TraceDef(41219, 1, "Chassis Number Assigned"), new TraceDef(41220, 4, "Lost Contact with Chassis"), new TraceDef(41221, 1, "Port Offline"), new TraceDef(41222, 5, "Remote Chassis Number Changed"), new TraceDef(41223, 2, "AL Init Failed (1=AL Init Failed, 2=Old Port, 3=Internal State Error)"), new TraceDef(41224, 1, "Could not Assign Chassis Number -- Chassis Isolated"), new TraceDef(41225, 3, "Configuration Modified"), new TraceDef(41226, 11, "Trap Alarm"), new TraceDef(41227, 3, "Fabric Login From N-port"), new TraceDef(41228, 2, "AL Initialization Started"), new TraceDef(45057, 2, "Get Frame Buffer "), new TraceDef(45058, 2, "Get Frame Buffer in Interrupt"), new TraceDef(45059, 2, "Free Frame Buffer"), new TraceDef(45060, 2, "Free Frame Buffer in Interrupt"), new TraceDef(45061, 2, "Queue Buffer"), new TraceDef(45062, 2, "Queue Buffer in Interrupt"), new TraceDef(45063, 2, "UnQueue Buffer"), new TraceDef(45064, 2, "UnQueue Buffer in Interrupt"), new TraceDef(45065, 0, "Pointer Error"), new TraceDef(45066, 5, "Error Events"), new TraceDef(45067, 10, "AL Initialization"), new TraceDef(45068, 4, "Queue Multiple"), new TraceDef(45069, 2, "Unqueue Multiple"), new TraceDef(45070, 1, "Free Multiple"), new TraceDef(45071, 19, "Extended Credit"), new TraceDef(45072, 4, "Util Command"), new TraceDef(49153, 9, "i960 Fault Detected")};
    private boolean startupFound = false;

    public String getTrapDef(int n) {
        return this.trapDefs[n].desc;
    }

    public String decodeLog(TrapLog trapLog) {
        byte[] byArray = trapLog.getData();
        int[] nArray = new int[byArray.length / 2];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = UtilMessage.decodeUnsignedShort(byArray, n * 2);
            ++n;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < nArray.length) {
            this.startupFound = false;
            n2 = this.decodeEntry(stringBuffer, n2, nArray, trapLog, 0);
            if (!this.startupFound) continue;
            n3 = n2;
        }
        bl = false;
        n2 = 0;
        stringBuffer = new StringBuffer();
        while (n2 < nArray.length) {
            n2 = this.decodeEntry(stringBuffer, n2, nArray, trapLog, n3);
        }
        return stringBuffer.toString();
    }

    private int decodeEntry(StringBuffer stringBuffer, int n, int[] nArray, TrapLog trapLog, int n2) {
        int n3 = nArray.length;
        int n4 = stringBuffer.length();
        boolean bl = false;
        boolean bl2 = false;
        int n5 = this.traceDefs.length - 1;
        while (n5 >= 0) {
            if (this.traceDefs[n5].code == nArray[n]) {
                bl2 = true;
                break;
            }
            --n5;
        }
        if (!bl2) {
            String string = Integer.toHexString(nArray[n]);
            stringBuffer.append("?? - 0x0000".substring(0, 11 - string.length()));
            stringBuffer.append(string);
            stringBuffer.append("\n");
            ++n;
        } else {
            stringBuffer.append(this.traceDefs[n5].desc + "\n");
            ++n;
            block0 : switch (this.traceDefs[n5].code) {
                case 41226: {
                    stringBuffer.append("    Port or S4 #" + Integer.toHexString(nArray[n++]));
                    int n6 = nArray[n++];
                    stringBuffer.append("\n    Trap Code: ");
                    if (n6 < 32) {
                        stringBuffer.append(this.trapDefs[n6].desc);
                        bl2 = true;
                    } else {
                        bl2 = false;
                        n5 = 0;
                        int n7 = this.trapDefs.length;
                        while (n5 < n7) {
                            if (this.trapDefs[n5].code == n6) {
                                bl2 = true;
                                break;
                            }
                            ++n5;
                        }
                        if (!bl2) {
                            String string = Integer.toHexString(n6);
                            stringBuffer = new StringBuffer("0x0000".substring(0, 6 - string.length()) + string + "\n");
                        } else {
                            stringBuffer.append(this.trapDefs[n5].desc);
                        }
                    }
                    stringBuffer.append("\n    Alarm Type: " + (nArray[n++] == 1 ? "Return to Normal" : "Error/Exceeds High Threshold"));
                    stringBuffer.append("\n    Rising Threshold: ");
                    stringBuffer.append(UtilMessage.decodeUnsignedInt(nArray, n));
                    stringBuffer.append("\n    Falling Threshold: ");
                    stringBuffer.append(UtilMessage.decodeUnsignedInt(nArray, n += 2));
                    n += 2;
                    switch (n6) {
                        case 32: 
                        case 33: 
                        case 36: {
                            stringBuffer.append("\n    Neighbor Domain ID: ");
                            break;
                        }
                        case 22: {
                            stringBuffer.append("\n    Domain ID: ");
                            break;
                        }
                        default: {
                            stringBuffer.append("\n    Data Total: ");
                        }
                    }
                    stringBuffer.append(UtilMessage.decodeUnsignedInt(nArray, n));
                    n += 2;
                    switch (n6) {
                        case 32: {
                            stringBuffer.append("\n    # of Links to Neighbor: ");
                            break;
                        }
                        case 33: {
                            stringBuffer.append("\n    # of Remaining Links: ");
                            break;
                        }
                        default: {
                            stringBuffer.append("\n    Data Change: ");
                        }
                    }
                    stringBuffer.append(UtilMessage.decodeInt(nArray, n));
                    n += 2;
                    stringBuffer.append("\n");
                    break;
                }
                case 40967: {
                    long l = UtilMessage.decodeUnsignedInt(nArray, n);
                    if (n > n2) {
                        long l2 = ((long)trapLog.getTimeStamp() - l) * 2L;
                        Date date = new Date(trapLog.getTimeStampDate().getTime() - l2);
                        stringBuffer.append("    " + date);
                    } else {
                        stringBuffer.append("    ");
                    }
                    stringBuffer.append(" [" + 2L * l + " ms.]");
                    stringBuffer.append("\n\n");
                    n += 2;
                    break;
                }
                case 40961: {
                    this.startupFound = true;
                    stringBuffer.append("============\n");
                    break;
                }
                default: {
                    int n8 = 0;
                    int n9 = this.traceDefs[n5].argc;
                    while (n8 < n9) {
                        if (n > n3 - 1) break block0;
                        String string = Integer.toHexString(nArray[n++]);
                        stringBuffer.append("  " + "0x0000".substring(0, 6 - string.length()) + string + "\n");
                        ++n8;
                    }
                    break block0;
                }
            }
        }
        return n;
    }

    private class TraceDef {
        public int code;
        public int argc;
        public String desc;

        TraceDef(int n, int n2, String string) {
            this.code = n;
            this.argc = n2;
            this.desc = string;
        }
    }

    private class TrapDef {
        public int code;
        public String desc;

        TrapDef(int n, String string) {
            this.code = n;
            this.desc = string;
        }
    }
}

