/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.archiver;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.TrapLog;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.archiver.events.ArchiverEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.util.JElement;
import com.qlogic.util.StringUtilities;
import java.io.IOException;
import java.net.InetAddress;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SanboxArchiver
extends SanboxChassisArchiver
implements ChassisEventListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErrorType applySwitchConfig(SanboxChassis sanboxChassis, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n6, int n7, int n8, Element element, Element element2) throws IOException {
        SanboxArchiver sanboxArchiver = this;
        synchronized (sanboxArchiver) {
            ErrorType errorType = null;
            ((Sanbox)sanboxChassis).applySwitchConfig(n, n2, n3, n4, n5, nArray, nArray2, nArray3, nArray4, n6, n7, n8);
            errorType = this.waitForEvent(231);
            if (errorType != null) {
                return errorType;
            }
            Sanbox sanbox = (Sanbox)sanboxChassis;
            sanbox.applySavePendingSwitchConfig();
            errorType = this.waitForEvent(266);
            if (errorType != null) {
                return errorType;
            }
            sanbox.applyActiveSwitchConfig(n, n2, n3, n4, n5, nArray, nArray2, nArray3, nArray4, n6, n7, n8);
            errorType = this.waitForEvent(231);
            if (errorType != null) {
                return errorType;
            }
            sanbox.applySaveActiveSwitchConfig();
            errorType = this.waitForEvent(267);
            if (errorType != null) {
                return errorType;
            }
            sanbox.updatePortStates();
            errorType = this.waitForEvent(269);
            if (errorType != null) {
                return errorType;
            }
            sanbox.updateActiveAdminPortTypes();
            errorType = this.waitForEvent(300);
            if (errorType != null) {
                return errorType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType applyPortInfo(SanboxChassis sanboxChassis, Element element, int n) throws IOException {
        SanboxArchiver sanboxArchiver = this;
        synchronized (sanboxArchiver) {
            Object object;
            Sanbox sanbox = (Sanbox)sanboxChassis;
            sanbox.applyAllPortsAdminStates(false);
            ErrorType errorType = this.waitForEvent(313);
            if (errorType != null) {
                return errorType;
            }
            boolean[] blArray = new boolean[sanbox.getPortCount()];
            int n2 = 0;
            while (n2 < sanbox.getPortCount()) {
                object = (S43Port)sanbox.getPort(n2);
                blArray[n2] = ((S43Port)object).isRscnSuppressed();
                ++n2;
            }
            object = element.getFirstChild();
            while (object != null) {
                if (object.getNodeName().equals("Port")) {
                    boolean bl;
                    Element element2 = (Element)object;
                    String string = DeviceUtilities.getData(element2, "Number");
                    int n3 = Integer.parseInt(string);
                    FCPort fCPort = sanboxChassis.getPort(n3);
                    string = DeviceUtilities.getData(element2, "RscnEnable");
                    blArray[n3] = bl = string.equals("True");
                }
                object = object.getNextSibling();
            }
            sanbox.applyRscn(blArray);
            errorType = this.waitForEvent(298);
            if (errorType != null) {
                return errorType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType applyNetworkParameters(SanboxChassis sanboxChassis, SnmpInfo snmpInfo, IPInfo iPInfo, Element element) throws IOException {
        String string = DeviceUtilities.getData(element, "snmpTrapAddress");
        snmpInfo.setTrapAddress(InetAddress.getByName(string));
        super.applyNetworkParameters(sanboxChassis, snmpInfo, iPInfo, element);
        SanboxArchiver sanboxArchiver = this;
        synchronized (sanboxArchiver) {
            sanboxChassis.reset();
            ErrorType errorType = this.waitForEvent(252);
            if (errorType != null) {
                return errorType;
            }
            sanboxChassis.getComAgent().setIpAddress(iPInfo.getIpAddress());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType restoreSwitchSpecificParameters(SanboxChassis sanboxChassis, Element element) throws IOException {
        Object object;
        Object object2;
        ErrorType errorType = null;
        this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9509, true));
        Element element2 = DeviceUtilities.getSubElement(element, "Parameters");
        if (element2 == null) {
            throw new IOException("failed parsing <Parameters> tag");
        }
        Element element3 = DeviceUtilities.getSubElement(element2, "TrapConfig");
        if (element3 == null) {
            throw new IOException("failed parsing <TrapConfig> tag");
        }
        Element element4 = DeviceUtilities.getSubElement(element, "Ports");
        if (element4 == null) {
            throw new IOException("failed parsing <Ports> tag");
        }
        Sanbox sanbox = (Sanbox)sanboxChassis;
        sanbox.setEditingTrapConfig(true);
        String string = DeviceUtilities.getData(element3, "NumberOfTraps");
        int n = Integer.parseInt(string);
        sanbox.setNumberOfTraps(n);
        string = DeviceUtilities.getData(element3, "TrapsEnabled");
        boolean bl = string.equals("True");
        sanbox.setTrapsEnabled(bl);
        string = DeviceUtilities.getData(element3, "SampleInterval");
        int n2 = Integer.parseInt(string);
        sanbox.setSampleInterval(n2);
        Node node = element3.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("Trap")) {
                object2 = (Element)node;
                string = DeviceUtilities.getData((Element)object2, "Number");
                int n3 = Integer.parseInt(string);
                string = DeviceUtilities.getData((Element)object2, "FallingThreshold");
                int n4 = Integer.parseInt(string);
                string = DeviceUtilities.getData((Element)object2, "RisingThreshold");
                int n5 = Integer.parseInt(string);
                string = DeviceUtilities.getData((Element)object2, "Enabled");
                boolean bl2 = string.equals("True");
                sanbox.setTrapConfig(n3, n5, n4, bl2);
            }
            node = node.getNextSibling();
        }
        object2 = this;
        synchronized (object2) {
            sanbox.applyTrapConfig();
            errorType = this.waitForEvent(275);
            this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9510, errorType));
        }
        this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9511, true));
        int[] nArray = new int[sanboxChassis.getPortCount() / 4];
        int[] nArray2 = new int[sanboxChassis.getPortCount() / 4];
        int n6 = 0;
        node = element4.getFirstChild();
        while (node != null && n6 < nArray.length) {
            int n7;
            if (node.getNodeName().equals("Port") && (n7 = Integer.parseInt(string = DeviceUtilities.getData((Element)(object = (Element)node), "Number"))) % 4 == 0) {
                nArray2[n6] = n7;
                string = DeviceUtilities.getData((Element)object, "ExtCreditMode");
                nArray[n6] = Integer.parseInt(string);
                ++n6;
            }
            node = node.getNextSibling();
        }
        object = this;
        synchronized (object) {
            sanbox.applyExtCredits(nArray2, nArray);
            ErrorType errorType2 = this.waitForEvent(301);
            if (errorType2 != null && errorType == null) {
                errorType = errorType2;
            }
            sanbox.applyActiveAdminPortTypesSave();
            errorType2 = this.waitForEvent(302);
            if (errorType2 != null && errorType == null) {
                errorType = errorType2;
            }
        }
        this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9512, errorType));
        return errorType;
    }

    public JElement getPortConfigTag(SanboxChassis sanboxChassis, FCPort fCPort) {
        JElement jElement = super.getPortConfigTag(sanboxChassis, fCPort);
        Sanbox sanbox = (Sanbox)sanboxChassis;
        S43Port s43Port = (S43Port)fCPort;
        jElement.addContent(new JElement("ExtCreditMode", Integer.toString(sanbox.getExtCreditMode(fCPort.getPortNumber()))));
        jElement.addContent(new JElement("RscnEnable", s43Port.isRscnSuppressed() ? "True" : "False"));
        jElement.addContent(new JElement("AutoLearnEnabled", s43Port.isAutoLearnEnabled() ? "True" : "False"));
        return jElement;
    }

    public JElement getChassisTag(SanboxChassis sanboxChassis) {
        JElement jElement = super.getChassisTag(sanboxChassis);
        Sanbox sanbox = (Sanbox)sanboxChassis;
        SnmpInfo snmpInfo = sanbox.getSnmpInfo();
        jElement.addContent(new JElement("snmpTrapAddress", snmpInfo.getTrapAddress().getHostAddress()));
        jElement.addContent(new JElement("OperationalState", sanbox.getChassisModeString()));
        jElement.addContent(this.getTrapConfigTag(sanbox));
        jElement.addContent(this.getTrapLogTag(sanbox));
        return jElement;
    }

    private JElement getTrapConfigTag(Sanbox sanbox) {
        JElement jElement = new JElement("TrapConfig");
        jElement.addContent(new JElement("TrapsEnabled", sanbox.getTrapsEnabled() ? "True" : "False"));
        jElement.addContent(new JElement("SampleInterval", Integer.toString(sanbox.getSampleInterval())));
        jElement.addContent(new JElement("NumberOfTraps", Integer.toString(sanbox.getNumberOfTraps())));
        int n = 0;
        while (n < sanbox.getNumberOfTraps()) {
            JElement jElement2 = new JElement("Trap");
            jElement2.addContent(new JElement("Number", Integer.toString(n)));
            jElement2.addContent(new JElement("SampleInterval", sanbox.getTrapDef(n)));
            jElement2.addContent(new JElement("Enabled", sanbox.getTrapEnable(n) ? "True" : "False"));
            jElement2.addContent(new JElement("FallingThreshold", Integer.toString(sanbox.getTrapFallingThreadhold(n))));
            jElement2.addContent(new JElement("RisingThreshold", Integer.toString(sanbox.getTrapRisingThreadhold(n))));
            jElement.addContent(jElement2);
            ++n;
        }
        return jElement;
    }

    private JElement getTrapLogTag(Sanbox sanbox) {
        JElement jElement = new JElement("TrapLog");
        TrapLog trapLog = sanbox.getTrapLog();
        byte[] byArray = trapLog.getData();
        String string = StringUtilities.byteArrayToString(byArray, 0, byArray.length, ":");
        jElement.addContent(string);
        return jElement;
    }

    public void setIgnoreNotifcations(SanboxChassis sanboxChassis, boolean bl) {
    }
}

