/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox8000Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.util.List;

public class IoModulesAttr
extends SwitchAttribute {
    private static final int SML_APPLY_CONFIG_ADMIN = 1;
    private static final int SML_APPLY_OPER_ADMIN = 2;
    public static final int UPDATE_COMPLETE_EVENT = 330;
    Sanbox8000Sml sb2_64;

    public IoModulesAttr(Sanbox8000Sml sanbox8000Sml) {
        super(sanbox8000Sml, 330);
        this.sb2_64 = sanbox8000Sml;
    }

    public boolean applyConfigAdminStates(List list, int[] nArray) {
        int n = list.size();
        if (n != nArray.length) {
            return false;
        }
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Switch.EditConfig");
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((Sanbox8000Blade)list.get(n2)).getSlotNumber();
            utilMsgSml.addSmlCommand("Config.Blade." + n3 + ".AdminState." + Sanbox8000Sml.bladeStates[nArray[n2]]);
            ++n2;
        }
        utilMsgSml.addSmlCommand("Cmd.Switch.SaveConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.ActConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setGroupKey(1);
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyOperAdminStates(List list, int[] nArray) {
        int n = list.size();
        if (n != nArray.length) {
            return false;
        }
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((Sanbox8000Blade)list.get(n2)).getSlotNumber();
            utilMsgSml.addSmlCommand("Cmd.Blade." + n3 + ".AdminState." + Sanbox8000Sml.bladeStates[nArray[n2]]);
            ++n2;
        }
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setGroupKey(2);
        utilMsgSml.setSetCommand();
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean update() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        boolean bl = this.theSwitch.getFirmwareVersion() > 4;
        int n = 0;
        int n2 = this.sb2_64.getNumberOfBlades();
        while (n < n2) {
            int n3 = Sanbox8000Blade.bladeToSlot(n);
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".State");
            utilMsgSml.addSmlCommand("Config.Blade." + n3 + ".AdminState");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".OperState");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".DiagStatus");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".TempStatus");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".BoardTemp.0");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".CreditPool");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".BoardSerialNum");
            utilMsgSml.addSmlCommand("Oper.Blade." + n3 + ".ZirconVersion");
            ++n;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        if (!utilMsgSml.getIsSetCommand()) {
            if (utilMsgSml.getStatus() == 103) {
                this.saveResponse(object);
            }
            this.theSwitch.eventHandler.fireChassisEvent(330, null, utilMsgSml.getErrorType());
        } else {
            switch (utilMsgSml.getGroupKey()) {
                case 1: {
                    this.theSwitch.eventHandler.fireChassisEvent(342, null, utilMsgSml.getErrorType());
                    break;
                }
                case 2: {
                    this.theSwitch.eventHandler.fireChassisEvent(340, null, utilMsgSml.getErrorType());
                }
            }
        }
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        int n = 0;
        int n2 = this.sb2_64.getNumberOfBlades();
        int n3 = 0;
        while (n < n2) {
            String string;
            Sanbox8000Blade sanbox8000Blade = this.sb2_64.getBlade(n);
            if (utilMsgSml.getResponse(n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setBladeState(Sanbox8000Sml.translateBladeState(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setBladeConfigState(Sanbox8000Sml.translateOperState(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setBladeOperState(Sanbox8000Sml.translateOperState(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setDiagStatus(Sanbox8000Sml.translateDiagStatus(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setTempStatus(Sanbox8000Sml.translateTempStatus(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setBoardTemp(Integer.parseInt(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                string = utilMsgSml.getResponse(n3).getResponse();
                sanbox8000Blade.setUnusedCreditPool(Integer.parseInt(string));
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                sanbox8000Blade.setSerialNumber(utilMsgSml.getResponse(n3).getResponse());
            }
            if (utilMsgSml.getResponse(++n3).getErrorCode() == 0) {
                sanbox8000Blade.setZirconVersion(utilMsgSml.getResponse(n3).getResponse());
            }
            ++n3;
            ++n;
        }
    }
}

