/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpInfoAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    public static final int UPDATE_COMPLETE_EVENT = 201;
    public static final int APPLY_COMPLETE_EVENT = 202;
    private static final String configSystem = "Config.System.";
    private String[] updateStrings = new String[]{"Config.System.IPAddress", "Config.System.IPMask", "Config.System.GatewayAddr", "Config.System.Discovery"};

    public IpInfoAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 201, null, 202, null);
        this.sanbox2 = sanbox2Sml;
        this.setUpdateCommands(this.updateStrings);
    }

    public boolean apply(IPInfo iPInfo) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.System.StartSetup");
        utilMsgSml.addSmlCommand("Config.System.IPAddress." + Sanbox2Sml.padIPAddr(iPInfo.getIpAddress()));
        utilMsgSml.addSmlCommand("Config.System.IPMask." + Sanbox2Sml.padIPAddr(Integer.toHexString(iPInfo.getNetMask())));
        utilMsgSml.addSmlCommand("Config.System.GatewayAddr." + Sanbox2Sml.padIPAddr(iPInfo.getGateway()));
        utilMsgSml.addSmlCommand("Config.System.Discovery." + this.translateNetworkDiscovery(iPInfo.getIpBootProcess()));
        utilMsgSml.addSmlCommand("Cmd.System.SaveSetup");
        utilMsgSml.addSmlCommand("Cmd.System.ActSetup");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setTimeoutValue(3000);
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        IPInfo iPInfo = new IPInfo();
        try {
            iPInfo.setIpAddress(InetAddress.getByName(UtilMessage.ipConvert(Long.decode("0x" + utilMsgSml.getResponse(0).getResponse()).intValue())));
            iPInfo.setNetMask(Long.decode("0x" + utilMsgSml.getResponse(1).getResponse()).intValue());
            iPInfo.setGateway(InetAddress.getByName(UtilMessage.ipConvert(Long.decode("0x" + utilMsgSml.getResponse(2).getResponse()).intValue())));
            iPInfo.setIpBootProcess(this.translateNetworkDiscovery(utilMsgSml.getResponse(3).getResponse()));
            this.sanbox2.setIpInfo(iPInfo);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("UnknownHostException " + unknownHostException.getMessage());
        }
    }

    private int translateNetworkDiscovery(String string) {
        if (string.equals("Static")) {
            return 0;
        }
        if (string.equals("Bootp")) {
            return 1;
        }
        if (string.equals("Dhcp")) {
            return 3;
        }
        if (string.equals("Rarp")) {
            return 2;
        }
        return -1;
    }

    private String translateNetworkDiscovery(int n) {
        if (n == 0) {
            return "Static";
        }
        if (n == 1) {
            return "Bootp";
        }
        if (n == 3) {
            return "Dhcp";
        }
        if (n == 2) {
            return "Rarp";
        }
        return "Static";
    }

    public String toString() {
        return "IpInfoAttr: switch=" + this.theSwitch.getChassisName();
    }
}

