/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class PortInfoAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    static final int SML_PORT_MODE = 1;
    static final int SML_PORT_STATE = 2;
    static final int SML_SET_PORT_CONFIG = 3;
    static final int SML_TEMP_PORT_MODE = 4;
    static final int SML_TEMP_PORT_STATE = 5;
    static final int SML_GET_ALL_PORT_STATES = 6;
    public static final int UPDATE_COMPLETE_EVENT = 269;
    private String[] updateStrings = new String[]{"Config.UserPort.0.xxx.AdminState", "Oper.UserPort.0.xxx.AdminState", "Oper.UserPort.0.xxx.OperState", "Oper.UserPort.0.xxx.RunningType", "Oper.UserPort.0.xxx.LoginStatus", "Oper.UserPort.0.xxx.GBICType", "Config.UserPort.0.xxx.Type", "Oper.UserPort.0.xxx.PortID", "Oper.UserPort.0.xxx.EpConnState", "Oper.UserPort.0.xxx.EpIsoReason", "Config.UserPort.0.xxx.MFSEnable"};

    public PortInfoAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 269);
        int n = sanbox2Sml.getPortCount();
        String[] stringArray = new String[n * this.updateStrings.length];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < this.updateStrings.length) {
                stringArray[n2 * this.updateStrings.length + n3] = this.insertPortNumber(this.updateStrings[n3], n2);
                ++n3;
            }
            ++n2;
        }
        this.setUpdateCommands(stringArray);
        this.sanbox2 = sanbox2Sml;
    }

    public boolean apply() {
        throw new UnsupportedOperationException();
    }

    public boolean applyPortConfig(int[] nArray, int[] nArray2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(3);
        int n = this.sanbox2.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            utilMsgSml.addSmlCommand("Config.UserPort.0." + n2 + ".AdminState." + this.translatePortState((byte)nArray[n2]));
            utilMsgSml.addSmlCommand("Config.UserPort.0." + n2 + ".Type." + this.translatePortType((byte)nArray2[n2]));
            ++n2;
        }
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyPortMode(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(1);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Type." + this.translatePortType((byte)n2));
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyPortState(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(2);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".AdminState." + this.translatePortState((byte)n2));
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyTempPortMode(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(4);
        utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".Type." + this.translatePortType((byte)n2));
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyTempPortState(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(5);
        utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".AdminState." + this.translatePortState((byte)n2));
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        int n = this.sanbox2.getPortCount();
        int n2 = this.updateStrings.length;
        int n3 = 0;
        while (n3 < n) {
            S16Port s16Port = (S16Port)this.sanbox2.getPort(n3);
            PortStates portStates = s16Port.getPortStates();
            if (portStates == null) {
                portStates = new PortStates();
                s16Port.setPortStates(portStates);
            }
            int n4 = n3 * n2;
            String string = utilMsgSml.getResponse(n4 + 7).getResponse();
            if (utilMsgSml.getResponse(n4 + 7).getErrorCode() == 0) {
                s16Port.setFcAddress(Integer.parseInt(string, 16));
            }
            portStates.setPendingAdminState(this.translatePortState(utilMsgSml.getResponse(n4 + 0).getResponse()));
            portStates.setActiveAdminState(this.translatePortState(utilMsgSml.getResponse(n4 + 1).getResponse()));
            portStates.setOperationalAdminState(this.translatePortState(utilMsgSml.getResponse(n4 + 2).getResponse()));
            portStates.setPortType(this.translatePortType(utilMsgSml.getResponse(n4 + 3).getResponse()));
            portStates.setLoggedIn(this.translatePortLogin(utilMsgSml.getResponse(n4 + 4).getResponse()));
            portStates.setConfigPortType(this.translatePortType(utilMsgSml.getResponse(n4 + 6).getResponse()));
            switch (portStates.getConfigPortType()) {
                case 2: 
                case 5: 
                case 9: {
                    portStates.setAlDisabled(new Integer(0).byteValue());
                    break;
                }
                default: {
                    portStates.setAlDisabled(new Integer(1).byteValue());
                }
            }
            portStates.setMfsMode(this.translateMfsMode(utilMsgSml.getResponse(n4 + 10).getResponse()));
            s16Port.setAdminState(this.translatePortState(utilMsgSml.getResponse(n4 + 2).getResponse()));
            s16Port.setGbicType(this.translateGBICtype(utilMsgSml.getResponse(n4 + 5).getResponse()));
            s16Port.setEPortConnState(this.translateEPortConnState(utilMsgSml.getResponse(n4 + 8).getResponse()));
            s16Port.setEPortIsolatedReason(utilMsgSml.getResponse(n4 + 9).getResponse());
            ++n3;
        }
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        switch (utilMsgSml.getGroupKey()) {
            case 6: {
                super.handleResponse(object);
                break;
            }
            case 3: {
                this.sanbox2.eventHandler.fireChassisEvent(376, null, utilMsgSml.getErrorType());
                break;
            }
            case 1: {
                this.sanbox2.eventHandler.fireChassisEvent(273, null, utilMsgSml.getErrorType());
                break;
            }
            case 2: {
                this.sanbox2.eventHandler.fireChassisEvent(317, null, utilMsgSml.getErrorType());
                break;
            }
            case 4: {
                this.sanbox2.eventHandler.fireChassisEvent(335, null, utilMsgSml.getErrorType());
                break;
            }
            case 5: {
                this.sanbox2.eventHandler.fireChassisEvent(334, null, utilMsgSml.getErrorType());
                break;
            }
            default: {
                super.handleResponse(object);
            }
        }
    }

    private String insertPortNumber(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.indexOf("xxx");
        stringBuffer.replace(n2, n2 + 3, Integer.toString(n));
        return stringBuffer.toString();
    }

    private byte translatePortLogin(String string) {
        if (string.equalsIgnoreCase("loggedin")) {
            return 1;
        }
        if (string.equalsIgnoreCase("notloggedin")) {
            return 0;
        }
        return -1;
    }

    private int translateGBICtype(String string) {
        if (string.indexOf("SN") >= 0) {
            return 0;
        }
        if (string.indexOf("SL") >= 0) {
            return 0;
        }
        if (string.indexOf("LL") >= 0) {
            return 1;
        }
        if (string.indexOf("EL") >= 0) {
            return 3;
        }
        if (string.indexOf("LE") >= 0) {
            return 0;
        }
        if (string.indexOf("SM") >= 0) {
            return 0;
        }
        if (string.indexOf("x") >= 0) {
            return 0;
        }
        if (string.indexOf("NotApplicable") >= 0) {
            return 9;
        }
        if (string.indexOf("NotInstalled") >= 0) {
            return 99;
        }
        return 98;
    }

    private int translateEPortConnState(String string) {
        if (string.equalsIgnoreCase("None")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Connecting")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Connected")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Isolated")) {
            return 3;
        }
        return -1;
    }

    public byte translateMfsMode(String string) {
        return string.equalsIgnoreCase("true") ? (byte)64 : 0;
    }

    private byte translatePortState(String string) {
        if (string.equalsIgnoreCase("Online")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Offline")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Diagnostics")) {
            return 3;
        }
        if (string.equalsIgnoreCase("Downed") || string.equalsIgnoreCase("Down")) {
            return 4;
        }
        if (string.equalsIgnoreCase("NotInstalled")) {
            return 5;
        }
        if (string.equalsIgnoreCase("Isolated")) {
            return 6;
        }
        return 4;
    }

    private String translatePortState(byte by) {
        if (by == 1) {
            return "Online";
        }
        if (by == 2) {
            return "Offline";
        }
        if (by == 3) {
            return "Diagnostics";
        }
        if (by == 4) {
            return "Down";
        }
        if (by == 6) {
            return "Isolated";
        }
        return "Offline";
    }

    private byte translatePortType(String string) {
        if (string.equalsIgnoreCase("Unknown")) {
            return 0;
        }
        if (string.equalsIgnoreCase("N")) {
            return 0;
        }
        if (string.equalsIgnoreCase("NL")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Donor")) {
            return 6;
        }
        if (string.equalsIgnoreCase("F")) {
            return 1;
        }
        if (string.equalsIgnoreCase("FL")) {
            return 2;
        }
        if (string.equalsIgnoreCase("E")) {
            return 7;
        }
        if (string.equalsIgnoreCase("TL")) {
            return 5;
        }
        if (string.equalsIgnoreCase("SL")) {
            return 4;
        }
        if (string.equalsIgnoreCase("G")) {
            return 8;
        }
        if (string.equalsIgnoreCase("GL")) {
            return 9;
        }
        return 0;
    }

    private String translatePortType(byte by) {
        if (by == 1) {
            return "F";
        }
        if (by == 2) {
            return "FL";
        }
        if (by == 7) {
            return "G";
        }
        if (by == 5) {
            return "TL";
        }
        if (by == 4) {
            return "SL";
        }
        if (by == 8) {
            return "G";
        }
        if (by == 9) {
            return "GL";
        }
        if (by == 6) {
            return "Donor";
        }
        return "F";
    }

    public String toString() {
        return "PortInfoAttr: switch=" + this.theSwitch.getChassisName();
    }
}

