/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class PortSpeedAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    public static final int UPDATE_COMPLETE_EVENT = 225;
    public static final int APPLY_COMPLETE_EVENT = 227;
    private static final String configPortStr = "Config.UserPort.0.";
    private static final String operPortStr = "Oper.UserPort.0.";
    private static final String linkSpeedStr = ".LinkSpeed";
    String[] updateStrings;

    public PortSpeedAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 225, null, 227, null);
        int n = sanbox2Sml.getPortCount();
        this.updateStrings = new String[2 * n];
        int n2 = 0;
        while (n2 < n) {
            this.updateStrings[n2] = configPortStr + Integer.toString(n2) + linkSpeedStr;
            ++n2;
        }
        int n3 = n;
        while (n3 < n * 2) {
            this.updateStrings[n3] = operPortStr + Integer.toString(n3 - n) + linkSpeedStr;
            ++n3;
        }
        this.setUpdateCommands(this.updateStrings);
        this.sanbox2 = sanbox2Sml;
    }

    public boolean apply(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        String string = configPortStr;
        utilMsgSml.addSmlCommand(configPortStr + Integer.toString(n) + ".LinkSpeed." + this.translatePortSpeed(n2));
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        int n = this.sanbox2.getPortCount();
        if (utilMsgSml.getNumberOfResponses() == 2 * n) {
            int n2;
            S16Port s16Port;
            int n3 = 0;
            while (n3 < n) {
                s16Port = (S16Port)this.sanbox2.getPort(n3);
                n2 = this.translatePortSpeed(utilMsgSml.getResponse(n3).getResponse());
                s16Port.setAdminPortSpeed(n2);
                ++n3;
            }
            int n4 = n;
            while (n4 < n * 2) {
                s16Port = (S16Port)this.sanbox2.getPort(n4 - n);
                n2 = this.translatePortSpeed(utilMsgSml.getResponse(n4).getResponse());
                s16Port.setOperationalPortSpeed(n2);
                ++n4;
            }
        }
    }

    private String translatePortSpeed(int n) {
        if (n == 3) {
            return "Auto";
        }
        if (n == 1) {
            return "1Gb/s";
        }
        if (n == 2) {
            return "2Gb/s";
        }
        return "Auto";
    }

    private int translatePortSpeed(String string) {
        if (string.equals("Auto")) {
            return 3;
        }
        if (string.equals("1Gb/s")) {
            return 1;
        }
        if (string.equals("2Gb/s")) {
            return 2;
        }
        return 0;
    }

    public String toString() {
        return "PortSpeedAttr: switch=" + this.theSwitch.getChassisName();
    }
}

