/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class RscnAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    public static final int UPDATE_COMPLETE_EVENT = 297;
    public static final int APPLY_COMPLETE_EVENT = 298;
    private static final String configUserPortStr = "Config.UserPort.0.";
    private static final String rscnEnableStr = ".RSCNEnable";
    private String[] updateStrings;

    public RscnAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 297, null, 298, null);
        this.sanbox2 = sanbox2Sml;
        int n = this.sanbox2.getPortCount();
        this.updateStrings = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.updateStrings[n2] = configUserPortStr + Integer.toString(n2) + rscnEnableStr;
            ++n2;
        }
        this.setUpdateCommands(this.updateStrings);
        this.sanbox2 = sanbox2Sml;
    }

    public boolean apply(int n, boolean bl) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        if (bl) {
            utilMsgSml.addSmlCommand(configUserPortStr + n + rscnEnableStr + ".True");
        } else {
            utilMsgSml.addSmlCommand(configUserPortStr + n + rscnEnableStr + ".False");
        }
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        int n = this.sanbox2.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            String string = utilMsgSml.getResponse(n2).getResponse();
            if (string.equals("True")) {
                ((S16Port)this.sanbox2.getPort(n2)).setRscnEnable(true);
            } else if (string.equals("False")) {
                ((S16Port)this.sanbox2.getPort(n2)).setRscnEnable(false);
            }
            ++n2;
        }
    }

    public String toString() {
        return "RscnAttr: switch=" + this.theSwitch.getChassisName();
    }
}

