/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.SnmpTrapConfig;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class SnmpInfoAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    public static final int UPDATE_COMPLETE_EVENT = 213;
    public static final int APPLY_COMPLETE_EVENT = 214;
    private static final String configSnmpStr = "Config.Snmp.";
    private String[] updateStrings = new String[]{"Config.Snmp.ProxyEnable", "Config.Snmp.Contact", "Config.Snmp.Location", "Config.Snmp.ReadComm", "Config.Snmp.WriteComm", "Config.Snmp.TrapComm", "Config.Snmp.TrapAuth", "Config.Snmp.TrapAddr", "Config.Snmp.TrapPort", "Config.Snmp.TrapSeverity", "Config.Snmp.TrapEnable", "Config.Snmp.TrapVersion", "Config.Snmp.TrapAddr1", "Config.Snmp.TrapPort1", "Config.Snmp.TrapSeverity1", "Config.Snmp.TrapEnable1", "Config.Snmp.TrapVersion1", "Config.Snmp.TrapAddr2", "Config.Snmp.TrapPort2", "Config.Snmp.TrapSeverity2", "Config.Snmp.TrapEnable2", "Config.Snmp.TrapVersion2", "Config.Snmp.TrapAddr3", "Config.Snmp.TrapPort3", "Config.Snmp.TrapSeverity3", "Config.Snmp.TrapEnable3", "Config.Snmp.TrapVersion3", "Config.Snmp.TrapAddr4", "Config.Snmp.TrapPort4", "Config.Snmp.TrapSeverity4", "Config.Snmp.TrapEnable4", "Config.Snmp.TrapVersion4"};

    public SnmpInfoAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 213, null, 214, null);
        this.sanbox2 = sanbox2Sml;
        this.setUpdateCommands(this.updateStrings);
    }

    public boolean apply(SnmpInfo snmpInfo) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Snmp.StartSetup");
        if (snmpInfo.getProxyEnabled()) {
            utilMsgSml.addSmlCommand("Config.Snmp.ProxyEnable.True");
        } else {
            utilMsgSml.addSmlCommand("Config.Snmp.ProxyEnable.False");
        }
        utilMsgSml.addSmlCommand("Config.Snmp.Contact." + snmpInfo.getContact());
        utilMsgSml.addSmlCommand("Config.Snmp.Location." + snmpInfo.getLocation());
        utilMsgSml.addSmlCommand("Config.Snmp.ReadComm." + snmpInfo.getReadComm());
        utilMsgSml.addSmlCommand("Config.Snmp.WriteComm." + snmpInfo.getWriteComm());
        utilMsgSml.addSmlCommand("Config.Snmp.TrapComm." + snmpInfo.getTrapComm());
        utilMsgSml.addSmlCommand("Config.Snmp.TrapAuth." + this.translateAuth((int)snmpInfo.getDoAuthTrap()));
        int n = 0;
        while (n < 5) {
            SnmpTrapConfig snmpTrapConfig = snmpInfo.getSnmpTrapConfig(n);
            if (snmpTrapConfig != null) {
                String string = "";
                if (n > 0) {
                    string = new Integer(n).toString();
                }
                utilMsgSml.addSmlCommand("Config.Snmp.TrapAddr" + string + "." + Sanbox2Sml.padIPAddr(snmpTrapConfig.getAddress()));
                String string2 = new Integer(snmpTrapConfig.getPort()).toString();
                utilMsgSml.addSmlCommand("Config.Snmp.TrapPort" + string + "." + string2);
                utilMsgSml.addSmlCommand("Config.Snmp.TrapSeverity" + string + "." + snmpTrapConfig.getSeverity());
                if (snmpTrapConfig.isEnabled()) {
                    utilMsgSml.addSmlCommand("Config.Snmp.TrapEnable" + string + ".True");
                } else {
                    utilMsgSml.addSmlCommand("Config.Snmp.TrapEnable" + string + ".False");
                }
                utilMsgSml.addSmlCommand("Config.Snmp.TrapVersion" + string + "." + snmpTrapConfig.getVersion());
            }
            ++n;
        }
        utilMsgSml.addSmlCommand("Cmd.Snmp.SaveSetup");
        utilMsgSml.addSmlCommand("Cmd.Snmp.ActSetup");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        utilMsgSml.setTimeoutValue(3000);
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        SnmpInfo snmpInfo = new SnmpInfo();
        snmpInfo.setName(this.sanbox2.getChassisName());
        boolean bl = false;
        String string = utilMsgSml.getResponse(0).getResponse();
        bl = string.equals("True");
        snmpInfo.setProxyEnabled(bl);
        snmpInfo.setContact(utilMsgSml.getResponse(1).getResponse());
        snmpInfo.setLocation(utilMsgSml.getResponse(2).getResponse());
        snmpInfo.setReadComm(utilMsgSml.getResponse(3).getResponse());
        snmpInfo.setWriteComm(utilMsgSml.getResponse(4).getResponse());
        snmpInfo.setTrapComm(utilMsgSml.getResponse(5).getResponse());
        snmpInfo.setDoAuthTrap(this.translateAuth(utilMsgSml.getResponse(6).getResponse()));
        int n = 7;
        int n2 = 0;
        while (n2 < 5) {
            SnmpTrapConfig snmpTrapConfig = new SnmpTrapConfig();
            snmpTrapConfig.setAddress(UtilMsgSml.smlStrToIpAdress(utilMsgSml.getResponse(n++).getResponse()));
            String string2 = utilMsgSml.getResponse(n++).getResponse();
            snmpTrapConfig.setPort(Integer.parseInt(string2));
            snmpTrapConfig.setSeverity(utilMsgSml.getResponse(n++).getResponse());
            String string3 = utilMsgSml.getResponse(n++).getResponse();
            if (string3.equals("True")) {
                snmpTrapConfig.setEnabled(true);
            } else {
                snmpTrapConfig.setEnabled(false);
            }
            String string4 = utilMsgSml.getResponse(n++).getResponse();
            snmpTrapConfig.setVersion(Integer.parseInt(string4));
            snmpInfo.setSnmpTrapConfig(n2, snmpTrapConfig);
            ++n2;
        }
        this.sanbox2.setSnmpInfo(snmpInfo);
    }

    public String translateAuth(int n) {
        if (n == 1) {
            return "True";
        }
        if (n == 0) {
            return "False";
        }
        return "False";
    }

    public int translateAuth(String string) {
        if (string.equals("True")) {
            return 1;
        }
        if (string.equals("False")) {
            return 0;
        }
        return 0;
    }

    public String toString() {
        return "SnmpInfoAttr: switch=" + this.theSwitch.getChassisName();
    }
}

