/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SyslogInfoAttr
extends SwitchAttribute {
    public static final int UPDATE_COMPLETE_EVENT = 314;
    public static final int APPLY_COMPLETE_EVENT = 315;
    private static final String[] updateStrings = new String[]{"Config.System.RmLogEnable", "Config.System.LogHost"};

    public SyslogInfoAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 314, updateStrings, 315, null);
    }

    public boolean apply(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public boolean apply(boolean bl, InetAddress inetAddress) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.System.StartSetup");
        utilMsgSml.addSmlCommand("Config.System.RmLogEnable." + (bl ? "True" : "False"));
        utilMsgSml.addSmlCommand("Config.System.LogHost." + Sanbox2Sml.padIPAddr(inetAddress));
        utilMsgSml.addSmlCommand("Cmd.System.SaveSetup");
        utilMsgSml.addSmlCommand("Cmd.System.ActSetup");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        String string = utilMsgSml.getResponse(0).getResponse();
        this.theSwitch.setSyslogEnable("true".equalsIgnoreCase(string));
        string = utilMsgSml.getResponse(1).getResponse();
        string = UtilMessage.ipConvert((int)Long.parseLong(string, 16));
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.theSwitch.setSyslogAddr(inetAddress);
    }
}

