/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.UserAccount;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.util.Vector;

public class UserAccountsAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    Vector updatedUserAccountList;
    static final int SML_USER_ACCOUNT_LIST = 1;
    static final int SML_USER_ACCOUNT_ADMIN_AUTHORITY = 2;
    static final int SML_USER_ACCOUNT_EXPIRATION = 3;
    static final int SML_ADD_USER_ACCOUNT = 4;
    static final int SML_REMOVE_USER_ACCOUNT = 5;
    static final int SML_CHANGE_PASSWORD = 6;
    public static final int UPDATE_COMPLETE_EVENT = 367;
    private static final String[] updateStrings = new String[]{"Oper.Switch.FirstPotentialUser"};

    public UserAccountsAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml);
        this.setUpdateCompleteEvent(367);
        this.setUpdateCommands(updateStrings);
        this.sanbox2 = sanbox2Sml;
    }

    public boolean update() {
        if (!this.sanbox2.getUserAccountListUpdateInProgress()) {
            this.sanbox2.setUserAccountListUpdateInProgress(true);
            this.updatedUserAccountList = new Vector();
            UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setGroupKey(1);
            utilMsgSml.addSmlCommand("Oper.Switch.FirstPotentialUser");
            return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
        }
        return false;
    }

    public boolean updateUserAccountAdminAuthority() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(2);
        String string = "Oper.Switch.User.";
        String string2 = ".AdminAuthority";
        int n = this.sanbox2.getUserAccountList().size();
        utilMsgSml.setGetCommand();
        int n2 = 0;
        while (n2 < n) {
            UserAccount userAccount = (UserAccount)this.sanbox2.getUserAccountList().elementAt(n2);
            utilMsgSml.addSmlCommand(string + userAccount.getLogin() + string2);
            ++n2;
        }
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean updateUserAccountExpiration() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(3);
        String string = "Oper.Switch.User.";
        String string2 = ".Expiration";
        int n = this.sanbox2.getUserAccountList().size();
        utilMsgSml.setGetCommand();
        int n2 = 0;
        while (n2 < n) {
            UserAccount userAccount = (UserAccount)this.sanbox2.getUserAccountList().elementAt(n2);
            utilMsgSml.addSmlCommand(string + userAccount.getLogin() + string2);
            ++n2;
        }
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyUserAccountExpiration(int n) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(3);
        utilMsgSml.addSmlCommand("Cmd.Switch.Expiration." + Integer.toString(n));
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyAddUserAccount(String string, boolean bl, String string2) {
        String string3 = bl ? "True" : "False";
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(4);
        utilMsgSml.addSmlCommand("Cmd.Switch.AddUser." + string + "." + string3 + "." + string2);
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyRemoveUserAccount(String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(5);
        utilMsgSml.addSmlCommand("Cmd.Switch.DeleteUser." + string);
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyChangePassword(String string, String string2, String string3) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(6);
        utilMsgSml.addSmlCommand("Cmd.Switch.OldPassword." + string + "." + string2);
        utilMsgSml.addSmlCommand("Cmd.Switch.NewPassword." + string + "." + string3);
        utilMsgSml.setSetCommand();
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        switch (utilMsgSml.getGroupKey()) {
            case 1: {
                this.saveUserAccountList(utilMsgSml);
                break;
            }
            case 2: {
                this.saveUserAccountAdminAuthority(utilMsgSml);
                break;
            }
            case 3: {
                this.saveUserAccountExpiration(utilMsgSml);
                break;
            }
            case 4: {
                this.saveAddUserAccount(utilMsgSml);
                break;
            }
            case 5: {
                this.saveRemoveUserAccount(utilMsgSml);
                break;
            }
            case 6: {
                this.saveChangePassword(utilMsgSml);
            }
        }
    }

    private void saveUserAccountList(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.AllResponsesOk()) {
            String string = utilMsgSml.getResponse(0).getResponse();
            this.updatedUserAccountList.add(new UserAccount(string));
            utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setGroupKey(1);
            utilMsgSml.addSmlCommand("Oper.Switch.NextPotentialUser." + string);
            this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
        } else if (utilMsgSml.getErrorType().getError() == 24) {
            this.sanbox2.setUserAccountList(this.updatedUserAccountList);
            this.sanbox2.eventHandler.fireChassisEvent(362, null, true);
            this.updateUserAccountAdminAuthority();
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(362, null, false);
            this.sanbox2.setUserAccountListUpdateInProgress(false);
            this.sanbox2.eventHandler.fireChassisEvent(367, null, false);
        }
    }

    private void saveUserAccountAdminAuthority(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.AllResponsesOk()) {
            int n = utilMsgSml.getNumberOfResponses();
            int n2 = 0;
            while (n2 < n) {
                boolean bl = utilMsgSml.getResponse(n2).getResponse().equals("True");
                String string = utilMsgSml.getRequest(n2).getRequestWord(3);
                this.sanbox2.setUserAccountAdminAuthority(string, bl);
                ++n2;
            }
            this.sanbox2.eventHandler.fireChassisEvent(364, null, true);
            this.updateUserAccountExpiration();
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(364, null, false);
            this.sanbox2.setUserAccountListUpdateInProgress(false);
            this.sanbox2.eventHandler.fireChassisEvent(367, null, false);
        }
    }

    private void saveUserAccountExpiration(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.getIsSetCommand()) {
            if (utilMsgSml.AllResponsesOk()) {
                this.sanbox2.eventHandler.fireChassisEvent(366, null, true);
            } else {
                this.sanbox2.eventHandler.fireChassisEvent(366, null, utilMsgSml.getErrorType());
            }
        } else if (utilMsgSml.AllResponsesOk()) {
            int n = 0;
            int n2 = utilMsgSml.getNumberOfResponses();
            int n3 = 0;
            while (n3 < n2) {
                try {
                    n = Integer.parseInt(utilMsgSml.getResponse(n3).getResponse());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string = utilMsgSml.getRequest(n3).getRequestWord(3);
                this.sanbox2.setUserAccountExpiration(string, n);
                ++n3;
            }
            this.sanbox2.eventHandler.fireChassisEvent(365, null, true);
            this.sanbox2.setUserAccountListUpdateInProgress(false);
            this.sanbox2.eventHandler.fireChassisEvent(367, null, true);
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(365, null, false);
            this.sanbox2.setUserAccountListUpdateInProgress(false);
            this.sanbox2.eventHandler.fireChassisEvent(367, null, false);
        }
    }

    private void saveAddUserAccount(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.AllResponsesOk()) {
            this.sanbox2.eventHandler.fireChassisEvent(368, null, true);
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(368, null, utilMsgSml.getErrorType());
        }
    }

    private void saveRemoveUserAccount(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.AllResponsesOk()) {
            this.sanbox2.eventHandler.fireChassisEvent(369, null, true);
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(369, null, utilMsgSml.getErrorType());
        }
    }

    private void saveChangePassword(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.AllResponsesOk()) {
            this.sanbox2.eventHandler.fireChassisEvent(370, null, true);
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(370, null, utilMsgSml.getErrorType());
        }
    }

    protected void saveResponse(Object object) {
    }

    public String toString() {
        return "UserAccountsAttr: switch=" + this.theSwitch.getChassisName();
    }
}

