/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.archiver.Sanbox8000Archiver;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.switchAttributes.IoModulesAttr;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNotifySml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

public class Sanbox8000Sml
extends Sanbox2Sml
implements Sanbox8000 {
    public static final String[] bladeStates = new String[]{"Online", "Offline", "Diagnostics", "Down"};
    private static final int NUMBER_OF_BLADES = 8;
    private Sanbox8000Blade[] blades = new Sanbox8000Blade[8];
    private Sanbox8000Archiver sanbox8000Archiver = new Sanbox8000Archiver();

    public Sanbox8000Sml(UtilMsgVersionReq utilMsgVersionReq, UtilAgent utilAgent) {
        super(utilMsgVersionReq, utilAgent);
        this.initalizeBlades();
    }

    public Sanbox8000Sml(String string, WorldWideName worldWideName, int n, UtilAgent utilAgent) {
        super(string, worldWideName, n, utilAgent);
        this.initalizeBlades();
    }

    private void initalizeBlades() {
        int n = 0;
        while (n < 8) {
            this.blades[n] = new Sanbox8000Blade(this, n);
            ++n;
        }
    }

    public int getNumberOfBlades() {
        return 8;
    }

    public Sanbox8000Blade getBlade(int n) {
        return this.blades[n];
    }

    public boolean applyBladeConfigAdminStates(Vector vector, int n) {
        int[] nArray = new int[vector.size()];
        Arrays.fill(nArray, n);
        IoModulesAttr ioModulesAttr = (IoModulesAttr)this.getAttr(330);
        return ioModulesAttr.applyConfigAdminStates(vector, nArray);
    }

    public boolean applyBladeConfigAdminStates(Vector vector, int[] nArray) {
        IoModulesAttr ioModulesAttr = (IoModulesAttr)this.getAttr(330);
        return ioModulesAttr.applyConfigAdminStates(vector, nArray);
    }

    public boolean applyBladeOperAdminStates(Vector vector, int n) {
        int[] nArray = new int[vector.size()];
        Arrays.fill(nArray, n);
        IoModulesAttr ioModulesAttr = (IoModulesAttr)this.getAttr(330);
        return ioModulesAttr.applyOperAdminStates(vector, nArray);
    }

    public boolean applyBladeOperAdminStates(Vector vector, int[] nArray) {
        IoModulesAttr ioModulesAttr = (IoModulesAttr)this.getAttr(330);
        return ioModulesAttr.applyOperAdminStates(vector, nArray);
    }

    public boolean resetBlades(Vector vector) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(96);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        int n = 0;
        while (n < vector.size()) {
            Sanbox8000Blade sanbox8000Blade = (Sanbox8000Blade)vector.elementAt(n);
            utilMsgSml.addSmlCommand("Cmd.Blade." + sanbox8000Blade.getSlotNumber() + ".Reset");
            ++n;
        }
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean testBlades(Vector vector) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(97);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        int n = 0;
        while (n < vector.size()) {
            Sanbox8000Blade sanbox8000Blade = (Sanbox8000Blade)vector.elementAt(n);
            utilMsgSml.addSmlCommand("Cmd.Blade." + sanbox8000Blade.getSlotNumber() + ".AdminState." + bladeStates[2]);
            utilMsgSml.addSmlCommand("Cmd.Blade." + sanbox8000Blade.getSlotNumber() + ".Test");
            ++n;
        }
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public void bladeTestDone(UtilMsgNotifySml utilMsgNotifySml) {
        String string = utilMsgNotifySml.getResponse(3).getResponse();
        int n = Sanbox8000Sml.slotToBlade(Integer.parseInt(string));
        Sanbox8000Blade sanbox8000Blade = this.getBlade(n);
        String string2 = utilMsgNotifySml.getResponse(5).getResponse();
        sanbox8000Blade.setBladeTestStatus(string2.equals("Passed") ? 3 : 4);
        this.getEventHandler().fireChassisEvent(341, (Object)new Integer(n), string2.equals("Passed"));
    }

    public SanboxChassisArchiver getArchiver() {
        return this.sanbox8000Archiver;
    }

    protected void createAttrs() {
        super.createAttrs();
        this.attributes.add(new IoModulesAttr(this));
        Collections.sort(this.attributes);
    }

    public void receiveMessage(UtilMessage utilMessage) {
        super.receiveMessage(utilMessage);
        if (utilMessage instanceof UtilMsgSml) {
            UtilMsgSml utilMsgSml = (UtilMsgSml)utilMessage;
            switch (utilMsgSml.getGroupKey()) {
                case 96: {
                    this.eventHandler.fireChassisEvent(338, null, utilMsgSml.getErrorType());
                    break;
                }
                case 97: {
                    if (utilMsgSml.AllResponsesOk()) {
                        int n = 2;
                        while (n < utilMsgSml.getNumberOfResponses()) {
                            String string = utilMsgSml.getRequest(n).getRequestWord(2);
                            int n2 = Integer.parseInt(string);
                            int n3 = Sanbox8000Sml.slotToBlade(n2);
                            this.getBlade(n3).setBladeTestStatus(2);
                            n += 2;
                        }
                    }
                    this.eventHandler.fireChassisEvent(339, null, utilMsgSml.getErrorType());
                    break;
                }
                case 119: {
                    FabricUtilities.logMessage(utilMsgSml.getDataTransfered());
                    this.eventHandler.fireChassisEvent(371, null, utilMsgSml.getErrorType());
                    break;
                }
                case 120: {
                    FabricUtilities.logMessage(utilMsgSml.getDataTransfered());
                    this.eventHandler.fireChassisEvent(372, null, utilMsgSml.getErrorType());
                    break;
                }
                case 121: {
                    FabricUtilities.logMessage(utilMsgSml.getDataTransfered());
                    this.eventHandler.fireChassisEvent(373, null, utilMsgSml.getErrorType());
                    break;
                }
                case 122: {
                    FabricUtilities.logMessage(utilMsgSml.getDataTransfered());
                    this.eventHandler.fireChassisEvent(374, null, utilMsgSml.getErrorType());
                    break;
                }
                case 123: {
                    this.eventHandler.fireChassisEvent(375, null, utilMsgSml.getErrorType());
                }
            }
        }
    }

    public static int slotToBlade(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return n - 1;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return n - 2;
            }
        }
        return -1;
    }

    public boolean updateIOModules() {
        IoModulesAttr ioModulesAttr = (IoModulesAttr)this.getAttr(330);
        return ioModulesAttr.update();
    }

    public static int translateOperState(String string) {
        if (string.equals("Online")) {
            return 0;
        }
        if (string.equals("Offline")) {
            return 1;
        }
        if (string.equals("NotInstalled")) {
            return 4;
        }
        if (string.equals("Diagnostics")) {
            return 2;
        }
        if (string.equals("Downed")) {
            return 3;
        }
        return 5;
    }

    public static int translateDiagStatus(String string) {
        if (string.equals("Passed")) {
            return 1;
        }
        if (string.equals("Failed")) {
            return 2;
        }
        if (string.equals("Compromised")) {
            return 3;
        }
        return 0;
    }

    public static int translateTempStatus(String string) {
        if (string.equals("Normal")) {
            return 1;
        }
        if (string.equals("Warm")) {
            return 2;
        }
        if (string.equals("Overheating")) {
            return 3;
        }
        return 0;
    }

    public static int translateBladeState(String string) {
        if (string.equals("Good")) {
            return 1;
        }
        if (string.equals("Bad")) {
            return 2;
        }
        if (string.equals("NotInstalled")) {
            return 3;
        }
        return 0;
    }

    public boolean applyBladeRemove(int n) {
        this.applySessionTimer(false);
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(119);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdminLock");
        utilMsgSml.addSmlCommand("Cmd.Blade." + n + ".Remove");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyBladeInsert(int n, boolean bl) {
        this.applySessionTimer(false);
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(121);
        if (bl) {
            utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdminLock");
        }
        utilMsgSml.addSmlCommand("Cmd.Blade." + n + ".Insert");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyBladeCancelRemove(int n) {
        this.applySessionTimer(false);
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(119);
        utilMsgSml.addSmlCommand("Cmd.Blade." + n + ".CancelRemove");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyBladeCancelInsert(int n) {
        this.applySessionTimer(false);
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(121);
        utilMsgSml.addSmlCommand("Cmd.Blade." + n + ".CancelInsert");
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyBladeRemoved(int n) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(120);
        utilMsgSml.addSmlCommand("Cmd.Blade." + n + ".Removed");
        utilMsgSml.setWaitAfterSend(8000);
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyBladeInserted(int n) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(122);
        utilMsgSml.addSmlCommand("Cmd.Blade." + n + ".Inserted");
        utilMsgSml.setWaitAfterSend(8000);
        utilMsgSml.setSetCommand();
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean updateBladeDiagnosticStatus(int n) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this, this);
        utilMsgSml.setGroupKey(123);
        utilMsgSml.addSmlCommand("Oper.Blade." + n + ".DiagStatus");
        return this.utilAgent.sendSml(utilMsgSml);
    }
}

