/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.EPortEntry;
import com.qlogic.device.fcfabric.EPortEntryList;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.util.InconsistentEPortTopologyException;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgEPortTopology;

public class SanboxTopologyUtil
implements UtilEventListener {
    public static final int E_PORT_TOPO_RETRY = 2;
    SanboxUtil dest;
    UtilAgent comAgent;
    ChassisEventHandler eventHandler;
    int ePortTopoRetryCount;
    int ePortFabricIncarnation;
    boolean firstEPortFabricIncarnation = true;
    EPortEntryList tmpLsdb;

    SanboxTopologyUtil(UtilAgent utilAgent, SanboxUtil sanboxUtil, ChassisEventHandler chassisEventHandler) {
        this.comAgent = utilAgent;
        this.dest = sanboxUtil;
        this.eventHandler = chassisEventHandler;
    }

    public boolean updateEPortTopology() {
        return this.comAgent.getEPortTopology(this.dest, this, 0, (short)0);
    }

    public void receiveMessage(UtilMessage utilMessage) {
        if (utilMessage instanceof UtilMsgEPortTopology) {
            this.saveEPortTopology((UtilMsgEPortTopology)utilMessage);
        }
    }

    public void saveEPortTopology(UtilMsgEPortTopology utilMsgEPortTopology) {
        int n = utilMsgEPortTopology.getStatus();
        if (n != 103) {
            this.eventHandler.fireChassisEvent(232, null, false);
            return;
        }
        if (this.tmpLsdb == null) {
            this.tmpLsdb = new EPortEntryList();
        }
        EPortEntryList ePortEntryList = utilMsgEPortTopology.getEPortList();
        if (utilMsgEPortTopology.getMoreDomains() == 1) {
            int n2 = utilMsgEPortTopology.getStartDomain();
            EPortEntry ePortEntry = ePortEntryList.getEntry(ePortEntryList.size() - 1);
            short s = 0;
            if (n2 == ePortEntry.getDomainId()) {
                s = (short)ePortEntry.getLinkResponseCount();
            }
            this.comAgent.getEPortTopology(this.dest, this, n2, s);
        }
        if (this.firstEPortFabricIncarnation) {
            this.ePortFabricIncarnation = utilMsgEPortTopology.getFabricIncarnation();
            this.firstEPortFabricIncarnation = false;
            try {
                this.addLsdbEntries(ePortEntryList);
            }
            catch (InconsistentEPortTopologyException inconsistentEPortTopologyException) {
                ++this.ePortTopoRetryCount;
                this.firstEPortFabricIncarnation = true;
                this.comAgent.getEPortTopology(this.dest, this, 0, (short)0);
            }
            if (utilMsgEPortTopology.getMoreDomains() == 0) {
                this.dest.setLsdb(this.tmpLsdb);
                this.eventHandler.fireChassisEvent(232, null, true);
                this.tmpLsdb = null;
            }
        } else if (this.ePortFabricIncarnation == utilMsgEPortTopology.getFabricIncarnation()) {
            try {
                this.addLsdbEntries(ePortEntryList);
            }
            catch (InconsistentEPortTopologyException inconsistentEPortTopologyException) {
                if (this.ePortTopoRetryCount < 2) {
                    ++this.ePortTopoRetryCount;
                    this.firstEPortFabricIncarnation = true;
                    this.comAgent.getEPortTopology(this.dest, this, 0, (short)0);
                }
                this.eventHandler.fireChassisEvent(232, null, false);
                this.firstEPortFabricIncarnation = true;
                this.ePortTopoRetryCount = 0;
                this.tmpLsdb = null;
            }
            if (utilMsgEPortTopology.getMoreDomains() == 0) {
                this.dest.setLsdb(this.tmpLsdb);
                this.tmpLsdb = null;
                this.eventHandler.fireChassisEvent(232, null, true);
            }
        } else if (this.ePortFabricIncarnation != utilMsgEPortTopology.getFabricIncarnation() && this.ePortTopoRetryCount < 2) {
            ++this.ePortTopoRetryCount;
            this.firstEPortFabricIncarnation = true;
            this.comAgent.getEPortTopology(this.dest, this, 0, (short)0);
        } else {
            this.eventHandler.fireChassisEvent(232, null, false);
            this.firstEPortFabricIncarnation = true;
            this.ePortTopoRetryCount = 0;
            this.tmpLsdb = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLsdbEntries(EPortEntryList ePortEntryList) throws InconsistentEPortTopologyException {
        if (ePortEntryList == null) {
            return;
        }
        int n = ePortEntryList.size();
        int n2 = 0;
        while (n2 < n) {
            EPortEntry ePortEntry = (EPortEntry)ePortEntryList.elementAt(n2);
            int n3 = this.tmpLsdb.indexOf(ePortEntry);
            if (n3 != -1) {
                EPortEntry ePortEntry2 = this.dest.getLsdb().getEntry(n3);
                if (ePortEntry2.getIncarnation() != ePortEntry.getIncarnation()) throw new InconsistentEPortTopologyException();
                int n4 = ePortEntry.getLinkResponseCount();
                while (n4 >= 0) {
                    ePortEntry2.addLink(ePortEntry.getLinkAt(n4));
                    --n4;
                }
            } else if (ePortEntry.getHops() != 255) {
                this.tmpLsdb.add(ePortEntry);
            }
            ++n2;
        }
    }
}

