/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;
import java.util.Vector;

public class UtilMsgAddZonesToZoneSet
extends UtilMsgConfig {
    String zoneSetName;
    Vector zones;
    byte seqNumber;
    byte zoneStatus = 0;
    boolean endOfZones;
    private static final int AZZS_ZONE_SET_NAME_LENGTH_OFFSET = 0;
    private static final int AZZS_ZONE_SET_NAME_OFFSET = 4;
    private static final int AZZS_ZONES_OFFSET = 68;
    private static final int AZZS_NUMBER_OF_ZONES_OFFSET = 476;
    private static final int AZZS_END_OF_ZONES_OFFSET = 480;
    private static final int AZZS_STATUS_OFFSET = 481;
    private static final int AZZS_SEQ_NUM_OFFSET = 482;
    private static final int AZZS_ZONE_NAME_LENGTH = 64;
    private static final int AZZS_ZONE_LENGTH = 68;
    private static final int AZZS_ZONE_SET_LENGTH = 68;
    private static final int AZZS_ZONE_SET_NAME_LENGTH = 64;
    public static final int AZZS_MAX_ZONESET_CHANGE_PER_UTIL_MSG = 6;
    private static final int AZZS_REQ_DATA_LENGTH = 484;
    private static final int AZZS_RESP_DATA_LENGTH = 484;
    private static final int AZZS_EXT_COMMAND = 776;

    public UtilMsgAddZonesToZoneSet(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, Vector vector, byte by, boolean bl) {
        super(utilDestination, utilEventListener, 484, 776);
        this.zoneSetName = string;
        this.zones = vector;
        this.seqNumber = by;
        this.endOfZones = bl;
    }

    public boolean getIsSetCommand() {
        return true;
    }

    public boolean setGetCommand() {
        return false;
    }

    public boolean setSetCommand() {
        return true;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        if (this.zones.size() > 6) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = (byte)this.zoneSetName.length();
        UtilMessage.encodeString(this.zoneSetName, this.dataBuffer, n + 4, 65);
        int n2 = 0;
        while (n2 < this.zones.size()) {
            String string = (String)this.zones.elementAt(n2);
            this.dataBuffer[n + 68 + n2 * 68] = (byte)string.length();
            UtilMessage.encodeString(string, this.dataBuffer, n + 68 + n2 * 68 + 4, 65);
            ++n2;
        }
        UtilMessage.encodeInt(this.zones.size(), this.dataBuffer, n + 476);
        this.dataBuffer[n + 480] = this.endOfZones ? (byte)1 : 0;
        this.dataBuffer[n + 481] = 0;
        this.dataBuffer[n + 482] = this.seqNumber;
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (byArray.length == 484) {
                String string = UtilMessage.decodeString(byArray, 4, 64);
                if (!string.equals(this.zoneSetName)) {
                    this.setStatus(105);
                    return false;
                }
                this.zoneStatus = byArray[481];
                if (this.zoneStatus >= 20) {
                    this.setStatus(105);
                    return false;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    public String getZoneSetName() {
        return this.zoneSetName;
    }

    public byte getZoneStatus() {
        return this.zoneStatus;
    }

    public boolean getEndOfZones() {
        return this.endOfZones;
    }

    public byte getSeqNumber() {
        return this.seqNumber;
    }

    public Vector getZonesList() {
        return this.zones;
    }

    public String toString() {
        String string = super.toString() + new String("Add zones to zone set = " + this.zoneSetName + " zones=");
        int n = 0;
        while (n < this.zones.size()) {
            string = string + (String)this.zones.elementAt(n);
            if (n != this.zones.size() - 1) {
                string = string + ",";
            }
            ++n;
        }
        return string;
    }
}

