/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgChassisStatusReq
extends UtilMessage {
    int firstPortAddress;
    byte numberOfPorts;
    byte powerSupplyFailed;
    byte inOrderDeliveryOn;
    byte boardHeatStatus;
    int boardTemperature;
    byte fan1Installed;
    byte fan2Installed;
    byte fan1Failed;
    byte fan2Failed;
    byte[] gbicTypes;
    int[] portFcAddress;
    private static final int CSR_FIRST_PORT_OFFSET = 0;
    private static final int CSR_NUMBER_OF_PORTS_OFFSET = 4;
    private static final int CSR_POWER_SUPPLY_FAILED_OFFSET = 5;
    private static final int CSR_IN_ORDER_DELIVERY_OFFSET = 6;
    private static final int CSR_BOARD_HEAT_STATUS__OFFSET = 7;
    private static final int CSR_BOARD_TEMPATURE_OFFSET = 8;
    private static final int CSR_FAN1_INSTALLED_OFFSET = 12;
    private static final int CSR_FAN2_INSTALLED_OFFSET = 13;
    private static final int CSR_FAN1_FAILED_OFFSET = 14;
    private static final int CSR_FAN2_FAILED_OFFSET = 15;
    private static final int CSR_GBIC_OFFSET = 16;
    private static final int CSR_REQ_DATA_LENGTH = 0;
    private static final int CSR_REQ_COMMAND = 18;
    private static final int CSR_RESP_DATA_LENGTH = 16;

    public UtilMsgChassisStatusReq(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 18, utilEventListener, 0);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        this.command = 18;
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 16) {
            this.firstPortAddress = UtilMessage.decodeInt(byArray, 0);
            this.numberOfPorts = byArray[4];
            this.powerSupplyFailed = byArray[5];
            this.inOrderDeliveryOn = byArray[6];
            this.boardHeatStatus = byArray[7];
            this.boardTemperature = UtilMessage.decodeInt(byArray, 8);
            this.fan1Installed = byArray[12];
            this.fan2Installed = byArray[13];
            this.fan1Failed = (byte)(byArray[14] == 0 ? 0 : 2);
            this.fan2Failed = (byte)(byArray[15] == 0 ? 0 : 2);
            this.gbicTypes = new byte[this.numberOfPorts];
            this.portFcAddress = new int[this.numberOfPorts];
            if (byArray.length >= 16 + this.numberOfPorts * 5) {
                int n = 0;
                while (n < this.numberOfPorts) {
                    this.gbicTypes[n] = byArray[16 + n];
                    this.portFcAddress[n] = UtilMessage.decodeInt(byArray, 16 + this.numberOfPorts + n * 4);
                    ++n;
                }
                return true;
            }
        }
        this.setStatus(105);
        return false;
    }

    public int getFirstPortAddress() {
        return this.firstPortAddress;
    }

    public byte getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public byte getPowerSupplyFailed() {
        return this.powerSupplyFailed;
    }

    public byte getInOrderDeliveryOn() {
        return this.inOrderDeliveryOn;
    }

    public byte getBoardHeatStatus() {
        return this.boardHeatStatus;
    }

    public int getBoardTemperature() {
        return this.boardTemperature;
    }

    public byte getFan1Installed() {
        return this.fan1Installed;
    }

    public byte getFan2Installed() {
        return this.fan2Installed;
    }

    public byte getFan1Failed() {
        return this.fan1Failed;
    }

    public byte getFan2Failed() {
        return this.fan2Failed;
    }

    public byte getGbicTypes(int n) {
        return this.gbicTypes[n];
    }

    public int getPortFcAddress(int n) {
        return this.portFcAddress[n];
    }

    public String toString() {
        String string = super.toString() + new String("CHASSIS STATUS REQUEST\nfirstPortAddress = " + Integer.toHexString(this.firstPortAddress) + "\n" + "numberOfPorts = " + this.numberOfPorts + "\n" + "powerSupplyFailed = " + this.powerSupplyFailed + "\n" + "inOrderDeliveryOn = " + this.inOrderDeliveryOn + "\n" + "boardHeatStatus = " + this.boardHeatStatus + "\n" + "boardTemperature = " + this.boardTemperature + "\n" + "fan1Installed = " + this.fan1Installed + "\n" + "fan2Installed = " + this.fan2Installed + "\n" + "fan1Failed = " + this.fan1Failed + "\n" + "fan1Failed = " + this.fan1Failed + "\n");
        int n = 0;
        while (n < this.numberOfPorts) {
            string = string + new String("gbicType[" + n + "] = " + this.gbicTypes[n] + "\n" + "portFcAddress[" + n + "]=" + Integer.toHexString(this.portFcAddress[n]) + "\n");
            ++n;
        }
        return string;
    }
}

