/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;
import java.util.Vector;

public class UtilMsgGetZoneMembers
extends UtilMsgConfig {
    String zoneName;
    int startIndex;
    Vector memberList = null;
    boolean endOfData = false;
    private static final int GZM_ZONE_NAME_LENGTH_OFFSET = 0;
    private static final int GZM_ZONE_NAME_OFFSET = 4;
    private static final int GZM_START_INDEX_OFFSET = 68;
    private static final int GZM_NUMBER_OF_MEMBERS_OFFSET = 70;
    private static final int GZM_STATUS_OFFSET = 71;
    private static final int GZM_END_OF_DATA_OFFSET = 72;
    private static final int GZM_MEMBER_LIST_OFFSET = 76;
    private static final int GZM_ZONE_NAME_LENGTH = 64;
    private static final int GZM_MEMBER_LENGTH = 12;
    private static final int GZM_MEMBER_DATA_LENGTH = 8;
    private static final int GZM_REQ_DATA_LENGTH = 76;
    private static final int GZM_RESP_DATA_LENGTH = 484;
    private static final int GZM_EXT_COMMAND = 773;
    private static final int MAX_ZONE_MEMBER_ENTRY_PER_UTIL_MSG = 6;
    private static final int MEMBER_TYPE_N_PORT_NAME = 1;
    private static final int MEMBER_TYPE_DOMAIN_ID_PORT = 2;
    private static final int MEMBER_TYPE_N_PORT_ADDRESS_ID = 3;
    private static final int MEMBER_TYPE_NODE_NAME = 4;

    public UtilMsgGetZoneMembers(UtilDestination utilDestination, UtilEventListener utilEventListener, String string, int n) {
        super(utilDestination, utilEventListener, 76, 773);
        this.zoneName = string;
        this.startIndex = n;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = (byte)this.zoneName.length();
        UtilMessage.encodeString(this.zoneName, this.dataBuffer, n + 4, 65);
        UtilMessage.encodeShort(this.startIndex, this.dataBuffer, n + 68);
        this.dataBuffer[n + 70] = 6;
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (byArray.length == 484) {
                String string = UtilMessage.decodeString(byArray, 4, 64);
                if (!string.equals(this.zoneName)) {
                    this.setStatus(105);
                    return false;
                }
                short s = UtilMessage.decodeShort(byArray, 68);
                if (this.startIndex != s) {
                    this.setStatus(105);
                    return false;
                }
                this.endOfData = byArray[72] == 1;
                int n = byArray[70];
                this.memberList = new Vector();
                int n2 = 0;
                while (n2 < n) {
                    int n3 = 76 + n2 * 12;
                    byte by = byArray[n3];
                    switch (by) {
                        case 1: 
                        case 4: {
                            byte[] byArray2 = new byte[8];
                            UtilMessage.byteCopy(byArray2, 0, byArray, n3 + 4, 8);
                            string = this.byteArrayToStr(byArray2);
                            this.memberList.add(string);
                            break;
                        }
                        case 2: {
                            byte[] byArray2 = new byte[]{byArray[76 + n2 * 12 + 6], (byte)UtilMessage.decodeShort(byArray, n3 + 4)};
                            string = this.byteArrayToStr(byArray2);
                            this.memberList.add(string);
                            break;
                        }
                        case 3: {
                            byte[] byArray2 = new byte[3];
                            UtilMessage.byteCopy(byArray2, 0, byArray, n3 + 5, 3);
                            string = this.byteArrayToStr(byArray2);
                            this.memberList.add(string);
                            break;
                        }
                        default: {
                            this.setStatus(105);
                            return false;
                        }
                    }
                    ++n2;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    private String byteArrayToStr(byte[] byArray) {
        String string = new String();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            String string2 = Integer.toHexString(n2);
            while (string2.length() < 2) {
                string2 = "0" + string2;
            }
            string = string + string2;
            ++n;
        }
        return string;
    }

    public Vector getMemberList() {
        return this.memberList;
    }

    public int getNumberOfMembers() {
        return this.memberList.size();
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean getEndOfData() {
        return this.endOfData;
    }

    public int getStartIndex() {
        return this.startIndex;
    }
}

