/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public abstract class UtilMsgNameServer
extends UtilMessage {
    int requestCode;
    byte sequenceComplete;
    byte messageRejected;
    byte reasonCode;
    byte reasonExplanation;
    int entryIndex;
    byte numberOfPorts;
    byte portNumber;
    private static final int NSR_REQUEST_CODE_OFFSET = 0;
    private static final int NSR_SEQUENCE_COMPLETE_OFFSET = 4;
    private static final int NSR_MESSAGE_REJECTED_OFFSET = 5;
    private static final int NSR_REASON_CODE_OFFSET = 6;
    private static final int NSR_REASON_EXPLANATION_OFFSET = 7;
    private static final int NSR_ENTRY_INDEX_OFFSET = 8;
    private static final int NSR_NUMBER_OF_PORTS_OFFSET = 10;
    private static final int NSR_PORT_NUMBER_OFFSET = 11;
    protected static final int NSR_DATA_OFFSET = 12;
    private static final int NSR_HEADER_LENGTH = 12;
    private static final int NSR_COMMAND = 51;

    protected UtilMsgNameServer(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, int n2, byte by) {
        super(utilDestination, 51, utilEventListener, n + 12);
        this.requestCode = n2;
        this.entryIndex = by;
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeInt(this.requestCode, this.dataBuffer, n + 0);
        this.dataBuffer[n + 4] = 0;
        this.dataBuffer[n + 5] = 0;
        this.dataBuffer[n + 6] = 0;
        this.dataBuffer[n + 7] = 0;
        UtilMessage.encodeShort(this.entryIndex, this.dataBuffer, n + 8);
        this.dataBuffer[n + 10] = 0;
        this.dataBuffer[n + 11] = 0;
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 11) {
            this.requestCode = UtilMessage.decodeInt(byArray, 0);
            this.sequenceComplete = byArray[4];
            this.messageRejected = byArray[5];
            this.reasonCode = byArray[6];
            this.reasonExplanation = byArray[7];
            this.entryIndex = UtilMessage.decodeShort(byArray, 8);
            this.numberOfPorts = byArray[10];
            this.portNumber = byArray[11];
            return true;
        }
        this.setStatus(105);
        return false;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public byte getSequenceComplete() {
        return this.sequenceComplete;
    }

    public byte getMessageRejected() {
        return this.messageRejected;
    }

    public byte getReasonCode() {
        return this.reasonCode;
    }

    public byte getReasonExplanation() {
        return this.reasonExplanation;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    public byte getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public byte getPortNumber() {
        return this.portNumber;
    }

    public String toString() {
        return super.toString() + new String("NAME SERVER REQUEST \nrequestCode = " + this.requestCode + "\n" + "sequenceComplete = " + this.sequenceComplete + "\n" + "messageRejected = " + this.messageRejected + "\n" + "reasonCode = " + this.reasonCode + "\n" + "reasonExplanation = " + this.reasonExplanation + "\n" + "entryIndex = " + this.entryIndex + "\n" + "numberOfPorts = " + this.numberOfPorts + "\n" + "portNumber = " + this.portNumber + "\n");
    }
}

