/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNameServer;
import java.net.InetAddress;

public class UtilMsgNameServerGetAllNextFabricUnzoned
extends UtilMsgNameServer {
    int fcAddress;
    byte portType;
    int portFcAddress;
    long worldWideName;
    String portName;
    long nodeWorldWideName;
    String nodeName;
    int[] processAssociator = new int[2];
    InetAddress[] ipAddress;
    int classOfService;
    int[] fc4Types = new int[8];
    public static final int NS_GAN_REQ_LENGTH = 4;
    public static final int NS_GAN_REQ_CODE = 28;
    public static final int NS_GAN_PORT_TYPE_OFFSET = 12;
    public static final int NS_GAN_PORT_FC_ADDRESS = 12;
    public static final int NS_GAN_WWN = 16;
    public static final int NS_GAN_PORT_NAME_LENGTH = 24;
    public static final int NS_GAN_PORT_NAME_ARRAY = 25;
    public static final int NS_GAN_NODE_WWN_OFFSET = 152;
    public static final int NS_GAN_NODE_LENGTH_OFFSET = 160;
    public static final int NS_GAN_NODE_ARRAY_OFFSET = 161;
    public static final int NS_GAN_PROCESS_ASSOCIATORS_OFFSET = 288;
    public static final int NS_GAN_IP_ADDRESSES_OFFSET = 296;
    public static final int NS_GAN_CLASS_OF_SERVICE_OFFSET = 312;
    public static final int NS_GAN_FC4_TYPES_OFFSET = 316;
    public static final int NS_GAN_TIMEOUT = 4000;

    public UtilMsgNameServerGetAllNextFabricUnzoned(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        super(utilDestination, utilEventListener, 4, 28, (byte)0);
        this.fcAddress = n;
        this.timeoutValue = 4000;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeInt(this.fcAddress, this.dataBuffer, n + 12);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        byte[] byArray;
        if (!super.unpack()) {
            return false;
        }
        if (this.messageRejected == 0 && (byArray = this.getResponsePayloadData()) != null && byArray.length >= 348) {
            this.portType = byArray[12];
            byArray[12] = 0;
            this.portFcAddress = UtilMessage.decodeInt(byArray, 12);
            byArray[12] = this.portType;
            this.worldWideName = UtilMessage.decodeLong(byArray, 16);
            int n = byArray[24];
            if (n < 0) {
                n += 256;
            }
            if (n > 127) {
                n = 127;
            }
            this.portName = new String();
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            int n2 = 0;
            while (n2 < n) {
                cArray[0] = (char)byArray[25 + n2];
                if (cArray[0] == '\u0000') break;
                this.portName = this.portName + new String(cArray);
                ++n2;
            }
            this.nodeWorldWideName = UtilMessage.decodeLong(byArray, 152);
            int n3 = byArray[160];
            if (n3 < 0) {
                n3 += 256;
            }
            if (n3 > 127) {
                n3 = 127;
            }
            this.nodeName = new String();
            cArray = new char[2];
            cArray[1] = '\u0000';
            int n4 = 0;
            while (n4 < n3) {
                cArray[0] = (char)byArray[161 + n4];
                if (cArray[0] == '\u0000') break;
                this.nodeName = this.nodeName + new String(cArray);
                ++n4;
            }
            this.processAssociator = new int[2];
            this.processAssociator[0] = UtilMessage.decodeInt(byArray, 288);
            this.processAssociator[1] = UtilMessage.decodeInt(byArray, 292);
            this.ipAddress = new InetAddress[4];
            int n5 = 0;
            while (n5 < 4) {
                try {
                    this.ipAddress[n5] = InetAddress.getByName(UtilMessage.ipConvert(UtilMessage.decodeInt(byArray, 296 + n5 * 4)));
                }
                catch (Exception exception) {
                    this.ipAddress[n5] = null;
                }
                ++n5;
            }
            this.classOfService = UtilMessage.decodeInt(byArray, 312);
            this.fc4Types = new int[8];
            int n6 = 0;
            while (n6 < 8) {
                this.fc4Types[n6] = UtilMessage.decodeInt(byArray, 316 + n6 * 4);
                ++n6;
            }
            return true;
        }
        return false;
    }

    public int getReqFcAddress() {
        return this.fcAddress;
    }

    public byte getPortType() {
        return this.portType;
    }

    public int getPortAddress() {
        return this.portFcAddress;
    }

    public long getWorldWideName() {
        return this.worldWideName;
    }

    public String getPortName() {
        return this.portName;
    }

    public long getNodeWorldWideName() {
        return this.nodeWorldWideName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getProcessAssociator(int n) {
        if (n >= 0 && n < this.processAssociator.length) {
            return this.processAssociator[n];
        }
        return 0;
    }

    public InetAddress getIpAddress(int n) {
        if (n >= 0 && n < this.ipAddress.length) {
            return this.ipAddress[n];
        }
        return null;
    }

    public int getClassOfService() {
        return this.classOfService;
    }

    public int getFc4Type(int n) {
        if (n >= 0 && n < this.fc4Types.length) {
            return this.fc4Types[n];
        }
        return 0;
    }

    public String toString() {
        int n;
        String string = super.toString();
        string = string + new String("GET NEXT ALL NEXT FABRIC UNZONED\nportType = " + this.portType + "\n" + "portFcAddress = " + Integer.toHexString(this.portFcAddress) + "\n" + "worldWideName = " + Long.toHexString(this.worldWideName) + "\n" + "portName = " + this.portName + "\n");
        string = string + new String("nodeWorldWideName = " + Long.toHexString(this.nodeWorldWideName) + "\n" + "nodeName = " + this.nodeName + "\n" + "processAssociator[0] = " + this.processAssociator[0] + "\n" + "processAssociator[1] = " + this.processAssociator[1] + "\n");
        if (this.ipAddress != null) {
            n = 0;
            while (n < this.ipAddress.length) {
                string = string + new String(" " + this.ipAddress[n].getHostAddress() + ",");
                ++n;
            }
        }
        string = string + new String("classOfService = " + this.classOfService + "\n");
        if (this.fc4Types != null) {
            n = 0;
            while (n < this.fc4Types.length) {
                string = string + new String("Fc4Type[" + n + "]= " + this.fc4Types[n] + ",");
                ++n;
            }
        }
        string = string + "\n";
        return string;
    }
}

