/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public abstract class UtilMsgOLT
extends UtilMessage {
    protected static final int OLT_COMMAND = 49;
    protected static final int EXT_COMMAND_OFFSET = 0;
    protected static final int OLT_DATA_OFFSET = 4;
    int extCommand;

    public UtilMsgOLT(UtilDestination utilDestination, UtilEventListener utilEventListener, int n, int n2) {
        super(utilDestination, 49, utilEventListener, n);
        this.extCommand = n2;
    }

    public int getExtCommand() {
        return this.extCommand;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset() - 4;
        UtilMessage.encodeInt(this.extCommand, this.dataBuffer, n);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = super.getResponsePayloadData();
        if (byArray != null && byArray.length >= 4) {
            if (UtilMessage.decodeInt(byArray, 0) != this.extCommand) {
                this.setStatus(105);
                return false;
            }
            return true;
        }
        this.setStatus(105);
        return false;
    }

    void setDataLength(int n) {
        super.setDataLength(n + 4);
    }

    public byte[] getResponsePayloadData() {
        byte[] byArray = super.getResponsePayloadData();
        if (byArray != null) {
            if (UtilMessage.decodeInt(byArray, 0) != this.extCommand) {
                this.setStatus(105);
                return null;
            }
            byte[] byArray2 = new byte[byArray.length - 4];
            int n = 0;
            while (n < byArray2.length) {
                byArray2[n] = byArray[n + 4];
                ++n;
            }
            return byArray2;
        }
        return null;
    }

    public int getSendPayloadDataOffset() {
        int n = super.getSendPayloadDataOffset();
        if (n != -1) {
            return n + 4;
        }
        return -1;
    }

    public String toString() {
        String string = super.toString() + new String("OLT MESSAGE: extCmd=" + this.extCommand);
        return string;
    }
}

