/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class UtilMsgSerialNumberSml
extends UtilMsgSml {
    private static final int MAX_SERIAL_NUMBER = 0x3FFFFFFF;
    int serialNumber;

    public UtilMsgSerialNumberSml(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl, int n) {
        super(utilDestination, utilEventListener);
        this.clearCommands();
        String string = "Config.System.";
        if (!bl) {
            this.addSmlCommand(string + "SerialNumber");
        } else {
            this.addSmlCommand("Cmd.Switch.ReqAdmin");
            this.addSmlCommand("Cmd.System.StartSetup");
            this.addSmlCommand(string + "SerialNumber." + n);
            this.addSmlCommand("Cmd.System.SaveSetup");
            this.addSmlCommand("Cmd.System.ActSetup");
            this.addSmlCommand("Cmd.Switch.RelAdmin");
            this.serialNumber = n;
            this.setSetCommand();
        }
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        if (this.AllResponsesOk()) {
            if (!this.getIsSetCommand()) {
                this.serialNumber = Integer.decode(this.getResponse(0).getResponse());
            }
        } else {
            this.setStatus(105);
        }
        return true;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + " SERIAL NUMBER ");
        stringBuffer.append(this.getIsSetCommand() ? "SET " : "GET ");
        stringBuffer.append("serialNumber = " + this.serialNumber + "\n");
        return stringBuffer.toString();
    }
}

