/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UtilMsgSnmpConfig
extends UtilMessage {
    String name;
    String contact;
    String location;
    int doAuthTrap;
    InetAddress snmpTrapAddress;
    private static final int SC_NAME_OFFSET = 0;
    private static final int SC_CONTACT_OFFSET = 64;
    private static final int SC_LOCATION_OFFSET = 128;
    private static final int SC_DO_AUTH_TRAP_OFFSET = 192;
    private static final int SC_TRAP_ADDRESS_OFFSET = 196;
    private static final int SC_REQ_DATA_LENGTH = 0;
    private static final int SC_SET_DATA_LENGTH = 200;
    private static final int SC_RESP_DATA_LENGTH = 200;
    private static final int UM_GET_SNMP_CONFIG = 134;
    private static final int UM_SET_SNMP_CONFIG = 135;

    public UtilMsgSnmpConfig() {
        super(null, 135, null, 200);
    }

    public UtilMsgSnmpConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 134, utilEventListener, 0);
    }

    public boolean setSetCommand() {
        this.command = 135;
        this.setDataLength(200);
        return true;
    }

    public boolean setGetCommand() {
        this.command = 134;
        this.setDataLength(0);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.command == 135;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        if (this.command == 135) {
            int n = this.getSendPayloadDataOffset();
            UtilMessage.encodeString(this.name, this.dataBuffer, n + 0, 64);
            UtilMessage.encodeString(this.contact, this.dataBuffer, n + 64, 64);
            UtilMessage.encodeString(this.location, this.dataBuffer, n + 128, 64);
            UtilMessage.encodeInt(this.doAuthTrap, this.dataBuffer, n + 192);
            int n2 = UtilMessage.inetToIp(this.snmpTrapAddress);
            UtilMessage.encodeInt(n2, this.dataBuffer, n + 196);
            this.encodeAndCalcCheckSum();
        }
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 200) {
            this.name = UtilMessage.decodeString(byArray, 0, 64);
            this.contact = UtilMessage.decodeString(byArray, 64, 64);
            this.location = UtilMessage.decodeString(byArray, 128, 64);
            this.doAuthTrap = UtilMessage.decodeInt(byArray, 192);
            int n = UtilMessage.decodeInt(byArray, 196);
            try {
                this.snmpTrapAddress = InetAddress.getByName(UtilMessage.ipConvert(n));
            }
            catch (UnknownHostException unknownHostException) {
                this.snmpTrapAddress = null;
            }
            return true;
        }
        if (this.getIsSetCommand()) {
            return true;
        }
        this.setStatus(105);
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public long getDoAuthTrap() {
        return this.doAuthTrap;
    }

    public void setDoAuthTrap(int n) {
        this.doAuthTrap = n;
    }

    public InetAddress getTrapAddress() {
        return this.snmpTrapAddress;
    }

    public void setTrapAddress(InetAddress inetAddress) {
        this.snmpTrapAddress = inetAddress;
    }

    public String toString() {
        return super.toString() + new String("SNMP CONFIG " + this.getIsSetCommand() + "\n" + "name = " + this.name + "\n" + "contact = " + this.contact + "\n" + "location = " + this.location + "\n" + "doAuthTrap = " + this.doAuthTrap + "\n" + "snmpTrapAddress = " + (this.snmpTrapAddress == null ? "null" : this.snmpTrapAddress.getHostAddress()) + "\n");
    }
}

