/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.SnmpTrapConfig;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.net.InetAddress;

public class UtilMsgSnmpConfigSml
extends UtilMsgSml {
    String contact;
    String location;
    String readComm;
    String writeComm;
    String trapComm;
    int doAuthTrap;
    boolean proxyEnabled;
    private InetAddress[] trapAddress = new InetAddress[5];
    private boolean[] trapEnabled = new boolean[5];
    private String[] trapSeverity = new String[5];
    private int[] trapPort = new int[5];
    private int[] trapVersion = new int[5];

    public UtilMsgSnmpConfigSml(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl, SnmpInfo snmpInfo) {
        super(utilDestination, utilEventListener);
        this.clearCommands();
        String string = "Config.Snmp.";
        if (!bl) {
            this.addSmlCommand(string + "Contact");
            this.addSmlCommand(string + "Location");
            this.addSmlCommand(string + "ReadComm");
            this.addSmlCommand(string + "WriteComm");
            this.addSmlCommand(string + "TrapComm");
            this.addSmlCommand(string + "TrapAuth");
            this.addSmlCommand(string + "TrapAddr");
            this.addSmlCommand(string + "TrapPort");
            this.addSmlCommand(string + "TrapSeverity");
            this.addSmlCommand(string + "TrapEnable");
            this.addSmlCommand(string + "TrapVersion");
            this.addSmlCommand(string + "TrapAddr1");
            this.addSmlCommand(string + "TrapPort1");
            this.addSmlCommand(string + "TrapSeverity1");
            this.addSmlCommand(string + "TrapEnable1");
            this.addSmlCommand(string + "TrapVersion1");
            this.addSmlCommand(string + "TrapAddr2");
            this.addSmlCommand(string + "TrapPort2");
            this.addSmlCommand(string + "TrapSeverity2");
            this.addSmlCommand(string + "TrapEnable2");
            this.addSmlCommand(string + "TrapVersion2");
            this.addSmlCommand(string + "TrapAddr3");
            this.addSmlCommand(string + "TrapPort3");
            this.addSmlCommand(string + "TrapSeverity3");
            this.addSmlCommand(string + "TrapEnable3");
            this.addSmlCommand(string + "TrapVersion3");
            this.addSmlCommand(string + "TrapAddr4");
            this.addSmlCommand(string + "TrapPort4");
            this.addSmlCommand(string + "TrapSeverity4");
            this.addSmlCommand(string + "TrapEnable4");
            this.addSmlCommand(string + "TrapVersion4");
            this.setGetCommand();
        } else {
            this.addSmlCommand("Cmd.Switch.ReqAdmin");
            this.addSmlCommand("Cmd.Snmp.StartSetup");
            this.addSmlCommand(string + "Contact." + snmpInfo.getContact());
            this.addSmlCommand(string + "Location." + snmpInfo.getLocation());
            this.addSmlCommand(string + "ReadComm." + snmpInfo.getReadComm());
            this.addSmlCommand(string + "WriteComm." + snmpInfo.getWriteComm());
            this.addSmlCommand(string + "TrapComm." + snmpInfo.getTrapComm());
            this.addSmlCommand(string + "TrapAuth." + this.translateAuth((int)snmpInfo.getDoAuthTrap()));
            int n = 0;
            while (n < 5) {
                SnmpTrapConfig snmpTrapConfig = snmpInfo.getSnmpTrapConfig(n);
                if (snmpTrapConfig != null) {
                    String string2 = "";
                    if (n > 0) {
                        string2 = new Integer(n).toString();
                    }
                    this.addSmlCommand(string + "TrapAddr" + string2 + "." + Sanbox2Sml.padIPAddr(snmpTrapConfig.getAddress()));
                    String string3 = new Integer(snmpTrapConfig.getPort()).toString();
                    this.addSmlCommand(string + "TrapPort" + string2 + "." + string3);
                    this.addSmlCommand(string + "TrapSeverity" + string2 + "." + snmpTrapConfig.getSeverity());
                    if (snmpTrapConfig.isEnabled()) {
                        this.addSmlCommand(string + "TrapEnable" + string2 + ".True");
                    } else {
                        this.addSmlCommand(string + "TrapEnable" + string2 + ".False");
                    }
                    this.addSmlCommand(string + "TrapVersion" + string2 + "." + snmpTrapConfig.getVersion());
                    this.trapAddress[n] = snmpTrapConfig.getAddress();
                    this.trapPort[n] = snmpTrapConfig.getPort();
                    this.trapSeverity[n] = snmpTrapConfig.getSeverity();
                    this.trapEnabled[n] = snmpTrapConfig.isEnabled();
                    this.trapVersion[n] = snmpTrapConfig.getVersion();
                }
                ++n;
            }
            this.contact = snmpInfo.getContact();
            this.location = snmpInfo.getLocation();
            this.readComm = snmpInfo.getReadComm();
            this.writeComm = snmpInfo.getWriteComm();
            this.trapComm = snmpInfo.getTrapComm();
            this.doAuthTrap = (int)snmpInfo.getDoAuthTrap();
            this.addSmlCommand("Cmd.Snmp.SaveSetup");
            this.addSmlCommand("Cmd.Snmp.ActSetup");
            this.addSmlCommand("Cmd.Switch.RelAdmin");
            this.setSetCommand();
            this.setTimeoutValue(3000);
        }
    }

    public String translateAuth(int n) {
        if (n == 1) {
            return "True";
        }
        if (n == 0) {
            return "False";
        }
        return "False";
    }

    public int translateAuth(String string) {
        if (string.equals("True")) {
            return 1;
        }
        if (string.equals("False")) {
            return 0;
        }
        return 0;
    }

    public boolean unpack() {
        String string = ((SanboxChassis)((Object)this.listener)).getChassisName();
        if (!super.unpack()) {
            return false;
        }
        if (this.AllResponsesOk()) {
            if (!this.getIsSetCommand()) {
                this.contact = this.getResponse(0).getResponse();
                this.location = this.getResponse(1).getResponse();
                this.doAuthTrap = 0;
                this.readComm = this.getResponse(2).getResponse();
                this.writeComm = this.getResponse(3).getResponse();
                this.trapComm = this.getResponse(4).getResponse();
                this.doAuthTrap = this.translateAuth(this.getResponse(5).getResponse());
                int n = 6;
                int n2 = 0;
                while (n2 < 5) {
                    String string2;
                    this.trapAddress[n2] = UtilMsgSml.smlStrToIpAdress(this.getResponse(n++).getResponse());
                    String string3 = this.getResponse(n++).getResponse();
                    this.trapPort[n2] = Integer.parseInt(string3);
                    this.trapSeverity[n2] = this.getResponse(n++).getResponse();
                    this.trapEnabled[n2] = (string2 = this.getResponse(n++).getResponse()).equals("True");
                    String string4 = this.getResponse(n++).getResponse();
                    this.trapVersion[n2] = Integer.parseInt(string4);
                    ++n2;
                }
            }
        } else {
            this.setStatus(105);
        }
        return true;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(boolean bl) {
        this.proxyEnabled = bl;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public String getReadComm() {
        return this.readComm;
    }

    public void setReadComm(String string) {
        this.readComm = string;
    }

    public String getWriteComm() {
        return this.writeComm;
    }

    public void setWriteComm(String string) {
        this.writeComm = string;
    }

    public String getTrapComm() {
        return this.trapComm;
    }

    public void setTrapComm(String string) {
        this.trapComm = string;
    }

    public long getDoAuthTrap() {
        return this.doAuthTrap;
    }

    public void setDoAuthTrap(int n) {
        this.doAuthTrap = n;
    }

    public void setTrapAddress(int n, InetAddress inetAddress) {
        this.trapAddress[n] = inetAddress;
    }

    public InetAddress getTrapAddress(int n) {
        return this.trapAddress[n];
    }

    public void setTrapPort(int n, int n2) {
        this.trapPort[n] = n2;
    }

    public int getTrapPort(int n) {
        return this.trapPort[n];
    }

    public void setTrapSeverity(int n, String string) {
        this.trapSeverity[n] = string;
    }

    public String getTrapSeverity(int n) {
        return this.trapSeverity[n];
    }

    public void setTrapEnabled(int n, boolean bl) {
        this.trapEnabled[n] = bl;
    }

    public boolean isTrapEnabled(int n) {
        return this.trapEnabled[n];
    }

    public void setTrapVersion(int n, int n2) {
        this.trapVersion[n] = n2;
    }

    public int getTrapVersion(int n) {
        return this.trapVersion[n];
    }
}

