/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.zoning;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.events.ZoneEvent;
import com.qlogic.device.fcfabric.zoning.events.ZoneListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class Zone
implements Serializable,
Comparable {
    public static final String[] zoneTypeStrings = new String[]{DeviceUtilities.getResource("Zone.softType"), DeviceUtilities.getResource("Zone.vpfType"), DeviceUtilities.getResource("Zone.aclType")};
    public static final int ZONE_TYPE_SOFT = 0;
    public static final int ZONE_TYPE_HARD_VPF = 1;
    public static final int ZONE_TYPE_HARD_ACL = 2;
    transient Vector listeners = new Vector();
    private boolean dirtyFlag = false;
    private String name;
    private int zoneType = 0;
    private Vector members = new Vector();
    private int numberOfSetIn = 0;
    private int maxMembers;

    protected Zone(String string, int n) {
        this.name = string;
        this.maxMembers = n;
    }

    public void removeListener(ZoneListener zoneListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            return;
        }
        if (this.listeners.contains(zoneListener)) {
            this.listeners.remove(zoneListener);
        }
    }

    public void addListener(ZoneListener zoneListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(zoneListener)) {
            this.listeners.add(zoneListener);
        }
    }

    private void fireEvent(ZoneEvent zoneEvent) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ZoneListener zoneListener = (ZoneListener)this.listeners.elementAt(n);
            zoneListener.zoneChanged(zoneEvent);
            ++n;
        }
    }

    protected void addedToSet() {
        ++this.numberOfSetIn;
    }

    protected void removedFromSet() {
        --this.numberOfSetIn;
    }

    protected boolean isOrphanZone() {
        return this.numberOfSetIn <= 0;
    }

    protected boolean getDirtyFlag() {
        return this.dirtyFlag;
    }

    protected void resetDirtyFlag() {
        this.dirtyFlag = false;
    }

    public int getZoneType() {
        return this.zoneType;
    }

    public void setZoneType(int n) {
        this.zoneType = n;
        this.dirtyFlag = true;
        this.fireEvent(new ZoneEvent(this, new Vector(), 3));
    }

    public String toString() {
        String string = DeviceUtilities.getResource("Zone.zone") + " " + this.name + " (" + zoneTypeStrings[this.getZoneType()] + ")";
        return string;
    }

    void setName(String string) {
        this.name = string;
        this.dirtyFlag = true;
        this.fireEvent(new ZoneEvent(this, new Vector(), 3));
    }

    public String getName() {
        return this.name;
    }

    protected boolean isMemberInZone(FCNode fCNode) {
        ZoneMember zoneMember = this.getFirstMember();
        while (zoneMember != null) {
            switch (zoneMember.getType()) {
                case 4: {
                    ZoneAlias zoneAlias = (ZoneAlias)zoneMember;
                    if (!zoneAlias.isMemberInZone(fCNode)) break;
                    return true;
                }
                case 3: {
                    if (!zoneMember.getMemberStorageString().equals(fCNode.getNPortZoningStr())) break;
                    return true;
                }
                case 2: {
                    if (!zoneMember.getMemberStorageString().equals(fCNode.getWwnZoningStr())) break;
                    return true;
                }
                case 1: {
                    String string = zoneMember.getMemberStorageString();
                    String string2 = fCNode.getNPortZoningStr();
                    if (!string.equals(string2.substring(0, 4))) break;
                    return true;
                }
            }
            zoneMember = this.getNextMember(zoneMember);
        }
        return false;
    }

    public boolean isMemberInZone(ZoneMember zoneMember, boolean bl) {
        if (this.getZoneMemberIndex(zoneMember) >= 0) {
            return true;
        }
        ZoneMember zoneMember2 = this.getFirstMember();
        while (zoneMember2 != null) {
            ZoneAlias zoneAlias;
            if (bl && zoneMember.getType() == 3 && zoneMember2.getType() == 1 && zoneMember.getMemberStorageString().substring(0, 4).equals(zoneMember2.getMemberStorageString())) {
                return true;
            }
            if (zoneMember2 instanceof ZoneAlias && (zoneAlias = (ZoneAlias)zoneMember2).isMemberInZone(zoneMember, bl)) {
                return true;
            }
            zoneMember2 = this.getNextMember(zoneMember2);
        }
        return false;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public int getMembersInZone() {
        int n = this.getMemberCount();
        ZoneMember zoneMember = this.getFirstMember();
        while (zoneMember != null) {
            if (zoneMember instanceof ZoneAlias) {
                ZoneAlias zoneAlias = (ZoneAlias)zoneMember;
                n += zoneAlias.getMemberCount();
                zoneMember = this.getNextMember(zoneMember);
                continue;
            }
            zoneMember = null;
        }
        return n;
    }

    public ZoneMember getFirstMember() {
        if (this.members.size() > 0) {
            return (ZoneMember)this.members.elementAt(0);
        }
        return null;
    }

    public ZoneMember getLastMember() {
        if (this.members.size() > 0) {
            return (ZoneMember)this.members.elementAt(this.members.size() - 1);
        }
        return null;
    }

    public ZoneMember getNextMember(ZoneMember zoneMember) {
        if (this.members.size() > 0) {
            int n = this.getZoneMemberIndex(zoneMember);
            if (n < 0) {
                return null;
            }
            if (n + 1 < this.members.size()) {
                return (ZoneMember)this.members.elementAt(n + 1);
            }
        }
        return null;
    }

    public ZoneMember getPrevMember(ZoneMember zoneMember) {
        if (this.members.size() > 0) {
            int n = this.getZoneMemberIndex(zoneMember);
            if (n < 0) {
                return null;
            }
            if (n - 1 >= 0) {
                return (ZoneMember)this.members.elementAt(n - 1);
            }
        }
        return null;
    }

    int addMembers(Vector vector) {
        Vector vector2 = new Vector();
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size() && n == 0) {
            int n3 = this.addMemberToThisZone((ZoneMember)vector.elementAt(n2));
            switch (n3) {
                case 105: {
                    break;
                }
                case 0: {
                    vector2.add(vector.elementAt(n2));
                    break;
                }
                default: {
                    n = n3;
                }
            }
            ++n2;
        }
        this.fireEvent(new ZoneEvent(this, vector2, 1));
        return n;
    }

    private int addMemberToThisZone(ZoneMember zoneMember) {
        if (this.getZoneMemberIndex(zoneMember) >= 0) {
            return 105;
        }
        if (this.members.size() >= this.maxMembers) {
            return 103;
        }
        this.dirtyFlag = true;
        if (zoneMember instanceof ZoneAlias) {
            ZoneAlias zoneAlias = (ZoneAlias)zoneMember;
            zoneAlias.incZonesIn();
        }
        if (this.members.size() == 0) {
            this.members.add(zoneMember);
            return 0;
        }
        int n = 0;
        int n2 = this.members.size() - 1;
        int n3 = (n + n2) / 2;
        boolean bl = false;
        while (!bl) {
            switch (n2 - n) {
                default: {
                    n3 = (n2 + n) / 2;
                    ZoneMember zoneMember2 = (ZoneMember)this.members.elementAt(n3);
                    if (zoneMember.compareTo(zoneMember2) < 0) {
                        n2 = n3;
                        break;
                    }
                    n = n3;
                    break;
                }
                case 0: {
                    ZoneMember zoneMember2 = (ZoneMember)this.members.elementAt(n);
                    n3 = zoneMember.compareTo(zoneMember2) < 0 ? n : n + 1;
                    bl = true;
                    break;
                }
                case 1: {
                    ZoneMember zoneMember2 = (ZoneMember)this.members.elementAt(n);
                    n3 = zoneMember.compareTo(zoneMember2) < 0 ? n : (zoneMember.compareTo(zoneMember2 = (ZoneMember)this.members.elementAt(n2)) < 0 ? n2 : n2 + 1);
                    bl = true;
                }
            }
        }
        this.members.insertElementAt(zoneMember, n3);
        return 0;
    }

    public int compareTo(Object object) {
        if (object instanceof Zone) {
            Zone zone = (Zone)object;
            int n = this.getName().compareToIgnoreCase(zone.getName());
            if (n == 0) {
                n = this.getName().compareTo(zone.getName());
            }
            return n;
        }
        return -1;
    }

    public void removeMembers(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ZoneMember zoneMember = (ZoneMember)vector.elementAt(n);
            int n2 = this.getZoneMemberIndex(zoneMember);
            if (n2 >= 0) {
                this.dirtyFlag = true;
                if (zoneMember instanceof ZoneAlias) {
                    ZoneAlias zoneAlias = (ZoneAlias)zoneMember;
                    zoneAlias.decZonesIn();
                }
                this.members.remove(n2);
            }
            ++n;
        }
        this.fireEvent(new ZoneEvent(this, vector, 2));
    }

    public int getZoneMemberIndex(ZoneMember zoneMember) {
        return Collections.binarySearch(this.members, zoneMember);
    }

    public boolean equals(Object object) {
        Zone zone;
        return object instanceof Zone && this.name.equals((zone = (Zone)object).getName());
    }
}

