/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.zoning;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import java.io.Serializable;

public class ZoneMemberElement
implements Serializable,
ZoneMember {
    public static final int MEMBER_TYPE_PORT_ID = 1;
    public static final int MEMBER_TYPE_NODE_WWN = 2;
    public static final int MEMBER_TYPE_NODE_PORT_ID = 3;
    public static final int MEMBER_TYPE_UNKNOWN = 4;
    public static final int FIRST_MEMBER_TYPE = 1;
    public static final int LAST_MEMBER_TYPE = 4;
    int type;
    long member;

    ZoneMemberElement(long l, int n) {
        this.member = l;
        this.type = n == 1 || n == 2 || n == 3 ? n : 4;
    }

    public boolean equals(Object object) {
        ZoneMemberElement zoneMemberElement;
        return object instanceof ZoneMemberElement && (zoneMemberElement = (ZoneMemberElement)object).getType() == this.type && zoneMemberElement.getMember() == this.member;
    }

    public int getType() {
        return this.type;
    }

    public long getMember() {
        return this.member;
    }

    public String getMemberStorageString() {
        String string = Long.toHexString(this.member);
        int n = 0;
        switch (this.type) {
            case 3: {
                n = 6;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 16;
            }
        }
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public int compareTo(Object object) {
        if (object instanceof ZoneMemberElement) {
            ZoneMemberElement zoneMemberElement = (ZoneMemberElement)object;
            if (zoneMemberElement.getType() < this.getType()) {
                return 1;
            }
            if (zoneMemberElement.getType() > this.getType()) {
                return -1;
            }
            if (zoneMemberElement.getMember() < this.getMember()) {
                return 1;
            }
            if (zoneMemberElement.getMember() > this.getMember()) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public String toString() {
        switch (this.type) {
            case 3: {
                return DeviceUtilities.getResource("ZoneMemberElement.fcAddress") + " " + this.getMemberStorageString();
            }
            case 1: {
                String string = this.getMemberStorageString();
                Integer n = Integer.decode("0x" + string.substring(0, 2));
                Integer n2 = Integer.decode("0x" + string.substring(2));
                return DeviceUtilities.getResource("ZoneMemberElement.domain") + " " + n + " " + DeviceUtilities.getResource("ZoneMemberElement.port") + n2;
            }
            case 2: {
                return DeviceUtilities.getResource("ZoneMemberElement.wwn") + " " + this.getMemberStorageString();
            }
        }
        return DeviceUtilities.getResource("ZoneMemberElement.unknown");
    }
}

