/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.zoning;

import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.zoning.SerializableCloneable;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneMemberElement;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.events.ZoneSetEvent;
import com.qlogic.device.fcfabric.zoning.events.ZoneSetListener;
import com.qlogic.device.fcfabric.zoning.events.ZonesEvent;
import com.qlogic.device.fcfabric.zoning.events.ZonesListener;
import com.qlogic.util.StringUtilities;
import com.qlogic.util.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Zones
extends SerializableCloneable
implements ZoneSetListener {
    transient Vector listeners = new Vector();
    int maxNumberOfSets = 0;
    int maxNumberOfAliases = 0;
    int maxNumberOfZones = 0;
    int maxNumberOfMembers = 0;
    int maxNumberOfMembersPerZone = 0;
    int maxNumberOfMembersPerAlias = 0;
    int maxNumberOfZonesInSets = 0;
    boolean limitsEnforced = true;
    boolean errorReading = false;
    boolean dirtyFlag = false;
    boolean currentWithSwitch = false;
    boolean zoningMergeDiff = false;
    private ZoneSet orphanZoneSet = new ZoneSet("ORPHAN ZONE SET", this, true);
    private Hashtable zoneSets = new Hashtable();
    private Hashtable zoneAliases = new Hashtable();
    private Hashtable allZones = new Hashtable();
    protected Hashtable allZoneMembers = new Hashtable();
    protected int numberOfZonesInSets = 0;
    public static final int ZONING_ERROR_OK = 0;
    public static final int ZONING_ERROR_EXCEED_MAX_MEMBERS = 100;
    public static final int ZONING_ERROR_EXCEED_MAX_ZONES = 101;
    public static final int ZONING_ERROR_EXCEED_MAX_ZONE_SETS = 102;
    public static final int ZONING_ERROR_EXCEED_MAX_MEMBERS_PER_ZONE = 103;
    public static final int ZONING_ERROR_EXCEED_MAX_MEMBERS_PER_ALIAS = 104;
    public static final int ZONING_ERROR_MEMBER_ALREADY_MEMBER = 105;
    public static final int ZONING_ERROR_INVALID_MEMBER_OF_ALIAS = 106;
    public static final int ZONING_ERROR_ZONE_IS_NOT_IN_SET = 107;
    public static final int ZONE_IS_ALREADY_MEMBER_OF_SET = 108;
    public static final int ZONING_ERROR_COULD_NOT_FIND_SET = 109;
    public static final int ZONING_ERROR_EXCEED_MAX_ZONES_IN_SETS = 110;
    static final int WWN_STR_LENGTH = 16;
    static final int NODE_PORTID_STR_LENGTH = 6;
    static final int PORTID_STR_LENGTH = 4;

    Zones() {
    }

    Zones(Zones zones) {
        this.maxNumberOfSets = zones.maxNumberOfSets;
        this.maxNumberOfZones = zones.maxNumberOfZones;
        this.maxNumberOfMembers = zones.maxNumberOfMembers;
        this.maxNumberOfAliases = zones.maxNumberOfAliases;
        this.limitsEnforced = zones.limitsEnforced;
    }

    Zones(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.maxNumberOfSets = n;
        this.maxNumberOfAliases = n2;
        this.maxNumberOfZones = n3;
        this.maxNumberOfMembers = n4;
        this.maxNumberOfMembersPerZone = n5;
        this.maxNumberOfMembersPerAlias = n6;
        this.maxNumberOfZonesInSets = n7;
    }

    public abstract Zones getEmptyZones();

    public Object clone() {
        Zones zones = (Zones)super.clone();
        this.registerListeners(zones);
        return zones;
    }

    public void copyZones(Zones zones) {
        this.maxNumberOfSets = zones.maxNumberOfSets;
        this.maxNumberOfAliases = zones.maxNumberOfAliases;
        this.maxNumberOfZones = zones.maxNumberOfZones;
        this.maxNumberOfMembers = zones.maxNumberOfMembers;
        this.maxNumberOfMembersPerZone = zones.maxNumberOfMembersPerZone;
        this.maxNumberOfMembersPerAlias = zones.maxNumberOfMembersPerAlias;
        this.maxNumberOfZonesInSets = zones.maxNumberOfZonesInSets;
        this.limitsEnforced = zones.limitsEnforced;
        this.numberOfZonesInSets = zones.numberOfZonesInSets;
        this.errorReading = zones.errorReading;
        this.dirtyFlag = zones.dirtyFlag;
        this.currentWithSwitch = zones.currentWithSwitch;
        this.zoneSets = zones.zoneSets;
        this.zoneAliases = zones.zoneAliases;
        this.allZones = zones.allZones;
        this.allZoneMembers = zones.allZoneMembers;
        this.orphanZoneSet = zones.orphanZoneSet;
        this.registerListeners(this);
    }

    public String getZonesList(FCNode fCNode) {
        String string = new String();
        ZoneSet zoneSet = this.getActiveZoneSet();
        if (zoneSet != null) {
            Zone zone = zoneSet.getFirstZone();
            while (zone != null) {
                if (zone.isMemberInZone(fCNode)) {
                    if (string.length() > 0) {
                        string = string + ",";
                    }
                    string = string + zone.getName();
                }
                zone = zoneSet.getNextZone(zone);
            }
        }
        return string;
    }

    private void registerListeners(Zones zones) {
        ZoneSet zoneSet = zones.getFirstZoneSet();
        while (zoneSet != null) {
            zoneSet.addListener(zones);
            zoneSet = zones.getNextZoneSet(zoneSet);
        }
    }

    private void removeListener(ZonesListener zonesListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            return;
        }
        if (this.listeners.contains(zonesListener)) {
            this.listeners.remove(zonesListener);
        }
    }

    public void addListener(ZonesListener zonesListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(zonesListener)) {
            this.listeners.add(zonesListener);
        }
    }

    private void fireEvent(ZonesEvent zonesEvent) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ZonesListener zonesListener = (ZonesListener)this.listeners.elementAt(n);
            zonesListener.zonesChanged(zonesEvent);
            ++n;
        }
    }

    public void zoneSetChanged(ZoneSetEvent zoneSetEvent) {
        switch (zoneSetEvent.getEventType()) {
            case 1: {
                ++this.numberOfZonesInSets;
                break;
            }
            case 2: {
                --this.numberOfZonesInSets;
            }
        }
    }

    public void setErrorReading(boolean bl) {
        this.errorReading = bl;
    }

    public void setLimitsEnforced(boolean bl) {
        this.limitsEnforced = bl;
    }

    public boolean getErrorReading() {
        return this.errorReading;
    }

    public boolean getZoningMergeDiff() {
        return this.zoningMergeDiff;
    }

    public void setZoningMergeDiff(boolean bl) {
        this.zoningMergeDiff = bl;
    }

    public boolean getCurrentWithSwitch() {
        return this.currentWithSwitch;
    }

    public void setCurrentWithSwitch(boolean bl) {
        this.currentWithSwitch = bl;
    }

    public static boolean verifyName(String string) {
        if (string.length() < 1) {
            return false;
        }
        char c = string.charAt(0);
        if (Character.isLetter(c)) {
            int n = 0;
            while (n < string.length()) {
                char c2 = string.charAt(n);
                if (!Character.isLetterOrDigit(c2) && c2 != '$' && c2 != '_' && c2 != '-' && c2 != '^') {
                    return false;
                }
                ++n;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean getDirtyFlag() {
        if (this.dirtyFlag) {
            return true;
        }
        ZoneSet zoneSet = this.getFirstZoneSet();
        while (zoneSet != null) {
            if (zoneSet.getDirtyFlag()) {
                return true;
            }
            zoneSet = this.getNextZoneSet(zoneSet);
        }
        Zone zone = this.getFirstZone();
        while (zone != null) {
            if (zone.getDirtyFlag()) {
                return true;
            }
            zone = this.getNextZone(zone);
        }
        ZoneAlias zoneAlias = this.getFirstZoneAlias();
        while (zoneAlias != null) {
            if (zoneAlias.getDirtyFlag()) {
                return true;
            }
            zoneAlias = this.getNextZoneAlias(zoneAlias);
        }
        return false;
    }

    public void resetDirtyFlag() {
        this.dirtyFlag = false;
        ZoneSet zoneSet = this.getFirstZoneSet();
        while (zoneSet != null) {
            zoneSet.resetDirtyFlag();
            zoneSet = this.getNextZoneSet(zoneSet);
        }
        Zone zone = this.getFirstZone();
        while (zone != null) {
            zone.resetDirtyFlag();
            zone = this.getNextZone(zone);
        }
        ZoneAlias zoneAlias = this.getFirstZoneAlias();
        while (zoneAlias != null) {
            zoneAlias.resetDirtyFlag();
            zoneAlias = this.getNextZoneAlias(zoneAlias);
        }
    }

    public boolean moreZoneSetsAllowed() {
        if (!this.limitsEnforced) {
            return true;
        }
        return this.maxNumberOfSets < 0 || this.zoneSets.size() < this.maxNumberOfSets;
    }

    public ZoneSet createZoneSet(String string) {
        ZoneSet zoneSet = this.findZoneSet(string);
        if (zoneSet == null) {
            if (this.moreZoneSetsAllowed()) {
                zoneSet = new ZoneSet(string, this, false);
                zoneSet.addListener(this);
                this.addZoneSet(zoneSet);
            } else {
                return null;
            }
        }
        return zoneSet;
    }

    private boolean addZoneSet(ZoneSet zoneSet) {
        if (this.zoneSets.get(zoneSet.getName()) == null) {
            this.zoneSets.put(zoneSet.getName(), zoneSet);
            this.fireEvent(new ZonesEvent(this, zoneSet, 1));
            this.dirtyFlag = true;
            return true;
        }
        return false;
    }

    public boolean moreAliasesAllowed() {
        if (!this.limitsEnforced) {
            return true;
        }
        return this.maxNumberOfAliases < 0 || this.zoneAliases.size() < this.maxNumberOfAliases;
    }

    public ZoneAlias createZoneAlias(String string) {
        ZoneAlias zoneAlias = this.findZoneAlias(string);
        if (zoneAlias == null) {
            if (this.moreAliasesAllowed()) {
                zoneAlias = new ZoneAlias(string, this.maxNumberOfMembersPerAlias);
                this.addZoneAlias(zoneAlias);
            } else {
                return null;
            }
        }
        return zoneAlias;
    }

    public boolean moreMembersAllowed() {
        if (!this.limitsEnforced) {
            return true;
        }
        return this.maxNumberOfMembers < 0 || this.getMemberCount() < this.maxNumberOfMembers;
    }

    public boolean moreZonesAllowed() {
        if (!this.limitsEnforced) {
            return true;
        }
        return this.maxNumberOfZones < 0 || this.allZones.size() < this.maxNumberOfZones;
    }

    public Zone createZone(String string) {
        Zone zone = this.findZone(string);
        if (zone == null) {
            if (this.moreZonesAllowed()) {
                zone = new Zone(string, this.maxNumberOfMembersPerZone);
                this.allZones.put(string, zone);
                this.orphanZoneSet.addZone(zone);
                this.dirtyFlag = true;
            } else {
                return null;
            }
        }
        return zone;
    }

    public ZoneSet getOrphanZoneSet() {
        return this.orphanZoneSet;
    }

    public ZoneMember createZoneMember(String string) {
        long l;
        try {
            l = StringUtilities.parseLongHexString(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        ZoneMember zoneMember = this.findZoneMember(l);
        if (zoneMember == null) {
            ZoneMemberElement zoneMemberElement = null;
            if (string.length() == 16) {
                zoneMemberElement = new ZoneMemberElement(l, 2);
            }
            if (string.length() == 6) {
                zoneMemberElement = new ZoneMemberElement(l, 3);
            }
            if (string.length() == 4) {
                zoneMemberElement = new ZoneMemberElement(l, 1);
            }
            if (zoneMemberElement != null) {
                this.allZoneMembers.put(new Long(zoneMemberElement.getMember()), zoneMemberElement);
                return zoneMemberElement;
            }
            Trace.warn((String)("Unable to create zone member idIn=" + string));
        }
        return zoneMember;
    }

    public int getMaxNumberOfSets() {
        return this.maxNumberOfSets;
    }

    public int getMaxNumberOfZones() {
        return this.maxNumberOfZones;
    }

    public int getMaxNumberOfAliases() {
        return this.maxNumberOfAliases;
    }

    public int getMaxNumberOfMembers() {
        return this.maxNumberOfMembers;
    }

    public int getMaxNumberOfMembersPerZone() {
        return this.maxNumberOfMembersPerZone;
    }

    public int getMaxNumberOfMembersPerAlias() {
        return this.maxNumberOfMembersPerAlias;
    }

    public int getMaxZonesInSets() {
        return this.maxNumberOfZonesInSets;
    }

    public boolean okToSave() {
        if (this.maxNumberOfSets >= 0 && this.zoneSets.size() > this.maxNumberOfSets) {
            return false;
        }
        if (this.maxNumberOfAliases >= 0 && this.zoneAliases.size() > this.maxNumberOfAliases) {
            return false;
        }
        if (this.maxNumberOfZones >= 0 && this.allZones.size() > this.maxNumberOfZones) {
            return false;
        }
        if (this.maxNumberOfMembers >= 0 && this.getMemberCount() > this.maxNumberOfMembers) {
            return false;
        }
        return this.maxNumberOfZonesInSets < 0 || this.getNumberZonesInSets() <= this.maxNumberOfZonesInSets;
    }

    private String removeLeadingAndTrailingSpaces(String string) {
        boolean bl = false;
        while (!bl) {
            if (string.length() > 0) {
                if (string.charAt(0) == ' ') {
                    string = string.substring(1);
                    continue;
                }
                if (string.charAt(string.length() - 1) == ' ') {
                    string = string.substring(0, string.length() - 1);
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        return string;
    }

    public Zone findZone(String string) {
        return (Zone)this.allZones.get(string);
    }

    public boolean isMemberInZoneSet(ZoneMember zoneMember, ZoneSet zoneSet) {
        if (zoneSet == null) {
            return false;
        }
        Zone zone = zoneSet.getFirstZone();
        while (zone != null) {
            if (zone.isMemberInZone(zoneMember, false)) {
                return true;
            }
            zone = zoneSet.getNextZone(zone);
        }
        return false;
    }

    public ZoneMember findZoneMember(long l) {
        return (ZoneMember)this.allZoneMembers.get(new Long(l));
    }

    private ZoneSet findFirstZoneSetThatContainsThisZone(Zone zone) {
        ZoneSet zoneSet = this.getFirstZoneSet();
        while (zoneSet != null) {
            if (zoneSet.findZone(zone.getName()) != null) {
                return zoneSet;
            }
            zoneSet = this.getNextZoneSet(zoneSet);
        }
        return null;
    }

    public ZoneAlias findZoneAlias(String string) {
        string = this.removeLeadingAndTrailingSpaces(string);
        ZoneAlias zoneAlias = this.getFirstZoneAlias();
        while (zoneAlias != null) {
            if (zoneAlias.getName().equals(string)) {
                return zoneAlias;
            }
            zoneAlias = this.getNextZoneAlias(zoneAlias);
        }
        return null;
    }

    public ZoneSet findZoneSet(String string) {
        string = this.removeLeadingAndTrailingSpaces(string);
        ZoneSet zoneSet = this.getFirstZoneSet();
        while (zoneSet != null) {
            if (zoneSet.getName().equals(string)) {
                return zoneSet;
            }
            zoneSet = this.getNextZoneSet(zoneSet);
        }
        return null;
    }

    public void clearZones() {
        this.zoneSets = new Hashtable();
        this.zoneAliases = new Hashtable();
        this.allZones = new Hashtable();
        this.allZoneMembers = new Hashtable();
        this.orphanZoneSet.removeAllZones();
        this.currentWithSwitch = false;
        this.errorReading = false;
        this.zoningMergeDiff = false;
        this.dirtyFlag = true;
    }

    public ZoneSet getFirstZoneSet() {
        Enumeration enumeration = this.zoneSets.keys();
        if (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            return (ZoneSet)this.zoneSets.get(k);
        }
        return null;
    }

    public ZoneSet getNextZoneSet(ZoneSet zoneSet) {
        Enumeration enumeration = this.zoneSets.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.equals(zoneSet.getName())) continue;
            if (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                return (ZoneSet)this.zoneSets.get(string);
            }
            return null;
        }
        return null;
    }

    public ZoneAlias getFirstZoneAlias() {
        Enumeration enumeration = this.zoneAliases.keys();
        if (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            return (ZoneAlias)this.zoneAliases.get(k);
        }
        return null;
    }

    public ZoneAlias getNextZoneAlias(ZoneAlias zoneAlias) {
        Enumeration enumeration = this.zoneAliases.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k != zoneAlias.getName()) continue;
            if (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                return (ZoneAlias)this.zoneAliases.get(k);
            }
            return null;
        }
        return null;
    }

    public Zone getFirstZone() {
        Enumeration enumeration = this.allZones.keys();
        if (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            return (Zone)this.allZones.get(k);
        }
        return null;
    }

    private Zone getFirstNonOrphanZone() {
        ZoneSet zoneSet = this.getOrphanZoneSet();
        Enumeration enumeration = this.allZones.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Zone zone = (Zone)this.allZones.get(k);
            if (zoneSet.findZone(zone.getName()) != null) continue;
            return zone;
        }
        return null;
    }

    public Zone getNextZone(Zone zone) {
        Enumeration enumeration = this.allZones.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k != zone.getName()) continue;
            if (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                return (Zone)this.allZones.get(k);
            }
            return null;
        }
        return null;
    }

    private Zone getNextNonOrphanZone(Zone zone) {
        ZoneSet zoneSet = this.getOrphanZoneSet();
        zone = this.getNextZone(zone);
        while (zone != null) {
            if (zoneSet.findZone(zone.getName()) == null) {
                return zone;
            }
            zone = this.getNextZone(zone);
        }
        return null;
    }

    public int getNumberOfZones() {
        return this.allZones.size();
    }

    public int getMemberCount() {
        int n = 0;
        Zone zone = this.getFirstZone();
        while (zone != null) {
            n += zone.getMemberCount();
            zone = this.getNextZone(zone);
        }
        ZoneAlias zoneAlias = this.getFirstZoneAlias();
        while (zoneAlias != null) {
            int n2 = zoneAlias.getMemberCount();
            int n3 = zoneAlias.getNumberOfZonesIn();
            if (n3 < 2) {
                n3 = 1;
            }
            n += n3 * n2;
            zoneAlias = this.getNextZoneAlias(zoneAlias);
        }
        return n;
    }

    public int getNumberOfZoneSets() {
        return this.zoneSets.size();
    }

    public int getNumberZonesInSets() {
        return this.numberOfZonesInSets;
    }

    public int getNumberOfZoneAliases() {
        return this.zoneAliases.size();
    }

    public boolean renameZoneSet(ZoneSet zoneSet, String string) {
        if (this.findZoneSet(string) != null) {
            return false;
        }
        this.zoneSets.remove(zoneSet.getName());
        zoneSet.setName(string);
        this.zoneSets.put(zoneSet.getName(), zoneSet);
        return true;
    }

    public boolean renameZoneAlias(ZoneAlias zoneAlias, String string) {
        if (this.findZoneAlias(string) != null) {
            return false;
        }
        this.zoneAliases.remove(zoneAlias.getName());
        zoneAlias.setName(string);
        this.zoneAliases.put(zoneAlias.getName(), zoneAlias);
        Vector<ZoneAlias> vector = new Vector<ZoneAlias>();
        vector.add(zoneAlias);
        Zone zone = this.getFirstZone();
        while (zone != null) {
            if (zone.isMemberInZone(zoneAlias, false)) {
                zone.removeMembers(vector);
                zone.addMembers(vector);
            }
            zone = this.getNextZone(zone);
        }
        return true;
    }

    public boolean renameZone(Zone zone, String string) {
        if (this.findZone(string) != null) {
            return false;
        }
        this.allZones.remove(zone.getName());
        zone.setName(string);
        this.allZones.put(zone.getName(), zone);
        ZoneSet zoneSet = this.getFirstZoneSet();
        while (zoneSet != null) {
            if (zoneSet.findZone(string) != null) {
                zoneSet.resortZone(zone);
            }
            zoneSet = this.getNextZoneSet(zoneSet);
        }
        return true;
    }

    public int addZoneToSet(Zone zone, ZoneSet zoneSet) {
        if (!zoneSet.getIsOrphanZoneSet() && this.numberOfZonesInSets >= this.maxNumberOfZonesInSets) {
            return 110;
        }
        return zoneSet.addZone(zone);
    }

    public boolean addZoneAlias(ZoneAlias zoneAlias) {
        if (this.zoneAliases.get(zoneAlias.getName()) == null) {
            this.zoneAliases.put(zoneAlias.getName(), zoneAlias);
            this.fireEvent(new ZonesEvent(this, zoneAlias, 3));
            this.dirtyFlag = true;
            return true;
        }
        return false;
    }

    public int addZoneMembersToZone(Zone zone, Vector vector) {
        if (this.limitsEnforced) {
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                ZoneAlias zoneAlias;
                ZoneMember zoneMember = (ZoneMember)vector.elementAt(n2);
                if (zone instanceof ZoneAlias) {
                    zoneAlias = (ZoneAlias)zone;
                    int n3 = zoneAlias.getNumberOfZonesIn();
                    if (n3 < 2) {
                        n3 = 1;
                    }
                    n += n3;
                } else {
                    ++n;
                    if (zoneMember instanceof ZoneAlias && (zoneAlias = (ZoneAlias)zoneMember).getNumberOfZonesIn() > 0) {
                        n += zoneAlias.getMemberCount();
                    }
                }
                ++n2;
            }
            if (this.maxNumberOfMembers >= 0 && this.getMemberCount() + n > this.maxNumberOfMembers) {
                return 100;
            }
        }
        return zone.addMembers(vector);
    }

    public boolean removeZone(Zone zone) {
        if (this.allZones.get(zone.getName()) != null) {
            this.dirtyFlag = true;
            ZoneSet zoneSet = this.getFirstZoneSet();
            while (zoneSet != null) {
                zoneSet.removeZone(zone);
                zoneSet = this.getNextZoneSet(zoneSet);
            }
            this.orphanZoneSet.removeZone(zone);
            this.allZones.remove(zone.getName());
            return true;
        }
        return false;
    }

    public boolean removeZoneSet(ZoneSet zoneSet) {
        if (this.zoneSets.get(zoneSet.getName()) != null) {
            zoneSet.removeAllZones();
            this.zoneSets.remove(zoneSet.getName());
            this.fireEvent(new ZonesEvent(this, zoneSet, 2));
            this.dirtyFlag = true;
            return true;
        }
        return false;
    }

    public boolean removeZoneAlias(ZoneAlias zoneAlias) {
        if (this.zoneAliases.get(zoneAlias.getName()) != null) {
            this.zoneAliases.remove(zoneAlias.getName());
            this.fireEvent(new ZonesEvent(this, zoneAlias, 4));
            Vector<ZoneAlias> vector = new Vector<ZoneAlias>();
            vector.add(zoneAlias);
            Zone zone = this.getFirstZone();
            while (zone != null) {
                zone.removeMembers(vector);
                zone = this.getNextZone(zone);
            }
            this.dirtyFlag = true;
            return true;
        }
        return false;
    }

    public void setActiveZoneSet(ZoneSet zoneSet) {
        this.dirtyFlag = true;
        ZoneSet zoneSet2 = this.getFirstZoneSet();
        while (zoneSet2 != null) {
            if (zoneSet2.equals(zoneSet)) {
                zoneSet2.setActive(true);
            } else {
                zoneSet2.setActive(false);
            }
            zoneSet2 = this.getNextZoneSet(zoneSet2);
        }
    }

    public ZoneSet getActiveZoneSet() {
        ZoneSet zoneSet = this.getFirstZoneSet();
        while (zoneSet != null) {
            if (zoneSet.getActive()) {
                return zoneSet;
            }
            zoneSet = this.getNextZoneSet(zoneSet);
        }
        return null;
    }

    public String toString() {
        return "Zone Sets";
    }
}

