/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util.ftp;

import com.qlogic.util.ftp.FtpClientEvent;
import com.qlogic.util.ftp.FtpClientEventListener;
import com.qlogic.util.ftp.FtpReply;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FtpClient {
    public static final int BUFSIZ = 8192;
    public static final int FTP_CTRL_SOCKET = 21;
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    FtpReply lastReply;
    Socket ctrlSocket;
    Socket dataSocket;
    BufferedReader iStream;
    BufferedWriter oStream;
    File file;
    boolean aborting;
    List eventListeners = new ArrayList();

    public FtpClient(String string, String string2, String string3) throws UnknownHostException, IOException, SecurityException {
        this(InetAddress.getByName(string), string2, string3);
    }

    public FtpClient(InetAddress inetAddress, String string, String string2) throws IOException, SecurityException {
        this.ctrlSocket = new Socket(inetAddress, 21);
        InputStreamReader inputStreamReader = new InputStreamReader(this.ctrlSocket.getInputStream(), US_ASCII);
        this.iStream = new BufferedReader(inputStreamReader);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.ctrlSocket.getOutputStream(), US_ASCII);
        this.oStream = new BufferedWriter(outputStreamWriter);
        FtpReply ftpReply = this.getReply();
        if (ftpReply.getCode() != 220) {
            throw new ConnectException(ftpReply.toString());
        }
        ftpReply = this.login(string, string2);
        if (ftpReply.getCodeClass() != 2) {
            this.iStream.close();
            this.oStream.close();
            this.ctrlSocket.close();
            this.iStream = null;
            this.oStream = null;
            this.ctrlSocket = null;
            throw new SecurityException(ftpReply.toString());
        }
    }

    private FtpReply sendCmd(String string) {
        try {
            this.oStream.write(string, 0, string.length());
            this.oStream.newLine();
            this.oStream.flush();
            FtpReply ftpReply = this.getReply();
            return ftpReply;
        }
        catch (IOException iOException) {
            return new FtpReply(451, iOException.toString());
        }
    }

    private FtpReply login(String string, String string2) {
        FtpReply ftpReply = this.sendCmd("USER " + string);
        if (ftpReply.getCodeClass() == 3) {
            ftpReply = this.sendCmd("PASS " + string2);
        }
        return ftpReply;
    }

    public FtpReply setType(char c) {
        return this.sendCmd("TYPE " + Character.toUpperCase(c));
    }

    public FtpReply setType(String string) {
        if ((string = string.toUpperCase()).equals("ASC")) {
            return this.sendCmd("TYPE A");
        }
        if (string.equals("BIN")) {
            return this.sendCmd("TYPE I");
        }
        return this.sendCmd("TYPE " + string);
    }

    public FtpReply setPassiveMode() {
        return this.sendCmd("PASV");
    }

    public FtpReply put(String string) {
        return this.put(new File(string));
    }

    public FtpReply put(File file) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new FtpReply(451, fileNotFoundException.toString());
        }
        FtpReply ftpReply = this.setPassiveMode();
        if (ftpReply.getCode() != 227) {
            return ftpReply;
        }
        Socket socket = new Socket();
        try {
            socket.connect(this.parseSocketAddr(ftpReply.getMsg(0)));
        }
        catch (Exception exception) {
            return new FtpReply(451, exception.toString());
        }
        ftpReply = this.sendCmd("STOR " + file.getName());
        if (ftpReply.getCode() != 150) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ftpReply;
        }
        byte[] byArray = new byte[8192];
        int n = 0;
        try {
            int n2;
            while (!this.aborting && (n2 = fileInputStream.read(byArray)) != -1) {
                socket.getOutputStream().write(byArray, 0, n2);
                this.fireEvent(0, new Long(n += n2));
            }
        }
        catch (IOException iOException) {
            ftpReply = new FtpReply(451, iOException.toString());
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return ftpReply;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.aborting ? new FtpReply(426, "Canceled") : this.getReply();
    }

    public void cancel() {
        this.aborting = true;
    }

    public FtpReply close() {
        FtpReply ftpReply = this.sendCmd("QUIT");
        try {
            this.ctrlSocket.close();
        }
        catch (IOException iOException) {}
        return ftpReply;
    }

    private FtpReply getReply() {
        return this.getReply(true);
    }

    private FtpReply getReply(boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (bl || this.iStream.ready()) {
                String string;
                while ((string = this.iStream.readLine()).length() >= 5) {
                    arrayList.add(string.substring(4, string.length()));
                    if (string.charAt(3) != ' ') continue;
                }
                n = Integer.parseInt(string.substring(0, 3));
                return new FtpReply(n, arrayList);
            }
            return null;
        }
        catch (IOException iOException) {
            return new FtpReply(451, iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(FtpClientEventListener ftpClientEventListener) {
        if (ftpClientEventListener == null) {
            return;
        }
        List list = this.eventListeners;
        synchronized (list) {
            if (!this.eventListeners.contains(ftpClientEventListener)) {
                this.eventListeners.add(ftpClientEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(FtpClientEventListener ftpClientEventListener) {
        if (ftpClientEventListener == null) {
            return;
        }
        List list = this.eventListeners;
        synchronized (list) {
            if (this.eventListeners.contains(ftpClientEventListener)) {
                this.eventListeners.remove(ftpClientEventListener);
            }
        }
    }

    public void fireEvent(int n, Object object) {
        this.fireEvent(new FtpClientEvent(this, n, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(FtpClientEvent ftpClientEvent) {
        List list = this.eventListeners;
        synchronized (list) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ((FtpClientEventListener)iterator.next()).receiveEvent(ftpClientEvent);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private InetSocketAddress parseSocketAddr(String var1_1) {
        var2_2 = new StringBuffer();
        var3_3 = 0;
        var4_4 = var1_1.indexOf(40);
        if (var4_4 != -1) ** GOTO lbl12
        throw new IllegalArgumentException("No host/port in string.");
lbl-1000:
        // 1 sources

        {
            if ((var5_5 = var1_1.charAt(++var4_4)) == 44) {
                var5_5 = 46;
                ++var3_3;
            }
            if (var3_3 >= 4) continue;
            var2_2.append((char)var5_5);
lbl12:
            // 3 sources

            ** while (var3_3 <= 3)
        }
lbl13:
        // 1 sources

        var5_5 = var1_1.indexOf(44, ++var4_4);
        var6_6 = Integer.parseInt(var1_1.substring(var4_4, var5_5));
        var4_4 = var5_5 + '\u0001';
        var5_5 = var1_1.indexOf(41, var4_4);
        var7_7 = Integer.parseInt(var1_1.substring(var4_4, var5_5));
        var8_8 = var6_6 * 256 + var7_7;
        return new InetSocketAddress(var2_2.toString(), var8_8);
    }
}

