/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.SkinConstants;
import com.qlogic.ui.EventDateRenderer;
import com.qlogic.ui.EventTableModel;
import com.qlogic.ui.SeverityCellRenderer;
import com.qlogic.ui.tools.DetailsDialog;
import com.qlogic.ui.tools.EventsPrintable;
import com.qlogic.ui.tools.SortControl;
import com.qlogic.ui.tools.SortHeaderRenderer;
import com.qlogic.ui.tools.SortModelAdapter;
import com.qlogic.util.EventEntry;
import com.qlogic.util.EventLogListener;
import com.qlogic.util.EventManager;
import com.qlogic.util.QPageable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class EventDialog
extends JDialog
implements ActionListener,
WindowListener,
EventLogListener,
MouseListener {
    private EventTableModel m_EventModel = null;
    private JButton m_ClearjButton = new JButton();
    private JButton m_OKjButton = new JButton();
    private JTable m_EventTable = new JTable();
    private JButton m_PrintButton = new JButton("Print");

    public EventDialog(Frame frame) {
        super(frame, QConstants.getString("Event_Log_Name"), true);
        int width;
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel tablePanel = new JPanel(new GridLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 4, 0));
        JScrollPane eventScrollPane = new JScrollPane();
        this.m_ClearjButton.setText(QConstants.getString("Clear"));
        this.m_OKjButton.setText(QConstants.getString("OK"));
        this.m_EventTable.setShowHorizontalLines(false);
        this.m_EventTable.setShowVerticalLines(false);
        this.m_EventModel = new EventTableModel(EventManager.instance().getEntries());
        this.m_EventTable.setModel(this.m_EventModel);
        SortModelAdapter sma = new SortModelAdapter(this.m_EventModel);
        SortControl sc = new SortControl();
        sc.setSortableModel(sma);
        this.m_EventTable.setModel(sma);
        sc.install(this.m_EventTable);
        this.m_EventTable.setIntercellSpacing(new Dimension(0, 0));
        TableColumnModel columnModel = this.m_EventTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(60);
        column.setMinWidth(60);
        column.setWidth(60);
        column = columnModel.getColumn(1);
        column.setPreferredWidth(200);
        column.setWidth(200);
        column = columnModel.getColumn(2);
        column.setPreferredWidth(340);
        column.setWidth(340);
        FontMetrics metrics = this.getFontMetrics(sc.getRenderer().getFont());
        SortHeaderRenderer headerRenderer = sc.getRenderer();
        headerRenderer.setSortIcons(SkinConstants.SORT_UP_IMAGE, SkinConstants.SORT_DOWN_IMAGE);
        Insets margin = headerRenderer.getMargin();
        Insets insets = headerRenderer.getInsets();
        int pad = headerRenderer.getMaxIconWidth();
        pad += margin.left + margin.right;
        pad += insets.left + insets.right;
        pad += 4;
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            String header = (String)columnModel.getColumn(i).getIdentifier();
            if (metrics == null || header == null) continue;
            width = metrics.stringWidth(header) + pad;
            column = columnModel.getColumn(i);
            column.setPreferredWidth(Math.max(column.getPreferredWidth(), width));
            column.setWidth(Math.max(column.getWidth(), width));
        }
        Date longDate = (Date)QConstants.getObject("long_date");
        String longestDate = QConstants.DATE_FORMAT.format(longDate);
        width = metrics.stringWidth(longestDate);
        column = columnModel.getColumn(1);
        column.setPreferredWidth(Math.max(column.getPreferredWidth(), width));
        column.setWidth(Math.max(column.getWidth(), width));
        Dimension size = new Dimension(columnModel.getTotalColumnWidth(), 400);
        this.m_EventTable.setPreferredScrollableViewportSize(size);
        this.m_EventTable.setDefaultRenderer(Class.forName("javax.swing.Icon"), new SeverityCellRenderer());
        this.m_EventTable.setDefaultRenderer(Class.forName("java.util.Date"), new EventDateRenderer());
        tablePanel.add(eventScrollPane);
        eventScrollPane.getViewport().add(this.m_EventTable);
        eventScrollPane.getViewport().setBackground(this.m_EventTable.getBackground());
        mainPanel.add((Component)tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        buttonPanel.add(this.m_OKjButton);
        buttonPanel.add(this.m_ClearjButton);
        buttonPanel.add(this.m_PrintButton);
        this.getContentPane().add(mainPanel);
        this.setDefaultCloseOperation(0);
        EventManager.instance().addEventLogListener(this);
        this.m_ClearjButton.addActionListener(this);
        this.m_OKjButton.addActionListener(this);
        this.m_PrintButton.addActionListener(this);
        this.m_EventTable.addMouseListener(this);
        this.addWindowListener(this);
        this.pack();
    }

    private void clearTable() {
        int result = JOptionPane.showConfirmDialog(this, QConstants.getString("clear_events_msg"), QConstants.getString("clear_events_title"), 2);
        if (result != 0) {
            return;
        }
        EventManager.instance().truncate();
        this.m_EventModel.setData(null);
    }

    private void okPressed() {
        EventManager.instance().removeEventLogListener(this);
        this.dispose();
    }

    public void eventLogged(EventEntry event) {
        this.m_EventModel.addEvent(event);
    }

    public void printPressed() {
        EventEntry[] entries = EventManager.instance().getEntries();
        EventsPrintable p = new EventsPrintable(entries);
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat format = new PageFormat();
        Paper paper = new Paper();
        double margin = 16.0;
        paper.setImageableArea(margin, margin, paper.getWidth() - margin * (double)2, paper.getHeight() - margin * (double)2);
        format.setPaper(paper);
        QPageable pageable = new QPageable(p, format);
        pj.setPageable(pageable);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException ex) {
                System.out.println(ex);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_OKjButton) {
            this.okPressed();
        } else if (obj == this.m_ClearjButton) {
            this.clearTable();
        } else if (obj == this.m_PrintButton) {
            this.printPressed();
        }
    }

    public void mouseClicked(MouseEvent e) {
        block4: {
            int result;
            Point p;
            int row;
            if (e.getClickCount() <= 1 || (row = this.m_EventTable.rowAtPoint(p = e.getPoint())) <= -1) break block4;
            SortModelAdapter sortModel = (SortModelAdapter)this.m_EventTable.getModel();
            DetailsDialog dd = new DetailsDialog(this, QConstants.getString("event_details"));
            dd.setLocationRelativeTo(this);
            this.updateDetailsDialog(dd, sortModel, row);
            while ((result = dd.display()) != 0) {
                int confirm;
                if (result == 1) {
                    if (row < this.m_EventTable.getRowCount() - 1) {
                        this.m_EventTable.changeSelection(++row, this.m_EventTable.getSelectedColumn(), false, false);
                        this.updateDetailsDialog(dd, sortModel, row);
                        continue;
                    }
                    confirm = JOptionPane.showConfirmDialog(this, "You are at the end.  Do you wish to move to the beginning?", "Event log", 0);
                    if (confirm != 0) continue;
                    row = 0;
                    this.m_EventTable.changeSelection(row, this.m_EventTable.getSelectedColumn(), false, false);
                    this.updateDetailsDialog(dd, sortModel, row);
                    continue;
                }
                if (row > 0) {
                    this.m_EventTable.changeSelection(--row, this.m_EventTable.getSelectedColumn(), false, false);
                    this.updateDetailsDialog(dd, sortModel, row);
                    continue;
                }
                confirm = JOptionPane.showConfirmDialog(this, "You are at the beginning.  Do you wish to move to the end?", "Event log", 0);
                if (confirm != 0) continue;
                row = this.m_EventTable.getRowCount() - 1;
                this.m_EventTable.changeSelection(row, this.m_EventTable.getSelectedColumn(), false, false);
                this.updateDetailsDialog(dd, sortModel, row);
            }
            dd.dispose();
        }
    }

    private void updateDetailsDialog(DetailsDialog dd, SortModelAdapter sortModel, int row) {
        dd.setText("");
        dd.append(sortModel.getColumnName(1));
        dd.append(": ");
        dd.append(sortModel.getValueAt(row, 1).toString());
        dd.append("\n");
        dd.append(sortModel.getColumnName(2));
        dd.append(": ");
        dd.append(sortModel.getValueAt(row, 2).toString());
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.okPressed();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

